/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Richard Neil Pittman												*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	registerblock_ICE												*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	0.0	-	Pre Release													*/
/* Revision	1.0	-	First General Release									*/
/* Revision	1.1	-	Bug Fixes, see Manual									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module registerblock(rst,addra,addrb,clka,clkb,dinb,douta,doutb,web,
	regfile00, regfile01, regfile02, regfile03, regfile04, regfile05, regfile06, regfile07, regfile08, regfile09,
	regfile10, regfile11, regfile12, regfile13, regfile14, regfile15, regfile16, regfile17, regfile18, regfile19,
	regfile20, regfile21, regfile22, regfile23, regfile24, regfile25, regfile26, regfile27, regfile28, regfile29,
	regfile30, regfile31);
	input rst, clka, clkb, web;
	input [4:0] addra, addrb;
	input [31:0] dinb;
	output [31:0] douta, doutb;
	output [31:0] regfile00, regfile01, regfile02, regfile03, regfile04, regfile05, regfile06, regfile07, regfile08, regfile09;
	output [31:0] regfile10, regfile11, regfile12, regfile13, regfile14, regfile15, regfile16, regfile17, regfile18, regfile19;
	output [31:0] regfile20, regfile21, regfile22, regfile23, regfile24, regfile25, regfile26, regfile27, regfile28, regfile29;
	output [31:0] regfile30, regfile31;

	/*regfileblock rf(
		.sinita(rst),
		.sinitb(rst),
		.addra(addra),
		.addrb(addrb),
		.clka(clka),
		.clkb(clkb),
		.dinb(dinb),
		.douta(douta),
		.doutb(doutb),
		.web(web)
		);*/

	wire [31:0] regfile00, regfile01, regfile02, regfile03, regfile04, regfile05, regfile06, regfile07, regfile08, regfile09;
	wire [31:0] regfile10, regfile11, regfile12, regfile13, regfile14, regfile15, regfile16, regfile17, regfile18, regfile19;
	wire [31:0] regfile20, regfile21, regfile22, regfile23, regfile24, regfile25, regfile26, regfile27, regfile28, regfile29;
	wire [31:0] regfile30, regfile31;
		
	reg [31:0] regfile [0:31];
	reg [31:0] douta_reg, doutb_reg;

	integer i;

	initial
	begin
		for (i=0; i<32; i=i+1)
		begin
			regfile[i] = 0;
		end
		douta_reg = 32'b0;
		doutb_reg = 32'b0;
	end
	
	assign douta = douta_reg;
	assign doutb = doutb_reg;

	assign regfile00 = regfile[0];
	assign regfile01 = regfile[1];
	assign regfile02 = regfile[2];
	assign regfile03 = regfile[3];
	assign regfile04 = regfile[4];
	assign regfile05 = regfile[5];
	assign regfile06 = regfile[6];
	assign regfile07 = regfile[7];
	assign regfile08 = regfile[8];
	assign regfile09 = regfile[9];
	assign regfile10 = regfile[10]; 
	assign regfile11 = regfile[11]; 
	assign regfile12 = regfile[12]; 
	assign regfile13 = regfile[13]; 
	assign regfile14 = regfile[14]; 
	assign regfile15 = regfile[15];
	assign regfile16 = regfile[16];
	assign regfile17 = regfile[17];
	assign regfile18 = regfile[18];
	assign regfile19 = regfile[19];
	assign regfile20 = regfile[20];
	assign regfile21 = regfile[21];
	assign regfile22 = regfile[22];
	assign regfile23 = regfile[23];
	assign regfile24 = regfile[24];
	assign regfile25 = regfile[25];
	assign regfile26 = regfile[26];
	assign regfile27 = regfile[27];
	assign regfile28 = regfile[28];
	assign regfile29 = regfile[29];
	assign regfile30 = regfile[30];
	assign regfile31 = regfile[31];
	
	always@(posedge clkb)
	begin
		if (rst)
		begin
			for (i=0; i<32; i=i+1)
			begin
				regfile[i] <= 0;
			end
			doutb_reg <= 32'b0;
		end
		else
		begin
			doutb_reg <= regfile[addrb];
			if (web)
			begin
				regfile[addrb] <= dinb;
				//$display("RF::REG %x = %x (%x)",addrb,dinb,regfile[addrb]);
			end
		end
	end
	
	always@(posedge clka)
	begin
		if (rst)
		begin
			douta_reg <= 32'b0;
		end
		else
		begin
			douta_reg <= regfile[addra];
		end
	end
	
endmodule
