/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Richard Neil Pittman												*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Library Name:	shift																*/
/* Module Names:	shift2															*/
/*						shift16															*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	0.0	-	Pre Release													*/
/* Revision	1.0	-	First General Release									*/
/* Revision	1.1	-	Bug Fixes, see Manual									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module shift2(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input [31:0]	A,		/* Input */
	input [1:0]		C_IN,	/* Carry-in */
	/* OUTPUT PORTS */
	output [31:0]	B,		/* Output */
	output [1:0]	C_OUT	/* Carry-out */
	);

/*********************************************************************/
	
	assign {C_OUT,B}	=	{A,C_IN};

endmodule

module shift16(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input [31:0] A,		/* Input */
	input [15:0] C_IN,	/* Carry-in */
	/* OUTPUT PORTS */
	output [31:0] B,		/* Output */
	output [15:0] C_OUT	/* Carry-out */
	);

/*********************************************************************/
	
	assign {C_OUT,B}	=	{A,C_IN};

endmodule
