/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Richard Neil Pittman												*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Library Name:	signextend														*/
/* Module Names:	signextend16_32												*/
/*						signextend8_32													*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	0.0	-	Pre Release													*/
/* Revision	1.0	-	First General Release									*/
/* Revision	1.1	-	Bug Fixes, see Manual									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

`include "decode.v"

module signextend16_32(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input [15:0]	IN,		/* Input */
	input				SE_OP,	/* Enable */
	/* OUTPUT PORTS */
	output [31:0]	OUT		/* Output */
	);

/*********************************************************************/

	assign OUT	=	(SE_OP == 1'b0)?	{{16{IN[15]}},IN}:
												(IN & 32'h0000FFFF);

endmodule

module signextend8_32(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input [7:0]		IN,		/* Input */
	input				SE_OP,	/* Enable */
	/* OUTPUT PORTS */
	output [31:0]	OUT		/* Output */
	);

/*********************************************************************/

	assign OUT	=	(SE_OP == 1'b0)?	{{24{IN[7]}},IN}:
												(IN & 32'h000000FF);

endmodule
