/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Richard Neil Pittman												*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	write_back														*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	0.0	-	Pre Release													*/
/* Revision	1.0	-	First General Release									*/
/* Revision	1.1	-	Bug Fixes, see Manual									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module write_back(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input [31:0]	ALURESULT,	/* ALU Result */
	input				CLK,			/* System Clock 50 - 100 MHZ */ 
	input [31:0]	DMDATAOUT,	/* Memory Data Out */
	input				MEMTOREG,	/* Memory to Regiser */
	input				RESET,		/* System Reset */
	/* OUTPUT PORTS */
	output [31:0]	WRREGDATA	/* Register Write Port Data */
	);

/*****Signals****************************************************************/
	
	wire [31:0] WRREGDATA_0;	/* Register Write Port Data Asynchronous */

/*****Registers****************************************************************/

	reg [31:0]	aluresult_reg;	/* ALU Result */
	reg [31:0]	dmdataout_reg;	/* Memory Data Out */
	reg			memtoreg_reg;	/* Memory to Regiser */
	reg [31:0]	wrregdata_reg;	/* Register Write Port Data */

/*****Initialization****************************************************************/

	initial
	begin
		aluresult_reg = 32'b0;
		dmdataout_reg = 32'b0;
		memtoreg_reg = 1'b0;
		wrregdata_reg = 32'b0;
	end

/*********************************************************************/

	assign WRREGDATA	=	wrregdata_reg;

/*****Select Writeback Data****************************************************************/

	MUX32_2to1 mux0(
		.a0(aluresult_reg), 
		.a1(dmdataout_reg), 
		.sel(memtoreg_reg), 
		.out(WRREGDATA_0)
		);

/*********************************************************************/

	always@(posedge CLK)
	begin
		if (RESET == 1'b0)
		begin
			/* Reset */
			memtoreg_reg <= 1'b0;
			dmdataout_reg <= 32'b0;
			aluresult_reg <= 32'b0;
			wrregdata_reg <= 32'b0;
		end
		else
		begin
			/* Latch Signals */
			memtoreg_reg <= MEMTOREG;
			dmdataout_reg <= DMDATAOUT;
			aluresult_reg <= ALURESULT;
			wrregdata_reg <= WRREGDATA_0;
		end
	end
	
endmodule
