/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Richard Neil Pittman												*/
/*					Bharat Sukhwani													*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	MIPSPL_FPGA3													*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/*	MIPSPL_FPGA is the top level module of the eMIPS microprocessor	*/
/*	system design.  All other components are submodules at some level	*/
/*	in the design tree.  All input/output pins are defined here as		*/
/*	well as the partitioning of the fixed design, TISA, from the		*/
/*	reconfigurable Extensions.														*/
/* 																						*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	0.0	-	Pre Release													*/
/* Revision	1.0	-	First General Release									*/
/* Revision	1.1	-	eBug Extension, Extension Peripherals, Bug		*/
/*							Fixes, see Manual											*/
/*																							*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module MIPSPL_FPGA3(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input 			BRDY,			/* System Ace Buffer Ready */
	input 			CLK,			/* Board System Clock 100 MHZ */
	input 			CLK_IN_PER,	/* System Ace Clock 33 MHZ */
	input 			IRQ_SYSACE,	/* System Ace Interrupt Request */
	input 			RESET,		/* Board Hardware Reset */
	input 			RX,			/* System Serial Recieve */
	input 			SRAMCLK_FB,	/* SRAM Clock Feedback 50 - 100 MHZ */
	input				RX2,			/* */
	/* OUTPUT PORTS */
	output 			BYTE,			/* Flash Byte Mode */
	output 			BYTESEL,		/* Flash Byte Select */
	output 			CE_FLASH,	/* Flash Chip Enable */
	output [23:0]	MADDR_OUT,	/* Memory Address Bus (SRAM & Flash) */
	output 			MODE,			/* SRAM Mode */
	output 			NADVLD,		/* SRAM ADV/LD */
	output [3:0]	NBW,			/* SRAM Byte Write Enable */
	output 			NCE_SRAM,	/* SRAM Chip Enable */
	output 			NCE_SYSACE,	/* System Ace Chip Enable */
	output 			NOE_MEM,		/* Memory Output Enable (SRAM & Flash) */
	output 			NOE_PER,		/* Peripheral Output Enable (SYSACE) */
	output 			NRP,			/* Flash Hardware Reset */
	output 			NWE_MEM,		/* Memory Write Enable (SRAM & Flash) */
	output 			NWE_PER,		/* Peripheral Write Enable (SYSACE) */
	output [6:0]	PADDR_OUT,	/* Peripheral Address Bus (SYSACE) */
	output 			SCLK,			/* USART Baud Clock */
	output 			SRAMCLK,		/* SRAM Clock 50 - 100 MHZ */
	output 			TX,			/* System Serial Transmit */
	output 			ZZ,			/* SRAM Sleep */
	output			TX2,			/* */
	/* INOUT PORTS */
	inout 			CLK_EXT,		/* External Timer Clock */
	inout [3:0]		DATA_PAR,	/* SRAM Parity Data Bus */
	inout [31:0]	GPIO,			/* General Purpose Input/Output */
	inout [31:0]	MDATA,		/* Memory Data Bus (SRAM & Flash) */
	inout [15:0]	PDATA			/* Peripheral Data Bus (SYSACE) */
	);
	
/*****Signals****************************************************************/

	/* GLOBAL SIGNALS */
	wire			CLK_IN_PER_BUF;		/* System Ace Clock 33 MHZ Buffered */
	wire			DCMLOCK;					/* Digital Clock Manager Lock */
	wire			MEMCLK;					/* Memory Bus Clock 50 - 100 MHZ */
	wire			SRAMCLK_INT;			/* SRAM Clock Internal 50 - 100 MHZ */
	wire			SYSCLK;					/* System Clock 50 - 100 MHZ */
	wire			SYSCLKD10;				/* Timer Clock 10 MHZ */
	wire			USARTCLK;				/* USART Clock 100 MHZ */

	/* BUS SIGNALS */
	wire [31:0]	GPIO_IN;					/* GPIO data in to tristate buffer out to pins */
	wire [31:0]	GPIO_OUT;				/* GPIO data out of tristate buffer in to FPGA */
	wire [31:0]	GPIO_TR;					/* GPIO data pin direction */
	wire [31:0] MDATA_IN;				/* Memory data bus in to tristate buffer out to pins */
	wire [31:0]	MDATA_OUT;				/* Memory data bus out of tristate buffer in to FPGA */
	wire [31:0]	MDATA_TR;				/* Memory data pin direction */
	wire [3:0]	MDATAP_IN;				/* Memory data parity bus in to tristate buffer out to pins */
	wire [3:0]	MDATAP_OUT;				/* Memory data parity bus out of tristate buffer in to FPGA */
	wire [3:0]	MDATAP_TR;				/* Memory data parity pin direction */
	wire [15:0]	PDATA_IN;				/* Peripheral data bus in to tristate buffer out to pins */
	wire [15:0]	PDATA_OUT;				/* Peripheral data bus out of tristate buffer in to FPGA */
	wire [15:0]	PDATA_TR;				/* Peripheral data pin direction */
	
	/* EXTENSION0 SIGNALS */
	wire 			ACK_EXT0e;				/* Extension 0 Enable Acknowledged External */
	wire 			ACK_EXT0i;				/* Extension 0 Enable Acknowledged Signal Internal */
	wire 			EXC_EXT0e;				/* Extension 0 Exception External */
	wire 			EXC_EXT0i;				/* Extension 0 Exception Internal */
	wire 			EXTCLK_EN_EXT0e;	/* */
	wire 			EXTCLK_EN_EXT0i;	/* */
	wire 			EMPTY_RG_EXT0e;		/* Extension 0 Register Write Buffer Empty External */
	wire 			EMPTY_RG_EXT0i;		/* Extension 0 Register Write Buffer Empty Internal */
	wire 			EN_EXT0e;				/* Extension 0 Enable External */
	wire 			EN_EXT0i;				/* Extension 0 Enable Internal */
	wire 			ENEXT_EXT0e;			/* Extension 0 Execution Enable External */
	wire 			ENEXT_EXT0i;			/* Extension 0 Execution Enable Internal */
	wire 			EXCEXT_EXT0e;			/* Extension 0 Exception Flush External */
	wire 			EXCEXT_EXT0i;			/* Extension 0 Exception Flush Internal */
	wire [31:0]	EXTADD_EXT0e;			/* Extension 0 Extension Address External */
	wire [31:0]	EXTADD_EXT0i;			/* Extension 0 Extension Address Internal */
												/* Multiplexed: */
												/* 	Extension 0 Next PC */
												/* 	Extension 0 Exception Address */
												/* 	Extension 0 PC Execute Phase */
												/* 	Extension 0 PC Memory Access Phase */
	wire 			EXTNOP_EX_EXT0e;		/* Extension 0 Extension Bubble in Execute Phase External */
	wire 			EXTNOP_EX_EXT0i;		/* Extension 0 Extension Bubble in Execute Phase Internal */
	wire 			EXTNOP_MA_EXT0e;		/* Extension 0 Extension Bubble in Memory Access Phase External */
	wire 			EXTNOP_MA_EXT0i;		/* Extension 0 Extension Bubble in Memory Access Phase Internal */
	wire			fspecial_EXT0e;		/* */
	wire			fspecial_EXT0i;		/* */
	wire 			FULL_RG_EXT0e;			/* Extension 0 Register Write Buffer Full External */
	wire 			FULL_RG_EXT0i;			/* Extension 0 Register Write Buffer Full Internal */
	wire 			GR_EXT0e;				/* Extension 0 Grant Pipeline Resources External */
	wire 			GR_EXT0i;				/* Extension 0 Grant Pipeline Resources Internal */
	wire [31:0]	INSTR_EXT0e;			/* Extension 0 Current Instruction External */
	wire [31:0]	INSTR_EXT0i;			/* Extension 0 Current Instruction Internal */
	wire 			LDEXT_EXT0e;				/* Extension 0 Extension Loaded */
	wire 			LDEXT_EXT0i;				/* Extension 0 Extension Loaded */
	wire [1:0]	MBYTES_EXT0e;		/* */
	wire [1:0]	MBYTES_EXT0i;		/* */
	wire [31:0]	PC_EXT0e;				/* Extension 0 Current PC External */
	wire [31:0]	PC_EXT0i;				/* Extension 0 Current PC External */
	wire 			PCLK_EXT0e;				/* Extension 0 Pipeline Clock External */
	wire 			PCLK_EXT0i;				/* Extension 0 Pipeline Clock Internal */
	wire 			PCNEXT_EXT0e;			/* Extension 0 Conditional PC Update External */
	wire 			PCNEXT_EXT0i;			/* Extension 0 Conditional PC Update Internal */
	wire			PER0_MSRT_EXT0e;	/* */
	wire			PER0_MSRT_EXT0i;	/* */
	wire 			PI_EXT0e;				/* Extension 0 Passive/Parrallel Instruction External */
	wire 			PI_EXT0i;				/* Extension 0 Passive/Parrallel Instruction Internal */
	wire [4:0]	RDREG1_EXT0e;			/* Extension 0 Register Read Port 1 Register Number External */
	wire [4:0]	RDREG1_EXT0i;			/* Extension 0 Register Read Port 1 Register Number Internal */
												/* Multiplexed: */
												/* 	Extension 0 Register Read Port 1 Register Number */
												/* 	Extension 0 Register Write Port 1 Register Number */
												/* 	Extension 0 Write Register Execute Phase */
												/* 	Extension 0 Write Register Memory Access Phase */
	wire [31:0]	RDREG1DATA_EXT0e;		/* Extension 0 Register Read Port 1 Register Data External */
	wire [31:0]	RDREG1DATA_EXT0i;		/* Extension 0 Register Read Port 1 Register Data Internal */
	wire [4:0]	RDREG2_EXT0e;			/* Extension 0 Register Read Port 2 Register Number External */
	wire [4:0]	RDREG2_EXT0i;			/* Extension 0 Register Read Port 2 Register Number Internal */
												/* Multiplexed: */
												/* 	Extension 0 Register Read Port 2 Register Number */
												/* 	Extension 0 Register Write Port 2 Register Number */
												/* 	<0> Extension 0 Register Write Enable Execute Phase */
												/*		<0> Extension 0 Register Write Enable Memory Access Phase */
												/* 	<1> Extension 0 Memory to Register Execute Phase */
												/* 	<1> Extension 0 Memory to Register Memory Acess Phase */
												/* 	<3> Extension 0 Load/Store Conditional Execute Phase */
												/* 	<4> Extension 0 Extended Memory Data Execute Phase */
	wire [31:0]	RDREG2DATA_EXT0e;		/* Extension 0 Register Read Port 2 Register Data External */
	wire [31:0]	RDREG2DATA_EXT0i;		/* Extension 0 Register Read Port 2 Register Data Internal */
	wire [4:0]	RDREG3_EXT0e;			/* Extension 0 Register Read Port 3 Register Number External */
	wire [4:0]	RDREG3_EXT0i;			/* Extension 0 Register Read Port 3 Register Number Internal */
												/* Multiplexed: */
												/* 	Extension 0 Register Read Port 3 Register Number */
												/* 	Extension 0 Exception Code [4:0] */
	wire [31:0]	RDREG3DATA_EXT0e;		/* Extension 0 Register Read Port 3 Register Data External */
	wire [31:0]	RDREG3DATA_EXT0i;		/* Extension 0 Register Read Port 3 Register Data Internal */
	wire [4:0]	RDREG4_EXT0e;			/* Extension 0 Register Read Port 4 Register Number External */
	wire [4:0]	RDREG4_EXT0i;			/* Extension 0 Register Read Port 4 Register Number Internal */
												/* Multiplexed: */
												/* 	Extension 0 Register Read Port 4 Register Number */
												/* 	<0> Extension 0 Memory Write Execute Phase */
												/* 	<1> Extension 0 Memory Read Execute Phase */
												/* 	<1:0> Extension 0 Data Address [1:0] Memory Access Phase */
												/*		<2> Extension 0 Right/Left Unaligned Load/Store Execute Phase */
												/*		<2> Extension 0 Right/Left Unaligned Load/Store Memory Access Phase */
												/* 	<3> Extension 0 Byte Load/Store Execute Phase */
												/* 	<3> Extension 0 Byte/Halfword Load/Store Memory Acess Phase */
												/* 	<4> Extension 0 Halfword Load/Store Execute */
	wire [31:0]	RDREG4DATA_EXT0e;		/* Extension 0 Register Read Port 4 Register Data External */
	wire [31:0]	RDREG4DATA_EXT0i;		/* Extension 0 Register Read Port 4 Register Data Internal */
	wire 			REGRDY_EXT0e;			/* Extension 0 Register Write Buffer Ready External */
	wire 			REGRDY_EXT0i;			/* Extension 0 Register Write Buffer Ready Internal */
	wire 			REGWRITE1_EXT0e;		/* Extension 0 Register Write Port 1 Write Enable External */
	wire 			REGWRITE1_EXT0i;		/* Extension 0 Register Write Port 1 Write Enable Internal */
	wire 			REGWRITE1_RG_EXT0e;	/* Extension 0 Register Write Port 1 Write Enable Monitor External */
	wire 			REGWRITE1_RG_EXT0i;	/* Extension 0 Register Write Port 1 Write Enable Monitor Internal */
	wire 			REGWRITE2_EXT0e;		/* Extension 0 Register Write Port 2 Write Enable External */
	wire 			REGWRITE2_EXT0i;		/* Extension 0 Register Write Port 2 Write Enable Internal */
	wire 			REGWRITE2_RG_EXT0e;	/* Extension 0 Register Write Port 2 Write Enable Monitor External */
	wire 			REGWRITE2_RG_EXT0i;	/* Extension 0 Register Write Port 2 Write Enable Monitor Internal */
	wire 			REMA_EXT0e;				/* Extension 0 Re-enter at Memory Access External */
	wire 			REMA_EXT0i;				/* Extension 0 Re-enter at Memory Access Internal */
	wire 			RESET_EXT0e;			/* Extension 0 System Reset External */
	wire 			RESET_EXT0i;			/* Extension 0 System Reset Internal */
	wire 			REWB_EXT0e;				/* Extension 0 Re-enter at Writeback External */
	wire 			REWB_EXT0i;				/* Extension 0 Re-enter at Writeback Internal */
	wire 			RI_EXT0e;				/* Extension 0 Reserved/Recognized Instruction External */
	wire 			RI_EXT0i;				/* Extension 0 Reserved/Recognized Instruction Internal */
	wire [31:0]	W_ADDR_BM_E;			/* Extension 0 Peripheral Memory Addresss Internal */
	wire [31:0]	W_ADDR_TISA_BM;		/* Extension 0 Peripheral Memory Addresss External */
												/* Multiplexed: */
												/* 	Extension 0 Peripheral Memory Addresss */
												/* 	Extension 0 Memory Address Monitor */
	wire			W_BAT_EN_BM_E;			/* */
	wire			W_BAT_EN_TISA_BM;		/* */
	wire 			W_BLS_BM_TISA;			/* Extension 0 Byte Load/Store External */
	wire 			W_BLS_E_BM;				/* Extension 0 Byte Load/Store Internal */
	wire 			W_EXC_BM_TISA;			/* Extension 0 Exception M External */
	wire 			W_EXC_E_BM;				/* Extension 0 Exception M Internal */
	wire 			W_HLS_BM_TISA;			/* Extension 0 Halfword Load/Store External */
	wire 			W_HLS_E_BM;				/* Extension 0 Halfword Load/Store Internal */
	wire 			W_INT_BM_TISA;			/* Extension 0 Interrupt External */
	wire 			W_INT_E_BM;				/* Extension 0 Interrupt Internal */
	wire [31:0]	W_MADDR_BM_TISA;		/* Extension 0 Memory Address External */
	wire [31:0]	W_MADDR_E_BM;			/* Extension 0 Memory Address Internal */
	wire [31:0]	W_MDATA_BM_E;			/* Extension 0 Memory Data In Internal */
	wire [31:0]	W_MDATA_TISA_BM;		/* Extension 0 Memory Data In External */
												/* Multiplexed: */
												/* 	Extension 0 Memory Data In */
												/* 	Extension 0 Peripheral Memory Data In */
												/* 	Extension 0 Memory Data Monitor */
	wire [31:0]	W_MDATA_BM_TISA;		/* Extension 0 Memory Data Out External */	
	wire [31:0]	W_MDATA_E_BM;			/* Extension 0 Memory Data Out Internal */
												/* Multiplexed: */
												/* 	Extension 0 Memory Data Out */
												/* 	Extension 0 Peripheral Memory Data Out */
	wire 			W_MDATAVLD_BM_E;		/* Extension 0 Memory Data Valid Internal */
	wire 			W_MDATAVLD_TISA_BM;	/* Extension 0 Memory Data Valid External */
	wire 			W_MLOCK_BM_TISA;		/* Extension 0 Memory Automic Lock External */
	wire 			W_MLOCK_E_BM;			/* Extension 0 Memory Automic Lock Internal */
	wire 			W_MOE_BM_TISA;			/* Extension 0 Memory Output Enable External */
	wire 			W_MOE_E_BM;				/* Extension 0 Memory Output Enable Internal */
	wire 			W_MWE_BM_TISA;			/* Extension 0 Memory Write Enable External */
	wire 			W_MWE_E_BM;				/* Extension 0 Memory Write Enable Internal */
	wire 			W_OE_BM_E;				/* Extension 0 Peripheral Output Enable Internal */
	wire 			W_OE_TISA_BM;			/* Extension 0 Peripheral Output Enable External */
												/* Multiplexed: */
												/* 	Extension 0 Peripheral Output Enable */
												/* 	Extension 0 Memory Output Enable Monitor */
	wire			W_PER_DNE_BM_TISA;	/* */
	wire			W_PER_DNE_EXT_BM;		/* */
	wire			W_PER_MYADDR_BM_TISA;/* */
	wire			W_PER_MYADDR_EXT_BM;	/* */
	wire 			W_PRESENT_BM_TISA;	/* */
	wire 			W_PRESENT_E_BM;		/* */
	wire			W_PRIVILEGE_BM_TISA;	/* */
	wire			W_PRIVILEGE_E_BM;		/* */
	wire 			W_RNL_BM_TISA;			/* Extension 0 Memory Right/Left Unaligned Load/Store External */
	wire 			W_RNL_E_BM;				/* Extension 0 Memory Right/Left Unaligned Load/Store Internal */
	wire			W_WANT_INTR_BM_TISA;	/* */
	wire 			W_WANT_INTR_E_BM;		/* */
	wire 			W_WE_BM_E;				/* Extension 0 Peripheral Write Enable External */
	wire 			W_WE_TISA_BM;			/* Extension 0 Peripheral Write Enable External */
												/* Multiplexed: */
												/* 	Extension 0 Peripheral Write Enable */
												/* 	Extension 0 Memory Write Enable Monitor */
	wire [31:0]	WRDATA1_EXT0e;			/* Extension 0 Register Write Port 1 Data External */
	wire [31:0]	WRDATA1_EXT0i;			/* Extension 0 Register Write Port 1 Data Internal */
												/* Multiplexed: */
												/* 	Extension 0 Register Write Port 1 Data */
												/* 	Extension 0 ALU Result Execute Phase */
												/* 	Extension 0 ALU Result Memory Access Phase */
	wire [31:0]	WRDATA2_EXT0e;			/* Extension 0 Register Write Port 2 Data External */
	wire [31:0]	WRDATA2_EXT0i;			/* Extension 0 Register Write Port 2 Data Internal */
												/* Multiplexed: */
												/* 	Extension 0 Register Write Port 2 Data */
												/* 	Extension 0 Register 2 Data Execute Phase */
												/* 	Extension 0 Memory Data Out Memory Access Phase */
	wire [31:0]	WRDATA1_RG_EXT0e;		/* Extension 0 Register Write Port 1 Data Monitor External */
	wire [31:0]	WRDATA1_RG_EXT0i;		/* Extension 0 Register Write Port 1 Data Monitor Internal */
	wire [31:0]	WRDATA2_RG_EXT0e;		/* Extension 0 Register Write Port 2 Data Monitor External */
	wire [31:0]	WRDATA2_RG_EXT0i;		/* Extension 0 Register Write Port 2 Data Monitor Internal */
	wire [4:0]	WRREG1_RG_EXT0e;		/* Extension 0 Register Write Port 1 Register Number Monitor External */
	wire [4:0]	WRREG1_RG_EXT0i;		/* Extension 0 Register Write Port 1 Register Number Monitor Internal */
	wire [4:0]	WRREG2_RG_EXT0e;		/* Extension 0 Register Write Port 2 Register Number Monitor External */
	wire [4:0]	WRREG2_RG_EXT0i;		/* Extension 0 Register Write Port 2 Register Number Monitor Internal */
	wire			RX2_EXT0i;				/* */
	wire			TX2_EXT0i;				/* */

/*****Clocks****************************************************************/

	top_dcm sys(
		.CLKIN_IN(CLK),
		.CLKIN_IBUFG(),
		.CLKPER(CLK_IN_PER_BUF),
		.CLKPER_IN(CLK_IN_PER),
		.LOCKED_OUT(DCMLOCK),
		.MEMCLK(MEMCLK),
		.RESET(RESET),
		.SLOW_FASTN(1'b0),			/* Select System Clock Speed 100 MHZ or 50 MHZ */
		.SLOW_FASTN2(1'b0),			/* Select SRAM Clock Speed 100 MHZ or 50 MHZ */
		.SRAMCLK(SRAMCLK),
		.SRAMCLK_FB_IN(SRAMCLK_FB),
		.SRAMCLK_INT(SRAMCLK_INT),
		.SYSCLK(SYSCLK),
		.TMRCLK(SYSCLKD10),
		.USARTCLK(USARTCLK)
		);
  		
/*****Trusted ISA (Base Design)****************************************************************/

	TISA mips(
		.DCMLOCK(DCMLOCK),	
		.RESET(RESET),		

		.BRAMCLK(MEMCLK),					/* Blockram Clock 50 - 100 MHZ */
		.CLK_EXT(CLK_EXT),
		.CLK_IN_PER(CLK_IN_PER_BUF),
		.FLASHCLK(MEMCLK),				/* Flash Memory Interface Clock 50 - 100 MHZ */
		.MEMCLK(MEMCLK),					/* Memory Interface to Data Path Clock 50 - 100 MHZ */
		.MEMCLK2(MEMCLK),					/* Memory Interface to Peripherals Clock 50 - 100 MHZ */
		.SRAMCLK(SRAMCLK_INT),
		.SYSCLK(SYSCLK),
		.TMRCLK(SYSCLKD10),
		.USARTCLK(USARTCLK),

		.BRDY(BRDY),
		.BYTE(BYTE),
		.BYTESEL(BYTESEL),
		.CE_FLASH(CE_FLASH),
		.GPIO_IN(GPIO_IN),
		.GPIO_OUT(GPIO_OUT),
		.GPIO_TR(GPIO_TR),
		.IRQ_SYSACE(IRQ_SYSACE),
		.MADDR_OUT(MADDR_OUT),
		.MDATA_IN(MDATA_IN),
		.MDATA_OUT(MDATA_OUT),
		.MDATA_TR(MDATA_TR),
		.MDATAP_IN(MDATAP_IN), 
		.MDATAP_OUT(MDATAP_OUT), 
		.MDATAP_TR(MDATAP_TR),
		.MODE(MODE),
		.NADVLD(NADVLD),
		.NBW(NBW),
		.NCE_SRAM(NCE_SRAM),
		.NCE_SYSACE(NCE_SYSACE),
		.NOE_MEM(NOE_MEM),
		.NOE_PER(NOE_PER),
		.NRP(NRP),
		.NWE_MEM(NWE_MEM),
		.NWE_PER(NWE_PER),
		.PADDR_OUT(PADDR_OUT),
		.PDATA_IN(PDATA_IN),
		.PDATA_OUT(PDATA_OUT),
		.PDATA_TR(PDATA_TR),
		.RX(RX),
		.SCLK(SCLK),
		.TX(TX),
		.ZZ(ZZ),
		
		.ACK_EXT0e(ACK_EXT0e),
		.ADDR_EXT0_OUT(W_ADDR_TISA_BM),
		.BLS_EXT0_IN(W_BLS_BM_TISA),
		.EMPTY_RG_EXT0e(EMPTY_RG_EXT0e),
		.EN_EXT0e(EN_EXT0e),
		.ENEXT_EXT0e(ENEXT_EXT0e),
		.EXC_EXT0e(EXC_EXT0e),
		.EXC_EXT0_IN(W_EXC_BM_TISA),
		.EXCEXT_EXT0e(EXCEXT_EXT0e),
		.EXTADD_EXT0e(EXTADD_EXT0e),
		.EXTNOP_EX_EXT0e(EXTNOP_EX_EXT0e),
		.EXTNOP_MA_EXT0e(EXTNOP_MA_EXT0e),
		.FULL_RG_EXT0e(FULL_RG_EXT0e),
		.GR_EXT0e(GR_EXT0e),
		.HLS_EXT0_IN(W_HLS_BM_TISA), 
		.INSTR_EXT0e(INSTR_EXT0e),
		.INT_EXT0_IN(W_INT_BM_TISA),
		.LDEXT_EXT0e(LDEXT_EXT0e),
		.MADDR_EXT0_IN(W_MADDR_BM_TISA),
		.MDATA_EXT0_IN(W_MDATA_BM_TISA),
		.MDATA_EXT0_OUT(W_MDATA_TISA_BM),
		.MDATAVLD_EXT0_OUT(W_MDATAVLD_TISA_BM),
		.MLOCK_EXT0_IN(W_MLOCK_BM_TISA), 
		.MOE_EXT0_IN(W_MOE_BM_TISA),
		.MWE_EXT0_IN(W_MWE_BM_TISA),
		.OE_EXT0_OUT(W_OE_TISA_BM),
		.PC_EXT0e(PC_EXT0e),
		.PCLK_EXT0e(PCLK_EXT0e),
		.PCNEXT_EXT0e(PCNEXT_EXT0e),
		.PER0_BAT_EN_OUT(W_BAT_EN_TISA_BM),
		.PER0_DNE_IN(W_PER_DNE_BM_TISA),
		.PER0_MSRT_OUT(PER0_MSRT_EXT0e),
		.PER0_MY_ADDR_IN(W_PER_MYADDR_BM_TISA),
		.PER0_PRESENT_IN(W_PRESENT_BM_TISA),
		.PER0_PRIVILEGE_IN(W_PRIVILEGE_BM_TISA),
		.PER0_WANTS_INTR_IN(W_WANT_INTR_BM_TISA),
		.PI_EXT0e(PI_EXT0e),
		.RI_EXT0e(RI_EXT0e),
		.RDREG1_EXT0e(RDREG1_EXT0e),
		.RDREG1DATA_EXT0e(RDREG1DATA_EXT0e),
		.RDREG2_EXT0e(RDREG2_EXT0e),
		.RDREG2DATA_EXT0e(RDREG2DATA_EXT0e),
		.RDREG3_EXT0e(RDREG3_EXT0e),
		.RDREG3DATA_EXT0e(RDREG3DATA_EXT0e),
		.RDREG4_EXT0e(RDREG4_EXT0e),
		.RDREG4DATA_EXT0e(RDREG4DATA_EXT0e),
		.REGRDY_EXT0e(REGRDY_EXT0e),
		.REGWRITE1_EXT0e(REGWRITE1_EXT0e),
		.REGWRITE1_RG_EXT0e(REGWRITE1_RG_EXT0e),
		.REGWRITE2_EXT0e(REGWRITE2_EXT0e),
		.REGWRITE2_RG_EXT0e(REGWRITE2_RG_EXT0e),
		.REMA_EXT0e(REMA_EXT0e),
		.RESET_EXT0e(RESET_EXT0e),
		.REWB_EXT0e(REWB_EXT0e),
		.RNL_EXT0_IN(W_RNL_BM_TISA),
		.WE_EXT0_OUT(W_WE_TISA_BM),
		.WRDATA1_EXT0e(WRDATA1_EXT0e),
		.WRDATA1_RG_EXT0e(WRDATA1_RG_EXT0e),
		.WRDATA2_EXT0e(WRDATA2_EXT0e),
		.WRDATA2_RG_EXT0e(WRDATA2_RG_EXT0e),
		.WRREG1_RG_EXT0e(WRREG1_RG_EXT0e),
		.WRREG2_RG_EXT0e(WRREG2_RG_EXT0e),
		.EXTCLK_EN_EXT0e(EXTCLK_EN_EXT0e),
		.BYTES_EXT0_OUT(MBYTES_EXT0e),
		.fspecial_EXT0e(fspecial_EXT0e)
		);
		
/*****Bus Tristates****************************************************************/
		
	iobuf32 GPIO_IO(
		.IO(GPIO),
		.I(GPIO_IN),
		.O(GPIO_OUT),
		.T(GPIO_TR)
		);
		
	iobuf32 MDATA_IO(
		.IO(MDATA),
		.I(MDATA_IN),
		.O(MDATA_OUT),
		.T(MDATA_TR)
		);
		
	iobuf4 MDATAP_IO(
		.IO(DATA_PAR),
		.I(MDATAP_IN),
		.O(MDATAP_OUT),
		.T(MDATAP_TR)
		);
		
	iobuf16 PDATA_IO(
		.IO(PDATA),
		.I(PDATA_IN),
		.O(PDATA_OUT),
		.T(PDATA_TR)
		);
	
/*****Input Bus Macros****************************************************************/

	/*PC_EXT0e -> PC_EXT0i*/

	busmacro_xc4v_r2l_async_narrow bmi0bm0(	
		.input0(PC_EXT0e[0]),
		.input1(PC_EXT0e[1]),
		.input2(PC_EXT0e[2]), 
		.input3(PC_EXT0e[3]),
		.input4(PC_EXT0e[4]),
		.input5(PC_EXT0e[5]), 
		.input6(PC_EXT0e[6]),
		.input7(PC_EXT0e[7]), 
		.output0(PC_EXT0i[0]),
		.output1(PC_EXT0i[1]),
		.output2(PC_EXT0i[2]), 
		.output3(PC_EXT0i[3]),
		.output4(PC_EXT0i[4]),
		.output5(PC_EXT0i[5]), 
		.output6(PC_EXT0i[6]),
		.output7(PC_EXT0i[7])
		);

	busmacro_xc4v_r2l_async_narrow bmi0bm1(
		.input0(PC_EXT0e[8]),
		.input1(PC_EXT0e[9]),
		.input2(PC_EXT0e[10]), 
		.input3(PC_EXT0e[11]),
		.input4(PC_EXT0e[12]),
		.input5(PC_EXT0e[13]), 
		.input6(PC_EXT0e[14]),
		.input7(PC_EXT0e[15]), 
		.output0(PC_EXT0i[8]),
		.output1(PC_EXT0i[9]),
		.output2(PC_EXT0i[10]), 
		.output3(PC_EXT0i[11]),
		.output4(PC_EXT0i[12]),
		.output5(PC_EXT0i[13]), 
		.output6(PC_EXT0i[14]),
		.output7(PC_EXT0i[15])
		);
		
	busmacro_xc4v_r2l_async_narrow bmi0bm2(
		.input0(PC_EXT0e[16]),
		.input1(PC_EXT0e[17]),
		.input2(PC_EXT0e[18]), 
		.input3(PC_EXT0e[19]),
		.input4(PC_EXT0e[20]),
		.input5(PC_EXT0e[21]), 
		.input6(PC_EXT0e[22]),
		.input7(PC_EXT0e[23]), 
		.output0(PC_EXT0i[16]),
		.output1(PC_EXT0i[17]),
		.output2(PC_EXT0i[18]), 
		.output3(PC_EXT0i[19]),
		.output4(PC_EXT0i[20]),
		.output5(PC_EXT0i[21]), 
		.output6(PC_EXT0i[22]),
		.output7(PC_EXT0i[23])
		);
		
	busmacro_xc4v_r2l_async_narrow bmi0bm3(
		.input0(PC_EXT0e[24]),
		.input1(PC_EXT0e[25]),
		.input2(PC_EXT0e[26]), 
		.input3(PC_EXT0e[27]),
		.input4(PC_EXT0e[28]),
		.input5(PC_EXT0e[29]), 
		.input6(PC_EXT0e[30]),
		.input7(PC_EXT0e[31]), 
		.output0(PC_EXT0i[24]),
		.output1(PC_EXT0i[25]),
		.output2(PC_EXT0i[26]), 
		.output3(PC_EXT0i[27]),
		.output4(PC_EXT0i[28]),
		.output5(PC_EXT0i[29]), 
		.output6(PC_EXT0i[30]),
		.output7(PC_EXT0i[31])
		);
		
	/*INSTR_EXT0e -> INSTR_EXT0i*/
		
	busmacro_xc4v_r2l_async_narrow bmi1bm0(
		.input0(INSTR_EXT0e[0]),
		.input1(INSTR_EXT0e[1]),
		.input2(INSTR_EXT0e[2]), 
		.input3(INSTR_EXT0e[3]),
		.input4(INSTR_EXT0e[4]),
		.input5(INSTR_EXT0e[5]), 
		.input6(INSTR_EXT0e[6]),
		.input7(INSTR_EXT0e[7]), 
		.output0(INSTR_EXT0i[0]),
		.output1(INSTR_EXT0i[1]),
		.output2(INSTR_EXT0i[2]), 
		.output3(INSTR_EXT0i[3]),
		.output4(INSTR_EXT0i[4]),
		.output5(INSTR_EXT0i[5]), 
		.output6(INSTR_EXT0i[6]),
		.output7(INSTR_EXT0i[7])
		);

	busmacro_xc4v_r2l_async_narrow bmi1bm1(
		.input0(INSTR_EXT0e[8]),
		.input1(INSTR_EXT0e[9]),
		.input2(INSTR_EXT0e[10]), 
		.input3(INSTR_EXT0e[11]),
		.input4(INSTR_EXT0e[12]),
		.input5(INSTR_EXT0e[13]), 
		.input6(INSTR_EXT0e[14]),
		.input7(INSTR_EXT0e[15]), 
		.output0(INSTR_EXT0i[8]),
		.output1(INSTR_EXT0i[9]),
		.output2(INSTR_EXT0i[10]), 
		.output3(INSTR_EXT0i[11]),
		.output4(INSTR_EXT0i[12]),
		.output5(INSTR_EXT0i[13]), 
		.output6(INSTR_EXT0i[14]),
		.output7(INSTR_EXT0i[15])
		);
		
	busmacro_xc4v_r2l_async_narrow bmi1bm2(
		.input0(INSTR_EXT0e[16]),
		.input1(INSTR_EXT0e[17]),
		.input2(INSTR_EXT0e[18]), 
		.input3(INSTR_EXT0e[19]),
		.input4(INSTR_EXT0e[20]),
		.input5(INSTR_EXT0e[21]), 
		.input6(INSTR_EXT0e[22]),
		.input7(INSTR_EXT0e[23]), 		
		.output0(INSTR_EXT0i[16]),
		.output1(INSTR_EXT0i[17]),
		.output2(INSTR_EXT0i[18]), 
		.output3(INSTR_EXT0i[19]),
		.output4(INSTR_EXT0i[20]),
		.output5(INSTR_EXT0i[21]), 
		.output6(INSTR_EXT0i[22]),
		.output7(INSTR_EXT0i[23])
		);
		
	busmacro_xc4v_r2l_async_narrow bmi1bm3(
		.input0(INSTR_EXT0e[24]),
		.input1(INSTR_EXT0e[25]),
		.input2(INSTR_EXT0e[26]), 
		.input3(INSTR_EXT0e[27]),
		.input4(INSTR_EXT0e[28]),
		.input5(INSTR_EXT0e[29]), 
		.input6(INSTR_EXT0e[30]),
		.input7(INSTR_EXT0e[31]), 		
		.output0(INSTR_EXT0i[24]),
		.output1(INSTR_EXT0i[25]),
		.output2(INSTR_EXT0i[26]), 
		.output3(INSTR_EXT0i[27]),
		.output4(INSTR_EXT0i[28]),
		.output5(INSTR_EXT0i[29]), 
		.output6(INSTR_EXT0i[30]),
		.output7(INSTR_EXT0i[31])
		);
		
	/*RDREG1DATA_EXT0e -> RDREG1DATA_EXT0i*/
		
	busmacro_xc4v_r2l_async_narrow bmi2bm0(
		.input0(RDREG1DATA_EXT0e[0]),
		.input1(RDREG1DATA_EXT0e[1]),
		.input2(RDREG1DATA_EXT0e[2]), 
		.input3(RDREG1DATA_EXT0e[3]),
		.input4(RDREG1DATA_EXT0e[4]),
		.input5(RDREG1DATA_EXT0e[5]), 
		.input6(RDREG1DATA_EXT0e[6]),
		.input7(RDREG1DATA_EXT0e[7]), 
		.output0(RDREG1DATA_EXT0i[0]),
		.output1(RDREG1DATA_EXT0i[1]),
		.output2(RDREG1DATA_EXT0i[2]), 
		.output3(RDREG1DATA_EXT0i[3]),
		.output4(RDREG1DATA_EXT0i[4]),
		.output5(RDREG1DATA_EXT0i[5]), 
		.output6(RDREG1DATA_EXT0i[6]),
		.output7(RDREG1DATA_EXT0i[7])
		);

	busmacro_xc4v_r2l_async_narrow bmi2bm1(
		.input0(RDREG1DATA_EXT0e[8]),
		.input1(RDREG1DATA_EXT0e[9]),
		.input2(RDREG1DATA_EXT0e[10]), 
		.input3(RDREG1DATA_EXT0e[11]),
		.input4(RDREG1DATA_EXT0e[12]),
		.input5(RDREG1DATA_EXT0e[13]), 
		.input6(RDREG1DATA_EXT0e[14]),
		.input7(RDREG1DATA_EXT0e[15]), 
		.output0(RDREG1DATA_EXT0i[8]),
		.output1(RDREG1DATA_EXT0i[9]),
		.output2(RDREG1DATA_EXT0i[10]), 
		.output3(RDREG1DATA_EXT0i[11]),
		.output4(RDREG1DATA_EXT0i[12]),
		.output5(RDREG1DATA_EXT0i[13]), 
		.output6(RDREG1DATA_EXT0i[14]),
		.output7(RDREG1DATA_EXT0i[15])
		);
		
	busmacro_xc4v_r2l_async_narrow bmi2bm2(
		.input0(RDREG1DATA_EXT0e[16]),
		.input1(RDREG1DATA_EXT0e[17]),
		.input2(RDREG1DATA_EXT0e[18]), 
		.input3(RDREG1DATA_EXT0e[19]),
		.input4(RDREG1DATA_EXT0e[20]),
		.input5(RDREG1DATA_EXT0e[21]), 
		.input6(RDREG1DATA_EXT0e[22]),
		.input7(RDREG1DATA_EXT0e[23]), 
		.output0(RDREG1DATA_EXT0i[16]),
		.output1(RDREG1DATA_EXT0i[17]),
		.output2(RDREG1DATA_EXT0i[18]), 
		.output3(RDREG1DATA_EXT0i[19]),
		.output4(RDREG1DATA_EXT0i[20]),
		.output5(RDREG1DATA_EXT0i[21]), 
		.output6(RDREG1DATA_EXT0i[22]),
		.output7(RDREG1DATA_EXT0i[23])
		);
		
	busmacro_xc4v_r2l_async_narrow bmi2bm3(
		.input0(RDREG1DATA_EXT0e[24]),
		.input1(RDREG1DATA_EXT0e[25]),
		.input2(RDREG1DATA_EXT0e[26]), 
		.input3(RDREG1DATA_EXT0e[27]),
		.input4(RDREG1DATA_EXT0e[28]),
		.input5(RDREG1DATA_EXT0e[29]), 
		.input6(RDREG1DATA_EXT0e[30]),
		.input7(RDREG1DATA_EXT0e[31]), 
		.output0(RDREG1DATA_EXT0i[24]),
		.output1(RDREG1DATA_EXT0i[25]),
		.output2(RDREG1DATA_EXT0i[26]), 
		.output3(RDREG1DATA_EXT0i[27]),
		.output4(RDREG1DATA_EXT0i[28]),
		.output5(RDREG1DATA_EXT0i[29]), 
		.output6(RDREG1DATA_EXT0i[30]),
		.output7(RDREG1DATA_EXT0i[31])
		);

	/*RDREG2DATA_EXT0e -> RDREG2DATA_EXT0i*/

	busmacro_xc4v_r2l_async_narrow bmi3bm0(
		.input0(RDREG2DATA_EXT0e[0]),
		.input1(RDREG2DATA_EXT0e[1]),
		.input2(RDREG2DATA_EXT0e[2]), 
		.input3(RDREG2DATA_EXT0e[3]),
		.input4(RDREG2DATA_EXT0e[4]),
		.input5(RDREG2DATA_EXT0e[5]), 
		.input6(RDREG2DATA_EXT0e[6]),
		.input7(RDREG2DATA_EXT0e[7]), 
		.output0(RDREG2DATA_EXT0i[0]),
		.output1(RDREG2DATA_EXT0i[1]),
		.output2(RDREG2DATA_EXT0i[2]), 
		.output3(RDREG2DATA_EXT0i[3]),
		.output4(RDREG2DATA_EXT0i[4]),
		.output5(RDREG2DATA_EXT0i[5]), 
		.output6(RDREG2DATA_EXT0i[6]),
		.output7(RDREG2DATA_EXT0i[7])
		);

	busmacro_xc4v_r2l_async_narrow bmi3bm1(
		.input0(RDREG2DATA_EXT0e[8]),
		.input1(RDREG2DATA_EXT0e[9]),
		.input2(RDREG2DATA_EXT0e[10]), 
		.input3(RDREG2DATA_EXT0e[11]),
		.input4(RDREG2DATA_EXT0e[12]),
		.input5(RDREG2DATA_EXT0e[13]), 
		.input6(RDREG2DATA_EXT0e[14]),
		.input7(RDREG2DATA_EXT0e[15]), 
		.output0(RDREG2DATA_EXT0i[8]),
		.output1(RDREG2DATA_EXT0i[9]),
		.output2(RDREG2DATA_EXT0i[10]), 
		.output3(RDREG2DATA_EXT0i[11]),
		.output4(RDREG2DATA_EXT0i[12]),
		.output5(RDREG2DATA_EXT0i[13]), 
		.output6(RDREG2DATA_EXT0i[14]),
		.output7(RDREG2DATA_EXT0i[15])
		);
		
	busmacro_xc4v_r2l_async_narrow bmi3bm2(
		.input0(RDREG2DATA_EXT0e[16]),
		.input1(RDREG2DATA_EXT0e[17]),
		.input2(RDREG2DATA_EXT0e[18]), 
		.input3(RDREG2DATA_EXT0e[19]),
		.input4(RDREG2DATA_EXT0e[20]),
		.input5(RDREG2DATA_EXT0e[21]), 
		.input6(RDREG2DATA_EXT0e[22]),
		.input7(RDREG2DATA_EXT0e[23]), 
		.output0(RDREG2DATA_EXT0i[16]),
		.output1(RDREG2DATA_EXT0i[17]),
		.output2(RDREG2DATA_EXT0i[18]), 
		.output3(RDREG2DATA_EXT0i[19]),
		.output4(RDREG2DATA_EXT0i[20]),
		.output5(RDREG2DATA_EXT0i[21]), 
		.output6(RDREG2DATA_EXT0i[22]),
		.output7(RDREG2DATA_EXT0i[23])
		);
		
	busmacro_xc4v_r2l_async_narrow bmi3bm3(
		.input0(RDREG2DATA_EXT0e[24]),
		.input1(RDREG2DATA_EXT0e[25]),
		.input2(RDREG2DATA_EXT0e[26]), 
		.input3(RDREG2DATA_EXT0e[27]),
		.input4(RDREG2DATA_EXT0e[28]),
		.input5(RDREG2DATA_EXT0e[29]), 
		.input6(RDREG2DATA_EXT0e[30]),
		.input7(RDREG2DATA_EXT0e[31]), 
		.output0(RDREG2DATA_EXT0i[24]),
		.output1(RDREG2DATA_EXT0i[25]),
		.output2(RDREG2DATA_EXT0i[26]), 
		.output3(RDREG2DATA_EXT0i[27]),
		.output4(RDREG2DATA_EXT0i[28]),
		.output5(RDREG2DATA_EXT0i[29]), 
		.output6(RDREG2DATA_EXT0i[30]),
		.output7(RDREG2DATA_EXT0i[31])
		);

	/*RDREG3DATA_EXT0e -> RDREG3DATA_EXT0i*/
		
	busmacro_xc4v_r2l_async_narrow bmi4bm0(
		.input0(RDREG3DATA_EXT0e[0]),
		.input1(RDREG3DATA_EXT0e[1]),
		.input2(RDREG3DATA_EXT0e[2]), 
		.input3(RDREG3DATA_EXT0e[3]),
		.input4(RDREG3DATA_EXT0e[4]),
		.input5(RDREG3DATA_EXT0e[5]), 
		.input6(RDREG3DATA_EXT0e[6]),
		.input7(RDREG3DATA_EXT0e[7]), 
		.output0(RDREG3DATA_EXT0i[0]),
		.output1(RDREG3DATA_EXT0i[1]),
		.output2(RDREG3DATA_EXT0i[2]), 
		.output3(RDREG3DATA_EXT0i[3]),
		.output4(RDREG3DATA_EXT0i[4]),
		.output5(RDREG3DATA_EXT0i[5]), 
		.output6(RDREG3DATA_EXT0i[6]),
		.output7(RDREG3DATA_EXT0i[7])
		);

	busmacro_xc4v_r2l_async_narrow bmi4bm1(
		.input0(RDREG3DATA_EXT0e[8]),
		.input1(RDREG3DATA_EXT0e[9]),
		.input2(RDREG3DATA_EXT0e[10]), 
		.input3(RDREG3DATA_EXT0e[11]),
		.input4(RDREG3DATA_EXT0e[12]),
		.input5(RDREG3DATA_EXT0e[13]), 
		.input6(RDREG3DATA_EXT0e[14]),
		.input7(RDREG3DATA_EXT0e[15]), 
		.output0(RDREG3DATA_EXT0i[8]),
		.output1(RDREG3DATA_EXT0i[9]),
		.output2(RDREG3DATA_EXT0i[10]), 
		.output3(RDREG3DATA_EXT0i[11]),
		.output4(RDREG3DATA_EXT0i[12]),
		.output5(RDREG3DATA_EXT0i[13]), 
		.output6(RDREG3DATA_EXT0i[14]),
		.output7(RDREG3DATA_EXT0i[15])
		);
		
	busmacro_xc4v_r2l_async_narrow bmi4bm2(
		.input0(RDREG3DATA_EXT0e[16]),
		.input1(RDREG3DATA_EXT0e[17]),
		.input2(RDREG3DATA_EXT0e[18]), 
		.input3(RDREG3DATA_EXT0e[19]),
		.input4(RDREG3DATA_EXT0e[20]),
		.input5(RDREG3DATA_EXT0e[21]), 
		.input6(RDREG3DATA_EXT0e[22]),
		.input7(RDREG3DATA_EXT0e[23]), 
		.output0(RDREG3DATA_EXT0i[16]),
		.output1(RDREG3DATA_EXT0i[17]),
		.output2(RDREG3DATA_EXT0i[18]), 
		.output3(RDREG3DATA_EXT0i[19]),
		.output4(RDREG3DATA_EXT0i[20]),
		.output5(RDREG3DATA_EXT0i[21]), 
		.output6(RDREG3DATA_EXT0i[22]),
		.output7(RDREG3DATA_EXT0i[23])
		);
		
	busmacro_xc4v_r2l_async_narrow bmi4bm3(
		.input0(RDREG3DATA_EXT0e[24]),
		.input1(RDREG3DATA_EXT0e[25]),
		.input2(RDREG3DATA_EXT0e[26]), 
		.input3(RDREG3DATA_EXT0e[27]),
		.input4(RDREG3DATA_EXT0e[28]),
		.input5(RDREG3DATA_EXT0e[29]), 
		.input6(RDREG3DATA_EXT0e[30]),
		.input7(RDREG3DATA_EXT0e[31]), 
		.output0(RDREG3DATA_EXT0i[24]),
		.output1(RDREG3DATA_EXT0i[25]),
		.output2(RDREG3DATA_EXT0i[26]), 
		.output3(RDREG3DATA_EXT0i[27]),
		.output4(RDREG3DATA_EXT0i[28]),
		.output5(RDREG3DATA_EXT0i[29]), 
		.output6(RDREG3DATA_EXT0i[30]),
		.output7(RDREG3DATA_EXT0i[31])
		);
		
	/*RDREG4DATA_EXT0e -> RDREG4DATA_EXT0i*/
		
	busmacro_xc4v_r2l_async_narrow bmi5bm0(
		.input0(RDREG4DATA_EXT0e[0]),
		.input1(RDREG4DATA_EXT0e[1]),
		.input2(RDREG4DATA_EXT0e[2]), 
		.input3(RDREG4DATA_EXT0e[3]),
		.input4(RDREG4DATA_EXT0e[4]),
		.input5(RDREG4DATA_EXT0e[5]), 
		.input6(RDREG4DATA_EXT0e[6]),
		.input7(RDREG4DATA_EXT0e[7]), 
		.output0(RDREG4DATA_EXT0i[0]),
		.output1(RDREG4DATA_EXT0i[1]),
		.output2(RDREG4DATA_EXT0i[2]), 
		.output3(RDREG4DATA_EXT0i[3]),
		.output4(RDREG4DATA_EXT0i[4]),
		.output5(RDREG4DATA_EXT0i[5]), 
		.output6(RDREG4DATA_EXT0i[6]),
		.output7(RDREG4DATA_EXT0i[7])
		);

	busmacro_xc4v_r2l_async_narrow bmi5bm1(
		.input0(RDREG4DATA_EXT0e[8]),
		.input1(RDREG4DATA_EXT0e[9]),
		.input2(RDREG4DATA_EXT0e[10]), 
		.input3(RDREG4DATA_EXT0e[11]),
		.input4(RDREG4DATA_EXT0e[12]),
		.input5(RDREG4DATA_EXT0e[13]), 
		.input6(RDREG4DATA_EXT0e[14]),
		.input7(RDREG4DATA_EXT0e[15]), 
		.output0(RDREG4DATA_EXT0i[8]),
		.output1(RDREG4DATA_EXT0i[9]),
		.output2(RDREG4DATA_EXT0i[10]), 
		.output3(RDREG4DATA_EXT0i[11]),
		.output4(RDREG4DATA_EXT0i[12]),
		.output5(RDREG4DATA_EXT0i[13]), 
		.output6(RDREG4DATA_EXT0i[14]),
		.output7(RDREG4DATA_EXT0i[15])
		);
		
	busmacro_xc4v_r2l_async_narrow bmi5bm2(
		.input0(RDREG4DATA_EXT0e[16]),
		.input1(RDREG4DATA_EXT0e[17]),
		.input2(RDREG4DATA_EXT0e[18]), 
		.input3(RDREG4DATA_EXT0e[19]),
		.input4(RDREG4DATA_EXT0e[20]),
		.input5(RDREG4DATA_EXT0e[21]), 
		.input6(RDREG4DATA_EXT0e[22]),
		.input7(RDREG4DATA_EXT0e[23]), 
		.output0(RDREG4DATA_EXT0i[16]),
		.output1(RDREG4DATA_EXT0i[17]),
		.output2(RDREG4DATA_EXT0i[18]), 
		.output3(RDREG4DATA_EXT0i[19]),
		.output4(RDREG4DATA_EXT0i[20]),
		.output5(RDREG4DATA_EXT0i[21]), 
		.output6(RDREG4DATA_EXT0i[22]),
		.output7(RDREG4DATA_EXT0i[23])
		);
		
	busmacro_xc4v_r2l_async_narrow bmi5bm3(
		.input0(RDREG4DATA_EXT0e[24]),
		.input1(RDREG4DATA_EXT0e[25]),
		.input2(RDREG4DATA_EXT0e[26]), 
		.input3(RDREG4DATA_EXT0e[27]),
		.input4(RDREG4DATA_EXT0e[28]),
		.input5(RDREG4DATA_EXT0e[29]), 
		.input6(RDREG4DATA_EXT0e[30]),
		.input7(RDREG4DATA_EXT0e[31]), 
		.output0(RDREG4DATA_EXT0i[24]),
		.output1(RDREG4DATA_EXT0i[25]),
		.output2(RDREG4DATA_EXT0i[26]), 
		.output3(RDREG4DATA_EXT0i[27]),
		.output4(RDREG4DATA_EXT0i[28]),
		.output5(RDREG4DATA_EXT0i[29]), 
		.output6(RDREG4DATA_EXT0i[30]),
		.output7(RDREG4DATA_EXT0i[31])
		);
		
	/*WRDATA1_RG_EXT0e -> WRDATA1_RG_EXT0i*/
		
	busmacro_xc4v_r2l_async_narrow bmi6bm0(
		.input0(WRDATA1_RG_EXT0e[0]),
		.input1(WRDATA1_RG_EXT0e[1]),
		.input2(WRDATA1_RG_EXT0e[2]), 
		.input3(WRDATA1_RG_EXT0e[3]),
		.input4(WRDATA1_RG_EXT0e[4]),
		.input5(WRDATA1_RG_EXT0e[5]), 
		.input6(WRDATA1_RG_EXT0e[6]),
		.input7(WRDATA1_RG_EXT0e[7]), 
		.output0(WRDATA1_RG_EXT0i[0]),
		.output1(WRDATA1_RG_EXT0i[1]),
		.output2(WRDATA1_RG_EXT0i[2]), 
		.output3(WRDATA1_RG_EXT0i[3]),
		.output4(WRDATA1_RG_EXT0i[4]),
		.output5(WRDATA1_RG_EXT0i[5]), 
		.output6(WRDATA1_RG_EXT0i[6]),
		.output7(WRDATA1_RG_EXT0i[7])
		);

	busmacro_xc4v_r2l_async_narrow bmi6bm1(
		.input0(WRDATA1_RG_EXT0e[8]),
		.input1(WRDATA1_RG_EXT0e[9]),
		.input2(WRDATA1_RG_EXT0e[10]), 
		.input3(WRDATA1_RG_EXT0e[11]),
		.input4(WRDATA1_RG_EXT0e[12]),
		.input5(WRDATA1_RG_EXT0e[13]), 
		.input6(WRDATA1_RG_EXT0e[14]),
		.input7(WRDATA1_RG_EXT0e[15]), 
		.output0(WRDATA1_RG_EXT0i[8]),
		.output1(WRDATA1_RG_EXT0i[9]),
		.output2(WRDATA1_RG_EXT0i[10]), 
		.output3(WRDATA1_RG_EXT0i[11]),
		.output4(WRDATA1_RG_EXT0i[12]),
		.output5(WRDATA1_RG_EXT0i[13]), 
		.output6(WRDATA1_RG_EXT0i[14]),
		.output7(WRDATA1_RG_EXT0i[15])
		);
		
	busmacro_xc4v_r2l_async_narrow bmi6bm2(
		.input0(WRDATA1_RG_EXT0e[16]),
		.input1(WRDATA1_RG_EXT0e[17]),
		.input2(WRDATA1_RG_EXT0e[18]), 
		.input3(WRDATA1_RG_EXT0e[19]),
		.input4(WRDATA1_RG_EXT0e[20]),
		.input5(WRDATA1_RG_EXT0e[21]), 
		.input6(WRDATA1_RG_EXT0e[22]),
		.input7(WRDATA1_RG_EXT0e[23]), 
		.output0(WRDATA1_RG_EXT0i[16]),
		.output1(WRDATA1_RG_EXT0i[17]),
		.output2(WRDATA1_RG_EXT0i[18]), 
		.output3(WRDATA1_RG_EXT0i[19]),
		.output4(WRDATA1_RG_EXT0i[20]),
		.output5(WRDATA1_RG_EXT0i[21]), 
		.output6(WRDATA1_RG_EXT0i[22]),
		.output7(WRDATA1_RG_EXT0i[23])
		);
		
	busmacro_xc4v_r2l_async_narrow bmi6bm3(
		.input0(WRDATA1_RG_EXT0e[24]),
		.input1(WRDATA1_RG_EXT0e[25]),
		.input2(WRDATA1_RG_EXT0e[26]), 
		.input3(WRDATA1_RG_EXT0e[27]),
		.input4(WRDATA1_RG_EXT0e[28]),
		.input5(WRDATA1_RG_EXT0e[29]), 
		.input6(WRDATA1_RG_EXT0e[30]),
		.input7(WRDATA1_RG_EXT0e[31]), 	
		.output0(WRDATA1_RG_EXT0i[24]),
		.output1(WRDATA1_RG_EXT0i[25]),
		.output2(WRDATA1_RG_EXT0i[26]), 
		.output3(WRDATA1_RG_EXT0i[27]),
		.output4(WRDATA1_RG_EXT0i[28]),
		.output5(WRDATA1_RG_EXT0i[29]), 
		.output6(WRDATA1_RG_EXT0i[30]),
		.output7(WRDATA1_RG_EXT0i[31])
		);
		
	/*WRDATA2_RG_EXT0e -> WRDATA2_RG_EXT0i*/
		
	busmacro_xc4v_r2l_async_narrow bmi7bm0(
		.input0(WRDATA2_RG_EXT0e[0]),
		.input1(WRDATA2_RG_EXT0e[1]),
		.input2(WRDATA2_RG_EXT0e[2]), 
		.input3(WRDATA2_RG_EXT0e[3]),
		.input4(WRDATA2_RG_EXT0e[4]),
		.input5(WRDATA2_RG_EXT0e[5]), 
		.input6(WRDATA2_RG_EXT0e[6]),
		.input7(WRDATA2_RG_EXT0e[7]), 
		.output0(WRDATA2_RG_EXT0i[0]),
		.output1(WRDATA2_RG_EXT0i[1]),
		.output2(WRDATA2_RG_EXT0i[2]), 
		.output3(WRDATA2_RG_EXT0i[3]),
		.output4(WRDATA2_RG_EXT0i[4]),
		.output5(WRDATA2_RG_EXT0i[5]), 
		.output6(WRDATA2_RG_EXT0i[6]),
		.output7(WRDATA2_RG_EXT0i[7])
		);

	busmacro_xc4v_r2l_async_narrow bmi7bm1(
		.input0(WRDATA2_RG_EXT0e[8]),
		.input1(WRDATA2_RG_EXT0e[9]),
		.input2(WRDATA2_RG_EXT0e[10]), 
		.input3(WRDATA2_RG_EXT0e[11]),
		.input4(WRDATA2_RG_EXT0e[12]),
		.input5(WRDATA2_RG_EXT0e[13]), 
		.input6(WRDATA2_RG_EXT0e[14]),
		.input7(WRDATA2_RG_EXT0e[15]), 
		.output0(WRDATA2_RG_EXT0i[8]),
		.output1(WRDATA2_RG_EXT0i[9]),
		.output2(WRDATA2_RG_EXT0i[10]), 
		.output3(WRDATA2_RG_EXT0i[11]),
		.output4(WRDATA2_RG_EXT0i[12]),
		.output5(WRDATA2_RG_EXT0i[13]), 
		.output6(WRDATA2_RG_EXT0i[14]),
		.output7(WRDATA2_RG_EXT0i[15])
		);
		
	busmacro_xc4v_r2l_async_narrow bmi7bm2(
		.input0(WRDATA2_RG_EXT0e[16]),
		.input1(WRDATA2_RG_EXT0e[17]),
		.input2(WRDATA2_RG_EXT0e[18]), 
		.input3(WRDATA2_RG_EXT0e[19]),
		.input4(WRDATA2_RG_EXT0e[20]),
		.input5(WRDATA2_RG_EXT0e[21]), 
		.input6(WRDATA2_RG_EXT0e[22]),
		.input7(WRDATA2_RG_EXT0e[23]), 
		.output0(WRDATA2_RG_EXT0i[16]),
		.output1(WRDATA2_RG_EXT0i[17]),
		.output2(WRDATA2_RG_EXT0i[18]), 
		.output3(WRDATA2_RG_EXT0i[19]),
		.output4(WRDATA2_RG_EXT0i[20]),
		.output5(WRDATA2_RG_EXT0i[21]), 
		.output6(WRDATA2_RG_EXT0i[22]),
		.output7(WRDATA2_RG_EXT0i[23])
		);
		
	busmacro_xc4v_r2l_async_narrow bmi7bm3(
		.input0(WRDATA2_RG_EXT0e[24]),
		.input1(WRDATA2_RG_EXT0e[25]),
		.input2(WRDATA2_RG_EXT0e[26]), 
		.input3(WRDATA2_RG_EXT0e[27]),
		.input4(WRDATA2_RG_EXT0e[28]),
		.input5(WRDATA2_RG_EXT0e[29]), 
		.input6(WRDATA2_RG_EXT0e[30]),
		.input7(WRDATA2_RG_EXT0e[31]), 
		.output0(WRDATA2_RG_EXT0i[24]),
		.output1(WRDATA2_RG_EXT0i[25]),
		.output2(WRDATA2_RG_EXT0i[26]), 
		.output3(WRDATA2_RG_EXT0i[27]),
		.output4(WRDATA2_RG_EXT0i[28]),
		.output5(WRDATA2_RG_EXT0i[29]), 
		.output6(WRDATA2_RG_EXT0i[30]),
		.output7(WRDATA2_RG_EXT0i[31])
		);
		
	/*WRREG1_RG_EXT0e -> WRREG1_RG_EXT0i*/
	/*REGWRITE1_RG_EXT0e -> REGWRITE1_RG_EXT0i*/
	/*FULL_RG_EXT0e -> FULL_RG_EXT0i*/
	/*EMPTY_RG_EXT0e -> EMPTY_RG_EXT0i*/
		
	busmacro_xc4v_r2l_async_narrow bmi8bm0(
		.input0(WRREG1_RG_EXT0e[0]),
		.input1(WRREG1_RG_EXT0e[1]),
		.input2(WRREG1_RG_EXT0e[2]), 
		.input3(WRREG1_RG_EXT0e[3]),
		.input4(WRREG1_RG_EXT0e[4]),
		.input5(REGWRITE1_RG_EXT0e), 
		.input6(FULL_RG_EXT0e),
		.input7(EMPTY_RG_EXT0e), 
		.output0(WRREG1_RG_EXT0i[0]),
		.output1(WRREG1_RG_EXT0i[1]),
		.output2(WRREG1_RG_EXT0i[2]), 
		.output3(WRREG1_RG_EXT0i[3]),
		.output4(WRREG1_RG_EXT0i[4]),
		.output5(REGWRITE1_RG_EXT0i), 
		.output6(FULL_RG_EXT0i),
		.output7(EMPTY_RG_EXT0i)
		);	
		
	/*WRREG2_RG_EXT0e -> WRREG2_RG_EXT0i*/
	/*REGWRITE2_RG_EXT0e -> REGWRITE2_RG_EXT0i*/
	/*REGRDY_EXT0e -> REGRDY_EXT0i*/
	/*EXCEXT_EXT0e -> EXCEXT_EXT0i*/
		
	busmacro_xc4v_r2l_async_narrow bmi9bm0(
		.input0(WRREG2_RG_EXT0e[0]),
		.input1(WRREG2_RG_EXT0e[1]),
		.input2(WRREG2_RG_EXT0e[2]), 
		.input3(WRREG2_RG_EXT0e[3]),
		.input4(WRREG2_RG_EXT0e[4]),
		.input5(REGWRITE2_RG_EXT0e), 
		.input6(REGRDY_EXT0e),
		.input7(EXCEXT_EXT0e),
		.output0(WRREG2_RG_EXT0i[0]),
		.output1(WRREG2_RG_EXT0i[1]),
		.output2(WRREG2_RG_EXT0i[2]), 
		.output3(WRREG2_RG_EXT0i[3]),
		.output4(WRREG2_RG_EXT0i[4]),
		.output5(REGWRITE2_RG_EXT0i), 
		.output6(REGRDY_EXT0i),
		.output7(EXCEXT_EXT0i)
		);
		
	/*PCLK_EXT0e -> PCLK_EXT0i*/
	/*RESET_EXT0e -> RESET_EXT0i*/
	/*EN_EXT0e -> EN_EXT0i*/
	/*GR_EXT0e -> GR_EXT0i*/
	/*EXTNOP_EX_EXT0e -> EXTNOP_MA_EXT0e*/
	/*EXTNOP_MA_EXT0e -> EXTNOP_MA_EXT0i*/
	/*ENEXT_EXT0e -> ENEXT_EXT0i*/
		
	busmacro_xc4v_r2l_async_narrow bmi10bm0(
		.input0(PCLK_EXT0e),
		.input1(RESET_EXT0e),
		.input2(EN_EXT0e), 
		.input3(GR_EXT0e),
		.input4(EXTNOP_EX_EXT0e),
		.input5(EXTNOP_MA_EXT0e), 
		.input6(ENEXT_EXT0e),
		.input7(LDEXT_EXT0e), 
		.output0(PCLK_EXT0i),
		.output1(RESET_EXT0i),
		.output2(EN_EXT0i), 
		.output3(GR_EXT0i),
		.output4(EXTNOP_EX_EXT0i),
		.output5(EXTNOP_MA_EXT0i), 
		.output6(ENEXT_EXT0i),
		.output7(LDEXT_EXT0i)
		);

	/*W_MDATA_TISA_BM -> W_MDATA_BM_E */

	busmacro_xc4v_r2l_async_narrow bmi11bm0(
		.input0(W_MDATA_TISA_BM[0]),
		.input1(W_MDATA_TISA_BM[1]),
		.input2(W_MDATA_TISA_BM[2]), 
		.input3(W_MDATA_TISA_BM[3]),
		.input4(W_MDATA_TISA_BM[4]),
		.input5(W_MDATA_TISA_BM[5]), 
		.input6(W_MDATA_TISA_BM[6]),
		.input7(W_MDATA_TISA_BM[7]), 
		.output0(W_MDATA_BM_E[0]),
		.output1(W_MDATA_BM_E[1]),
		.output2(W_MDATA_BM_E[2]), 
		.output3(W_MDATA_BM_E[3]),
		.output4(W_MDATA_BM_E[4]),
		.output5(W_MDATA_BM_E[5]), 
		.output6(W_MDATA_BM_E[6]),
		.output7(W_MDATA_BM_E[7])
		);

	busmacro_xc4v_r2l_async_narrow bmi11bm1(
		.input0(W_MDATA_TISA_BM[8]),
		.input1(W_MDATA_TISA_BM[9]),
		.input2(W_MDATA_TISA_BM[10]), 
		.input3(W_MDATA_TISA_BM[11]),
		.input4(W_MDATA_TISA_BM[12]),
		.input5(W_MDATA_TISA_BM[13]), 
		.input6(W_MDATA_TISA_BM[14]),
		.input7(W_MDATA_TISA_BM[15]), 
		.output0(W_MDATA_BM_E[8]),
		.output1(W_MDATA_BM_E[9]),
		.output2(W_MDATA_BM_E[10]), 
		.output3(W_MDATA_BM_E[11]),
		.output4(W_MDATA_BM_E[12]),
		.output5(W_MDATA_BM_E[13]), 
		.output6(W_MDATA_BM_E[14]),
		.output7(W_MDATA_BM_E[15])
		);
		
	busmacro_xc4v_r2l_async_narrow bmi11bm2(
		.input0(W_MDATA_TISA_BM[16]),
		.input1(W_MDATA_TISA_BM[17]),
		.input2(W_MDATA_TISA_BM[18]), 
		.input3(W_MDATA_TISA_BM[19]),
		.input4(W_MDATA_TISA_BM[20]),
		.input5(W_MDATA_TISA_BM[21]), 
		.input6(W_MDATA_TISA_BM[22]),
		.input7(W_MDATA_TISA_BM[23]), 
		.output0(W_MDATA_BM_E[16]),
		.output1(W_MDATA_BM_E[17]),
		.output2(W_MDATA_BM_E[18]), 
		.output3(W_MDATA_BM_E[19]),
		.output4(W_MDATA_BM_E[20]),
		.output5(W_MDATA_BM_E[21]), 
		.output6(W_MDATA_BM_E[22]),
		.output7(W_MDATA_BM_E[23])
		);
		
	busmacro_xc4v_r2l_async_narrow bmi11bm3(
		.input0(W_MDATA_TISA_BM[24]),
		.input1(W_MDATA_TISA_BM[25]),
		.input2(W_MDATA_TISA_BM[26]), 
		.input3(W_MDATA_TISA_BM[27]),
		.input4(W_MDATA_TISA_BM[28]),
		.input5(W_MDATA_TISA_BM[29]), 
		.input6(W_MDATA_TISA_BM[30]),
		.input7(W_MDATA_TISA_BM[31]), 
		.output0(W_MDATA_BM_E[24]),
		.output1(W_MDATA_BM_E[25]),
		.output2(W_MDATA_BM_E[26]), 
		.output3(W_MDATA_BM_E[27]),
		.output4(W_MDATA_BM_E[28]),
		.output5(W_MDATA_BM_E[29]), 
		.output6(W_MDATA_BM_E[30]),
		.output7(W_MDATA_BM_E[31])
		);
		
	/*W_ADDR_TISA_BM -> W_ADDR_BM_E*/
		
	busmacro_xc4v_r2l_async_narrow bmi12bm0(
		.input0(W_ADDR_TISA_BM[0]),
		.input1(W_ADDR_TISA_BM[1]),
		.input2(W_ADDR_TISA_BM[2]), 
		.input3(W_ADDR_TISA_BM[3]),
		.input4(W_ADDR_TISA_BM[4]),
		.input5(W_ADDR_TISA_BM[5]), 
		.input6(W_ADDR_TISA_BM[6]),
		.input7(W_ADDR_TISA_BM[7]), 
		.output0(W_ADDR_BM_E[0]),
		.output1(W_ADDR_BM_E[1]),
		.output2(W_ADDR_BM_E[2]), 
		.output3(W_ADDR_BM_E[3]),
		.output4(W_ADDR_BM_E[4]),
		.output5(W_ADDR_BM_E[5]), 
		.output6(W_ADDR_BM_E[6]),
		.output7(W_ADDR_BM_E[7])
		);

	busmacro_xc4v_r2l_async_narrow bmi12bm1(
		.input0(W_ADDR_TISA_BM[8]),
		.input1(W_ADDR_TISA_BM[9]),
		.input2(W_ADDR_TISA_BM[10]), 
		.input3(W_ADDR_TISA_BM[11]),
		.input4(W_ADDR_TISA_BM[12]),
		.input5(W_ADDR_TISA_BM[13]), 
		.input6(W_ADDR_TISA_BM[14]),
		.input7(W_ADDR_TISA_BM[15]), 
		.output0(W_ADDR_BM_E[8]),
		.output1(W_ADDR_BM_E[9]),
		.output2(W_ADDR_BM_E[10]), 
		.output3(W_ADDR_BM_E[11]),
		.output4(W_ADDR_BM_E[12]),
		.output5(W_ADDR_BM_E[13]), 
		.output6(W_ADDR_BM_E[14]),
		.output7(W_ADDR_BM_E[15])
		);
		
	busmacro_xc4v_r2l_async_narrow bmi12bm2(
		.input0(W_ADDR_TISA_BM[16]),
		.input1(W_ADDR_TISA_BM[17]),
		.input2(W_ADDR_TISA_BM[18]), 
		.input3(W_ADDR_TISA_BM[19]),
		.input4(W_ADDR_TISA_BM[20]),
		.input5(W_ADDR_TISA_BM[21]), 
		.input6(W_ADDR_TISA_BM[22]),
		.input7(W_ADDR_TISA_BM[23]), 
		.output0(W_ADDR_BM_E[16]),
		.output1(W_ADDR_BM_E[17]),
		.output2(W_ADDR_BM_E[18]), 
		.output3(W_ADDR_BM_E[19]),
		.output4(W_ADDR_BM_E[20]),
		.output5(W_ADDR_BM_E[21]), 
		.output6(W_ADDR_BM_E[22]),
		.output7(W_ADDR_BM_E[23])
		);
		
	busmacro_xc4v_r2l_async_narrow bmi12bm3(
		.input0(W_ADDR_TISA_BM[24]),
		.input1(W_ADDR_TISA_BM[25]),
		.input2(W_ADDR_TISA_BM[26]), 
		.input3(W_ADDR_TISA_BM[27]),
		.input4(W_ADDR_TISA_BM[28]),
		.input5(W_ADDR_TISA_BM[29]), 
		.input6(W_ADDR_TISA_BM[30]),
		.input7(W_ADDR_TISA_BM[31]), 
		.output0(W_ADDR_BM_E[24]),
		.output1(W_ADDR_BM_E[25]),
		.output2(W_ADDR_BM_E[26]), 
		.output3(W_ADDR_BM_E[27]),
		.output4(W_ADDR_BM_E[28]),
		.output5(W_ADDR_BM_E[29]), 
		.output6(W_ADDR_BM_E[30]),
		.output7(W_ADDR_BM_E[31])
		);
		
	/*W_MDATAVLD_TISA_BM -> W_MDATAVLD_BM_E*/
	/*W_OE_TISA_BM -> W_OE_BM_E*/
	/*W_WE_TISA_BM -> W_WE_BM_E*/
	/*W_BAT_EN_TISA_BM -> W_BAT_EN_BM_E*/
	/*PER0_MSRT_EXT0e -> PER0_MSRT_EXT0i*/
	/*MBYTES_EXT0e -> MBYTES_EXT0i*/

	busmacro_xc4v_r2l_async_narrow bmi13bm0(
		.input0(W_MDATAVLD_TISA_BM),
		.input1(W_OE_TISA_BM),
		.input2(W_WE_TISA_BM), 
		.input3(W_BAT_EN_TISA_BM),
		.input4(PER0_MSRT_EXT0e),
		.input5(EXTCLK_EN_EXT0e),
		.input6(MBYTES_EXT0e[0]),
		.input7(MBYTES_EXT0e[1]),
		.output0(W_MDATAVLD_BM_E),
		.output1(W_OE_BM_E),
		.output2(W_WE_BM_E),
		.output3(W_BAT_EN_BM_E),
		.output4(PER0_MSRT_EXT0i),
		.output5(EXTCLK_EN_EXT0i), 
		.output6(MBYTES_EXT0i[0]),
		.output7(MBYTES_EXT0i[1])
		);
		
	busmacro_xc4v_r2l_async_narrow bmi13bm1(
		.input0(RX2),
		/*.input1(),*/
		/*.input2(),*/ 
		/*.input3(),*/
		/*.input4(),*/
		/*.input5(),*/
		/*.input6(),*/
		/*.input7(),*/
		.output0(RX2_EXT0i)/*,*/
		/*.output1(),*/
		/*.output2(),*/
		/*.output3(),*/
		/*.output4(),*/
		/*.output5(),*/ 
		/*.output6(),*/
		/*.output7()*/
		);

/*****Extension 0****************************************************************/

	extension0 ext0(
		.ACK(ACK_EXT0i),
		.BAT_EN_IN(W_BAT_EN_BM_E),
		.BLS_OUT(W_BLS_E_BM),
		.CLK(SYSCLK),
		.DNE_OUT(W_PER_DNE_EXT_BM),
		.EN(EN_EXT0i),
		.ENEXT(ENEXT_EXT0i),
		.EXC(EXC_EXT0i),
		.EXC_OUT(W_EXC_E_BM), 
		.EXCEXT(EXCEXT_EXT0i),
		.EXTADD(EXTADD_EXT0i),
		.EXTNOP_EX(EXTNOP_EX_EXT0i),
		.EXTNOP_MA(EXTNOP_MA_EXT0i),
		.GR(GR_EXT0i),
		.HLS_OUT(W_HLS_E_BM),
		.INSTR(INSTR_EXT0i),
		.INT_OUT(W_INT_E_BM),
		.PC(PC_EXT0i),
		.PCNEXT(PCNEXT_EXT0i),
		.PI(PI_EXT0i),
		.PCLK(PCLK_EXT0i),
		.MADDR_IN(W_ADDR_BM_E),
		.MADDR_OUT(W_MADDR_E_BM),
		.MDATA_IN(W_MDATA_BM_E),
		.MDATA_OUT(W_MDATA_E_BM), 
		.MDATA_VLD_IN(W_MDATAVLD_BM_E),
		.MLOCK_OUT(W_MLOCK_E_BM),
		.MOE_OUT(W_MOE_E_BM),
		.MWE_OUT(W_MWE_E_BM),
		.MY_ADDR_OUT(W_PER_MYADDR_EXT_BM),
		.OE_IN(W_OE_BM_E),
		.PRESENT_OUT(W_PRESENT_E_BM),
		.PRIVILEGE_OUT(W_PRIVILEGE_E_BM),
		.RDREG1(RDREG1_EXT0i),
		.RDREG1DATA(RDREG1DATA_EXT0i),
		.RDREG2(RDREG2_EXT0i),
		.RDREG2DATA(RDREG2DATA_EXT0i),
		.RDREG3(RDREG3_EXT0i),
		.RDREG3DATA(RDREG3DATA_EXT0i),
		.RDREG4DATA(RDREG4DATA_EXT0i),
		.RDREG4(RDREG4_EXT0i),
		.REGRDY(REGRDY_EXT0i),
		.REGFULL(FULL_RG_EXT0i),
		.REGEMPTY(EMPTY_RG_EXT0i),
		.REGWRITE1(REGWRITE1_EXT0i),
		.REGWRITE1_RG(REGWRITE1_RG_EXT0i),
		.REGWRITE2(REGWRITE2_EXT0i),
		.REGWRITE2_RG(REGWRITE2_RG_EXT0i),
		.REMA(REMA_EXT0i),
		.RESET(RESET_EXT0i),
		.REWB(REWB_EXT0i),
		.RI(RI_EXT0i),
		.RNL_OUT(W_RNL_E_BM),
		.WANT_INTR_OUT(W_WANT_INTR_E_BM),
		.WE_IN(W_WE_BM_E),
		.WRREG1_RG(WRREG1_RG_EXT0i),
		.WRREG2_RG(WRREG2_RG_EXT0i),
		.WRDATA1_RG(WRDATA1_RG_EXT0i),
		.WRDATA2_RG(WRDATA2_RG_EXT0i),
		.WRDATA1(WRDATA1_EXT0i),
		.WRDATA2(WRDATA2_EXT0i),
		.SRT(PER0_MSRT_EXT0i),
		.EXTCLK_EN(EXTCLK_EN_EXT0i),
		.LDEXT(LDEXT_EXT0i),
		.BYTES(MBYTES_EXT0i),
		.RX(RX2_EXT0i),
		.TX(TX2_EXT0i),
		.fspecial(fspecial_EXT0i)
		);
		
/*****Output Bus Macros****************************************************************/

	/*EXTADD_EXT0i -> EXTADD_EXT0e*/
		
	busmacro_xc4v_l2r_async_enable_narrow bmo0bm0(
		.enable0(LDEXT_EXT0e),
		.enable1(LDEXT_EXT0e),
		.enable2(LDEXT_EXT0e),
		.enable3(LDEXT_EXT0e), 
		.enable4(LDEXT_EXT0e),
		.enable5(LDEXT_EXT0e),
		.enable6(LDEXT_EXT0e),
		.enable7(LDEXT_EXT0e), 		
		.input0(EXTADD_EXT0i[0]),
		.input1(EXTADD_EXT0i[1]),
		.input2(EXTADD_EXT0i[2]), 
		.input3(EXTADD_EXT0i[3]),
		.input4(EXTADD_EXT0i[4]),
		.input5(EXTADD_EXT0i[5]), 
		.input6(EXTADD_EXT0i[6]),
		.input7(EXTADD_EXT0i[7]), 
		.output0(EXTADD_EXT0e[0]),
		.output1(EXTADD_EXT0e[1]),
		.output2(EXTADD_EXT0e[2]), 
		.output3(EXTADD_EXT0e[3]),
		.output4(EXTADD_EXT0e[4]),
		.output5(EXTADD_EXT0e[5]), 
		.output6(EXTADD_EXT0e[6]),
		.output7(EXTADD_EXT0e[7])
		);

	busmacro_xc4v_l2r_async_enable_narrow bmo0bm1(
		.enable0(LDEXT_EXT0e),
		.enable1(LDEXT_EXT0e),
		.enable2(LDEXT_EXT0e),
		.enable3(LDEXT_EXT0e), 
		.enable4(LDEXT_EXT0e),
		.enable5(LDEXT_EXT0e),
		.enable6(LDEXT_EXT0e),
		.enable7(LDEXT_EXT0e), 
		.input0(EXTADD_EXT0i[8]),
		.input1(EXTADD_EXT0i[9]),
		.input2(EXTADD_EXT0i[10]), 
		.input3(EXTADD_EXT0i[11]),
		.input4(EXTADD_EXT0i[12]),
		.input5(EXTADD_EXT0i[13]), 
		.input6(EXTADD_EXT0i[14]),
		.input7(EXTADD_EXT0i[15]), 
		.output0(EXTADD_EXT0e[8]),
		.output1(EXTADD_EXT0e[9]),
		.output2(EXTADD_EXT0e[10]), 
		.output3(EXTADD_EXT0e[11]),
		.output4(EXTADD_EXT0e[12]),
		.output5(EXTADD_EXT0e[13]), 
		.output6(EXTADD_EXT0e[14]),
		.output7(EXTADD_EXT0e[15])
		);
		
	busmacro_xc4v_l2r_async_enable_narrow bmo0bm2(
		.enable0(LDEXT_EXT0e),
		.enable1(LDEXT_EXT0e),
		.enable2(LDEXT_EXT0e),
		.enable3(LDEXT_EXT0e), 
		.enable4(LDEXT_EXT0e),
		.enable5(LDEXT_EXT0e),
		.enable6(LDEXT_EXT0e),
		.enable7(LDEXT_EXT0e), 
		.input0(EXTADD_EXT0i[16]),
		.input1(EXTADD_EXT0i[17]),
		.input2(EXTADD_EXT0i[18]), 
		.input3(EXTADD_EXT0i[19]),
		.input4(EXTADD_EXT0i[20]),
		.input5(EXTADD_EXT0i[21]), 
		.input6(EXTADD_EXT0i[22]),
		.input7(EXTADD_EXT0i[23]), 
		.output0(EXTADD_EXT0e[16]),
		.output1(EXTADD_EXT0e[17]),
		.output2(EXTADD_EXT0e[18]), 
		.output3(EXTADD_EXT0e[19]),
		.output4(EXTADD_EXT0e[20]),
		.output5(EXTADD_EXT0e[21]), 
		.output6(EXTADD_EXT0e[22]),
		.output7(EXTADD_EXT0e[23])
		);
		
	busmacro_xc4v_l2r_async_enable_narrow bmo0bm3(
		.enable0(LDEXT_EXT0e),
		.enable1(LDEXT_EXT0e),
		.enable2(LDEXT_EXT0e),
		.enable3(LDEXT_EXT0e), 
		.enable4(LDEXT_EXT0e),
		.enable5(LDEXT_EXT0e),
		.enable6(LDEXT_EXT0e),
		.enable7(LDEXT_EXT0e), 
		.input0(EXTADD_EXT0i[24]),
		.input1(EXTADD_EXT0i[25]),
		.input2(EXTADD_EXT0i[26]), 
		.input3(EXTADD_EXT0i[27]),
		.input4(EXTADD_EXT0i[28]),
		.input5(EXTADD_EXT0i[29]), 
		.input6(EXTADD_EXT0i[30]),
		.input7(EXTADD_EXT0i[31]), 
		.output0(EXTADD_EXT0e[24]),
		.output1(EXTADD_EXT0e[25]),
		.output2(EXTADD_EXT0e[26]), 
		.output3(EXTADD_EXT0e[27]),
		.output4(EXTADD_EXT0e[28]),
		.output5(EXTADD_EXT0e[29]), 
		.output6(EXTADD_EXT0e[30]),
		.output7(EXTADD_EXT0e[31])
		);

	/*WRDATA1_EXT0i -> WRDATA1_EXT0e*/
		
	busmacro_xc4v_l2r_async_enable_narrow bmo1bm0(
		.enable0(LDEXT_EXT0e),
		.enable1(LDEXT_EXT0e),
		.enable2(LDEXT_EXT0e),
		.enable3(LDEXT_EXT0e), 
		.enable4(LDEXT_EXT0e),
		.enable5(LDEXT_EXT0e),
		.enable6(LDEXT_EXT0e),
		.enable7(LDEXT_EXT0e), 
		.input0(WRDATA1_EXT0i[0]),
		.input1(WRDATA1_EXT0i[1]),
		.input2(WRDATA1_EXT0i[2]), 
		.input3(WRDATA1_EXT0i[3]),
		.input4(WRDATA1_EXT0i[4]),
		.input5(WRDATA1_EXT0i[5]), 
		.input6(WRDATA1_EXT0i[6]),
		.input7(WRDATA1_EXT0i[7]), 
		.output0(WRDATA1_EXT0e[0]),
		.output1(WRDATA1_EXT0e[1]),
		.output2(WRDATA1_EXT0e[2]), 
		.output3(WRDATA1_EXT0e[3]),
		.output4(WRDATA1_EXT0e[4]),
		.output5(WRDATA1_EXT0e[5]), 
		.output6(WRDATA1_EXT0e[6]),
		.output7(WRDATA1_EXT0e[7])
		);

	busmacro_xc4v_l2r_async_enable_narrow bmo1bm1(
		.enable0(LDEXT_EXT0e),
		.enable1(LDEXT_EXT0e),
		.enable2(LDEXT_EXT0e),
		.enable3(LDEXT_EXT0e), 
		.enable4(LDEXT_EXT0e),
		.enable5(LDEXT_EXT0e),
		.enable6(LDEXT_EXT0e),
		.enable7(LDEXT_EXT0e), 
		.input0(WRDATA1_EXT0i[8]),
		.input1(WRDATA1_EXT0i[9]),
		.input2(WRDATA1_EXT0i[10]), 
		.input3(WRDATA1_EXT0i[11]),
		.input4(WRDATA1_EXT0i[12]),
		.input5(WRDATA1_EXT0i[13]), 
		.input6(WRDATA1_EXT0i[14]),
		.input7(WRDATA1_EXT0i[15]), 
		.output0(WRDATA1_EXT0e[8]),
		.output1(WRDATA1_EXT0e[9]),
		.output2(WRDATA1_EXT0e[10]), 
		.output3(WRDATA1_EXT0e[11]),
		.output4(WRDATA1_EXT0e[12]),
		.output5(WRDATA1_EXT0e[13]), 
		.output6(WRDATA1_EXT0e[14]),
		.output7(WRDATA1_EXT0e[15])
		);
		
	busmacro_xc4v_l2r_async_enable_narrow bmo1bm2(
		.enable0(LDEXT_EXT0e),
		.enable1(LDEXT_EXT0e),
		.enable2(LDEXT_EXT0e),
		.enable3(LDEXT_EXT0e), 
		.enable4(LDEXT_EXT0e),
		.enable5(LDEXT_EXT0e),
		.enable6(LDEXT_EXT0e),
		.enable7(LDEXT_EXT0e), 
		.input0(WRDATA1_EXT0i[16]),
		.input1(WRDATA1_EXT0i[17]),
		.input2(WRDATA1_EXT0i[18]), 
		.input3(WRDATA1_EXT0i[19]),
		.input4(WRDATA1_EXT0i[20]),
		.input5(WRDATA1_EXT0i[21]), 
		.input6(WRDATA1_EXT0i[22]),
		.input7(WRDATA1_EXT0i[23]), 
		.output0(WRDATA1_EXT0e[16]),
		.output1(WRDATA1_EXT0e[17]),
		.output2(WRDATA1_EXT0e[18]), 
		.output3(WRDATA1_EXT0e[19]),
		.output4(WRDATA1_EXT0e[20]),
		.output5(WRDATA1_EXT0e[21]), 
		.output6(WRDATA1_EXT0e[22]),
		.output7(WRDATA1_EXT0e[23])
		);
		
	busmacro_xc4v_l2r_async_enable_narrow bmo1bm3(
		.enable0(LDEXT_EXT0e),
		.enable1(LDEXT_EXT0e),
		.enable2(LDEXT_EXT0e),
		.enable3(LDEXT_EXT0e), 
		.enable4(LDEXT_EXT0e),
		.enable5(LDEXT_EXT0e),
		.enable6(LDEXT_EXT0e),
		.enable7(LDEXT_EXT0e), 
		.input0(WRDATA1_EXT0i[24]),
		.input1(WRDATA1_EXT0i[25]),
		.input2(WRDATA1_EXT0i[26]), 
		.input3(WRDATA1_EXT0i[27]),
		.input4(WRDATA1_EXT0i[28]),
		.input5(WRDATA1_EXT0i[29]), 
		.input6(WRDATA1_EXT0i[30]),
		.input7(WRDATA1_EXT0i[31]), 
		.output0(WRDATA1_EXT0e[24]),
		.output1(WRDATA1_EXT0e[25]),
		.output2(WRDATA1_EXT0e[26]), 
		.output3(WRDATA1_EXT0e[27]),
		.output4(WRDATA1_EXT0e[28]),
		.output5(WRDATA1_EXT0e[29]), 
		.output6(WRDATA1_EXT0e[30]),
		.output7(WRDATA1_EXT0e[31])
		);

	/*WRDATA2_EXT0i -> WRDATA2_EXT0e*/
		
	busmacro_xc4v_l2r_async_enable_narrow bmo2bm0(
		.enable0(LDEXT_EXT0e),
		.enable1(LDEXT_EXT0e),
		.enable2(LDEXT_EXT0e),
		.enable3(LDEXT_EXT0e), 
		.enable4(LDEXT_EXT0e),
		.enable5(LDEXT_EXT0e),
		.enable6(LDEXT_EXT0e),
		.enable7(LDEXT_EXT0e), 
		.input0(WRDATA2_EXT0i[0]),
		.input1(WRDATA2_EXT0i[1]),
		.input2(WRDATA2_EXT0i[2]), 
		.input3(WRDATA2_EXT0i[3]),
		.input4(WRDATA2_EXT0i[4]),
		.input5(WRDATA2_EXT0i[5]), 
		.input6(WRDATA2_EXT0i[6]),
		.input7(WRDATA2_EXT0i[7]), 
		.output0(WRDATA2_EXT0e[0]),
		.output1(WRDATA2_EXT0e[1]),
		.output2(WRDATA2_EXT0e[2]), 
		.output3(WRDATA2_EXT0e[3]),
		.output4(WRDATA2_EXT0e[4]),
		.output5(WRDATA2_EXT0e[5]), 
		.output6(WRDATA2_EXT0e[6]),
		.output7(WRDATA2_EXT0e[7])
		);

	busmacro_xc4v_l2r_async_enable_narrow bmo2bm1(
		.enable0(LDEXT_EXT0e),
		.enable1(LDEXT_EXT0e),
		.enable2(LDEXT_EXT0e),
		.enable3(LDEXT_EXT0e), 
		.enable4(LDEXT_EXT0e),
		.enable5(LDEXT_EXT0e),
		.enable6(LDEXT_EXT0e),
		.enable7(LDEXT_EXT0e), 
		.input0(WRDATA2_EXT0i[8]),
		.input1(WRDATA2_EXT0i[9]),
		.input2(WRDATA2_EXT0i[10]), 
		.input3(WRDATA2_EXT0i[11]),
		.input4(WRDATA2_EXT0i[12]),
		.input5(WRDATA2_EXT0i[13]), 
		.input6(WRDATA2_EXT0i[14]),
		.input7(WRDATA2_EXT0i[15]), 
		.output0(WRDATA2_EXT0e[8]),
		.output1(WRDATA2_EXT0e[9]),
		.output2(WRDATA2_EXT0e[10]), 
		.output3(WRDATA2_EXT0e[11]),
		.output4(WRDATA2_EXT0e[12]),
		.output5(WRDATA2_EXT0e[13]), 
		.output6(WRDATA2_EXT0e[14]),
		.output7(WRDATA2_EXT0e[15])
		);
		
	busmacro_xc4v_l2r_async_enable_narrow bmo2bm2(
		.enable0(LDEXT_EXT0e),
		.enable1(LDEXT_EXT0e),
		.enable2(LDEXT_EXT0e),
		.enable3(LDEXT_EXT0e), 
		.enable4(LDEXT_EXT0e),
		.enable5(LDEXT_EXT0e),
		.enable6(LDEXT_EXT0e),
		.enable7(LDEXT_EXT0e), 
		.input0(WRDATA2_EXT0i[16]),
		.input1(WRDATA2_EXT0i[17]),
		.input2(WRDATA2_EXT0i[18]), 
		.input3(WRDATA2_EXT0i[19]),
		.input4(WRDATA2_EXT0i[20]),
		.input5(WRDATA2_EXT0i[21]), 
		.input6(WRDATA2_EXT0i[22]),
		.input7(WRDATA2_EXT0i[23]), 
		.output0(WRDATA2_EXT0e[16]),
		.output1(WRDATA2_EXT0e[17]),
		.output2(WRDATA2_EXT0e[18]), 
		.output3(WRDATA2_EXT0e[19]),
		.output4(WRDATA2_EXT0e[20]),
		.output5(WRDATA2_EXT0e[21]), 
		.output6(WRDATA2_EXT0e[22]),
		.output7(WRDATA2_EXT0e[23])
		);
		
	busmacro_xc4v_l2r_async_enable_narrow bmo2bm3(
		.enable0(LDEXT_EXT0e),
		.enable1(LDEXT_EXT0e),
		.enable2(LDEXT_EXT0e),
		.enable3(LDEXT_EXT0e), 
		.enable4(LDEXT_EXT0e),
		.enable5(LDEXT_EXT0e),
		.enable6(LDEXT_EXT0e),
		.enable7(LDEXT_EXT0e), 
		.input0(WRDATA2_EXT0i[24]),
		.input1(WRDATA2_EXT0i[25]),
		.input2(WRDATA2_EXT0i[26]), 
		.input3(WRDATA2_EXT0i[27]),
		.input4(WRDATA2_EXT0i[28]),
		.input5(WRDATA2_EXT0i[29]), 
		.input6(WRDATA2_EXT0i[30]),
		.input7(WRDATA2_EXT0i[31]), 
		.output0(WRDATA2_EXT0e[24]),
		.output1(WRDATA2_EXT0e[25]),
		.output2(WRDATA2_EXT0e[26]), 
		.output3(WRDATA2_EXT0e[27]),
		.output4(WRDATA2_EXT0e[28]),
		.output5(WRDATA2_EXT0e[29]), 
		.output6(WRDATA2_EXT0e[30]),
		.output7(WRDATA2_EXT0e[31])
		);

	/*RDREG1_EXT0i -> RDREG1_EXT0e*/
	/*RI_EXT0i -> RI_EXT0e*/
	/*PI_EXT0i -> PI_EXT0e*/
	/*ACK_EXT0i -> ACK_EXT0e*/
		
	busmacro_xc4v_l2r_async_enable_narrow bmo3bm0(
		.enable0(LDEXT_EXT0e),
		.enable1(LDEXT_EXT0e),
		.enable2(LDEXT_EXT0e),
		.enable3(LDEXT_EXT0e), 
		.enable4(LDEXT_EXT0e),
		.enable5(LDEXT_EXT0e),
		.enable6(LDEXT_EXT0e),
		.enable7(LDEXT_EXT0e), 
		.input0(RDREG1_EXT0i[0]),
		.input1(RDREG1_EXT0i[1]),
		.input2(RDREG1_EXT0i[2]), 
		.input3(RDREG1_EXT0i[3]),
		.input4(RDREG1_EXT0i[4]),
		.input5(RI_EXT0i), 
		.input6(PI_EXT0i),
		.input7(ACK_EXT0i), 
		.output0(RDREG1_EXT0e[0]),
		.output1(RDREG1_EXT0e[1]),
		.output2(RDREG1_EXT0e[2]), 
		.output3(RDREG1_EXT0e[3]),
		.output4(RDREG1_EXT0e[4]),
		.output5(RI_EXT0e), 
		.output6(PI_EXT0e),
		.output7(ACK_EXT0e)
		);

	/*RDREG2_EXT0i -> RDREG2_EXT0e*/
	/*REMA_EXT0i -> REMA_EXT0e*/
	/*REWB_EXT0i -> REWB_EXT0e*/
	/*REGWRITE1_EXT0i -> REGWRITE1_EXT0e*/

	busmacro_xc4v_l2r_async_enable_narrow bmo3bm1(
		.enable0(LDEXT_EXT0e),
		.enable1(LDEXT_EXT0e),
		.enable2(LDEXT_EXT0e),
		.enable3(LDEXT_EXT0e), 
		.enable4(LDEXT_EXT0e),
		.enable5(LDEXT_EXT0e),
		.enable6(LDEXT_EXT0e),
		.enable7(LDEXT_EXT0e), 
		.input0(RDREG2_EXT0i[0]),
		.input1(RDREG2_EXT0i[1]),
		.input2(RDREG2_EXT0i[2]), 
		.input3(RDREG2_EXT0i[3]),
		.input4(RDREG2_EXT0i[4]),
		.input5(REMA_EXT0i), 
		.input6(REWB_EXT0i),
		.input7(REGWRITE1_EXT0i), 
		.output0(RDREG2_EXT0e[0]),
		.output1(RDREG2_EXT0e[1]),
		.output2(RDREG2_EXT0e[2]), 
		.output3(RDREG2_EXT0e[3]),
		.output4(RDREG2_EXT0e[4]),
		.output5(REMA_EXT0e), 
		.output6(REWB_EXT0e),
		.output7(REGWRITE1_EXT0e)
		);

	/*RDREG3_EXT0i -> RDREG3_EXT0e*/
	/*REGWRITE2_EXT0i -> REGWRITE2_EXT0e*/
	/*EXC_EXT0i -> EXC_EXT0e*/
	/*W_PRESENT_E_BM -> W_PRESENT_BM_TISA*/
	
	busmacro_xc4v_l2r_async_enable_narrow bmo3bm2(
		.enable0(LDEXT_EXT0e),
		.enable1(LDEXT_EXT0e),
		.enable2(LDEXT_EXT0e),
		.enable3(LDEXT_EXT0e), 
		.enable4(LDEXT_EXT0e),
		.enable5(LDEXT_EXT0e),
		.enable6(LDEXT_EXT0e),
		.enable7(EXTCLK_EN_EXT0e), 
		.input0(RDREG3_EXT0i[0]),
		.input1(RDREG3_EXT0i[1]),
		.input2(RDREG3_EXT0i[2]), 
		.input3(RDREG3_EXT0i[3]),
		.input4(RDREG3_EXT0i[4]),
		.input5(REGWRITE2_EXT0i), 
		.input6(EXC_EXT0i),
		.input7(W_PRESENT_E_BM), 
		.output0(RDREG3_EXT0e[0]),
		.output1(RDREG3_EXT0e[1]),
		.output2(RDREG3_EXT0e[2]), 
		.output3(RDREG3_EXT0e[3]),
		.output4(RDREG3_EXT0e[4]),
		.output5(REGWRITE2_EXT0e), 
		.output6(EXC_EXT0e),
		.output7(W_PRESENT_BM_TISA)
		);

	/*RDREG4_EXT0i -> RDREG4_EXT0e*/
	/*PCNEXT_EXT0i -> PCNEXT_EXT0e*/
	/*W_WANT_INTR_E_BM -> W_WANT_INTR_BM_TISA*/
	/*W_PRIVILEGE_E_BM -> W_PRIVILEGE_BM_TISA*/
	
	busmacro_xc4v_l2r_async_enable_narrow bmo3bm3(
		.enable0(LDEXT_EXT0e),
		.enable1(LDEXT_EXT0e),
		.enable2(LDEXT_EXT0e),
		.enable3(LDEXT_EXT0e), 
		.enable4(LDEXT_EXT0e),
		.enable5(LDEXT_EXT0e),
		.enable6(LDEXT_EXT0e),
		.enable7(LDEXT_EXT0e),
		.input0(RDREG4_EXT0i[0]),
		.input1(RDREG4_EXT0i[1]),
		.input2(RDREG4_EXT0i[2]), 
		.input3(RDREG4_EXT0i[3]),
		.input4(RDREG4_EXT0i[4]),
		.input5(PCNEXT_EXT0i), 
		.input6(W_WANT_INTR_E_BM),
		.input7(W_PRIVILEGE_E_BM), 
		.output0(RDREG4_EXT0e[0]),
		.output1(RDREG4_EXT0e[1]),
		.output2(RDREG4_EXT0e[2]), 
		.output3(RDREG4_EXT0e[3]),
		.output4(RDREG4_EXT0e[4]),
		.output5(PCNEXT_EXT0e), 
		.output6(W_WANT_INTR_BM_TISA),
		.output7(W_PRIVILEGE_BM_TISA)
		);

	/*W_MADDR_E_BM -> W_MADDR_BM_TISA*/

	busmacro_xc4v_l2r_async_enable_narrow bmo4bm0(
		.enable0(LDEXT_EXT0e),
		.enable1(LDEXT_EXT0e),
		.enable2(LDEXT_EXT0e),
		.enable3(LDEXT_EXT0e), 
		.enable4(LDEXT_EXT0e),
		.enable5(LDEXT_EXT0e),
		.enable6(LDEXT_EXT0e),
		.enable7(LDEXT_EXT0e), 
		.input0(W_MADDR_E_BM[0]),
		.input1(W_MADDR_E_BM[1]),
		.input2(W_MADDR_E_BM[2]), 
		.input3(W_MADDR_E_BM[3]),
		.input4(W_MADDR_E_BM[4]),
		.input5(W_MADDR_E_BM[5]), 
		.input6(W_MADDR_E_BM[6]),
		.input7(W_MADDR_E_BM[7]), 
		.output0(W_MADDR_BM_TISA[0]),
		.output1(W_MADDR_BM_TISA[1]),
		.output2(W_MADDR_BM_TISA[2]), 
		.output3(W_MADDR_BM_TISA[3]),
		.output4(W_MADDR_BM_TISA[4]),
		.output5(W_MADDR_BM_TISA[5]), 
		.output6(W_MADDR_BM_TISA[6]),
		.output7(W_MADDR_BM_TISA[7])
		);

	busmacro_xc4v_l2r_async_enable_narrow bmo4bm1(
		.enable0(LDEXT_EXT0e),
		.enable1(LDEXT_EXT0e),
		.enable2(LDEXT_EXT0e),
		.enable3(LDEXT_EXT0e), 
		.enable4(LDEXT_EXT0e),
		.enable5(LDEXT_EXT0e),
		.enable6(LDEXT_EXT0e),
		.enable7(LDEXT_EXT0e), 
		.input0(W_MADDR_E_BM[8]),
		.input1(W_MADDR_E_BM[9]),
		.input2(W_MADDR_E_BM[10]), 
		.input3(W_MADDR_E_BM[11]),
		.input4(W_MADDR_E_BM[12]),
		.input5(W_MADDR_E_BM[13]), 
		.input6(W_MADDR_E_BM[14]),
		.input7(W_MADDR_E_BM[15]), 
		.output0(W_MADDR_BM_TISA[8]),
		.output1(W_MADDR_BM_TISA[9]),
		.output2(W_MADDR_BM_TISA[10]), 
		.output3(W_MADDR_BM_TISA[11]),
		.output4(W_MADDR_BM_TISA[12]),
		.output5(W_MADDR_BM_TISA[13]), 
		.output6(W_MADDR_BM_TISA[14]),
		.output7(W_MADDR_BM_TISA[15])
		);
		
	busmacro_xc4v_l2r_async_enable_narrow bmo4bm2(
		.enable0(LDEXT_EXT0e),
		.enable1(LDEXT_EXT0e),
		.enable2(LDEXT_EXT0e),
		.enable3(LDEXT_EXT0e), 
		.enable4(LDEXT_EXT0e),
		.enable5(LDEXT_EXT0e),
		.enable6(LDEXT_EXT0e),
		.enable7(LDEXT_EXT0e), 
		.input0(W_MADDR_E_BM[16]),
		.input1(W_MADDR_E_BM[17]),
		.input2(W_MADDR_E_BM[18]), 
		.input3(W_MADDR_E_BM[19]),
		.input4(W_MADDR_E_BM[20]),
		.input5(W_MADDR_E_BM[21]), 
		.input6(W_MADDR_E_BM[22]),
		.input7(W_MADDR_E_BM[23]), 
		.output0(W_MADDR_BM_TISA[16]),
		.output1(W_MADDR_BM_TISA[17]),
		.output2(W_MADDR_BM_TISA[18]), 
		.output3(W_MADDR_BM_TISA[19]),
		.output4(W_MADDR_BM_TISA[20]),
		.output5(W_MADDR_BM_TISA[21]), 
		.output6(W_MADDR_BM_TISA[22]),
		.output7(W_MADDR_BM_TISA[23])
		);
		
	busmacro_xc4v_l2r_async_enable_narrow bmo4bm3(
		.enable0(LDEXT_EXT0e),
		.enable1(LDEXT_EXT0e),
		.enable2(LDEXT_EXT0e),
		.enable3(LDEXT_EXT0e), 
		.enable4(LDEXT_EXT0e),
		.enable5(LDEXT_EXT0e),
		.enable6(LDEXT_EXT0e),
		.enable7(LDEXT_EXT0e), 
		.input0(W_MADDR_E_BM[24]),
		.input1(W_MADDR_E_BM[25]),
		.input2(W_MADDR_E_BM[26]), 
		.input3(W_MADDR_E_BM[27]),
		.input4(W_MADDR_E_BM[28]),
		.input5(W_MADDR_E_BM[29]), 
		.input6(W_MADDR_E_BM[30]),
		.input7(W_MADDR_E_BM[31]), 
		.output0(W_MADDR_BM_TISA[24]),
		.output1(W_MADDR_BM_TISA[25]),
		.output2(W_MADDR_BM_TISA[26]), 
		.output3(W_MADDR_BM_TISA[27]),
		.output4(W_MADDR_BM_TISA[28]),
		.output5(W_MADDR_BM_TISA[29]), 
		.output6(W_MADDR_BM_TISA[30]),
		.output7(W_MADDR_BM_TISA[31])
		);

	/*W_MDATA_E_BM -> W_MDATA_BM_TISA*/
	
	busmacro_xc4v_l2r_async_enable_narrow bmo5bm0(
		.enable0(LDEXT_EXT0e),
		.enable1(LDEXT_EXT0e),
		.enable2(LDEXT_EXT0e),
		.enable3(LDEXT_EXT0e), 
		.enable4(LDEXT_EXT0e),
		.enable5(LDEXT_EXT0e),
		.enable6(LDEXT_EXT0e),
		.enable7(LDEXT_EXT0e), 
		.input0(W_MDATA_E_BM[0]),
		.input1(W_MDATA_E_BM[1]),
		.input2(W_MDATA_E_BM[2]), 
		.input3(W_MDATA_E_BM[3]),
		.input4(W_MDATA_E_BM[4]),
		.input5(W_MDATA_E_BM[5]), 
		.input6(W_MDATA_E_BM[6]),
		.input7(W_MDATA_E_BM[7]), 
		.output0(W_MDATA_BM_TISA[0]),
		.output1(W_MDATA_BM_TISA[1]),
		.output2(W_MDATA_BM_TISA[2]), 
		.output3(W_MDATA_BM_TISA[3]),
		.output4(W_MDATA_BM_TISA[4]),
		.output5(W_MDATA_BM_TISA[5]), 
		.output6(W_MDATA_BM_TISA[6]),
		.output7(W_MDATA_BM_TISA[7])
		);

	busmacro_xc4v_l2r_async_enable_narrow bmo5bm1(
		.enable0(LDEXT_EXT0e),
		.enable1(LDEXT_EXT0e),
		.enable2(LDEXT_EXT0e),
		.enable3(LDEXT_EXT0e), 
		.enable4(LDEXT_EXT0e),
		.enable5(LDEXT_EXT0e),
		.enable6(LDEXT_EXT0e),
		.enable7(LDEXT_EXT0e), 
		.input0(W_MDATA_E_BM[8]),
		.input1(W_MDATA_E_BM[9]),
		.input2(W_MDATA_E_BM[10]), 
		.input3(W_MDATA_E_BM[11]),
		.input4(W_MDATA_E_BM[12]),
		.input5(W_MDATA_E_BM[13]), 
		.input6(W_MDATA_E_BM[14]),
		.input7(W_MDATA_E_BM[15]), 
		.output0(W_MDATA_BM_TISA[8]),
		.output1(W_MDATA_BM_TISA[9]),
		.output2(W_MDATA_BM_TISA[10]), 
		.output3(W_MDATA_BM_TISA[11]),
		.output4(W_MDATA_BM_TISA[12]),
		.output5(W_MDATA_BM_TISA[13]), 
		.output6(W_MDATA_BM_TISA[14]),
		.output7(W_MDATA_BM_TISA[15])
		);
		
	busmacro_xc4v_l2r_async_enable_narrow bmo5bm2(
		.enable0(LDEXT_EXT0e),
		.enable1(LDEXT_EXT0e),
		.enable2(LDEXT_EXT0e),
		.enable3(LDEXT_EXT0e), 
		.enable4(LDEXT_EXT0e),
		.enable5(LDEXT_EXT0e),
		.enable6(LDEXT_EXT0e),
		.enable7(LDEXT_EXT0e), 
		.input0(W_MDATA_E_BM[16]),
		.input1(W_MDATA_E_BM[17]),
		.input2(W_MDATA_E_BM[18]), 
		.input3(W_MDATA_E_BM[19]),
		.input4(W_MDATA_E_BM[20]),
		.input5(W_MDATA_E_BM[21]), 
		.input6(W_MDATA_E_BM[22]),
		.input7(W_MDATA_E_BM[23]), 
		.output0(W_MDATA_BM_TISA[16]),
		.output1(W_MDATA_BM_TISA[17]),
		.output2(W_MDATA_BM_TISA[18]), 
		.output3(W_MDATA_BM_TISA[19]),
		.output4(W_MDATA_BM_TISA[20]),
		.output5(W_MDATA_BM_TISA[21]), 
		.output6(W_MDATA_BM_TISA[22]),
		.output7(W_MDATA_BM_TISA[23])
		);
		
	busmacro_xc4v_l2r_async_enable_narrow bmo5bm3(
		.enable0(LDEXT_EXT0e),
		.enable1(LDEXT_EXT0e),
		.enable2(LDEXT_EXT0e),
		.enable3(LDEXT_EXT0e), 
		.enable4(LDEXT_EXT0e),
		.enable5(LDEXT_EXT0e),
		.enable6(LDEXT_EXT0e),
		.enable7(LDEXT_EXT0e), 
		.input0(W_MDATA_E_BM[24]),
		.input1(W_MDATA_E_BM[25]),
		.input2(W_MDATA_E_BM[26]), 
		.input3(W_MDATA_E_BM[27]),
		.input4(W_MDATA_E_BM[28]),
		.input5(W_MDATA_E_BM[29]), 
		.input6(W_MDATA_E_BM[30]),
		.input7(W_MDATA_E_BM[31]), 
		.output0(W_MDATA_BM_TISA[24]),
		.output1(W_MDATA_BM_TISA[25]),
		.output2(W_MDATA_BM_TISA[26]), 
		.output3(W_MDATA_BM_TISA[27]),
		.output4(W_MDATA_BM_TISA[28]),
		.output5(W_MDATA_BM_TISA[29]), 
		.output6(W_MDATA_BM_TISA[30]),
		.output7(W_MDATA_BM_TISA[31])
		);
		
	/*W_MOE_E_BM -> W_MOE_BM_TISA*/
	/*W_MWE_E_BM -> W_MWE_BM_TISA*/
	/*W_MLOCK_E_BM -> W_MLOCK_BM_TISA*/
	/*W_RNL_E_BM -> W_RNL_BM_TISA*/
	/*W_BLS_E_BM -> W_BLS_BM_TISA*/
	/*W_HLS_E_BM -> W_HLS_BM_TISA*/
	/*W_EXC_E_BM -> W_EXC_BM_TISA*/
	/*W_INT_E_BM -> W_INT_BM_TISA*/ 

	busmacro_xc4v_l2r_async_enable_narrow bmo6bm0(
		.enable0(LDEXT_EXT0e),
		.enable1(LDEXT_EXT0e),
		.enable2(LDEXT_EXT0e),
		.enable3(LDEXT_EXT0e), 
		.enable4(LDEXT_EXT0e),
		.enable5(LDEXT_EXT0e),
		.enable6(LDEXT_EXT0e),
		.enable7(LDEXT_EXT0e),
		.input0(W_MOE_E_BM),
		.input1(W_MWE_E_BM),
		.input2(W_MLOCK_E_BM),
		.input3(W_RNL_E_BM),
		.input4(W_BLS_E_BM),
		.input5(W_HLS_E_BM),
		.input6(W_EXC_E_BM),
		.input7(W_INT_E_BM),
		.output0(W_MOE_BM_TISA),
		.output1(W_MWE_BM_TISA),
		.output2(W_MLOCK_BM_TISA),
		.output3(W_RNL_BM_TISA),
		.output4(W_BLS_BM_TISA),
		.output5(W_HLS_BM_TISA),
		.output6(W_EXC_BM_TISA),
		.output7(W_INT_BM_TISA)
		);

	/*W_PER_DNE_EXT_BM -> W_PER_DNE_BM_TISA*/
	/*W_PER_MYADDR_EXT_BM -> W_PER_MYADDR_BM_TISA*/
	/*fspecial_EXT0i -> fspecial_EXT0e*/

	busmacro_xc4v_l2r_async_enable_narrow bmo6bm1(
		.enable0(LDEXT_EXT0e),
		.enable1(LDEXT_EXT0e),
		.enable2(LDEXT_EXT0e),
		.enable3(LDEXT_EXT0e), 
		.enable4(LDEXT_EXT0e),
		.enable5(LDEXT_EXT0e),
		.enable6(LDEXT_EXT0e),
		.enable7(LDEXT_EXT0e),
		.input0(W_PER_DNE_EXT_BM),
		.input1(W_PER_MYADDR_EXT_BM),
		.input2(TX2_EXT0i),
		.input3(fspecial_EXT0i),
		.input4(1'b0),
		.input5(1'b0),
		.input6(1'b0),
		.input7(1'b0),
		.output0(W_PER_DNE_BM_TISA),
		.output1(W_PER_MYADDR_BM_TISA),
		.output2(TX2),
		.output3(fspecial_EXT0e)/*,*/
		/*.output4(),*/
		/*.output5(),*/
		/*.output6(),*/
		/*.output7()*/
		);

endmodule
