/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Richard Neil Pittman												*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Library Name:	bus_macros_pr													*/
/* Module Names:	busmacro_xc4v_l2r_async_enable_wide						*/
/*						busmacro_xc4v_r2l_async_enable_wide						*/
/*						busmacro_xc4v_t2b_async_enable_wide						*/
/*						busmacro_xc4v_b2t_async_enable_wide						*/
/*						busmacro_xc4v_l2r_async_wide								*/
/*						busmacro_xc4v_r2l_async_wide								*/
/*						busmacro_xc4v_t2b_async_wide								*/
/*						busmacro_xc4v_b2t_async_wide								*/
/*						busmacro_xc4v_l2r_async_enable_narrow					*/
/*						busmacro_xc4v_r2l_async_enable_narrow					*/
/*						busmacro_xc4v_t2b_async_enable_narrow					*/
/*						busmacro_xc4v_b2t_async_enable_narrow					*/
/*						busmacro_xc4v_l2r_async_narrow							*/
/*						busmacro_xc4v_r2l_async_narrow							*/
/*						busmacro_xc4v_t2b_async_narrow							*/
/*						busmacro_xc4v_b2t_async_narrow							*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	0.0	-	Pre Release													*/
/* Revision	1.0	-	First General Release									*/
/* Revision	1.1	-	Bug Fixes, see Manual									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module busmacro_xc4v_l2r_async_enable_wide(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input enable0,		/* enable bits */
	input enable1,
	input enable2, 
	input enable3, 
	input enable4,
	input enable5,
	input enable6,
	input enable7,
	input input0,		/* input bits */
	input input1,
	input input2,
	input input3, 
	input input4,
	input input5,
	input input6,
	input input7,
	/* OUTPUT PORTS */
	output output0,	/* output bits */
	output output1,
	output output2,
	output output3, 
	output output4,
	output output5,
	output output6,
	output output7
	);
endmodule

module busmacro_xc4v_r2l_async_enable_wide(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input enable0,		/* enable bits */
	input enable1,
	input enable2, 
	input enable3, 
	input enable4,
	input enable5,
	input enable6,
	input enable7,
	input input0,		/* input bits */
	input input1,
	input input2,
	input input3, 
	input input4,
	input input5,
	input input6,
	input input7,
	/* OUTPUT PORTS */
	output output0,	/* output bits */
	output output1,
	output output2,
	output output3, 
	output output4,
	output output5,
	output output6,
	output output7
	);
endmodule

module busmacro_xc4v_t2b_async_enable_wide(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input enable0,		/* enable bits */
	input enable1,
	input enable2, 
	input enable3, 
	input enable4,
	input enable5,
	input enable6,
	input enable7,
	input input0,		/* input bits */
	input input1,
	input input2,
	input input3, 
	input input4,
	input input5,
	input input6,
	input input7,
	/* OUTPUT PORTS */
	output output0,	/* output bits */
	output output1,
	output output2,
	output output3, 
	output output4,
	output output5,
	output output6,
	output output7
	);
endmodule

module busmacro_xc4v_b2t_async_enable_wide(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input enable0,		/* enable bits */
	input enable1,
	input enable2, 
	input enable3, 
	input enable4,
	input enable5,
	input enable6,
	input enable7,
	input input0,		/* input bits */
	input input1,
	input input2,
	input input3, 
	input input4,
	input input5,
	input input6,
	input input7,
	/* OUTPUT PORTS */
	output output0,	/* output bits */
	output output1,
	output output2,
	output output3, 
	output output4,
	output output5,
	output output6,
	output output7
	);
endmodule

module busmacro_xc4v_l2r_async_wide(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input input0,		/* input bits */
	input input1,
	input input2,
	input input3, 
	input input4,
	input input5,
	input input6,
	input input7,
	/* OUTPUT PORTS */
	output output0,	/* output bits */
	output output1,
	output output2,
	output output3, 
	output output4,
	output output5,
	output output6,
	output output7
	);
endmodule

module busmacro_xc4v_r2l_async_wide(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input input0,		/* input bits */
	input input1,
	input input2,
	input input3, 
	input input4,
	input input5,
	input input6,
	input input7,
	/* OUTPUT PORTS */
	output output0,	/* output bits */
	output output1,
	output output2,
	output output3, 
	output output4,
	output output5,
	output output6,
	output output7
	);
endmodule

module busmacro_xc4v_t2b_async_wide(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input input0,		/* input bits */
	input input1,
	input input2,
	input input3, 
	input input4,
	input input5,
	input input6,
	input input7,
	/* OUTPUT PORTS */
	output output0,	/* output bits */
	output output1,
	output output2,
	output output3, 
	output output4,
	output output5,
	output output6,
	output output7
	);
endmodule

module busmacro_xc4v_b2t_async_wide(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input input0,		/* input bits */
	input input1,
	input input2,
	input input3, 
	input input4,
	input input5,
	input input6,
	input input7,
	/* OUTPUT PORTS */
	output output0,	/* output bits */
	output output1,
	output output2,
	output output3, 
	output output4,
	output output5,
	output output6,
	output output7
	);
endmodule

module busmacro_xc4v_l2r_async_enable_narrow(/*****Ports****************************************************************/
	/* INPUT PORTS */
	input enable0,		/* enable bits */
	input enable1,
	input enable2, 
	input enable3, 
	input enable4,
	input enable5,
	input enable6,
	input enable7,
	input input0,		/* input bits */
	input input1,
	input input2,
	input input3, 
	input input4,
	input input5,
	input input6,
	input input7,
	/* OUTPUT PORTS */
	output output0,	/* output bits */
	output output1,
	output output2,
	output output3, 
	output output4,
	output output5,
	output output6,
	output output7
	);
endmodule

module busmacro_xc4v_r2l_async_enable_narrow(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input enable0,		/* enable bits */
	input enable1,
	input enable2, 
	input enable3, 
	input enable4,
	input enable5,
	input enable6,
	input enable7,
	input input0,		/* input bits */
	input input1,
	input input2,
	input input3, 
	input input4,
	input input5,
	input input6,
	input input7,
	/* OUTPUT PORTS */
	output output0,	/* output bits */
	output output1,
	output output2,
	output output3, 
	output output4,
	output output5,
	output output6,
	output output7
	);
endmodule

module busmacro_xc4v_t2b_async_enable_narrow(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input enable0,		/* enable bits */
	input enable1,
	input enable2, 
	input enable3, 
	input enable4,
	input enable5,
	input enable6,
	input enable7,
	input input0,		/* input bits */
	input input1,
	input input2,
	input input3, 
	input input4,
	input input5,
	input input6,
	input input7,
	/* OUTPUT PORTS */
	output output0,	/* output bits */
	output output1,
	output output2,
	output output3, 
	output output4,
	output output5,
	output output6,
	output output7
	);
endmodule

module busmacro_xc4v_b2t_async_enable_narrow(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input enable0,		/* enable bits */
	input enable1,
	input enable2, 
	input enable3, 
	input enable4,
	input enable5,
	input enable6,
	input enable7,
	input input0,		/* input bits */
	input input1,
	input input2,
	input input3, 
	input input4,
	input input5,
	input input6,
	input input7,
	/* OUTPUT PORTS */
	output output0,	/* output bits */
	output output1,
	output output2,
	output output3, 
	output output4,
	output output5,
	output output6,
	output output7
	);
endmodule

module busmacro_xc4v_l2r_async_narrow(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input input0,		/* input bits */
	input input1,
	input input2,
	input input3, 
	input input4,
	input input5,
	input input6,
	input input7,
	/* OUTPUT PORTS */
	output output0,	/* output bits */
	output output1,
	output output2,
	output output3, 
	output output4,
	output output5,
	output output6,
	output output7
	);
endmodule

module busmacro_xc4v_r2l_async_narrow(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input input0,		/* input bits */
	input input1,
	input input2,
	input input3, 
	input input4,
	input input5,
	input input6,
	input input7,
	/* OUTPUT PORTS */
	output output0,	/* output bits */
	output output1,
	output output2,
	output output3, 
	output output4,
	output output5,
	output output6,
	output output7
	);
endmodule

module busmacro_xc4v_t2b_async_narrow(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input input0,		/* input bits */
	input input1,
	input input2,
	input input3, 
	input input4,
	input input5,
	input input6,
	input input7,
	/* OUTPUT PORTS */
	output output0,	/* output bits */
	output output1,
	output output2,
	output output3, 
	output output4,
	output output5,
	output output6,
	output output7
	);
endmodule

module busmacro_xc4v_b2t_async_narrow(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input input0,		/* input bits */
	input input1,
	input input2,
	input input3, 
	input input4,
	input input5,
	input input6,
	input input7,
	/* OUTPUT PORTS */
	output output0,	/* output bits */
	output output1,
	output output2,
	output output3, 
	output output4,
	output output5,
	output output6,
	output output7
	);
endmodule