/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Richard Neil Pittman												*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	iobuf16															*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	0.0	-	Pre Release													*/
/* Revision	1.0	-	First General Release									*/
/* Revision	1.1	-	Bug Fixes, see Manual									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module iobuf16(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input [15:0]	I,		/* In coming data from design */
	input [15:0]	T,		/* Pin direction, tristate enable */
	/* OUTPUT PORTS */
	output [15:0]	O,		/* Out going data to design */
	/* INOUT PORTS */
	inout [15:0]	IO		/* Pin status */
	);
	
/*****IO Buffers****************************************************************/
	
	IOBUF #(
		.DRIVE(12),					// Specify the output drive strength
		.IOSTANDARD("DEFAULT"),	// Specify the I/O standard
		.SLEW("SLOW")				// Specify the output slew rate
		)
	IOBUF_B0 (
		.O(O[0]),					// Buffer output
		.IO(IO[0]),					// Buffer inout port (connect directly to top-level port)
		.I(I[0]),					// Buffer input
		.T(T[0])						// 3-state enable input
		);

	IOBUF #(
		.DRIVE(12),					// Specify the output drive strength
		.IOSTANDARD("DEFAULT"),	// Specify the I/O standard
		.SLEW("SLOW")				// Specify the output slew rate
		)
	IOBUF_B1 (
		.O(O[1]),					// Buffer output
		.IO(IO[1]),					// Buffer inout port (connect directly to top-level port)
		.I(I[1]),					// Buffer input
		.T(T[1])						// 3-state enable input
		);

	IOBUF #(
		.DRIVE(12),					// Specify the output drive strength
		.IOSTANDARD("DEFAULT"),	// Specify the I/O standard
		.SLEW("SLOW")				// Specify the output slew rate
		)
	IOBUF_B2 (
		.O(O[2]),					// Buffer output
		.IO(IO[2]),					// Buffer inout port (connect directly to top-level port)
		.I(I[2]),					// Buffer input
		.T(T[2])						// 3-state enable input
		);

	IOBUF #(
		.DRIVE(12),					// Specify the output drive strength
		.IOSTANDARD("DEFAULT"),	// Specify the I/O standard
		.SLEW("SLOW")				// Specify the output slew rate
		)
	IOBUF_B3 (
		.O(O[3]),					// Buffer output
		.IO(IO[3]),					// Buffer inout port (connect directly to top-level port)
		.I(I[3]),					// Buffer input
		.T(T[3])						// 3-state enable input
		);

	IOBUF #(
		.DRIVE(12),					// Specify the output drive strength
		.IOSTANDARD("DEFAULT"),	// Specify the I/O standard
		.SLEW("SLOW")				// Specify the output slew rate
		)
	IOBUF_B4 (
		.O(O[4]),					// Buffer output
		.IO(IO[4]),					// Buffer inout port (connect directly to top-level port)
		.I(I[4]),					// Buffer input
		.T(T[4])						// 3-state enable input
		);

	IOBUF #(
		.DRIVE(12),					// Specify the output drive strength
		.IOSTANDARD("DEFAULT"),	// Specify the I/O standard
		.SLEW("SLOW")				// Specify the output slew rate
		)
	IOBUF_B5 (
		.O(O[5]),					// Buffer output
		.IO(IO[5]),					// Buffer inout port (connect directly to top-level port)
		.I(I[5]),					// Buffer input
		.T(T[5])						// 3-state enable input
		);

	IOBUF #(
		.DRIVE(12),					// Specify the output drive strength
		.IOSTANDARD("DEFAULT"),	// Specify the I/O standard
		.SLEW("SLOW")				// Specify the output slew rate
		)
	IOBUF_B6 (
		.O(O[6]),					// Buffer output
		.IO(IO[6]),					// Buffer inout port (connect directly to top-level port)
		.I(I[6]),					// Buffer input
		.T(T[6])						// 3-state enable input
		);

	IOBUF #(
		.DRIVE(12),					// Specify the output drive strength
		.IOSTANDARD("DEFAULT"),	// Specify the I/O standard
		.SLEW("SLOW")				// Specify the output slew rate
		)
	IOBUF_B7 (
		.O(O[7]),					// Buffer output
		.IO(IO[7]),					// Buffer inout port (connect directly to top-level port)
		.I(I[7]),					// Buffer input
		.T(T[7])						// 3-state enable input
		);

	IOBUF #(
		.DRIVE(12),					// Specify the output drive strength
		.IOSTANDARD("DEFAULT"),	// Specify the I/O standard
		.SLEW("SLOW")				// Specify the output slew rate
		)
	IOBUF_B8 (
		.O(O[8]),					// Buffer output
		.IO(IO[8]),					// Buffer inout port (connect directly to top-level port)
		.I(I[8]),					// Buffer input
		.T(T[8])						// 3-state enable input
		);

	IOBUF #(
		.DRIVE(12),					// Specify the output drive strength
		.IOSTANDARD("DEFAULT"),	// Specify the I/O standard
		.SLEW("SLOW")				// Specify the output slew rate
		)
	IOBUF_B9 (
		.O(O[9]),					// Buffer output
		.IO(IO[9]),					// Buffer inout port (connect directly to top-level port)
		.I(I[9]),					// Buffer input
		.T(T[9])						// 3-state enable input
		);

	IOBUF #(
		.DRIVE(12),					// Specify the output drive strength
		.IOSTANDARD("DEFAULT"),	// Specify the I/O standard
		.SLEW("SLOW")				// Specify the output slew rate
		)
	IOBUF_B10 (
		.O(O[10]),					// Buffer output
		.IO(IO[10]),				// Buffer inout port (connect directly to top-level port)
		.I(I[10]),					// Buffer input
		.T(T[10])					// 3-state enable input
		);

	IOBUF #(
		.DRIVE(12),					// Specify the output drive strength
		.IOSTANDARD("DEFAULT"),	// Specify the I/O standard
		.SLEW("SLOW")				// Specify the output slew rate
		)
	IOBUF_B11 (
		.O(O[11]),					// Buffer output
		.IO(IO[11]),				// Buffer inout port (connect directly to top-level port)
		.I(I[11]),					// Buffer input
		.T(T[11])					// 3-state enable input
		);

	IOBUF #(
		.DRIVE(12),					// Specify the output drive strength
		.IOSTANDARD("DEFAULT"),	// Specify the I/O standard
		.SLEW("SLOW")				// Specify the output slew rate
		)
	IOBUF_B12 (
		.O(O[12]),					// Buffer output
		.IO(IO[12]),				// Buffer inout port (connect directly to top-level port)
		.I(I[12]),					// Buffer input
		.T(T[12])					// 3-state enable input
		);

	IOBUF #(
		.DRIVE(12),					// Specify the output drive strength
		.IOSTANDARD("DEFAULT"),	// Specify the I/O standard
		.SLEW("SLOW")				// Specify the output slew rate
		)
	IOBUF_B13 (
		.O(O[13]),					// Buffer output
		.IO(IO[13]),				// Buffer inout port (connect directly to top-level port)
		.I(I[13]),					// Buffer input
		.T(T[13])					// 3-state enable input
		);

	IOBUF #(
		.DRIVE(12),					// Specify the output drive strength
		.IOSTANDARD("DEFAULT"),	// Specify the I/O standard
		.SLEW("SLOW")				// Specify the output slew rate
		)
	IOBUF_B14 (
		.O(O[14]),					// Buffer output
		.IO(IO[14]),				// Buffer inout port (connect directly to top-level port)
		.I(I[14]),					// Buffer input
		.T(T[14])					// 3-state enable input
		);

	IOBUF #(
		.DRIVE(12),					// Specify the output drive strength
		.IOSTANDARD("DEFAULT"),	// Specify the I/O standard
		.SLEW("SLOW")				// Specify the output slew rate
		)
	IOBUF_B15 (
		.O(O[15]),					// Buffer output
		.IO(IO[15]),				// Buffer inout port (connect directly to top-level port)
		.I(I[15]),					// Buffer input
		.T(T[15])					// 3-state enable input
		);

endmodule
