/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Richard Neil Pittman												*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	iobuf32															*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	0.0	-	Pre Release													*/
/* Revision	1.0	-	First General Release									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module iobuf32(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input [31:0]	I,		/* In coming data from design */
	input [31:0]	T,		/* Pin direction, tristate enable */
	/* OUTPUT PORTS */
	output [31:0]	O,		/* Out going data to design */
	/* INOUT PORTS */
	inout [31:0]	IO		/* Pin status */
	);
	
/*****IO Buffers****************************************************************/
	
	assign O[0]	=	IO[0];
	assign IO[0] =	(~T[0])?I[0]:1'bz;

	assign O[1]	=	IO[1];
	assign IO[1] =	(~T[1])?I[1]:1'bz;

	assign O[2]	=	IO[2];
	assign IO[2] =	(~T[2])?I[2]:1'bz;

	assign O[3]	=	IO[3];
	assign IO[3] =	(~T[3])?I[3]:1'bz;

	assign O[4]	=	IO[4];
	assign IO[4] =	(~T[4])?I[4]:1'bz;

	assign O[5]	=	IO[5];
	assign IO[5] =	(~T[5])?I[5]:1'bz;

	assign O[6]	=	IO[6];
	assign IO[6] =	(~T[6])?I[6]:1'bz;

	assign O[7]	=	IO[7];
	assign IO[7] =	(~T[7])?I[7]:1'bz;

	assign O[8]	=	IO[8];
	assign IO[8] =	(~T[8])?I[8]:1'bz;

	assign O[9]	=	IO[9];
	assign IO[9] =	(~T[9])?I[9]:1'bz;

	assign O[10]	=	IO[10];
	assign IO[10] =	(~T[10])?I[10]:1'bz;

	assign O[11]	=	IO[11];
	assign IO[11] =	(~T[11])?I[11]:1'bz;

	assign O[12]	=	IO[12];
	assign IO[12] =	(~T[12])?I[12]:1'bz;

	assign O[13]	=	IO[13];
	assign IO[13] =	(~T[13])?I[13]:1'bz;

	assign O[14]	=	IO[14];
	assign IO[14] =	(~T[14])?I[14]:1'bz;

	assign O[15]	=	IO[15];
	assign IO[15] =	(~T[15])?I[15]:1'bz;

	assign O[16]	=	IO[16];
	assign IO[16] =	(~T[16])?I[16]:1'bz;

	assign O[17]	=	IO[17];
	assign IO[17] =	(~T[17])?I[17]:1'bz;

	assign O[18]	=	IO[18];
	assign IO[18] =	(~T[18])?I[18]:1'bz;

	assign O[19]	=	IO[19];
	assign IO[19] =	(~T[19])?I[19]:1'bz;

	assign O[20]	=	IO[20];
	assign IO[20] =	(~T[20])?I[20]:1'bz;

	assign O[21]	=	IO[21];
	assign IO[21] =	(~T[21])?I[21]:1'bz;

	assign O[22]	=	IO[22];
	assign IO[22] =	(~T[22])?I[22]:1'bz;

	assign O[23]	=	IO[23];
	assign IO[23] =	(~T[23])?I[23]:1'bz;

	assign O[24]	=	IO[24];
	assign IO[24] =	(~T[24])?I[24]:1'bz;

	assign O[25]	=	IO[25];
	assign IO[25] =	(~T[25])?I[25]:1'bz;

	assign O[26]	=	IO[26];
	assign IO[26] =	(~T[26])?I[26]:1'bz;

	assign O[27]	=	IO[27];
	assign IO[27] =	(~T[27])?I[27]:1'bz;

	assign O[28]	=	IO[28];
	assign IO[28] =	(~T[28])?I[28]:1'bz;

	assign O[29]	=	IO[29];
	assign IO[29] =	(~T[29])?I[29]:1'bz;

	assign O[30]	=	IO[30];
	assign IO[30] =	(~T[30])?I[30]:1'bz;

	assign O[31]	=	IO[31];
	assign IO[31] =	(~T[31])?I[31]:1'bz;

endmodule
