/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Richard Neil Pittman												*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	iobuf4															*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	0.0	-	Pre Release													*/
/* Revision	1.0	-	First General Release									*/
/* Revision	1.1	-	Bug Fixes, see Manual									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module iobuf4(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input [3:0]		I,		/* In coming data from design */
	input [3:0]		T,		/* Pin direction, tristate enable */
	/* OUTPUT PORTS */
	output [3:0]	O,		/* Out going data to design */
	/* INOUT PORTS */
	inout [3:0]		IO		/* Pin status */
	);

/*****IO Buffers****************************************************************/

	IOBUF #(
		.DRIVE(12),					// Specify the output drive strength
		.IOSTANDARD("DEFAULT"),	// Specify the I/O standard
		.SLEW("SLOW")				// Specify the output slew rate
		)
	IOBUF_B0 (
		.O(O[0]),					// Buffer output
		.IO(IO[0]),					// Buffer inout port (connect directly to top-level port)
		.I(I[0]),					// Buffer input
		.T(T[0])						// 3-state enable input
		);

	IOBUF #(
		.DRIVE(12),					// Specify the output drive strength
		.IOSTANDARD("DEFAULT"),	// Specify the I/O standard
		.SLEW("SLOW")				// Specify the output slew rate
		)
	IOBUF_B1 (
		.O(O[1]),					// Buffer output
		.IO(IO[1]),					// Buffer inout port (connect directly to top-level port)
		.I(I[1]),					// Buffer input
		.T(T[1])						// 3-state enable input
		);

	IOBUF #(
		.DRIVE(12),					// Specify the output drive strength
		.IOSTANDARD("DEFAULT"),	// Specify the I/O standard
		.SLEW("SLOW")				// Specify the output slew rate
		)
	IOBUF_B2 (
		.O(O[2]),					// Buffer output
		.IO(IO[2]),					// Buffer inout port (connect directly to top-level port)
		.I(I[2]),					// Buffer input
		.T(T[2])						// 3-state enable input
		);

	IOBUF #(
		.DRIVE(12),					// Specify the output drive strength
		.IOSTANDARD("DEFAULT"),	// Specify the I/O standard
		.SLEW("SLOW")				// Specify the output slew rate
		)
	IOBUF_B3 (
		.O(O[3]),					// Buffer output
		.IO(IO[3]),					// Buffer inout port (connect directly to top-level port)
		.I(I[3]),					// Buffer input
		.T(T[3])						// 3-state enable input
		);

endmodule
