/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Richard Neil Pittman												*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPSv1															*/
/* Module Name:	iobuf4															*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	0.0	-	Pre Release													*/
/* Revision	1.0	-	First General Release									*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module iobuf4(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input [3:0]		I,		/* In coming data from design */
	input [3:0]		T,		/* Pin direction, tristate enable */
	/* OUTPUT PORTS */
	output [3:0]	O,		/* Out going data to design */
	/* INOUT PORTS */
	inout [3:0]		IO		/* Pin status */
	);

/*****IO Buffers****************************************************************/

	assign O[0]	=	IO[0];
	assign IO[0] =	(~T[0])?I[0]:1'bz;

	assign O[1]	=	IO[1];
	assign IO[1] =	(~T[1])?I[1]:1'bz;

	assign O[2]	=	IO[2];
	assign IO[2] =	(~T[2])?I[2]:1'bz;

	assign O[3]	=	IO[3];
	assign IO[3] =	(~T[3])?I[3]:1'bz;

endmodule
