/* Copyright (c) Microsoft Corporation. All rights reserved.			*/

/*********************************************************************/
/* Company:		Microsoft Research (MSR)										*/
/*					Microsoft Corporation											*/
/* Group:		Embedded Systems Group											*/
/* Engineer: 	Richard Neil Pittman												*/
/*																							*/
/* Project Name:	eMIPS Dynamically Extensible Processor					*/
/* Design Name:	eMIPS Debug														*/
/* Module Name:	top_dcm_ice															*/
/* Target Devices:	Xilinx Virtex 4 FPGA (xc4vlx25-10ff668)			*/
/* Tool versions:		8.2i sp 3 and 8.2i sp1 PR								*/
/* Description:																		*/
/*																							*/
/* Dependencies:																		*/
/*																							*/
/* Revision:																			*/
/* Revision	0.0	-	Pre Release													*/
/* Additional Comments:																*/
/*																							*/
/*********************************************************************/

`timescale 1ns / 1ps

module top_dcm(
/*****Ports****************************************************************/
	/* INPUT PORTS */
	input CLKIN_IN,				/* Input Source Clock, Board Clock 100 MHZ */
	input CLKPER_IN,				/* Input System Ace Clock 33 MHZ */
	input RESET,					/* Hardware Reset */
	input SLOW_FASTN,				/* Select System Clock Speed 100 or 50 MHZ */
	input SLOW_FASTN2,			/* Select SRAM Clock Speed 100 MHZ or 50 MHZ */
	input SRAMCLK_FB_IN, 		/* SRAM Clock Feedback 50 - 100 MHZ */
	/* OUTPUT PORTS */
	output CLKIN_IBUFG,			/* Buffered Source Clock 100 MHZ */
	output CLKPER,					/* Buffered System Ace Clock 33 MHZ */
	output LOCKED_OUT,			/* Digital Clock Manager Lock */
	output MEMCLK,					/* Buffered Memory Interface Clock 50 - 100 MHZ */
	output SRAMCLK,				/* Buffered & Deskewed Output SRAM Clock 50 - 100 MHZ */
	output SRAMCLK_INT,			/* Buffered & Deskewed Internal SRAM Clock 50 - 100 MHZ */
	output SYSCLK,					/* Buffered & Deskewed System Clock 50 - 100 MHZ */
	output TMRCLK,					/* Buffered & Deskewed Timer Clock 10 MHZ */
	output USARTCLK				/* Buffered & Deskewed USART Clock 100 MHZ */
	);
	
/*****Signals****************************************************************/

   wire 			CLK0_BUF_DCM;		/* Source Clock Buffered by System DCM, 100 MHZ */
	wire 			CLK0_BUF_PMCD;		/* Source Clock Buffered by System PMCD, 100 MHZ */
   wire 			CLK0_D2;				/* Source Clock Divided by 2, 50 MHZ */
	wire 			CLK0_D4;				/* Source Clock Divided by 4, 25 MHZ */
	wire 			CLK0_D8;				/* Source Clock Divided by 8, 12.5 MHZ */
   wire 			CLKDV_BUF_DCM;		/* Source Clock Divided by 10 Buffered by System DCM, 10 MHZ*/
	wire 			CLKDV_BUF_PMCD;	/* Source Clock Divided by 10 Buffered by System PMCD, 10 MHZ*/
   wire 			CLKFB_IN;			/* Source Clock Internal Feedback 100 MHZ */
	wire 			CLKPER_IBUFG;		/* System Ace Clock Buffered 33 MHZ */
   wire [6:0]	GND1;					/* 7-bit GND */
   wire [15:0]	GND2;					/* 16-bit GND */
   wire			GND3;					/* 1-bit GND */
	wire 			LOCKED_SYS;			/* System DCM Lock */
	wire 			LOCKED_SRAM;		/* SRAM DCM Lock */
	wire			SRAMCLK_FB_IBUFG;	/* SRAM Clock Feedback Buffered 50 - 100 MHZ */
	
/*********************************************************************/

	assign CLKIN_IBUFG = CLKPER_IN;
	assign CLKPER = CLKPER_IN;
	assign LOCKED_OUT = 1'b1;
	assign MEMCLK = CLKIN_IN;
	assign SRAMCLK = CLKIN_IN;
	assign SRAMCLK_INT = CLKIN_IN;
	assign SYSCLK = CLKIN_IN;
	assign TMRCLK = CLKIN_IN;
	assign USARTCLK = CLKIN_IN;

endmodule

 

