/* Utility to dump a binary file in the Xilinx COE format.
 */
#include <stdio.h>

#define ByteSwap32BitValue(_n_)  ((((_n_)&0xff)<<24) | \
                                  (((_n_)&0xff00)<<8) | \
                                  (((_n_)&0xff0000)>>8) | \
                                  (((_n_)&0xff000000)>>24))

int main(int argc, char **argv)
{
    FILE *fin, *fout;
    int i;
    int ByteSwap = 1;
#define _bs32(_v_)  ((ByteSwap) ? ByteSwap32BitValue(_v_) : (_v_))

    if (argc > 1) {
        fin = fopen(argv[1], "rb");
        if (fin == NULL) {
            fprintf(stderr,"Could not open %s for reading\n", argv[1]);
            goto Usage;
        }
    } else
        fin = stdin;

    if (argc > 2) {
        fout = fopen(argv[2],"w");
        if (fout == NULL) {
            fprintf(stderr,"Could not open %s for writing\n", argv[2]);
            fclose(fin);
            goto Usage;
        }
    } else
        fout = stdout;

    if (argc > 3)
        ByteSwap = !ByteSwap;

    fprintf(fout,"; Dump of %s\n", (argc > 1) ? argv[1] : "stdin");
    fprintf(fout,"memory_initialization_radix=16;\n");
    fprintf(fout,"memory_initialization_vector=\n");

    for (i = 0;;i++) {
        size_t n;
        unsigned int v = 0;

        n = fread(&v,1,4,fin);
        if (n == 0) break;

        if (i)
            fprintf(fout,",\n");

        v = _bs32(v);
        fprintf(fout,"%08x", v);
    }

    fprintf(fout,";\n");
 Done:
    fclose(fin);
    fclose(fout);
    return 0;

 Usage:
    fprintf(stderr,"Usage: %s [bin-filename [output-COEfilename]]", argv[0]);
    return -1;
}
