#include <mips/mips_asm.h>
#define __ASSEMBLER__ 1
#include <mips/ml40x.h>
        _EXPORT(start)
        
        .set noreorder
        .set noat
        .set nomacro

        .org 0

#define OUR_TOTAL_SIZE   (128*4) /* Change a few things if this changes */
#define ENTRIES_IN_PMT   (10)     /* WARNING: change if the PMT table changes! */

ENTRY(start)
    /* Find where we are and skip our data table
     */
    bgezal  $zero, _L(_start2) /* Always jumps */
    ori     $t2,$zero,((ENTRIES_IN_PMT-1)*4)

_LABEL(SramCtlrData)
    _DCD   (0x00100000 | SRAMST_BUS_32)// reset bit below
#define SRAM_START (0x00000000)
#define SRAM_START_VIRTUAL (0x80000000 | SRAM_START)
    _DCD   (SRAM_START | PMTTAG_SRAM)  // base==0, tag ro but decorate code :-)

_LABEL(FlashCtlrData)
    _DCD   (0x00800000 | FLASHST_BUS_32 | FLASHST_RESET_PIN | 11) // 8MBx32,~RESET,delay
#define FLASH_START (0xF0000000)
#define FLASH_START_VIRTUAL (0x80000000 | FLASH_START)
    _DCD   (FLASH_START | PMTTAG_FLASH)  // base==0, tag ro but decorate code :-)

_LABEL(GpioCtlrData)
    _DCD   (PIO_SW1_1_BIT|PIO_SW1_2_BIT|PIO_SW1_3_BIT|PIO_SW1_4_BIT|PIO_SW1_5_BIT|PIO_SW1_6_BIT|PIO_SW1_7_BIT|PIO_SW1_8_BIT)

_LABEL(UsartData)
    _DCD   (USC_RXEN|USC_TXEN|USC_BPC_8|USC_NONE|USC_1STOP|USC_CLKDIV_4)  // Control

    /* Real start of code
     */
_LABEL(_start2)
    /* Copy the PMT table into place
     */
    addiu  $t0,$ra,(OUR_TOTAL_SIZE-8)-((ENTRIES_IN_PMT-1)*4)
                                          // source pointer, ra=start+8=='.org 0'+8
    subu   $t1,$zero,$t2                  // destination, up to fffffffc included
_LABEL(PmtCopyLoop)
    lw     $t3,-4($t0)
    addiu  $t0,$t0,4
    sw     $t3,-4($t1)
    addiu  $t1,$t1,4
    bgtz   $t2,_L(PmtCopyLoop)
    subu   $t2,$t2,4

    /* First turn on power to all peripherals we'll use
     */
    lui    $t0,(POWER_MGR_DEFAULT_ADDRESS>>16) // nb: knows about 16bit chop
    ori    $t2,$zero,PMCPC_USART
    sw     $t2,PMCPE($t0)

    /* Reset SRAM controller, initialize it
     */
    lui    $t0,(SRAM_0_DEFAULT_ADDRESS>>16) // nb: knows about 16bit chop
    ori    $t2,$zero,SRAMST_RESET
    sw     $t2,SRAMST($t0)            // reset SRAM controller
    lw     $t2,0($ra)                 // one cycle delay min.
    sw     $t2,SRAMST($t0)            // even though reset auto-clears, do this first
    lw     $t2,4($ra)
    sw     $t2,SRAMBT($t0)
    addu   $gp,$ra,8                  // Done with our table, point to the next one
    
    /* Next initialize the FLASH controller
     */
    lui    $t0,(FLASH_0_DEFAULT_ADDRESS>>16) // nb: knows about 16bit chop
    ori    $t2,$zero,FLASHST_RESET_CONTROLLER
    sw     $t2,FLASHST($t0)           // reset FLASH controller
    lw     $t2,0($gp)                 // one cycle delay min.
    sw     $t2,FLASHST($t0)           // even though reset auto-clears, do this first
    lw     $t2,4($gp)
    sw     $t2,FLASHBT($t0)
    addu   $gp,$gp,8                  // Done with our table, point to the next one

    /* Now the GPIO controller, to read the dip switches
     * First make sure its there
     */
    lw     $t3,0($gp)                 // get our data
    lui    $t0,(GPIO_DEFAULT_ADDRESS>>16) // nb: knows about 16bit chop
    ori    $t2,$zero,PMTTAG_GPIO
    lw     $t1,PIOT($t0)
    bne    $t2,$t1,_L(TryTheUsart)
    addu   $gp,$gp,4                  // Done with our table, point to the next one

    /* Init the DIP switches for input
     */
    sw     $t3,PIOOD($t0)             // Direction = IN (make sure even though reset..)
    sw     $t3,PIOEN($t0)             // Enable
    li     $t1,SW1_BOOT_FROM_FLASH
    li     $t3,SW1_BOOT_FROM_SRAM     // give it another cycle to sample
    lw     $t2,PIOPS($t0)             // read the PinStatus directly
    and    $t1,$t1,$t2                // well then, shall we?
    bne    $t1,$zero,_L(Geronimo)
    lui    $a0,(FLASH_START_VIRTUAL>>16) // nb: knows about 16bit chop
    and    $t1,$t3,$t2                // well then, shall we?
    bne    $t1,$zero,_L(Geronimo)
    lui    $a0,(SRAM_START_VIRTUAL>>16)  // nb: knows about 16bit chop

    /* We want to boot from the usart..
     */

    /* Init USART
     * First make triple sure its there
     */
_LABEL(TryTheUsart)
    lui    $t0,(USART_DEFAULT_ADDRESS>>16) // nb: knows about 16bit chop
    ori    $t2,$zero,PMTTAG_USART
    lw     $t1,USARTT($t0)
    bne    $t2,$t1,_L(FatalError)

    /* Next set baudrate and enable tx/rx
     */
    ori    $t2,$zero,0x29    // BUGBUG fixme right
    sw     $t2,USARTBD($t0)  // Baud
    lw     $t2,0($gp)
    /* Funny way to do a subroutine since JAL is ~absolute
     * and the assembler really doesnt like x=label-label.
     */
    bgezal  $zero, _L(GetSize) /* Always jumps */
    sw     $t2,USARTC($t0)        // Control

/* Assumes: t0==USART,ra=caller
 * Uses: t1,t2,t3,t4
 * Returns: v0==0 ok, -1 timeout; t2==word if ok
 */
_LABEL(GetWord)
    lui    $t1,1000          // n*65k spins max
_LABEL(StartWord)
    li     $t2,0
    li     $t3,0
_LABEL(NextByte)
    lw     $t4,USARTST($t0)       // ChannelStatus
    andi   $t4,$t4,USI_RXRDY
    bgtz   $t4,_L(GotByte)
    subu   $t1,$t1,1
    // still ok to spin?
    bgtz   $t1,_L(NextByte)
    nop
    /* Timed out, go with what we got
     */
    jr     $ra
    li     $v0,-1
    /* Gottabyte, shift it in place and see if we got 4
     */
_LABEL(GotByte)
    lw     $t4,USARTRX($t0)        // RxData
    sw     $t4,USARTTX($t0)        // TxData
    sll    $t2,$t2,8
    or     $t2,$t2,$t4
    slti   $t4,$t3,3
    bne    $t4,$zero,_L(NextByte)
    addiu  $t3,$t3,1
    jr     $ra
    li     $v0,0

    /* We get here with RA==GetWord
     */ 
_LABEL(GetSize)
    /* Start by sending a 'l'eader byte
     */        
    or     $s0,$ra,$zero       // save address of GetWord
    li     $t4,0x6c           // 'l' for leadmeon
    jalr   $s0
    sw     $t4,USARTTX($t0)

    bne    $v0,$zero,_L(FatalError)
    or     $s1,$t2,$zero       // count of words to come

    /* ACK the size
     */
    li     $t4,0x73            // 's' for startmeup
    sw     $t4,USARTTX($t0)

    /* Spin getting and copying words, stop on errors
     */
    lui    $a1,(SRAM_START>>16) // nb: knows about 16bit chop
_LABEL(MoreWords)
    jalr   $s0
    subu   $s1,$s1,1

    sw     $t2,0($a1)
    bgtz   $s1,_L(MoreWords)
    addiu  $a1,$a1,4


_LABEL(Done)
    lui    $a0,(SRAM_START_VIRTUAL>>16) // nb: knows about 16bit chop
_LABEL(Geronimo)
    jr     $a0
    nop

_LABEL(FatalError)
	b     start
    nop

	.org  (OUR_TOTAL_SIZE - (ENTRIES_IN_PMT*4))
_LABEL(ThePmt)
    _DCD   (0x00000000 | PMTTAG_END_OF_TABLE)
    _DCD   (EXTENSION_CONTROLLER_DEFAULT_ADDRESS | PMTTAG_EXTENSION_CONTROLLER)
    _DCD   (IDE_DEFAULT_ADDRESS | PMTTAG_SYSTEM_ACE)
    _DCD   (FLASH_0_DEFAULT_ADDRESS | PMTTAG_FLASH)
    _DCD   (GPIO_DEFAULT_ADDRESS | PMTTAG_GPIO)
    _DCD   (USART_DEFAULT_ADDRESS | PMTTAG_USART)
    _DCD   (TIMER_DEFAULT_ADDRESS | PMTTAG_TIMER)
    _DCD   (INTERRUPT_CONTROLLER_DEFAULT_ADDRESS | PMTTAG_INTERRUPT_CONTROLLER)
    _DCD   (SRAM_0_DEFAULT_ADDRESS | PMTTAG_SRAM) 
    _DCD   (0x00000000 | PMTTAG_PMT)    // first entry, tag for this PMT 

END(start)
