#include <windows.h>

BOOL WaitForLeaderByte = FALSE;
BOOL WaitForEcho = TRUE;
BOOL Verbose = FALSE;

BOOL Download(HANDLE Serial, char *Filename)
{
    HANDLE b;
    int n = 0;
    DWORD Filesize = 0, Wordsize;
    int Byte = 0, Ack = 0;
    UINT nRead, nWritten;
    char *msg;
#define FAIL(_m_) {msg = _m_;goto Bad;}

    b = CreateFile(Filename, 
                   GENERIC_READ,
                   FILE_SHARE_READ,
                   NULL,
                   OPEN_EXISTING,
                   FILE_ATTRIBUTE_NORMAL,
                   NULL);
    if (b == INVALID_HANDLE_VALUE) {
        printf("Cant open %s, le=x%x\n", Filename, GetLastError());
        return FALSE;
    }

    Filesize = GetFileSize(b,NULL);
    if (Verbose)
        printf("%s is %d bytes long (%08x)\n", Filename, Filesize, Filesize);

    /* Wait for leader?
     */
    if (WaitForLeaderByte) {
        if (Verbose)
            printf("Waiting for leader byte...\n");
        if (!ReadFile(Serial,&Byte,1,&nRead,NULL) ||
            (nRead != 1))
            FAIL("Cant read leader byte");
        if (Byte != 'l'/*x6c*/)
            FAIL("Bad leader byte");
    }

    /* Send size over
     */
    Wordsize = ((Filesize + 3) & ~3) >> 2;
    if (Verbose)
        printf("Sending size (as %d words)...\n", Wordsize);
    for (n = 0; n < 4; n++) {
        Byte = (Wordsize >> (8*(3-n))) & 0xff;
        if (!WriteFile(Serial,&Byte,1,&nWritten,NULL) ||
            (nWritten != 1))
            FAIL("Cant write data byte");

        if (WaitForEcho) {
            if (!ReadFile(Serial,&Ack,1,&nRead,NULL) ||
                (nRead != 1))
                FAIL("Cant read ack byte");

            if (Verbose)
                printf("{%x %x}\n",Byte,Ack);

            if (Byte != Ack)
                FAIL("Bad ACK byte");
        }
    }

#if 1
    /* Wait for the 's' to ACK the size
     */
    if (WaitForEcho) {
        if (Verbose)
            printf("Waiting for 's' ACK of size...\n");
        if (!ReadFile(Serial,&Ack,1,&nRead,NULL) ||
            (nRead != 1))
            FAIL("Cant read ack byte");
        if (Verbose)
            printf("{%x}\n",Ack);

        if (Ack != 's'/*x73*/)
            FAIL("Bad size-ACK byte");
    }
#endif

    /* Loop reading one byte, sending it, waiting for ACK
     */
    for (n = 0; n < Filesize; n++) {
        if (!ReadFile(b,&Byte,1,&nRead,NULL) ||
            (nRead != 1)) {
            if (GetLastError() == 0)
                break;
            FAIL("Cant read data byte");
        }

        if (!WriteFile(Serial,&Byte,1,&nWritten,NULL) ||
            (nWritten != 1))
            FAIL("Cant write data byte");

        if (0 == (n & 0xff))
            printf(".");

        if (WaitForEcho) {
            if (!ReadFile(Serial,&Ack,1,&nRead,NULL) ||
                (nRead != 1))
                FAIL("Cant read ack byte");

            if (Verbose)
                printf("{%x %x}\n",Byte,Ack);

            if (Byte != Ack)
                FAIL("Bad ACK byte");
        }
    }

    /* Roundup to words, if we have to
     */
    Filesize = (Filesize + 3) & ~3;
    for (;n < Filesize; n++) {
        Byte = 0;
        if (!WriteFile(Serial,&Byte,1,&nWritten,NULL) ||
            (nWritten != 1))
            FAIL("Cant write data byte");

        if (WaitForEcho) {
            if (!ReadFile(Serial,&Ack,1,&nRead,NULL) ||
                (nRead != 1))
                FAIL("Cant read ack byte");

            if (Verbose)
                printf("{%x %x}\n",Byte,Ack);

            if (Byte != Ack)
                FAIL("Bad ACK byte");
        }
    }

    if (WaitForEcho)
        printf("Download complete, ");
    printf("%d bytes sent\n", n);
    CloseHandle(b);
    return TRUE;
 Bad:
    printf("After %d bytes, le=x%x, download failed: %s\n",n,GetLastError(),msg);
    CloseHandle(b);
    return FALSE;

}

void ChangeSerialLineParameters(HANDLE hLine, int Baud)
{
    UINT InterByteTime;
    DCB ControlBlock;
    COMMTIMEOUTS Timeouts;
    int bpc, parity, stops;

    /* Bits per char */
    bpc = 8;

    /* Stop bits */
    stops = ONESTOPBIT;

    /* parity */
    parity = NOPARITY;

    /*    Get what we wont change
     */
    ControlBlock.DCBlength = sizeof(ControlBlock);
    if (!GetCommState(hLine,&ControlBlock)) {
        /* 
         *    might be a disk file, ignore
         */
        return;
    }

    /* 
     *    No parity, no flow..
     */
    ControlBlock.BaudRate = Baud;
    ControlBlock.fBinary = TRUE;     /* no EOF check */
    ControlBlock.fParity = FALSE;
    ControlBlock.fOutxCtsFlow = FALSE;
    ControlBlock.fOutxDsrFlow = FALSE;
    ControlBlock.fDtrControl = DTR_CONTROL_ENABLE;
    ControlBlock.fDsrSensitivity = FALSE;
    ControlBlock.fTXContinueOnXoff = TRUE;
    ControlBlock.fOutX = FALSE;
    ControlBlock.fInX = FALSE;
    ControlBlock.fErrorChar = FALSE;
    ControlBlock.fNull = FALSE;
    ControlBlock.fRtsControl = RTS_CONTROL_ENABLE;
    ControlBlock.fAbortOnError = FALSE;
    ControlBlock.ByteSize = (BYTE) bpc;
    ControlBlock.Parity = (BYTE) parity;
    ControlBlock.StopBits = (BYTE) stops;
    if (!SetCommState(hLine,&ControlBlock)) {
        printf("Warn: SetCommState() failed (x%x)",GetLastError());
        /* 
         *    might be a disk file, ignore
         */
        return;
    }
}

int main(int argc, char ** argv)
{
    HANDLE f;

    while ((argc > 1) && (argv[1][0] == '-')) {
        if (argv[1][1] == 'n') {
            WaitForEcho = !WaitForEcho;
        }
        if (argv[1][1] == 'l') {
            WaitForLeaderByte = !WaitForLeaderByte;
        }
        if (argv[1][1] == 'v') {
            Verbose = !Verbose;
        }
        argc--, argv++;
    }

    if (argc < 3) {
        printf("Usage: <comN> <file-to-download>");
        return -1;
    }
    if (argc > 3)
        WaitForLeaderByte = TRUE;

    f = CreateFile(argv[1], 
                   GENERIC_READ | GENERIC_WRITE,
                   FILE_SHARE_WRITE,
                   NULL,
                   OPEN_EXISTING,
                   FILE_FLAG_NO_BUFFERING,
                   NULL);
    if (f == INVALID_HANDLE_VALUE) {
        printf("Cant open %s, le=x%x\n", argv[1], GetLastError());
        return -1;
    }

    ChangeSerialLineParameters(f,38400);
    Download(f,argv[2]);

    CloseHandle(f);

    return 0;
}
