@echo Compiling %1.s ...
@setlocal

@set CC_DIR=%MMLITE_SDK%\tools\emips
@set path=%CC_DIR%\bin;%path%
@set GCC_EXEC_PREFIX=%CC_DIR%\bin
@set AS=%CC_DIR%\bin\as.exe
@set GCC=%CC_DIR%\bin\gcc.exe
@set LD=%CC_DIR%\bin\ld.exe
@set LINKSCRIPT=%CC_DIR%\bin\emips.x
@set OCP=%CC_DIR%\bin\objcopy.exe
@set DUMP=%CC_DIR%\bin\objdump.exe
@set BBDIR=.\bbtools

@set INCLUDE=%MMLITE_SDK%\include

@rem make sure the library file is updated
%GCC% -I %INCLUDE% -E -x c print.s > print.ss
%AS% -mips2 -g -gstabs -G 0 --trap -o print.o print.ss

@rem Now compile the C program
%GCC% -g -fverbose-asm -mno-abicalls -S -fno-builtin -mips2 -fno-common -fPIC -G0 -gstabs -I %INCLUDE% -o %1.ss %1.c
if %ERRORLEVEL% GTR 0 goto out
%AS% -mips2 -g -G 0 -o %1.o %1.ss
if %ERRORLEVEL% GTR 0 goto out

@rem If there is an optional assembly module compile that too
@set ass=
if %2"" == "" goto LinkEm
@set ass=%2.o
%GCC% -I %INCLUDE% -E -x c %2.s > %2.ss
%AS% -mips2 -g -gstabs -G 0 --trap -o %2.o %2.ss

@rem Now link them together
:LinkEm
@del %1
%LD% -r -T %LINKSCRIPT% -Ttext 80000000 -estart -d -g -o %1.rel print.o %1.o %ass%
%LD% -T %LINKSCRIPT% -Ttext 80000000 -estart -d -g -o %1 print.o %1.o %ass%
%DUMP% --disassemble-all %1
@del %1.bin
%OCP% -O binary %1 %1.bin

@rem Do it again after we patch with the bbtools
%BBDIR%\bbfind -T 80000000 -m %BBDIR%\patts.bbw -s %1.rel.nm %1.rel %1.rel.out
%OCP% -O binary %1.rel.out %1.rel.bin

@rem %DUMP% -EB -b binary -m mips --disassemble-all %1.bin
:out
