#include "print.h"
#include <mips\ml40x.h>

#define TheAic ((struct _Aic *)INTERRUPT_CONTROLLER_DEFAULT_ADDRESS)
#define TheTc  ((struct _Tc  *)TIMER_DEFAULT_ADDRESS)

void DumpAicRegisters(void)
{
#define DumpRegister(_n_,_o_) { \
    Puts(_n_); \
    PutWord(TheAic->_o_); \
    PutChar('\n'); \
}
    Puts("-- AIC --\n");
    DumpRegister("Tag=",Tag);
    DumpRegister("IrqStatus=",IrqStatus);
    DumpRegister("IrqRawStatus=",IrqRawStatus);
    DumpRegister("IrqEnable=",IrqEnable);
    DumpRegister("IrqEnableClear=",IrqEnableClear);
#undef DumpRegister
}

void DumpTcRegisters(void)
{
    UINT64 v;
#define DumpRegister(_n_,_v_) { \
    Puts(_n_); \
    PutWord(_v_); \
    PutChar('\n'); \
}
#define DumpRegister64(_n_,_h_,_l_) { \
    Puts(_n_); \
    PutWord(_h_); PutChar('.'); PutWord(_l_); \
    PutChar('\n'); \
}
    Puts("-- TC --\n");
    DumpRegister("Tag=",TheTc->Tag);
    DumpRegister("Control=",TheTc->Control);
    DumpRegister64("DownCounter=",TheTc->DownCounterHigh,TheTc->DownCounter);
    v = TheTc->FreeRunning;
    DumpRegister64("FreeCounter=",(UINT32)(v>>32), (UINT32)v);
#undef DumpRegister
#undef DumpRegister64
}

void DumpPsr(void)
{
    UINT32 v;
    Puts("-- COPROC-0 --\n");
    v = GetPsr();
    Puts("psr="); PutWord(v); PutChar('\n');
    v = GetCause();
    Puts("cause="); PutWord(v); PutChar('\n');
    v = GetEpc();
    Puts("epc="); PutWord(v); PutChar('\n');
}



void main(char *StackPointer)
{
    char Step = 'a'-1;
    volatile UINT32 x;
    UINT32 psr;

    /* Wait fro go
     */
    Delay(20 * 0x10000); // NB: about 1 sec

    /* Test utils */
    Step++;
    Puts("HiMom! sp=");
    PutWord((UINT32)StackPointer);
    PutChar('\n');

    /* TEST: Check the tag, bail out if wrong
     */
    Step++;
    if (TheTc->Tag != PMTTAG_TIMER) {
        Puts("?TimerTag=");
        PutWord(TheTc->Tag);
        PutChar('\n');
        goto error;
    }

    /* TEST: Dump all registers
     */
    Step++;
    DumpTcRegisters();


    /* TEST: Enable interrupts from the timer, see what happens
     */
    Step++;
    Puts("\tEnabling interrupts for TC...");

    x = TheTc->Control;
    TheTc->Control = TCCT_ENABLE | TCCT_INT_ENABLE;
    TheAic->IrqEnable = AIC_TIMER_BIT;
    Delay(0x10000);

    Puts("Done\n");
    DumpTcRegisters();
    DumpAicRegisters();
    DumpPsr();


    /* TEST: Disable interrupts from the timer, see what happens
     */
    Step++;
    Puts("\tResetting TC...");

    TheTc->Control = TCCT_RESET;
    TheAic->IrqEnableClear = AIC_TIMER_BIT;

    Puts("Done\n");
    DumpTcRegisters();
    DumpAicRegisters();

    /* TEST: Perform the init that MMLite will do, see what happens
     */
    Step++;
    Puts("\tInitializing FRC...");

    TheTc->Control = TCCT_RESET;
    TheAic->IrqEnable = AIC_TIMER_BIT;
    TheTc->DownCounterHigh = 0;
    TheTc->DownCounter = ~0;
    TheTc->Control = TCCT_ENABLE | TCCT_INT_ENABLE;

    Puts("Done\n");
    DumpTcRegisters();

    /* TEST: Do what SetNextInterrupt() will do, see what happens
     */
    Step++;
    Puts("\tStarting FRC...");

    TheTc->DownCounter = 0x08000000;
    /* enable interrupts, drop BEV */
    psr = GetPsr();
    psr |= 1;
    psr &= ~0x00400000;
    SetPsr(psr);

    Puts("Done\n");
    DumpTcRegisters();

    /* TEST-2: Wait until the timeout above expires, see what happens
     */
    Step++;
    Puts("\tWaiting for the FRC ");

    x = 0;
    while (TheTc->DownCounterHigh == 0) {
        Delay(100);
        if (0 == (++x & 0xffff)) // NB: about 5sec each
            PutChar('.');
        if (0 == (x & 0x3ffff)) {
            DumpTcRegisters();
            Puts("\tStill waiting");
        }
        if (x > 0x1000000) {
            Puts("\tWaited too long!\n");
            goto error;
        }
    }

    x = GetEpc();
    psr = TheAic->IrqStatus;
    Puts("Done\n");

    DumpAicRegisters();
    DumpPsr();
    DumpTcRegisters();

    if ((x == 0xfffffffc)  || (psr != AIC_TIMER_BIT)) {
        Puts("\tDid NOT get an interrupt!\n");
        goto error;
    }

    /* TEST: The DownCounter. It should:
     * 1- Start counting down from what we load, when we load the low part.
     * 2- Get to zero and keep going without stopping.
     * 3- It should *not* reload the initial value
     */
    Step++;
    Puts("\n\tTesting the DownCounter...\n");

#define STARTVAL 100 /* 0x08000000 */
    TheTc->DownCounterHigh = 0;
    TheTc->DownCounter = STARTVAL;
    Delay(10); /*uhu?*/

    if (TheTc->DownCounter >= STARTVAL) {
        Puts("\tDownCounter load failed\n");
    }

    x = 0;
    while (TheTc->DownCounterHigh == 0) {
        Delay(100);
        if (0 == (++x & 0xffff)) // NB: about 5sec each
            DumpTcRegisters();
        if (x > 0x1000000) {
            Puts("\tWaited too long!\n");
            goto error;
        }
    }
    /* keep printing for a while longer */
    for (x = 0; x < 0x100000; ) {
        Delay(100);
        if (0 == (++x & 0xffff)) // NB: about 5sec each
            DumpTcRegisters();
    }

    /* END: all is well
     */ 
    Step++;
    Puts("TEST PASSED SUCCESSFULLY\n");
    return;

error:
    Puts("TEST FAILED at Step=");
    PutChar(Step);
    Puts("\n");
    return;
}
