#include "print.h"
#include <mips\ml40x.h>

#define TheAic ((struct _Aic *)INTERRUPT_CONTROLLER_DEFAULT_ADDRESS)
#define TheUsart ((struct _Usart *)USART_DEFAULT_ADDRESS)

void DumpAicRegisters(void)
{
#define DumpRegister(_n_,_o_) { \
    Puts(_n_); \
    PutWord(TheAic->_o_); \
    PutChar('\n'); \
}
    Puts("-- AIC --\n");
    DumpRegister("Tag=",Tag);
    DumpRegister("IrqStatus=",IrqStatus);
    DumpRegister("IrqRawStatus=",IrqRawStatus);
    DumpRegister("IrqEnable=",IrqEnable);
    DumpRegister("IrqEnableClear=",IrqEnableClear);
    DumpRegister("IrqSoft=",IrqSoft);
#undef DumpRegister
}

void DumpUsartRegisters(void)
{
#define DumpRegister(_n_,_o_) { \
    Puts(_n_); \
    PutWord(TheUsart->_o_); \
    PutChar('\n'); \
}
    Puts("-- USART --\n");
    DumpRegister("Tag=",Tag);
    DumpRegister("Control=",Control);
    DumpRegister("IntrEnable=",IntrEnable);
    DumpRegister("IntrDisable=",IntrDisable);
    DumpRegister("IntrMask=",IntrMask);
    DumpRegister("ChannelStatus=",ChannelStatus);
    DumpRegister("RxData=",RxData);
    DumpRegister("TxData=",TxData);
    DumpRegister("Baud=",Baud);
    DumpRegister("Timeout=",Timeout);
#undef DumpRegister
}

void DumpPsr(void)
{
    UINT32 v;
    Puts("-- COPROC-0 --\n");
    v = GetPsr();
    Puts("psr="); PutWord(v); PutChar('\n');
    v = GetCause();
    Puts("cause="); PutWord(v); PutChar('\n');
    v = GetEpc();
    Puts("epc="); PutWord(v); PutChar('\n');
}


void main(char *StackPointer)
{
    char Step = 'a'-1;
    UINT32 psr, x;

    /* Wait fro go
     */
    Delay(20 * 0x10000); // NB: about 1 sec

    /* Test utils */
    Step++;
    Puts("\tHiMom! sp=");
    PutWord((UINT32)StackPointer);
    PutChar('\n');

    /* TEST1: Check the tag, bail out if wrong
     */
    Step++;
    if (TheAic->Tag != PMTTAG_INTERRUPT_CONTROLLER) {
        Puts("AIC: bad tag="); PutWord(TheAic->Tag); PutChar('\n');
        goto error;
    }

    /* TEST2: Enable interrupts, dump all registers
     */
    Step++;

    /* enable interrupts, drop BEV */
    psr = GetPsr();
    psr |= 1;
    psr &= ~0x00400000;
    Puts("psr->");PutWord(psr);PutChar('\n');
    SetPsr(psr);

    DumpUsartRegisters();
    DumpAicRegisters();
    DumpPsr();

    /* TEST3: Enable interrupts from the USART, see what happens
     */
    Step++;
    Puts("\tEnabling interrupts for USART...");

#define ZEBITS (USI_RXRDY|USI_TXRDY|USI_FRAME)
    TheUsart->IntrEnable = ZEBITS;
    TheAic->IrqEnable = AIC_USART_BIT;
    Delay(0x10000);

    Puts("Done\n");
    DumpUsartRegisters();
    DumpAicRegisters();
    DumpPsr();
    
    x = GetPsr();

    /* TEST4: Disable interrupts from the USART, see what happens
     */
    Step++;
    Puts("\tDisabling interrupts for USART...");

    TheUsart->IntrDisable = ZEBITS;

    Puts("Done\n");
    DumpUsartRegisters();
    DumpAicRegisters();
    DumpPsr();

    /* We should have gotten an interrupts and interrupts are now disabled */
    if (x == psr) {
        Puts("FAILURE: Did not get an interrupt\n");
        goto error;
    }

    /* TEST5: Write to IrqSoft, see what happens
     */
    Step++;
#if 0
    Puts("psr->");PutWord(psr);PutChar('\n');
    SetPsr(psr);
#endif
    Puts("\tWriting to IrqSoft.1...");

    TheAic->IrqSoft = 2;

    Puts("Done\n");
    DumpAicRegisters();
    DumpPsr();


    /* TEST6: Write to IrqSoft and cause a reset, see what happens
     */
    Step++;
    Puts("\tWriting to IrqSoft.0...");

    TheAic->IrqSoft = 1;

    Puts("Done\n");
    DumpAicRegisters();
    DumpPsr();


    /* END: all is well
     */ 
    Puts("TEST PASSED SUCCESSFULLY\n");
    return;

error:
    Puts("TEST FAILED at Step=");
    PutChar(Step);
    Puts("\n");
    return;
}
