#include <mips/mips_asm.h>
#define __ASSEMBLER__ 1
#include <mips/ml40x.h>


        _EXPORT(loadext0)
        _EXPORT(unloadext0)
        _EXPORT(enableext0)
        _EXPORT(disableext0)
        _EXPORT(trapext0)
        _EXPORT(notrapext0)
		_EXPORT(maxpriorityext0)
		_EXPORT(smult)
		_EXPORT(sdiv)
        
        .set noreorder

#ifdef __MIPSEB__
#define p0h $a0
#define p0l $a1
#define p1h $a2
#define p1l $a3
#define resh $v0
#define resl $v1
#define _p0h _a0
#define _p0l _a1
#define _p1h _a2
#define _p1l _a3
#define _resh _v0
#define _resl _v1
#else
#define p0h $a1
#define p0l $a0
#define p1h $a3
#define p1l $a2
#define resh $v1 
#define resl $v0
#define _p0h _a1
#define _p0l _a0
#define _p1h _a3
#define _p1l _a2
#define _resh _v1 
#define _resl _v0
#endif

#define _zero 0
#define _at 1
#define _v0 2
#define _v1 3
#define _a0 4
#define _a1 5
#define _a2 6
#define _a3 7
#define _t0 8
#define _t1 9
#define _t2 10
#define _t3 11
#define _t4 12
#define _t5 13
#define _t6 14
#define _t7 15
#define _s0 16
#define _s1 17
#define _s2 18
#define _s3 19
#define _s4 20
#define _s5 21
#define _s6 22
#define _s7 23
#define _t8 24
#define _t9 25
#define _k0 26
#define _k1 27
#define _gp 28
#define _sp 29
#define _s8 30
#define _ra 31

#define ExtInstruction(_op_,_reg1_,_reg2_,_imm_)	_DCD ((_op_<<26)|(_reg1_<<21)|(_reg2_<<16)|(_imm_))

 /* UINT64 mmldiv64(UINT64 a0a1, UINT64 a2a3);
 * Returns: quotient of a0a1/a2a3
 */

ENTRY(mmldiv64)
    li   $t2,63           /* Set loop count                    */
    move $t0,$zero        /* Clear partial remainder           */
    move $t1,$zero        /* done.                             */
next:
	ExtInstruction(30,_p0h,_t0,64)
    sll  $t1,$t1,1        /* Shift next dividend bit           */
    srl  $t3,$t0,31       /* into the partial remainder        */
    or   $t1,$t1,$t3      /*                                   */
    sll  $t0,$t0,1        /* so far:  t1:t0<<1                 */
    srl  $t3,p0h,31       /*                                   */
    or   $t0,$t0,$t3      /* done.                             */
    sll  p0h,p0h,1        /* Left shift one the QWORD dividend */
    srl  $t3,p0l,31       /*                                   */
    or   p0h,p0h,$t3      /* done.                             */
    sltu $t3,$t1,p1h      /* Is remainder < divisor.high ?     */
    beq  $zero,$t3,rmge   /* If eq, partial remainder not less */
    sll  p0l,p0l,1        /*                                   */
    bne  $zero,$t2,next   /* If ne, more iterations to go      */
    subu $t2,$t2,1        /* Decrement iteration count         */
    b    done             /*                                   */
    nop                   /*                                   */
rmge:
    bne  p1h,$t1,rmgt     /* If ne, partial remainder greater  */
    sltu $t3,$t0,p1l      /* Is remainder < divisor.low ?      */
    bne  $zero,$t3,rmls   /* If ne, partial remainder is less  */
    nop                   /*                                   */
rmgt:
    or   p0l,p0l,1        /* Merge quotient bit                */
    subu $t1,$t1,p1h      /* Subtract out divisor high part    */
    sltu $t3,$t0,p1l      /* Set borrow from high part         */
    subu $t1,$t1,$t3      /* Subtract borrow from high part    */
    subu $t0,$t0,p1l      /* Subtract out divisor low          */
rmls:
    bne  $zero,$t2,next   /* If ne, more iterations to go      */
    subu $t2,$t2,1        /* Decrement iteration count         */
done:
    move resl,p0l         /* Done, collect low-part of result  */
    jr      $ra
    move resh,p0h         /* Collect high-part of result       */
    //.set reorder
END(mmldiv64)

ENTRY(mmldiv64_chk)
	li   $t2,63
	move $t0,$zero
	move $t1,$zero
next_chk:
    sll  $t1,$t1,1
    srl  $t3,$t0,31
    or   $t1,$t1,$t3
    sll  $t0,$t0,1
    srl  $t3,p0h,31
    or   $t0,$t0,$t3
    sll  p0h,p0h,1
    srl  $t3,p0l,31
    or   p0h,p0h,$t3
    sltu $t3,$t1,p1h
    beq  $zero,$t3,rmge_chk
    sll  p0l,p0l,1
    bne  $zero,$t2,next_chk
    subu $t2,$t2,1
    b    done_chk
    nop
rmge_chk:
    bne  p1h,$t1,rmgt_chk
    sltu $t3,$t0,p1l
    bne  $zero,$t3,rmls_chk
    nop
rmgt_chk:
    or   p0l,p0l,1
    subu $t1,$t1,p1h
    sltu $t3,$t0,p1l
    subu $t1,$t1,$t3
    subu $t0,$t0,p1l
rmls_chk:
    bne  $zero,$t2,next_chk
    subu $t2,$t2,1
done_chk:
    move resl,p0l
    jr      $ra
    move resh,p0h
    //.set reorder
END(mmldiv64_chk)

/* void loadext0(void);
 * raises load bit of extension0
 */
 
ENTRY(loadext0)
	nop
	li		$t0,2
	mfc0	$t1,$s0
	or		$t0,$t0,$t1
	mtc0	$t0,$s0
	jr     $ra
	nop
END(loadext0)
 
/* void unloadext0(void);
 * lowers load bit of extension0
 */ 
 
ENTRY(unloadext0)
	nop
	li		$t2,1
	subu	$t2,$zero,$t2
	li		$t0,2
	xor		$t0,$t0,$t2
	mfc0	$t1,$s0
	and		$t0,$t0,$t1
	mtc0	$t0,$s0
	jr     $ra
	nop
END(unloadext0)
 
/* void enableext0(void);
 * raises enable bit of extension0
 */
 
ENTRY(enableext0)
	nop
	li		$t0,1
	mfc0	$t1,$s0
	or		$t0,$t0,$t1
	mtc0	$t0,$s0
	jr     $ra
	nop
END(enableext0)
 
/* void disableext0(void);
 * lowers enable bit of extension0
 */ 

ENTRY(disableext0)
	nop
	li		$t2,1
	subu	$t2,$zero,$t2
	li		$t0,1
	xor		$t0,$t0,$t2
	mfc0	$t1,$s0
	and		$t0,$t0,$t1
	mtc0	$t0,$s0
	jr     $ra
	nop
 END(disableext0)
 
/* void trapext0(void);
 * raises trap bit of extension0
 */
 
ENTRY(trapext0)
	nop
	li		$t0,4
	mfc0	$t1,$s0
	or		$t0,$t0,$t1
	mtc0	$t0,$s0
	jr     $ra
	nop
END(trapext0)
 
/* void notrapext0(void);
 * lowers trap bit of extension0
 */ 
 
ENTRY(notrapext0)
	nop
	li		$t2,1
	subu	$t2,$zero,$t2
	li		$t0,4
	xor		$t0,$t0,$t2
	mfc0	$t1,$s0
	and		$t0,$t0,$t1
	mtc0	$t0,$s0
	jr     $ra
	nop
END(notrapext0)


/* void maxpriorityext0(void);
 * set extension0  priority to 2'b11
 */ 

ENTRY(maxpriorityext0)
	nop
	li 	$t2,0xd8
	mfc0	$t1,$s0
	or	$t0,$t1,$t2
	mtc0	$t0,$s0
	jr     $ra
	nop
END(maxpriorityext0)

ENTRY(smult)
	nop
	mult	$a0,$a1
	mflo	$v0
	jr		$ra
	nop
END(smult)

ENTRY(sdiv)
	nop
	div		$a0,$a1
	mflo	$v0
	jr		$ra
	nop
END(sdiv)
 
	.set reorder
 
