#include "print.h"
#include <mips\ml40x.h>

/* Special instructions */
extern UINT32 SpecialInstruction0(UINT32 a0_r4, UINT32 a1_r5, UINT32 a2_r6, UINT32 a3_r7);
extern UINT32 SpecialInstruction1(UINT32 a0_r4, UINT32 a1_r5, UINT32 a2_r6, UINT32 a3_r7);
extern UINT32 SpecialInstruction2(UINT32 a0_r4, UINT32 a1_r5, UINT32 a2_r6, UINT32 a3_r7);


void DumpUint32(char *What, UINT32 Value)
{
    Puts(What);
    PutWord(Value);
    PutChar('\n');
}

BOOL HadTrap = FALSE;

PCXTINFO TrapHandler(PCXTINFO Context)
{
    HadTrap = TRUE;
    DumpUint32("Caught trap at pc=", Context->pc);
    Context->pc += 4;
    return Context;
}

void main(char *StackPointer)
{
    char Step = 'a'-1;
    UINT32 x, psr;

    /* Wait for go
     */
    Delay(20 * 0x10000); // NB: about 1 sec

    /* Test utils */
    Step++;
    DumpUint32("HiMom! sp=", (UINT32)StackPointer);

    /* Enable traps to non-boot location
     */
    Step++;
    psr = GetPsr();
    psr &= ~0x00400000;
    SetPsr(psr);

    /* Install trap our handler
     */
    Step++;
    UserInterruptHandler = TrapHandler;

    /* Execute extended instruction.
     * This will trap if the extension is not loaded
     */
    Step++;
	x = SpecialInstruction0(0,0,0,0);

    /* Did it work or did it fail?
     */
    if (HadTrap) {
        Puts("Had a trap, our Extension is not loaded/enabled.\n");
        goto error;
    } 

    DumpUint32("logged writes", x);
    Puts("TEST PASSED SUCCESSFULLY\n");
    return;

 error:
    Puts("TEST FAILED at Step=");
    PutChar(Step);
    Puts("\n");
    return;
}
