#include "print.h"
#include <mips\ml40x.h>

#define TheGPIO ((struct _Pio  *)GPIO_DEFAULT_ADDRESS)
#define TheTc  ((struct _Tc  *)TIMER_DEFAULT_ADDRESS)

/* Special instructions */
extern UINT32 loadlink(UINT32 a0);
extern UINT32 storeconditional(UINT32 a0, UINT32 a1);
extern void loadext0(void);
extern void unloadext0(void);
extern void enableext0(void);
extern void disableext0(void);
extern void trapext0(void);
extern void notrapext0(void);
extern void enableclkext0(void);
extern void disableclkext0(void);

void DumpUint32(char *What, UINT32 Value)
{
    Puts(What);
    PutWord(Value);
    PutChar('\n');
}

void DumpUint64(char *What, UINT32 Value1, UINT32 Value2)
{
    Puts(What);
    //if (Value1 > 0)
	//{
		PutWord(Value1);
		PutChar('.');
	//}
	PutWord(Value2);
    //PutChar('\n');
}

BOOL HadTrap = FALSE;

PCXTINFO TrapHandler(PCXTINFO Context)
{
    HadTrap = TRUE;
    DumpUint32("Caught trap at pc=", Context->pc);
    Context->pc += 4;
    return Context;
}

void main(char *StackPointer)
{
    char Step = 'a'-1;
    UINT32 x, psr;

	UINT32 datamem, *datamem_p;
	UINT32 datamem2, *datamem2_p;
	UINT32 data, data2;

	Step++;
	TheGPIO->OutDisable = 0xffffffff;
	TheGPIO->Enable = 0xffffffff;
	TheGPIO->ClearData = 0xffffffff;
	x = TheGPIO->PinStatus; /* verbose and whatnot */

    /* Wait for go
     */
    Step++;
    if (((x)&(0x4)) == 0) Delay(20 * 0x10000); // NB: about 1 sec

    /* Test utils */
    Step++;
    DumpUint32("HiMom! sp=", (UINT32)StackPointer);

    /* Enable traps to non-boot location
     */
    Step++;
    psr = GetPsr();
    psr &= ~0x00400000;
    SetPsr(psr);

    /* Install trap our handler
     */
    Step++;
    UserInterruptHandler = TrapHandler;

	Step++;
	datamem_p = &(datamem);
	datamem2_p = &(datamem2);
	//DumpUint32("\ndatamem at address ", datamem_p);
	//DumpUint32("\ndatamem2 at address ", datamem2_p);

	Step++;

	datamem = 0;
	//DumpUint32("\ndatamem = ", datamem);
	//DumpUint32("datamem_p = ", *datamem_p);
	if (datamem != *datamem_p) goto error;

	datamem2 = 0;
	//DumpUint32("\ndatamem2 = ", datamem2);
	//DumpUint32("datamem2_p = ", *datamem2_p);
	if (datamem2 != *datamem2_p) goto error;

	Step++;

	datamem = 0x10101010;
	//DumpUint32("\ndatamem = ", datamem);
	//DumpUint32("datamem_p = ", *datamem_p);
	if (datamem != *datamem_p) goto error;

	datamem2 = 0x01010101;
	//DumpUint32("\ndatamem2 = ", datamem2);
	//DumpUint32("datamem2_p = ", *datamem2_p);
	if (datamem2 != *datamem2_p) goto error;

	Step++;
	Puts("\n\nTEST LL-SC");

	DumpUint32("\ndatamem = ", datamem);
	DumpUint32("datamem_p = ", *datamem_p);
	data = loadlink(datamem_p);
	data = storeconditional(datamem_p,0x11110000);
	DumpUint32("\ndatamem = ", datamem);
	DumpUint32("datamem_p = ", *datamem_p);
	DumpUint32("data = ", data);
	if (data == 0) goto error;

	DumpUint32("\ndatamem2 = ", datamem2);
	DumpUint32("datamem2_p = ", *datamem2_p);
	data2 = loadlink(datamem2_p);
	data2 = storeconditional(datamem2_p,0x00001111);
	DumpUint32("\ndatamem2 = ", datamem2);
	DumpUint32("datamem2_p = ", *datamem2_p);
	DumpUint32("data2 = ", data2);
	if (data2 == 0) goto error;

	Step++;
	Puts("\n\n\TEST LL1-LL2-SC1-SC2");

	DumpUint32("\ndatamem = ", datamem);
	DumpUint32("datamem_p = ", *datamem_p);
	DumpUint32("datamem2 = ", datamem2);
	DumpUint32("datamem2_p = ", *datamem2_p);
	data = loadlink(datamem_p);
	data2 = loadlink(datamem2_p);
	data = storeconditional(datamem_p,0x55555555);
	data2 = storeconditional(datamem2_p,0xaaaaaaaa);
	DumpUint32("\ndatamem = ", datamem);
	DumpUint32("datamem_p = ", *datamem_p);
	DumpUint32("data = ", data);
	DumpUint32("datamem2 = ", datamem2);
	DumpUint32("datamem2_p = ", *datamem2_p);
	DumpUint32("data2 = ", data2);
	if (data > 0) goto error;
	if (data2 > 0) goto error;

	Step++;
	Puts("\n\n\TEST LL1-LL2-SC2-SC1");

	DumpUint32("\ndatamem = ", datamem);
	DumpUint32("datamem_p = ", *datamem_p);
	DumpUint32("datamem2 = ", datamem2);
	DumpUint32("datamem2_p = ", *datamem2_p);
	data = loadlink(datamem_p);
	data2 = loadlink(datamem2_p);
	data2 = storeconditional(datamem2_p,0xaaaaaaaa);
	data = storeconditional(datamem_p,0x55555555);
	DumpUint32("\ndatamem = ", datamem);
	DumpUint32("datamem_p = ", *datamem_p);
	DumpUint32("data = ", data);
	DumpUint32("datamem2 = ", datamem2);
	DumpUint32("datamem2_p = ", *datamem2_p);
	DumpUint32("data2 = ", data2);
	if (data > 0) goto error;
	if (data2 == 0) goto error;

	Step++;
    Puts("TEST PASSED SUCCESSFULLY\n");
    return;

 error:
    Puts("TEST FAILED at Step=");
    PutChar(Step);
    Puts("\n");
    return;
}
