#include "print.h"
#include <mips\ml40x.h>

#define TheGPIO ((struct _Pio  *)GPIO_DEFAULT_ADDRESS)

/* Special instructions */
extern UINT32 ReturnTest(void);
extern void loadext0(void);
extern void unloadext0(void);
extern void enableext0(void);
extern void disableext0(void);
extern void trapext0(void);
extern void notrapext0(void);
extern void enableclkext0(void);
extern void disableclkext0(void);


void DumpUint32(char *What, UINT32 Value)
{
    Puts(What);
    PutWord(Value);
    PutChar('\n');
}

void DumpUint64(char *What, UINT32 Value1, UINT32 Value2)
{
    Puts(What);
    //if (Value1 > 0)
	//{
		PutWord(Value1);
		PutChar('.');
	//}
	PutWord(Value2);
    //PutChar('\n');
}

BOOL HadTrap = FALSE;

PCXTINFO TrapHandler(PCXTINFO Context)
{
    HadTrap = TRUE;
    DumpUint32("Caught trap at pc=", Context->pc);
    Context->pc += 4;
    return Context;
}

void main(char *StackPointer)
{
    char Step = 'a'-1;
	int i = 0;
    UINT32 x, psr;

	Step++;
	TheGPIO->OutDisable = 0xffffffff;
	TheGPIO->Enable = 0xffffffff;
	TheGPIO->ClearData = 0xffffffff;
	x = TheGPIO->PinStatus; /* verbose and whatnot */

    /* Wait for go
     */
    Step++;
    if (((x)&(0x4)) == 0) Delay(20 * 0x10000); // NB: about 1 sec

    /* Test utils */
    Step++;
    DumpUint32("HiMom! sp=", (UINT32)StackPointer);

	/* Enable traps to non-boot location
     */
    Step++;
    psr = GetPsr();
    psr &= ~0x00400000;
    SetPsr(psr);

    /* Install trap our handler
     */
    Step++;
    UserInterruptHandler = TrapHandler;

	Step++;
	DumpUint32("GPIO = ", x);
	PutChar('\n');
	PutChar('\n');

	disableclkext0();
	enableclkext0();
	loadext0();
	notrapext0();

	for (i=0;i<20;i++)
	{
		x = ReturnTest();
		Puts("foo returns ");
		PutWord(x);
		Puts(" ");
		PutWord(i);
		Puts("\n");
		if (x == 20)
		{
		}
		else
		{
			goto error;
		}
	}

	trapext0();
	enableext0();

	for (i=0;i<20;i++)
	{
		x = ReturnTest();
		Puts("foo returns ");
		PutWord(x);
		Puts(" ");
		PutWord(i);
		Puts("\n");
		if (x == 20)
		{
		}
		else
		{
			goto error;
		}
	}

	disableext0();
	notrapext0();
	unloadext0();
	disableclkext0();

	Puts("TEST PASSED SUCCESSFULLY\n");
    return;

 error:
    Puts("TEST FAILED at Step=");
    PutChar(Step);
    Puts("\n");
    return;
}
