#include <mips/mips_asm.h>
#define __ASSEMBLER__ 1
#include <mips/ml40x.h>

		_EXPORT(ReturnTest)
		_EXPORT(loadext0)
		_EXPORT(unloadext0)
		_EXPORT(enableext0)
		_EXPORT(disableext0)
		_EXPORT(trapext0)
		_EXPORT(notrapext0)
		_EXPORT(perext0)
		_EXPORT(notperext0)
		_EXPORT(privext0)
		_EXPORT(notprivext0)
		_EXPORT(enableclkext0)
		_EXPORT(disableclkext0)
		_EXPORT(maxpriorityext0)

#define _zero 0
#define _at 1
#define _v0 2
#define _v1 3
#define _a0 4
#define _a1 5
#define _a2 6
#define _a3 7
#define _t0 8
#define _t1 9
#define _t2 10
#define _t3 11
#define _t4 12
#define _t5 13
#define _t6 14
#define _t7 15
#define _s0 16
#define _s1 17
#define _s2 18
#define _s3 19
#define _s4 20
#define _s5 21
#define _s6 22
#define _s7 23
#define _t8 24
#define _t9 25
#define _k0 26
#define _k1 27
#define _gp 28
#define _sp 29
#define _s8 30
#define _ra 31

#define ExtInstruction(_op_,_reg1_,_reg2_,_imm_)	_DCD ((_op_<<26)|(_reg1_<<21)|(_reg2_<<16)|(_imm_))


		.set noreorder

ENTRY(ReturnTest)
	addiu	$sp,$sp,-24
	sw		$ra,16($sp)
	li		$v0,20
	ExtInstruction(31,_sp,_ra,24)
	lw		$ra,16($sp)
	jr		$ra
	addiu	$sp,$sp,24
END(ReturnTest)

/* void loadext0(void);
 * raises load bit of extension0
 */
 
ENTRY(loadext0)
	nop
	li		$t0,2
	mfc0	$t1,$s0
	or		$t0,$t0,$t1
	mtc0	$t0,$s0
	jr		$ra
	nop
END(loadext0)
 
/* void unloadext0(void);
 * lowers load bit of extension0
 */ 
 
ENTRY(unloadext0)
	nop
	li		$t2,1
	subu	$t2,$zero,$t2
	li		$t0,2
	xor		$t0,$t0,$t2
	mfc0	$t1,$s0
	and		$t0,$t0,$t1
	mtc0	$t0,$s0
	jr		$ra
	nop
END(unloadext0)
 
/* void enableext0(void);
 * raises enable bit of extension0
 */
 
ENTRY(enableext0)
	nop
	li		$t0,1
	mfc0	$t1,$s0
	or		$t0,$t0,$t1
	mtc0	$t0,$s0
	jr		$ra
	nop
END(enableext0)
 
/* void disableext0(void);
 * lowers enable bit of extension0
 */ 

ENTRY(disableext0)
	nop
	li		$t2,1
	subu	$t2,$zero,$t2
	li		$t0,1
	xor		$t0,$t0,$t2
	mfc0	$t1,$s0
	and		$t0,$t0,$t1
	mtc0	$t0,$s0
	jr		$ra
	nop
 END(disableext0)
 
/* void trapext0(void);
 * raises trap bit of extension0
 */
 
ENTRY(trapext0)
	nop
	li		$t0,4
	mfc0	$t1,$s0
	or		$t0,$t0,$t1
	mtc0	$t0,$s0
	jr		$ra
	nop
END(trapext0)
 
/* void notrapext0(void);
 * lowers trap bit of extension0
 */ 
 
ENTRY(notrapext0)
	nop
	li		$t2,1
	subu	$t2,$zero,$t2
	li		$t0,4
	xor		$t0,$t0,$t2
	mfc0	$t1,$s0
	and		$t0,$t0,$t1
	mtc0	$t0,$s0
	jr		$ra
	nop
END(notrapext0)

/* void perext0(void);
 * raises peripheral bit of extension0
 */
 
ENTRY(perext0)
	nop
	li		$t0,32
	mfc0	$t1,$s0
	or		$t0,$t0,$t1
	mtc0	$t0,$s0
	jr		$ra
	nop
END(perext0)

/* void notperext0(void);
 * lowers peripheral bit of extension0
 */
 
ENTRY(notperext0)
	nop
	li		$t2,1
	subu	$t2,$zero,$t2
	li		$t0,32
	xor		$t0,$t0,$t2
	mfc0	$t1,$s0
	and		$t0,$t0,$t1
	mtc0	$t0,$s0
	jr		$ra
	nop
END(notperext0) 

/* void privext0(void);
 * raises privilege bit of extension0
 */

ENTRY(privext0)
	nop
	li		$t0,64
	mfc0	$t1,$s0
	or		$t0,$t0,$t1
	mtc0	$t0,$s0
	jr		$ra
	nop
END(privext0)

/* void notprivext0(void);
 * lowers privilege bit of extension0
 */

ENTRY(notprivext0)
	nop
	li		$t2,1
	subu	$t2,$zero,$t2
	li		$t0,64
	xor		$t0,$t0,$t2
	mfc0	$t1,$s0
	and		$t0,$t0,$t1
	mtc0	$t0,$s0
	jr		$ra
	nop
END(notprivext0) 

/* void enableclkext0(void);
 * raises clock enable bit of extension0
 */

ENTRY(enableclkext0)
	nop
	li		$t0,128
	mfc0	$t1,$s0
	or		$t0,$t0,$t1
	mtc0	$t0,$s0
	jr		$ra
	nop
END(enableclkext0)

/* void disableclkext0(void);
 * lowers clock enable bit of extension0
 */

ENTRY(disableclkext0)
	nop
	li		$t2,1
	subu	$t2,$zero,$t2
	li		$t0,128
	xor		$t0,$t0,$t2
	mfc0	$t1,$s0
	and		$t0,$t0,$t1
	mtc0	$t0,$s0
	jr		$ra
	nop
END(disableclkext0) 

/* void maxpriorityext0(void);
 *
 */
 
ENTRY(maxpriorityext0)
	nop
	li		$t0,24
	mfc0	$t1,$s0
	or		$t0,$t0,$t1
	mtc0	$t0,$s0
	jr		$ra
	nop
END(maxpriorityext0)

	.set reorder
 