#include "print.h"
#include <mips\ml40x.h>

#define TheGPIO ((struct _Pio  *)GPIO_DEFAULT_ADDRESS)
#define TheTc  ((struct _Tc  *)TIMER_DEFAULT_ADDRESS)

#define epoch 1
#define dot 64
#define line 64*dot
#define dlbreak 64*line

#define NTESTS ((UINT)	(sizeof TSTVECTORS / (sizeof TSTVECTORS[0] * 3)))
#define TSTUINT64_UINT64(_low_,_high_)	(((UINT64)(_high_))<<32)|((UINT64)(_low_))

/* Special instructions */
extern UINT64 mmldiv64(UINT64 a0a1, UINT64 a2a3);
extern UINT64 mmldiv64_chk(UINT64 a0a1, UINT64 a2a3);
extern void loadext0(void);
extern void unloadext0(void);
extern void enableext0(void);
extern void disableext0(void);
extern void trapext0(void);
extern void notrapext0(void);

typedef struct
{
	UINT32 LowPart;
	UINT32 HighPart;
}   TSTUINT64;

TSTUINT64 TSTVECTORS[] = {
  { 0x80000000, 0xffffc88a }, { 0x649f0000, 0x0 }, { 0x8b5004b7, 0x2 },
  { 0x80000000, 0xffffe14d }, { 0x54000000, 0x10 }, { 0xfadae41, 0x0 },
  { 0x80000000, 0xffffc467 }, { 0x91800000, 0x0 }, { 0xc26aeab7, 0x1 },
#if defined(i386) || defined(mips)
  /* On the i386 the hardware division exists, and generates a trap
   * on zero-divide. Since we dont support any exception reporting/handling
   * mechanism there is no way to cope with this case in a sensible way.
   *
   * Division by zero is undefined so the test is meaningless on the Tigon.
   */
#else
  { 0x0, 0x0 }, { 0x0, 0x0 }, { 0x0, 0x0 },
#endif
    { 0x0, 0x0 }, { 0x1, 0x0 }, { 0x0, 0x0 },
    { 0x0, 0x0 }, { 0xffffffff, 0xffffffff }, { 0x0, 0x0 },
    { 0x0, 0x0 }, { 0x0, 0x80000000 }, { 0x0, 0x0 },
    { 0x0, 0x0 }, { 0xffffffff, 0x7fffffff }, { 0x0, 0x0 },
    { 0x0, 0x0 }, { 0x1, 0x80000000 }, { 0x0, 0x0 },
    { 0x1, 0x0 }, { 0x1, 0x0 }, { 0x1, 0x0 },
    { 0x1, 0x0 }, { 0xffffffff, 0xffffffff }, { 0x0, 0x0 },
    { 0xffffffff, 0xffffffff }, { 0x1, 0x0 }, { 0xffffffff, 0xffffffff },
    { 0xffffffff, 0xffffffff }, { 0xffffffff, 0xffffffff }, { 0x1, 0x0 },
    { 0x1, 0x0 }, { 0x2, 0x0 }, { 0x0, 0x0 },
    { 0x1, 0x0 }, { 0xfffffffe, 0xffffffff }, { 0x0, 0x0 },
    { 0xffffffff, 0xffffffff }, { 0x2, 0x0 }, { 0xffffffff, 0x7fffffff },
    { 0xffffffff, 0xffffffff }, { 0xfffffffe, 0xffffffff }, { 0x1, 0x0 },
    { 0x2, 0x0 }, { 0x1, 0x0 }, { 0x2, 0x0 },
    { 0x2, 0x0 }, { 0xffffffff, 0xffffffff }, {  0x0, 0x0 },
    { 0xfffffffe, 0xffffffff }, { 0x1, 0x0 }, { 0xfffffffe, 0xffffffff },
    { 0xfffffffe, 0xffffffff }, { 0xffffffff, 0xffffffff }, { 0x0, 0x0 },
    { 0x0, 0x80000000 }, { 0x1, 0x0 }, { 0x0, 0x80000000 },
    { 0x0, 0x80000000 }, { 0xffffffff, 0xffffffff }, { 0x0, 0x0},
    { 0x1, 0x80000000 }, { 0x1, 0x0 }, { 0x1, 0x80000000 },
    { 0x1, 0x80000000 }, { 0xffffffff, 0xffffffff }, {  0x0, 0x0 },
    { 0xffffffff, 0x7fffffff }, { 0x1, 0x0 }, { 0xffffffff, 0x7fffffff },
    { 0xffffffff, 0x7fffffff }, { 0xffffffff, 0xffffffff }, {  0x0, 0x0 },
    { 0x0, 0x80000000 }, { 0x0, 0x80000000 }, { 0x1, 0x0 },
    { 0xffffffff, 0x7fffffff }, { 0x0, 0x80000000 }, { 0x0, 0x0 },
    { 0x0, 0x80000000 }, { 0xffffffff, 0x7fffffff }, { 0x1, 0x0 },
    { 0xffffffff, 0x7fffffff }, { 0xffffffff, 0x7fffffff }, { 0x1, 0x0 },
    { 0x1, 0x80000000 }, { 0x0, 0x80000000 }, { 0x1, 0x0 },
    { 0x0, 0x80000000 }, { 0x1, 0x80000000 }, { 0x0, 0x0 },
    { 0x1, 0x80000000 }, { 0x1, 0x80000000 }, { 0x1, 0x0 },
    { 0xffffb51f, 0xffff987b }, { 0x4823, 0x29 }, { 0x63e6dd2, 0x0 },
    { 0x6df1, 0x0 }, { 0x6952, 0x0 }, { 0x1, 0x0 },
    { 0xffffed25, 0xffffd159 }, { 0x1eb, 0x26e9 }, { 0x69449, 0x0 },
    { 0x305e, 0x0 }, { 0xfffff0c2, 0xffffffff }, {  0x0, 0x0 },
    { 0x37, 0x0 }, { 0x33, 0x0 }, { 0x1, 0x0 },
    { 0x6443, 0x4dc8 }, { 0x26a6, 0x428b }, { 0x1, 0x0 },
    { 0x125, 0x0 }, { 0x7d, 0x0 }, { 0x2, 0x0 },
    { 0x7ff5, 0x7f96 }, { 0x63cb, 0x1ad4 }, { 0x4, 0x0 },
    { 0x1c, 0x0 }, { 0xd, 0x0 }, { 0x2, 0x0 },
    { 0xffffdd12, 0xffffffff }, { 0xfffffee0, 0xffffffff }, {  0x0, 0x0 },
    { 0x5f32, 0x0 }, { 0x5cfd, 0x0 }, { 0x1, 0x0 },
    { 0xffffa0b7, 0xffffffff }, { 0x314f, 0x0 }, { 0x548c957f, 0x53119 },
    { 0xffffc995, 0xffffffef }, { 0xffffd1c0, 0xfffffffb }, { 0x0, 0x0 },
    { 0x6032, 0x7eb7 }, { 0x5422, 0x15a1 }, { 0x5, 0x0 },
    { 0x409d, 0x1 }, { 0xffffede1, 0xfffffffe }, { 0x0, 0x0 },
    { 0x2, 0x0 }, { 0x1, 0x0 }, { 0x2, 0x0 },
    { 0x4a80, 0x692c }, { 0x6899, 0x16c5 }, { 0x4, 0x0 },
    { 0x48cc, 0x3c9 }, { 0x5db2, 0x80 }, { 0x7, 0x0 },
    { 0x3cd6, 0x5c67 }, { 0x6ad6, 0x2f14 }, { 0x1, 0x0 },
    { 0x368e, 0x1c }, { 0x75ef, 0x3 }, { 0x9, 0x0 },
    { 0x3a61, 0x8f }, { 0x2fff, 0x61 }, { 0x1, 0x0 },
    { 0x6172, 0x0 }, { 0x5e9d, 0x0 }, { 0x1, 0x0 },
    { 0xa, 0x0 }, { 0x1, 0x0 }, { 0xa, 0x0 },
    { 0x1953, 0x542c }, { 0x6be8, 0x18d7 }, { 0x3, 0x0 },
    { 0xffffdb62, 0xffff878b }, { 0xffffa0e2, 0xfffff1ed }, { 0x0, 0x0 },
    { 0x6ad4, 0x0 }, { 0x5fa4, 0x0 }, { 0x1, 0x0 },
    { 0xffffe50c, 0xffff92dd }, { 0x7cf, 0x35 }, { 0x4d4852e, 0x0 },
    { 0xe90, 0x1d3 }, { 0x57d3, 0x48 }, { 0x6, 0x0 },
    { 0xffffc81b, 0xffffffff }, { 0x19d9, 0x0 }, { 0xbef7101f, 0x9e778 },
    { 0x0, 0x0 }, { 0x1, 0x0 }, { 0x0, 0x0 },
    { 0x3a8d, 0x0 }, { 0x2b00, 0x0 }, { 0x1, 0x0 },
    { 0x33, 0x0 }, { 0x15, 0x0 }, { 0x2, 0x0 },
    { 0xffff9d90, 0xffffffff }, { 0x5064, 0x0 }, { 0x2cfaf97a, 0x32f38 },
    { 0xffff95eb, 0xffff9296 }, { 0x4c85, 0x3bb1 }, {  0x449e8, 0x0 },
    { 0x470e, 0x0 }, { 0x3004, 0x0 }, { 0x1, 0x0 },
    { 0x2cf7, 0xd4 }, { 0x4d67, 0x2f }, { 0x4, 0x0 },
    { 0x4e57, 0xd0 }, { 0x66fa, 0x76 }, { 0x1, 0x0 },
    { 0x74ad, 0x2f11 }, { 0x588, 0x1d24 }, { 0x1, 0x0 },
    { 0xffffb725, 0xffffffed }, { 0xfffff21b, 0xfffffffc }, { 0x0, 0x0 },
    { 0x13d3, 0x0 }, { 0x9ce, 0x0 }, { 0x2, 0x0 },
    { 0x3b97, 0x0 }, { 0x3960, 0x0 }, { 0x1, 0x0 },
    { 0x7ac2, 0x9d0 }, { 0x5e76, 0x959 }, { 0x1, 0x0 },
    { 0xd4, 0x0 }, { 0xffffff87, 0xffffffff }, { 0x0, 0x0 },
    { 0x293b, 0x0 }, { 0x940, 0x0 }, { 0x4, 0x0 },
    { 0x0, 0x0 }, { 0x1, 0x0 }, { 0x0, 0x0 },
    { 0xf97, 0x0 }, { 0xf1, 0x0 }, { 0x10, 0x0 },
    { 0xffffffff, 0xffffffff }, { 0x1, 0x0 }, { 0xffffffff, 0xffffffff },
    { 0x6486, 0x0 }, { 0x5fa8, 0x0 }, { 0x1, 0x0 },
    { 0x50bf, 0x0 }, { 0x10d9, 0x0 }, { 0x4, 0x0 },
    { 0x390, 0x4e55 }, { 0xffffae2f, 0xfffff8d7 }, {  0x0, 0x0 },
    { 0xffffb39a, 0xffffffff }, { 0xfffffe1f, 0xffffffff }, { 0x0, 0x0 },
    { 0x1bd9, 0x4efe }, { 0x4fe2, 0x159f }, { 0x3, 0x0 },
    { 0xffffbc9b, 0xffff98b8 }, { 0x549b, 0x2f0c }, { 0x570fc, 0x0 },
    { 0x2079, 0x182 }, { 0x1289, 0x146 }, { 0x1, 0x0 },
    { 0x4626, 0x1 }, { 0x36c2, 0x0 }, { 0x4acd6, 0x0 },
    { 0x64e0, 0x2462 }, { 0x676d, 0xe29 }, { 0x2, 0x0 },
    { 0x1d3f, 0x6da6 }, { 0x4ebf, 0x5f34 }, { 0x1, 0x0 },
    { 0xfffff594, 0xffffffff }, { 0x56d, 0x0 }, { 0x1531f25a, 0x2f2ea1 },
    { 0x2120, 0x0 }, { 0x12c2, 0x0 }, { 0x1, 0x0 },
    { 0x7, 0x0 }, { 0x4, 0x0 }, { 0x1, 0x0 },
    { 0x6b28, 0x1 }, { 0xffffa73b, 0xfffffffe }, { 0x0, 0x0 },
    { 0x1edc, 0x3308 }, { 0xffffbcba, 0xffffff71 }, { 0x0, 0x0 },
    { 0xeb, 0x71f2 }, { 0x78fe, 0x578d }, { 0x1, 0x0 },
    { 0xffffb630, 0xffff9b5f }, { 0x3106, 0x1c75 }, { 0x8fef7, 0x0 },
    { 0x5478, 0xa87 }, { 0x67d0, 0x84d }, { 0x1, 0x0 },
    { 0x3, 0x0 }, { 0xffffffff, 0xffffffff }, { 0x0, 0x0 },
    { 0xaf0, 0x5a70 }, { 0xffff90d0, 0xfffffc05 }, { 0x0, 0x0 },
    { 0xffffb0a5, 0xffffffff }, { 0x2332, 0x0 }, { 0xef1f6cb2, 0x74610},
    { 0x58e6, 0x2f0b }, { 0x1eca, 0x13f5 }, { 0x2, 0x0 },
    { 0x389, 0x0 }, { 0xffffffe5, 0xffffffff }, { 0x0, 0x0 },
    { 0xffff9098, 0xffff9cb0 }, { 0x7b, 0x3a72 }, { 0x46150, 0x0 },
    { 0x7d3, 0x0 }, { 0xffffffbc, 0xffffffff }, { 0x0, 0x0 },
    { 0x4f66, 0x0 }, { 0x190b, 0x0 }, { 0x3, 0x0 },
    { 0xfffffafd, 0xffffffff }, { 0x45e, 0x0 }, { 0x526ed392, 0x3a9e74 },
    { 0x3605, 0x48e6 }, { 0x4a0e, 0x4531 }, { 0x1, 0x0 },
    { 0x1927, 0x65ca }, { 0xffffd32b, 0xffffcd30 }, { 0x0, 0x0 },
    { 0x1279, 0x0 }, { 0x914, 0x0 }, { 0x2, 0x0 },
    { 0x6af8, 0x0 }, { 0xffffc784, 0xffffffff }, { 0x0, 0x0 },
    { 0x7020, 0x7 }, { 0x17b8, 0x4 }, { 0x1, 0x0 },
    { 0x504c, 0x3895 }, { 0x248d, 0x65a }, { 0x8, 0x0 },
    { 0x3260, 0x72b1 }, { 0x5ae7, 0x7299 }, { 0x1, 0x0 },
    { 0xe9, 0x0 }, { 0xad, 0x0 }, { 0x1, 0x0 },
    { 0x5718, 0x0 }, { 0x11d5, 0x0 }, { 0x4, 0x0 },
    { 0x424c, 0x3e }, { 0xe00, 0x2 }, { 0x1e, 0x0 },
    { 0xb93, 0x5804 }, { 0x38f, 0x9b3 }, { 0x9, 0x0 },
    { 0x27e, 0x0 }, { 0x243, 0x0 }, { 0x1, 0x0 },
    { 0x4ecf, 0x0 }, { 0xc95, 0x0 }, { 0x6, 0x0 },
    { 0x3b65, 0x3e }, { 0x43f6, 0x2a }, { 0x1, 0x0 },
    { 0x15b4, 0x6 }, { 0xffffce42, 0xfffffffe }, { 0x0, 0x0 },
    { 0x1b32, 0x6469 }, { 0x12c, 0x3e09 }, { 0x1, 0x0 },
    { 0x6bdb, 0x0 }, { 0xffff9ee9, 0xffffffff }, { 0x0, 0x0 },
    { 0xfffff928, 0xffffffff }, { 0x181, 0x0 }, { 0x35dc17eb, 0xaa392f },
    { 0xffffb198, 0xffffffff }, { 0xfffffc07, 0xffffffff }, {  0x0, 0x0 },
    { 0x6778, 0x0 }, { 0x3371, 0x0 }, { 0x2, 0x0 },
    { 0x1d, 0x0 }, { 0x19, 0x0 }, { 0x1, 0x0 },
    { 0xffffa9e4, 0xffff978b }, { 0x2237, 0x14f }, { 0xc3a0ed, 0x0 },
    { 0xffffa321, 0xffffffff }, { 0xffffd06b, 0xffffffff }, { 0x0, 0x0 },
    { 0x7b8b, 0x63d9 }, { 0x448d, 0x176d }, { 0x4, 0x0 },
    { 0x5079, 0x16 }, { 0x7a08, 0x11 }, { 0x1, 0x0 },
    { 0xffffea1f, 0xffff9b1f }, { 0x2015, 0x21eb }, { 0x78c2d, 0x0 },
    { 0x275b, 0xff4 }, { 0x673c, 0xa6e }, { 0x1, 0x0 },
    { 0x1f7, 0x5c }, { 0x188f, 0xa }, { 0x9, 0x0 },
    { 0xffff949f, 0xffffa964 }, { 0xfffff6c5, 0xffffe9b5 }, { 0x0, 0x0 },
    { 0x1dc3, 0x63c6 }, { 0xffffe5d0, 0xffffe258 }, { 0x0, 0x0 },
    { 0x12f, 0x603 }, { 0x6275, 0x2ee }, { 0x2, 0x0 },
    { 0x45c8, 0x0 }, { 0x3510, 0x0 }, { 0x1, 0x0 },
    { 0x2e9, 0x0 }, { 0x28, 0x0 }, { 0x12, 0x0 },
    { 0x81, 0x0 }, { 0xffffff94, 0xffffffff }, { 0x0, 0x0 },
    { 0x0, 0x0 }, { 0x1, 0x0 }, { 0x0, 0x0 },
    { 0x7, 0x0 }, { 0x2, 0x0 }, { 0x3, 0x0 },
    { 0x6959, 0x2d50 }, { 0x1c, 0x15bd }, { 0x2, 0x0 },
    { 0x675f, 0x0 }, { 0xb7f, 0x0 }, { 0x8, 0x0 },
    { 0x52e5, 0x0 }, { 0x2c4e, 0x0 }, { 0x1, 0x0 },
    { 0x3742, 0x5198 }, { 0xffffcdd5, 0xffffe0f2 }, { 0x0, 0x0 },
    { 0x4673, 0x512f }, { 0x69bb, 0x2ec }, { 0x1b, 0x0 },
    { 0x3d84, 0x0 }, { 0x267d, 0x0 }, { 0x1, 0x0 },
    { 0x60be, 0x0 }, { 0x5b16, 0x0 }, { 0x1, 0x0 },
    { 0xffffb07d, 0xffffffff }, { 0x2518, 0x0 }, { 0x426d20fd, 0x6e6c4 },
    { 0xfffff8f2, 0xffffffff }, { 0xfffffcd2, 0xffffffff }, { 0x0, 0x0 },
    { 0xffffe093, 0xffffffff }, { 0xfca, 0x0 }, { 0xaf4face5, 0x1036b8 },
    { 0xffffbf4b, 0xffff8a72 }, { 0xffff8b8c, 0xffffaf6d }, { 0x0, 0x0 },
    { 0xffff87a2, 0xfffffe2a }, { 0x19fc, 0x40 }, { 0x3fffff7, 0x0 },
    { 0x4736, 0x0 }, { 0x54b, 0x0 }, { 0xd, 0x0 },
    { 0x7f7d, 0x0 }, { 0x672, 0x0 }, { 0x13, 0x0 },
    { 0x2871, 0x8d }, { 0x36b8, 0x8c }, { 0x1, 0x0 },
    { 0xffffc850, 0xffff9940 }, { 0xffffc051, 0xffffeab1 }, { 0x0, 0x0 },
    { 0xffffef8b, 0xffffffe2 }, { 0x7210, 0x1c }, { 0x9249222, 0x0 },
    { 0x5df2, 0x0 }, { 0xffffc460, 0xffffffff }, { 0x0, 0x0 },
    { 0xffff96e3, 0xffff8c34 }, { 0x6f49, 0xde9 }, { 0x126758, 0x0 },
    { 0x77d2, 0x555 }, { 0x1b0b, 0x51a }, { 0x1, 0x0 },
    { 0x0, 0x0 }, { 0x1, 0x0 }, { 0x0, 0x0 },
    { 0x62e1, 0xad }, { 0x6788, 0x35 }, { 0x3, 0x0 },
    { 0x7ae5, 0x0 }, { 0xffffe8ce, 0xffffffff }, { 0x0, 0x0 },
    { 0x62b5, 0x0 }, { 0xf77, 0x0 }, { 0x6, 0x0 },
    { 0x3b0d, 0x0 }, { 0x396c, 0x0 }, { 0x1, 0x0 },
    { 0x7268, 0x0 }, { 0x479a, 0x0 }, { 0x1, 0x0 },
    { 0x20bc, 0x6 }, { 0x50e6, 0x5 }, { 0x1, 0x0 },
    { 0x652a, 0x0 }, { 0xffffb93d, 0xffffffff }, { 0x0, 0x0 },
    { 0xfffffffc, 0xffffffff }, { 0x1, 0x0 }, { 0xfffffffc, 0xffffffff },
    { 0x6bb, 0x3dae }, { 0xffff9da0, 0xffffffe3 }, { 0x0, 0x0 },
    { 0x2c45, 0x0 }, { 0x75d, 0x0 }, { 0x6, 0x0 },
    { 0x7da8, 0x0 }, { 0x3d0d, 0x0 }, { 0x2, 0x0 },
    { 0x2784, 0x0 }, { 0x1255, 0x0 }, { 0x2, 0x0 },
    { 0x20d5, 0x72ed }, { 0xffff97c9, 0xfffffa07 }, { 0x0, 0x0 },
    { 0xffff93df, 0xffff8e60 }, { 0xffff93b2, 0xffffe2a3 }, { 0x0, 0x0 },
    { 0x17b0, 0x0 }, { 0x1785, 0x0 }, { 0x1, 0x0 },
    { 0x74b1, 0xe }, { 0x7fe9, 0x5 }, { 0x2, 0x0 },
    { 0x12c6, 0xb8b }, { 0x15e2, 0x466 }, { 0x2, 0x0 },
    { 0x5e32, 0x0 }, { 0xfffffc0c, 0xffffffff }, { 0x0, 0x0 },
    { 0x3002, 0x1c04 }, { 0x71e0, 0x152c }, { 0x1, 0x0 },
    { 0x3, 0x0 }, { 0x1, 0x0 }, { 0x3, 0x0 },
    { 0x92, 0x0 }, { 0x1c, 0x0 }, { 0x5, 0x0 },
    { 0x2737, 0x0 }, { 0x4fb, 0x0 }, { 0x7, 0x0 },
    { 0x126, 0x0 }, { 0xffffff0a, 0xffffffff }, { 0x0, 0x0 },
    { 0x19ca, 0x0 }, { 0xf55, 0x0 }, { 0x1, 0x0 },
    { 0xffffff94, 0xffffffff }, { 0xffffffc1, 0xffffffff }, { 0x0, 0x0 },
    { 0x223a, 0x0 }, { 0xfffffde4, 0xffffffff }, { 0x0, 0x0 },
    { 0xffffc9e5, 0xffff9b1b }, { 0x7aba, 0x47dd }, { 0x38ff2, 0x0 },
    { 0xffffa038, 0xffffffff }, { 0xffffbde3, 0xffffffff }, { 0x0, 0x0 },
    { 0x318, 0x50c3 }, { 0x624a, 0x3b2b }, { 0x1, 0x0 },
    { 0x2c4, 0x0 }, { 0x26a, 0x0 }, { 0x1, 0x0 },
    { 0x3, 0x0 }, { 0xfffffffd, 0xffffffff }, { 0x0, 0x0 },
    { 0x11a, 0x0 }, { 0x65, 0x0 }, { 0x2, 0x0 },
    { 0x3105, 0x773c }, { 0x7cb3, 0x14a }, { 0x5c, 0x0 },
    { 0x47a1, 0x0 }, { 0x2a9e, 0x0 }, { 0x1, 0x0 },
    { 0xd, 0x0 }, { 0xa, 0x0 }, { 0x1, 0x0 },
    { 0x6ff8, 0x0 }, { 0xffffd8ec, 0xffffffff }, { 0x0, 0x0 },
    { 0xffffb4af, 0xffffe897 }, { 0x47c5, 0x3c0 }, { 0x44443e, 0x0 },
    { 0xffffe797, 0xfffff26b }, { 0x5d12, 0x694 }, { 0x26eab5, 0x0 },
    { 0x4f41, 0x5 }, { 0x3af, 0x3 }, { 0x1, 0x0 },
    { 0x1da1, 0x0 }, { 0xfffff9b1, 0xffffffff }, { 0x0, 0x0 },
    { 0x25c, 0x0 }, { 0x1fd, 0x0 }, { 0x1, 0x0 },
    { 0xe, 0x0 }, { 0xfffffff7, 0xffffffff }, { 0x0, 0x0 },
    { 0x224b, 0x7836 }, { 0xffff90a2, 0xffffb41d }, { 0x0, 0x0 },
    { 0xffffff96, 0xffffffff }, { 0x2f, 0x0 }, { 0xe4c415c7, 0x572620a },
    { 0x68c5, 0x0 }, { 0x116c, 0x0 }, { 0x6, 0x0 },
    { 0x1d, 0x0 }, { 0xa, 0x0 }, { 0x2, 0x0 },
    { 0xffffa471, 0xffffd267 }, { 0xfffff64f, 0xfffffd0d }, { 0x0, 0x0 },
    { 0x174f, 0x0 }, { 0x774, 0x0 }, { 0x3, 0x0 },
    { 0x1454, 0x2742 }, { 0x3be, 0x10df }, { 0x2, 0x0 },
    { 0xffffb6f4, 0xffffff99 }, { 0xffffaae5, 0xffffffe3 }, { 0x0, 0x0 },
    { 0x666e, 0x0 }, { 0xfffff289, 0xffffffff }, { 0x0, 0x0 },
    { 0xffff96bc, 0xffff9058 }, { 0xffffa9fe, 0xffffb9c1 }, { 0x0, 0x0 },
    { 0xffff824a, 0xffff8678 }, { 0x22dd, 0x4c22 }, { 0x35cce, 0x0 },
    { 0xffffc19f, 0xffffb322 }, { 0xffffc2c3, 0xffffe291 }, { 0x0, 0x0 },
    { 0x7dc4, 0x67 }, { 0x1e2f, 0x3c }, { 0x1, 0x0 },
    { 0x44cc, 0x0 }, { 0xffffd370, 0xffffffff }, { 0x0, 0x0 },
    { 0x761e, 0x1c11 }, { 0x5341, 0x74b }, { 0x3, 0x0 },
    { 0x2bb8, 0x1 }, { 0x83f, 0x0 }, { 0x1f0b8a, 0x0 },
    { 0x4d51, 0x531 }, { 0xffff94b7, 0xfffffd56 }, { 0x0, 0x0 },
    { 0x19, 0x0 }, { 0xe, 0x0 }, { 0x1, 0x0 },
    { 0x381c, 0x1e }, { 0x2277, 0xe }, { 0x2, 0x0 },
    { 0x10a, 0x0 }, { 0xd3, 0x0 }, { 0x1, 0x0 },
    { 0x7f10, 0x0 }, { 0x1ef6, 0x0 }, { 0x4, 0x0 },
    { 0xab6, 0x5326 }, { 0xffffd97c, 0xffffe3d2 }, { 0x0, 0x0 },
    { 0x4802, 0x0 }, { 0xdaf, 0x0 }, { 0x5, 0x0 },
    { 0x6fc6, 0xde }, { 0x759, 0xba }, { 0x1, 0x0 },
    { 0x4f36, 0x5147 }, { 0x65cf, 0xa65 }, { 0x7, 0x0 },
    { 0xffffe167, 0xfffffffd }, { 0x7d4b, 0x1 }, { 0xffff82b3, 0x0 },
    { 0x22e0, 0x65c0 }, { 0x5d20, 0x3091 }, { 0x2, 0x0 },
    { 0xffff8312, 0xffffaa7b }, { 0xffffd2b1, 0xffffb29d }, { 0x0, 0x0 },
    { 0x7a0c, 0x1 }, { 0xffffdbdc, 0xffffffff }, { 0x0, 0x0 },
    { 0x0, 0x0 }, { 0x1, 0x0 }, { 0x0, 0x0 },
    { 0xbd, 0x9 }, { 0x77b8, 0x4 }, { 0x2, 0x0 },
    { 0x6, 0x0 }, { 0x1, 0x0 }, { 0x6, 0x0 },
    { 0xffff80e0, 0xffffcd7c }, { 0x4574, 0x1337 }, { 0xd52af, 0x0 },
    { 0x57fd, 0x3 }, { 0xffffe2bc, 0xfffffffd }, { 0x0, 0x0 },
    { 0x7b09, 0x0 }, { 0x618, 0x0 }, { 0x14, 0x0 },
    { 0x4975, 0x7b34 }, { 0x339a, 0x3450 }, { 0x2, 0x0 },
    { 0xffff8705, 0xffff969c }, { 0x4ee1, 0x49 }, { 0x381bf6b, 0x0 },
    { 0x3a2c, 0x0 }, { 0x350a, 0x0 }, { 0x1, 0x0 },
    { 0xffffff61, 0xffff9886 }, { 0xffffdc90, 0xffffcd83 }, { 0x0, 0x0 },
    { 0x1c0a, 0x0 }, { 0xfffff820, 0xffffffff }, { 0x0, 0x0 },
    { 0xfffffffe, 0xffffffff }, { 0x1, 0x0 }, { 0xfffffffe, 0xffffffff },
    { 0x636c, 0x0 }, { 0x412b, 0x0 }, { 0x1, 0x0 },
    { 0xffffaf79, 0xffffffff }, { 0xb2e, 0x0 }, { 0x62925633, 0x16e60f },
    { 0xffffc7cd, 0xffffd667 }, { 0xffffedb8, 0xfffff157 }, { 0x0, 0x0 },
    { 0x49c2, 0x0 }, { 0x426e, 0x0 }, { 0x1, 0x0 },
    { 0xffffd0b7, 0xffff83f1 }, { 0x1c80, 0x42c7 }, { 0x3d567, 0x0 },
    { 0x350b, 0x2 }, { 0x31ce, 0x1 }, { 0x1, 0x0 },
    { 0x6c69, 0x6064 }, { 0xfffff44d, 0xffffa1ee }, { 0x0, 0x0 },
    { 0xc15, 0xcd }, { 0x2beb, 0x1c }, { 0x7, 0x0 },
    { 0xffffec41, 0xffffd847 }, { 0x22da, 0x1755 }, { 0xaf8d5, 0x0 },
    { 0x6795, 0x7b59 }, { 0xfffff7a0, 0xffffd515 }, { 0x0, 0x0 },
    { 0x1fd2, 0x1980 }, { 0x3daf, 0x16f2 }, { 0x1, 0x0 },
    { 0xffff9a3c, 0xffffff5f }, { 0x6945, 0x57 }, { 0x2f1498a, 0x0 },
    { 0x3, 0x0 }, { 0xfffffffe, 0xffffffff }, { 0x0, 0x0 },
    { 0xbf9, 0x3ee1 }, { 0x242d, 0x9d1 }, { 0x6, 0x0 },
    { 0x5, 0x0 }, { 0x4, 0x0 }, { 0x1, 0x0 },
    { 0xe, 0x0 }, { 0x9, 0x0 }, { 0x1, 0x0 },
    { 0x0, 0x0 }, { 0x1, 0x0 }, { 0x0, 0x0 },
    { 0x43f, 0x0 }, { 0x14f, 0x0 }, { 0x3, 0x0 },
    { 0x5704, 0x0 }, { 0x4bf7, 0x0 }, { 0x1, 0x0 },
    { 0x7ec, 0x3f }, { 0xffff93ee, 0xffffffe9 }, { 0x0, 0x0 },
    { 0x2e01, 0x7245 }, { 0x2a6d, 0x30d7 }, { 0x2, 0x0 },
    { 0xffffc233, 0xffffffff }, { 0x3775, 0x0 }, { 0x66503e06, 0x49dbe },
    { 0x78e, 0x0 }, { 0xfffff879, 0xffffffff }, { 0x0, 0x0 },
    { 0x74a3, 0x2e }, { 0x2425, 0x2a }, { 0x1, 0x0 },
    { 0xffff8f28, 0xffffffff }, { 0x128b, 0x0 }, { 0x1401f0fb, 0xdce47 },
    { 0x3777, 0x0 }, { 0x1932, 0x0 }, { 0x2, 0x0 },
    { 0x14d, 0x0 }, { 0x149, 0x0 }, { 0x1, 0x0 },
    { 0x49d, 0x5f21 }, { 0x46be, 0xa8b }, { 0x9, 0x0 },
    { 0x9e1, 0x1c04 }, { 0x34a4, 0x840 }, { 0x3, 0x0 },
    { 0x7550, 0x14 }, { 0xffffbee1, 0xfffffff5 }, { 0x0, 0x0 },
    { 0x3c47, 0x5a7d }, { 0xffffbcca, 0xffffd3e2 }, { 0x0, 0x0 },
    { 0xffffbec7, 0xfffff2bb }, { 0x6a23, 0x89e }, { 0x1db542, 0x0 },
    { 0x39c4, 0x0 }, { 0x2ec1, 0x0 }, { 0x1, 0x0 },
    { 0xffffbf0e, 0xfffffff0 }, { 0x45f2, 0x0 }, { 0xe7d2efab, 0x3a8f5 },
    { 0x5f46, 0x0 }, { 0xffffc76a, 0xffffffff }, { 0x0, 0x0 },
    { 0x1f, 0x0 }, { 0xfffffffb, 0xffffffff }, { 0x0, 0x0 },
    { 0x3, 0x0 }, { 0xfffffffe, 0xffffffff }, { 0x0, 0x0 },
    { 0xffff9256, 0xffffba5c }, { 0x763f, 0x1bf0 }, { 0x929cc, 0x0 },
    { 0x3185, 0x0 }, { 0xfffffeaf, 0xffffffff }, { 0x0, 0x0 },
    { 0xd5, 0x0 }, { 0xffffff7f, 0xffffffff }, { 0x0, 0x0 },
    { 0xffffcc17, 0xffffffff }, { 0x3325, 0x0 }, { 0x62905606, 0x50163 },
    { 0x500d, 0x0 }, { 0x444a, 0x0 }, { 0x1, 0x0 },
    { 0x34d5, 0xa97 }, { 0xffffa9a8, 0xfffff5fe }, { 0x0, 0x0 },
    { 0xd0f, 0x248 }, { 0xffffecf8, 0xfffffeea }, { 0x0, 0x0 },
    { 0x51e8, 0x1 }, { 0xffffc5ec, 0xffffffff }, { 0x0, 0x0 },
    { 0x7060, 0x0 }, { 0x3285, 0x0 }, { 0x2, 0x0 },
    { 0x681d, 0x0 }, { 0xffffa0d3, 0xffffffff }, { 0x0, 0x0 },
    { 0x6450, 0x0 }, { 0xffffe9a3, 0xffffffff }, { 0x0, 0x0 },
    { 0xffffdc3c, 0xfffffffc }, { 0x1ee1, 0x0 }, { 0xdee72938, 0x84a5a },
    { 0x32c, 0x0 }, { 0x165, 0x0 }, { 0x2, 0x0 },
    { 0x2760, 0x0 }, { 0xffffdc9e, 0xffffffff }, { 0x0, 0x0 },
    { 0x1a, 0x0 }, { 0xfffffff0, 0xffffffff }, { 0x0, 0x0 },
    { 0xfffffd3d, 0xfffffc97 }, { 0x102d, 0xba }, { 0x1605811, 0x0 },
    { 0xfffffff5, 0xffffffff }, { 0xffffffff, 0xffffffff }, { 0x0, 0x0 },
    { 0x494a, 0x0 }, { 0xffffffeb, 0xffffffff }, { 0x0, 0x0 },
    { 0x25f2, 0xa5 }, { 0x65a2, 0x20 }, { 0x5, 0x0 },
    { 0xffffce29, 0xfffffffe }, { 0x14b7, 0x1 }, { 0xffffeb48, 0x0 },
    { 0xffff8e4f, 0xffffffff }, { 0x21e9, 0x0 }, { 0xe6ab1960, 0x78ca2 },
    { 0x7d1d, 0x5de1 }, { 0xffff9973, 0xffffe47d }, { 0x0, 0x0 },
    { 0xffff8032, 0xffffffff }, { 0xffffe3c3, 0xffffffff }, { 0x0, 0x0 },
    { 0x7706, 0x0 }, { 0x63a, 0x0 }, { 0x13, 0x0 },
    { 0xfffff24a, 0xffffffff }, { 0x34b, 0x0 }, { 0x5ff64842, 0x4dbdcc },
    { 0x4619, 0x17 }, { 0x4ed7, 0x16 }, { 0x1, 0x0 },
    { 0x20cb, 0x0 }, { 0xfffff159, 0xffffffff }, { 0x0, 0x0 },
    { 0x79, 0x0 }, { 0x28, 0x0 }, { 0x3, 0x0 },
    { 0x5ff7, 0x1 }, { 0x2af9, 0x1 }, { 0x1, 0x0 },
    { 0x31, 0x0 }, { 0x1d, 0x0 }, { 0x1, 0x0 },
    { 0x7250, 0x5224 }, { 0x1ccc, 0x39fc }, { 0x1, 0x0 },
    { 0xffffd443, 0xffffa15c }, { 0x1db4, 0x34b2 }, { 0x4dbab, 0x0 },
    { 0x7275, 0x0 }, { 0xded, 0x0 }, { 0x8, 0x0 },
    { 0x1ef, 0x12 }, { 0x7c44, 0xe }, { 0x1, 0x0 },
    { 0xffffb256, 0xfffffffc }, { 0xd41, 0x3 }, { 0x555553db, 0x0 },
    { 0x7fc3, 0xeee }, { 0x90, 0x53a }, { 0x2, 0x0 },
    { 0xffff9fe4, 0xffffffff }, { 0x4e6e, 0x0 }, { 0x198d324e, 0x3439a },
    { 0x71ca, 0x5072 }, { 0x7425, 0x91a }, { 0x8, 0x0 },
    { 0x5009, 0x76 }, { 0x4975, 0x5 }, { 0x17, 0x0 },
    { 0xffffa548, 0xffffffff }, { 0x3969, 0x0 }, { 0x491f79a9, 0x4758a },
    { 0x7cb0, 0xf9a }, { 0xf0f, 0x835 }, { 0x1, 0x0 },
    { 0x6bd6, 0x7950 }, { 0x6ede, 0x1ba3 }, { 0x4, 0x0 },
    { 0x476b, 0x7f7 }, { 0xffff9f94, 0xfffff91f }, { 0x0, 0x0 },
    { 0x1, 0x0 }, { 0x1, 0x0 }, { 0x1, 0x0 },
    { 0x58d, 0x0 }, { 0xffffffb4, 0xffffffff }, { 0x0, 0x0 },
    { 0x52c0, 0x0 }, { 0x11e4, 0x0 }, { 0x4, 0x0 },
    { 0x4ffc, 0x0 }, { 0x2089, 0x0 }, { 0x2, 0x0 },
    { 0x7b02, 0x0 }, { 0xe07, 0x0 }, { 0x8, 0x0 },
    { 0xffff9683, 0xffff9ad0 }, { 0x42a7, 0xbed }, { 0x157749, 0x0 },
    { 0x525b, 0x0 }, { 0x17fb, 0x0 }, { 0x3, 0x0 },
    { 0xffff8ad7, 0xffffffff }, { 0x5d1e, 0x0 }, { 0x23acebff, 0x2bfcd },
    { 0x2312, 0x5f4f }, { 0x693f, 0x3ff }, { 0x17, 0x0 },
    { 0x6, 0x0 }, { 0x5, 0x0 }, { 0x1, 0x0 },
    { 0x603d, 0x1e13 }, { 0x5920, 0xc88 }, { 0x2, 0x0 },
    { 0xffff8e3a, 0xffffffff }, { 0x2c76, 0x0 }, { 0x5429eca5, 0x5c203 },
    { 0x7dc3, 0x72 }, { 0xffffc9ce, 0xffffffae }, { 0x0, 0x0 },
    { 0x4, 0x0 }, { 0x3, 0x0 }, { 0x1, 0x0 },
    { 0x2e, 0x0 }, { 0x26, 0x0 }, { 0x1, 0x0 },
    { 0x434a, 0x7 }, { 0xffffadc5, 0xffffffff }, { 0x0, 0x0 },
    { 0x6f, 0x0 }, { 0xb, 0x0 }, { 0xa, 0x0 },
    { 0x293c, 0x727 }, { 0x1f6c, 0x307 }, { 0x2, 0x0 },
    { 0x49e3, 0x0 }, { 0x1880, 0x0 }, { 0x3, 0x0 },
    { 0x3, 0x0 }, { 0x1, 0x0 }, { 0x3, 0x0 },
    { 0x8d1, 0xe01 }, { 0x28fa, 0x37d }, { 0x4, 0x0 },
    { 0x4a2e, 0x0 }, { 0x29e2, 0x0 }, { 0x1, 0x0 },
    { 0x4a67, 0x5ada }, { 0x1df, 0x25ba }, { 0x2, 0x0 },
    { 0x41ff, 0x0 }, { 0xffffd8ee, 0xffffffff }, { 0x0, 0x0 },
    { 0x5a94, 0x5c93 }, { 0x4166, 0x3049 }, { 0x1, 0x0 },
    { 0xffffa27b, 0xffff8582 }, { 0x3fd9, 0x1d2d }, { 0x8c63a, 0x0 },
    { 0xffff9b92, 0xffffffff }, { 0x4e69, 0x0 }, { 0x6243ecc3, 0x343cf },
    { 0xffff923a, 0xffff8040 }, { 0xdc9, 0x1422 }, { 0xcb728, 0x0 },
    { 0x9, 0x0 }, { 0x2, 0x0 }, { 0x4, 0x0 },
    { 0x4c60, 0x1b }, { 0x7423, 0x6 }, { 0x4, 0x0 },
    { 0x2, 0x0 }, { 0x1, 0x0 }, { 0x2, 0x0 },
    { 0x38ba, 0x32f3 }, { 0x64ea, 0x61b }, { 0x8, 0x0 },
    { 0x6fa4, 0x0 }, { 0xffffaa69, 0xffffffff }, { 0x0, 0x0 },
    { 0x574c, 0x7 }, { 0x4aea, 0x4 }, { 0x1, 0x0 },
    { 0x6, 0x0 }, { 0xffffffff, 0xffffffff }, { 0x0, 0x0 },
    { 0xffffce72, 0xffff9b0e }, { 0x4a4e, 0x4d3a }, { 0x3509d, 0x0 },
    { 0x1, 0x0 }, { 0x1, 0x0 }, { 0x1, 0x0 },
    { 0xffff8e36, 0xffffffff }, { 0x6413, 0x0 }, { 0xbbe3fb14, 0x28edf },
    { 0x30, 0x0 }, { 0x18, 0x0 }, { 0x2, 0x0 },
    { 0x6641, 0x67f2 }, { 0xffff8c0f, 0xffff9cab }, { 0x0, 0x0 },
    { 0xa3, 0x0 }, { 0x9d, 0x0 }, { 0x1, 0x0 },
    { 0x4435, 0x3dcb }, { 0x32c1, 0xf32 }, { 0x4, 0x0 },
    { 0x5205, 0x5723 }, { 0xffffdd46, 0xffffb808 }, { 0x0, 0x0 },
    { 0x5883, 0x0 }, { 0x15be, 0x0 }, { 0x4, 0x0 },
    { 0x7ffd, 0x0 }, { 0x4339, 0x0 }, { 0x1, 0x0 },
    { 0x7775, 0xf }, { 0x468a, 0x2 }, { 0x7, 0x0 },
    { 0xffff92a1, 0xffffffff }, { 0x85a, 0x0 }, { 0x8378ef6c, 0x1ea727 },
    { 0xf56, 0x0 }, { 0x98c, 0x0 }, { 0x1, 0x0 },
    { 0x28f1, 0x0 }, { 0xeb0, 0x0 }, { 0x2, 0x0 },
    { 0x6fb4, 0x0 }, { 0x292a, 0x0 }, { 0x2, 0x0 },
    { 0xffffabcd, 0xffffffff }, { 0x4178, 0x0 }, { 0xf714681b, 0x3e906 },
    { 0x1ff, 0x0 }, { 0x161, 0x0 }, { 0x1, 0x0 },
    { 0x154, 0x0 }, { 0x141, 0x0 }, { 0x1, 0x0 },
    { 0xe6a, 0x42cf }, { 0x605c, 0x357e }, { 0x1, 0x0 },
    { 0x2b8d, 0x7f }, { 0x3b90, 0x5d }, { 0x1, 0x0 },
    { 0x6017, 0x15c }, { 0x63fe, 0x9b }, { 0x2, 0x0 },
    { 0x6ea, 0x0 }, { 0xfffffb57, 0xffffffff }, { 0x0, 0x0 },
    { 0x7664, 0xe9 }, { 0xffffbec0, 0xffffff7e }, { 0x0, 0x0 },
    { 0x0, 0x0 }, { 0x1, 0x0 }, { 0x0, 0x0 },
    { 0x1533, 0x3eda }, { 0x2967, 0x644 }, { 0xa, 0x0 },
    { 0x6ca1, 0x2682 }, { 0x1426, 0x1fa }, { 0x13, 0x0 },
    { 0xeea, 0x0 }, { 0x1a, 0x0 }, { 0x92, 0x0 },
    { 0x672c, 0x7572 }, { 0x3954, 0x311a }, { 0x2, 0x0 },
    { 0x44f3, 0x7522 }, { 0x4e73, 0x1ffb }, { 0x3, 0x0 },
    { 0x6de0, 0x0 }, { 0x48fe, 0x0 }, { 0x1, 0x0 },
    { 0x6738, 0x188e }, { 0xfffffcc0, 0xfffff0df }, { 0x0, 0x0 },
    { 0x215d, 0x0 }, { 0xffffee67, 0xffffffff }, { 0x0, 0x0 },
    { 0x9d8, 0x361f }, { 0x512a, 0x13b5 }, { 0x2, 0x0 },
    { 0x6a73, 0x0 }, { 0x3fce, 0x0 }, { 0x1, 0x0 },
    { 0xffffe8aa, 0xffffffe1 }, { 0x42f, 0x4 }, { 0x3fffffb5, 0x0 },
    { 0xffffbc7e, 0xfffffffe }, { 0x3505, 0x0 }, { 0xa27316f2, 0x4d412 },
    { 0x26b1, 0x1386 }, { 0x21f4, 0x6b5 }, { 0x2, 0x0 },
    { 0x4a9f, 0x0 }, { 0x347, 0x0 }, { 0x16, 0x0 },
    { 0x37c0, 0x4cbd }, { 0xd42, 0xa55 }, { 0x7, 0x0 },
    { 0x35cd, 0x7d48 }, { 0xffff96ef, 0xffffd419 }, { 0x0, 0x0 },
    { 0x579, 0xea6 }, { 0x5aed, 0xb03 }, { 0x1, 0x0 },
    { 0x5292, 0x0 }, { 0x5100, 0x0 }, { 0x1, 0x0 },
    { 0xffffff83, 0xffffffff }, { 0xd, 0x0 }, { 0xb13b13a7, 0x13b13b13 },
    { 0xffffc17e, 0xffffffff }, { 0x2ac, 0x0 }, { 0xf405fcea, 0x5fd017 },
    { 0x36a9, 0x3 }, { 0x7633, 0x0 }, { 0x67f5c, 0x0 },
    { 0x4504, 0x6043 }, { 0x74a1, 0x77 }, { 0xcf, 0x0 },
    { 0x7, 0x0 }, { 0x1, 0x0 }, { 0x7, 0x0 },
    { 0xfffffd44, 0xfffff390 }, { 0x30f8, 0x4cf }, { 0x353cec, 0x0 },
    { 0xffffd1cb, 0xffffffff }, { 0xffffd1ea, 0xffffffff }, { 0x0, 0x0 },
    { 0x2f8a, 0x1e }, { 0x46d5, 0x12 }, { 0x1, 0x0 },
    { 0xffff9633, 0xffffffff }, { 0xffffd17b, 0xffffffff }, { 0x0, 0x0 },
    { 0x7, 0x0 }, { 0x1, 0x0 }, { 0x7, 0x0 },
    { 0xb, 0x0 }, { 0x1, 0x0 }, { 0xb, 0x0 },
    { 0x6266, 0x6c56 }, { 0x5646, 0x464e }, { 0x1, 0x0 },
    { 0x0, 0x0 }, { 0x1, 0x0 }, { 0x0, 0x0 },
    { 0xffff9a2c, 0xffffffff }, { 0x986, 0x0 }, { 0x7ed84eeb, 0x1ae18c },
    { 0xffffff04, 0xffffffff }, { 0xffffff0e, 0xffffffff }, { 0x0, 0x0 },
    { 0xffff9256, 0xffffffff }, { 0x68be, 0x0 }, { 0x4caefb64, 0x271b0 },
    { 0x354a, 0x0 }, { 0x7c4, 0x0 }, { 0x6, 0x0 },
    { 0xffff8b77, 0xffffffff }, { 0x367a, 0x0 }, { 0x44784599, 0x4b303 },
    { 0x50ce, 0x0 }, { 0xffffd862, 0xffffffff }, { 0x0, 0x0 },
    { 0x7b84, 0x5691 }, { 0x4a3, 0x256a }, { 0x2, 0x0 },
    { 0xffffe8d2, 0xffffee10 }, { 0x7441, 0x290 }, { 0x63e6ff, 0x0 },
    { 0x660c, 0x343a }, { 0x3f7b, 0x2eb7 }, { 0x1, 0x0 },
    { 0x2ac7, 0x44b0 }, { 0x617e, 0x3899 }, { 0x1, 0x0 },
    { 0xffffffb4, 0xffffffff }, { 0x35, 0x0 }, { 0xcade304b, 0x4d4873e },
    { 0x14e7, 0x0 }, { 0xfffff3fd, 0xffffffff }, { 0x0, 0x0 },
    { 0x7fd9, 0x0 }, { 0xffffd5f7, 0xffffffff }, { 0x0, 0x0 },
    { 0xffffb9df, 0xffffff6c }, { 0x34cf, 0x2a }, { 0x618617a, 0x0 },
    { 0x37b6, 0x0 }, { 0x2521, 0x0 }, { 0x1, 0x0 },
    { 0x50ae, 0x0 }, { 0x1108, 0x0 }, { 0x4, 0x0 },
    { 0xffffad13, 0xffffff44 }, { 0xffffba21, 0xffffff91 }, { 0x0, 0x0 },
    { 0xffffe38d, 0xffffdeb5 }, { 0x648b, 0x1d2e }, { 0x8c5f1, 0x0 },
    { 0x7bc7, 0x32a }, { 0x69d3, 0x81 }, { 0x6, 0x0 },
    { 0xd, 0x0 }, { 0xc, 0x0 }, { 0x1, 0x0 },
    { 0x6c70, 0x39 }, { 0xffffe5ae, 0xffffffe0 }, { 0x0, 0x0 },
    { 0x0, 0x0 }, { 0x1, 0x0 }, { 0x0, 0x0 },
    { 0x6694, 0x0 }, { 0x4d82, 0x0 }, { 0x1, 0x0 },
    { 0x5, 0x0 }, { 0x2, 0x0 }, { 0x2, 0x0 },
    { 0x508c, 0x0 }, { 0x2304, 0x0 }, { 0x2, 0x0 },
    { 0xffff8838, 0xffffffff }, { 0x2fb4, 0x0 }, { 0x908f8df3, 0x55dd4 },
    { 0x18eb, 0x6384 }, { 0xecd, 0x45d5 }, { 0x1, 0x0 },
    { 0xffff9c25, 0xffffff86 }, { 0x2caa, 0x50 }, { 0x333332f, 0x0 },
    { 0xffffb0ac, 0xffffa2af }, { 0x1403, 0x596 }, { 0x2dd440, 0x0 },
    { 0xffff980d, 0xffff9d19 }, { 0x360d, 0x10fa }, { 0xf145b, 0x0 },
    { 0x7ae5, 0x425f }, { 0x69f3, 0xef8 }, { 0x4, 0x0 },
    { 0x5e35, 0x0 }, { 0x438b, 0x0 }, { 0x1, 0x0 },
    { 0x1b74, 0x556b }, { 0x5a1, 0x63b }, { 0xd, 0x0 },
    { 0x1aa0, 0x67c9 }, { 0x463d, 0x3695 }, { 0x1, 0x0 },
    { 0x6ef2, 0x1509 }, { 0x7009, 0x305 }, { 0x6, 0x0 },
    { 0xffff85f3, 0xfffff26a }, { 0xe67, 0x74a }, { 0x231eff, 0x0 },
    { 0x7, 0x0 }, { 0x7, 0x0 }, { 0x1, 0x0 },
    { 0x1c03, 0x5 }, { 0xffffa7fe, 0xfffffffb }, { 0x0, 0x0 },
    { 0x3441, 0x64be }, { 0x5464, 0x40ca }, { 0x1, 0x0 },
    { 0x20c4, 0x7430 }, { 0x6927, 0x491e }, { 0x1, 0x0 },
    { 0xffffe764, 0xffffffc3 }, { 0x6dd7, 0x11 }, { 0xf0f0eaa, 0x0 },
    { 0x7499, 0x0 }, { 0xffffaea2, 0xffffffff }, { 0x0, 0x0 },
    { 0x3006, 0x0 }, { 0x92, 0x0 }, { 0x54, 0x0 },
    { 0x58a0, 0x1 }, { 0x293f, 0x0 }, { 0x634e9, 0x0 },
    { 0xffffa6b4, 0xffff81fa }, { 0x8de, 0x683d }, { 0x274b5, 0x0 },
    { 0x7efa, 0x0 }, { 0x769, 0x0 }, { 0x11, 0x0 },
    { 0xf, 0x0 }, { 0x2, 0x0 }, { 0x7, 0x0 },
    { 0x46d7, 0x0 }, { 0x90d, 0x0 }, { 0x7, 0x0 },
    { 0x54bd, 0x0 }, { 0x46dc, 0x0 }, { 0x1, 0x0 },
    { 0xa87, 0x0 }, { 0xfffff630, 0xffffffff }, { 0x0, 0x0 },
    { 0x30d, 0x0 }, { 0x2d0, 0x0 }, { 0x1, 0x0 },
    { 0x4998, 0x7c00 }, { 0x16b1, 0x15fc }, { 0x5, 0x0 },
    { 0x6b01, 0x0 }, { 0x3786, 0x0 }, { 0x1, 0x0 },
    { 0x2201, 0x338a }, { 0xffffb61f, 0xffffe49c }, { 0x0, 0x0 },
    { 0x7143, 0x3 }, { 0xffff96be, 0xfffffffe }, { 0x0, 0x0 },
    { 0x6800, 0x5508 }, { 0x108b, 0x1f12 }, { 0x2, 0x0 },
    { 0xffffa2f7, 0xffffffff }, { 0x746, 0x0 }, { 0xf126c561, 0x233251 },
    { 0x6ef0, 0x0 }, { 0xc52, 0x0 }, { 0x9, 0x0 },
    { 0x532f, 0x0 }, { 0x4602, 0x0 }, { 0x1, 0x0 },
    { 0x3f53, 0x203 }, { 0x2fdd, 0x100 }, { 0x2, 0x0 },
    { 0x7a0, 0x0 }, { 0x13b, 0x0 }, { 0x6, 0x0 },
    { 0xffffdd1a, 0xffffffb7 }, { 0x249f, 0x1c }, { 0x924923a, 0x0 },
    { 0xfffffffc, 0xffffffff }, { 0x1, 0x0 }, { 0xfffffffc, 0xffffffff },
    { 0xffff87f5, 0xffff9e23 }, { 0xffff80d3, 0xffffa06f }, { 0x0, 0x0 },
    { 0x33ed, 0x1c85 }, { 0xffffeab6, 0xfffff135 }, { 0x0, 0x0 },
    { 0x64b, 0x0 }, { 0x26a, 0x0 }, { 0x2, 0x0 },
    { 0xffffb2a7, 0xffffffa5 }, { 0x1b9, 0x13 }, { 0xd794358, 0x0 },
    { 0xffffe747, 0xffffffff }, { 0xe4b, 0x0 }, { 0xb8b4c9a, 0x11e931 },
    { 0x1ff, 0x0 }, { 0x193, 0x0 }, { 0x1, 0x0 },
    { 0xffffa5b5, 0xfffff2b5 }, { 0xb38, 0x6bb }, { 0x260934, 0x0 },
    { 0xfffff9b4, 0xffffffff }, { 0x19c, 0x0 }, { 0xe725480f, 0x9f1165 },
    { 0xffffbb36, 0xffffffff }, { 0xffffe20f, 0xffffffff }, { 0x0, 0x0 },
    { 0x2305, 0x39 }, { 0x2dc3, 0x21 }, { 0x1, 0x0 },
    { 0x7326, 0x0 }, { 0xfffffcbf, 0xffffffff }, { 0x0, 0x0 },
    { 0x15c, 0x363d }, { 0xffffa246, 0xffffd527 }, { 0x0, 0x0 },
    { 0x74d6, 0x3f80 }, { 0x5d5d, 0x2316 }, { 0x1, 0x0 },
    { 0xffff8129, 0xffffffff }, { 0x2097, 0x0 }, { 0xe8a62fca, 0x7daee },
    { 0x465b, 0x710e }, { 0x71f3, 0xf9b }, { 0x7, 0x0 },
    { 0x6011, 0x0 }, { 0x5ac2, 0x0 }, { 0x1, 0x0 },
    { 0x1447, 0x712 }, { 0xffff89ed, 0xffffffd3 }, { 0x0, 0x0 },
    { 0x6dbe, 0x0 }, { 0x4a95, 0x0 }, { 0x1, 0x0 },
    { 0xfffffe0b, 0xffffffff }, { 0xcd, 0x0 }, { 0xfb013fad, 0x13fb013 },
    { 0x4947, 0x142 }, { 0x7fa5, 0x11c }, { 0x1, 0x0 },
    { 0xffffc23d, 0xffffff63 }, { 0x545b, 0x97 }, { 0x1b20362, 0x0 },
    { 0x767f, 0x0 }, { 0x520e, 0x0 }, { 0x1, 0x0 },
    { 0xffff9289, 0xffffff66 }, { 0x4819, 0x2a }, { 0x6186177, 0x0 },
    { 0x0, 0xa0 }, { 0x100000, 0x0 }, { 0xa0000, 0x0 },
    { 0x5d2ca, 0x0 }, { 0xa, 0x0 }, { 0x9514, 0x0 }
};

void DumpUint32(char *What, UINT32 Value)
{
    Puts(What);
    PutWord(Value);
    PutChar('\n');
}

void DumpUint64(char *What, UINT32 Value1, UINT32 Value2)
{
    Puts(What);
    //if (Value1 > 0)
	//{
		PutWord(Value1);
		PutChar('.');
	//}
	PutWord(Value2);
    //PutChar('\n');
}

BOOL HadTrap = FALSE;

PCXTINFO TrapHandler(PCXTINFO Context)
{
    HadTrap = TRUE;
    DumpUint32("Caught trap at pc=", Context->pc);
    Context->pc += 4;
    return Context;
}

#define LED_SHIFT 8
#define LED_MASK 0x1ff00 /* 9 leds */
void PaintLeds(int i)
{
    /* NB: too many times is bad for Giano */
    //if (i & 127) return;
    TheGPIO->ClearData = LED_MASK;
    TheGPIO->PinData = (i << LED_SHIFT) & LED_MASK;
}

void main(char *StackPointer)
{
    char Step = 'a'-1;
    UINT32 x, y, verbose, psr;
	UINT64 base_start, base_finish;
	UINT64 ext_start, ext_finish;
	UINT64 noext_start, noext_finish;
	UINT32 base_time, ext_time, noext_time, overhead;
	UINT32 performance, performance2;
	int i, j, k, n;
	int errorcnt;
	UINT64 a, b, c;
	UINT64 ce, cb, cv;
	TSTUINT64 *p;

	errorcnt = 0;

	Step++;
	TheGPIO->OutDisable = 0xffffffff;
	TheGPIO->Enable = 0xffffffff;
	TheGPIO->ClearData = 0xffffffff;
	x = TheGPIO->PinStatus; /* verbose and whatnot */

    TheGPIO->Enable    = LED_MASK; 
    TheGPIO->Direction = LED_MASK; 
	TheGPIO->ClearData = LED_MASK;

    /* Wait for go
     */
    Step++;
    if (((x)&(0x4)) == 0) Delay(20 * 0x10000); // NB: about 1 sec

    /* Test utils */
    Step++;
    DumpUint32("HiMom! sp=", (UINT32)StackPointer);

    /* Enable traps to non-boot location
     */
    Step++;
    psr = GetPsr();
    psr &= ~0x00400000;
    SetPsr(psr);

    /* Install trap our handler
     */
    Step++;
    UserInterruptHandler = TrapHandler;

	Step++;
	DumpUint32("GPIO = ", x);
	PutChar('\n');
	PutChar('\n');
	verbose = x>>7;
	if (verbose > 0) Puts("Verbose Mode\n");
	PutChar('\n');
	PutChar('\n');

	Step++;
	TheTc->Control = TCCT_RESET;
	Delay(10);
	TheTc->Control = TCCT_ENABLE;

	Step++;
	Puts("MARK - RUNNING NON EXTENSION TEST\n");
	Puts("READY...\n");
	Puts("SET...\n");
	Puts("GO!!!\n");
	Puts("\n");
	noext_start = TheTc->FreeRunning;

	Step++;
#define NREPEATS 20
    for (n = 0; n < NREPEATS; n++) {
    PaintLeds(n);
	p = TSTVECTORS;
	for (i=0; i<NTESTS; i++)
	{

		a = TSTUINT64_UINT64(p->LowPart,p->HighPart);
		p++;
		b = TSTUINT64_UINT64(p->LowPart,p->HighPart);
		p++;
		c = TSTUINT64_UINT64(p->LowPart,p->HighPart);
		p++;
		cv = mmldiv64_chk(a,b);
		if (HadTrap) 
		{
			Puts("Had a trap, our Extension is not loaded/enabled.\n");
			goto error;
		}
		if (verbose > 0)
		{
			DumpUint64(" ",((UINT32)(a>>32)),((UINT32)(a)));
			DumpUint64("/",((UINT32)(b>>32)),((UINT32)(b)));
			DumpUint64("=",((UINT32)(c>>32)),((UINT32)(c)));
			Puts("\t");
			DumpUint64(" ",((UINT32)(cv>>32)),((UINT32)(cv)));
            Puts("\n");
		}
#if 0
		else
		{
			if (((i)%dot) == (dot-1)) Puts(".");
			if (((i)%line) == (line-1)) Puts("\n");
			if (((i)%dlbreak) == (dlbreak-1)) Puts("\n");
		}
#endif
		if (cv != c) 
		{
			//goto error;
			errorcnt++;
			Puts("\tERROR\t");
		}
	}
    }
    TheGPIO->ClearData = LED_MASK;

	Step++;
	noext_finish = TheTc->FreeRunning;
	Puts("\n");
	Puts("\n");
	Puts("DONE...\n");
	Puts("\n");

	Step++;
	disableclkext0();
	enableclkext0();
	if (verbose > 0) 
	{
		Puts("Turning on Clock Extension 0\n");
		PutChar('\n');
	}

	Step++;
	loadext0();
	if (verbose > 0) 
	{
		Puts("Loading Extension 0\n");
		PutChar('\n');
	}

	Step++;
	notrapext0();
	if (verbose > 0)
	{
		Puts("Turn off Trap Extension 0\n");
		PutChar('\n');
	}

	Step++;
	Puts("MARK - RUNNING BASELINE\n");
	Puts("READY...\n");
	Puts("SET...\n");
	Puts("GO!!!\n");
	Puts("\n");
	base_start = TheTc->FreeRunning;

	Step++;
    for (n = 0; n < NREPEATS; n++) {
    PaintLeds(n);
	p = TSTVECTORS;
	for (i=0; i<NTESTS; i++)
	{

		a = TSTUINT64_UINT64(p->LowPart,p->HighPart);
		p++;
		b = TSTUINT64_UINT64(p->LowPart,p->HighPart);
		p++;
		c = TSTUINT64_UINT64(p->LowPart,p->HighPart);
		p++;
		cv = mmldiv64(a,b);
		if (HadTrap) 
		{
			Puts("Had a trap, our Extension is not loaded/enabled.\n");
			goto error;
		}
		if (verbose > 0)
		{
			DumpUint64(" ",((UINT32)(a>>32)),((UINT32)(a)));
			DumpUint64("/",((UINT32)(b>>32)),((UINT32)(b)));
			DumpUint64("=",((UINT32)(c>>32)),((UINT32)(c)));
			Puts("\t");
			DumpUint64(" ",((UINT32)(cv>>32)),((UINT32)(cv)));
            Puts("\n");
		}
#if 0
		else
		{
			if (((i)%dot) == (dot-1)) Puts(".");
			if (((i)%line) == (line-1)) Puts("\n");
			if (((i)%dlbreak) == (dlbreak-1)) Puts("\n");
		}
#endif
		if (cv != c) 
		{
			//goto error;
			errorcnt++;
			Puts("\tERROR\t");
		}
    }
	}
    TheGPIO->ClearData = LED_MASK;

	Step++;
	base_finish = TheTc->FreeRunning;
	Puts("\n");
	Puts("\n");
	Puts("DONE...\n");
	Puts("\n");

	Step++;
	trapext0();
	if (verbose > 0)
	{
		Puts("Turn on Trap Extension 0\n");
		PutChar('\n');
	}

	Step++;
	enableext0();
	if (verbose > 0)
	{
		Puts("Enabling Extension 0\n");
		Puts("\n");
	}

	Step++;
	Puts("MARK - RUNNING EXTENSION TEST\n");
	Puts("READY...\n");
	Puts("SET...\n");
	Puts("GO!!!\n");
	Puts("\n");
	ext_start = TheTc->FreeRunning;

	Step++;
    for (n = 0; n < NREPEATS; n++) {
    PaintLeds(n);
	p = TSTVECTORS;
	for (i=0; i<NTESTS; i++)
	{
		a = TSTUINT64_UINT64(p->LowPart,p->HighPart);
		p++;
		b = TSTUINT64_UINT64(p->LowPart,p->HighPart);
		p++;
		c = TSTUINT64_UINT64(p->LowPart,p->HighPart);
		p++;
		cv = mmldiv64(a,b);
		if (HadTrap) 
		{
			Puts("Had a trap, our Extension is not loaded/enabled.\n");
			goto error;
		}
		if (verbose > 0)
		{
			DumpUint64(" ",((UINT32)(a>>32)),((UINT32)(a)));
			DumpUint64("/",((UINT32)(b>>32)),((UINT32)(b)));
			DumpUint64("=",((UINT32)(c>>32)),((UINT32)(c)));
			Puts("\t");
			DumpUint64(" ",((UINT32)(cv>>32)),((UINT32)(cv)));
            Puts("\n");
		}
#if 0
		else
		{
			if (((i)%dot) == (dot-1)) Puts(".");
			if (((i)%line) == (line-1)) Puts("\n");
			if (((i)%dlbreak) == (dlbreak-1)) Puts("\n");
		}
#endif
		if (cv != c) 
		{
			//goto error;
			errorcnt++;
			Puts("\tERROR\t");
		}
	}
    }
    TheGPIO->ClearData = LED_MASK;

	Step++;
	ext_finish = TheTc->FreeRunning;
	Puts("\n");
	Puts("\n");
	Puts("DONE...\n");
	Puts("\n");

	Step++;
	disableext0();
	if (verbose > 0)
	{
		Puts("Disabling Extension 0\n");
		Puts("\n");
	}

	Step++;
	notrapext0();
	if (verbose > 0)
	{
		Puts("Turn off Trap Extension 0\n");
		PutChar('\n');
	}

	Step++;
	unloadext0();
	if (verbose > 0)
	{
		Puts("Unloading Extension 0\n");
		PutChar('\n');
	}

	Step++;
	disableclkext0();
	if (verbose > 0) 
	{
		Puts("Turning off Clock Extension 0\n");
		PutChar('\n');
	}

	Step++;
	base_time = (base_finish - base_start);
	ext_time = (ext_finish - ext_start);
	noext_time = (noext_finish - noext_start);
	performance = base_time/ext_time;
	performance2 = noext_time/ext_time;
	overhead = base_time/noext_time;
	Puts("\n");
	Puts("\n");
	Puts("\n");
	Puts("\n");
	Puts("RESULTS\n");
	Puts("\n");
	Puts("\n");
	DumpUint32("Errors = \t", errorcnt);
	Puts("\n");
	Puts("NON EXTENSION TEST RESULTS\n");
	DumpUint64("\tNOEXT START = \t", (UINT32)(noext_start>>32), (UINT32)noext_start);
	PutChar('\n');
	DumpUint64("\tNOEXT FINISH = \t", (UINT32)(noext_finish>>32), (UINT32)noext_finish);
	PutChar('\n');
	DumpUint32("\tNOEXT TIME = \t", noext_time);
	Puts("\n");
	Puts("BASELINE RESULTS\n");
	DumpUint64("\tBASE START = \t", (UINT32)(base_start>>32), (UINT32)base_start);
	PutChar('\n');
	DumpUint64("\tBASE FINISH = \t", (UINT32)(base_finish>>32), (UINT32)base_finish);
	PutChar('\n');
	DumpUint32("\tBASE TIME = \t", base_time);
	Puts("\n");
	Puts("EXTENSION TEST RESULTS\n");
	DumpUint64("\tEXT START = \t", (UINT32)(ext_start>>32), (UINT32)ext_start);
	PutChar('\n');
	DumpUint64("\tEXT FINISH = \t", (UINT32)(ext_finish>>32), (UINT32)ext_finish);
	PutChar('\n');
	DumpUint32("\tEXT TIME = \t", ext_time);
	Puts("\n");

	DumpUint32("PERFORMANCE over base (base/ext) = \t\t", performance);
	DumpUint32("PERFORMANCE over original (noext/ext) = \t", performance2);
	DumpUint32("OVERHEAD over original (base/noext) = \t\t", overhead);
	
    /* Execute extended instruction.
     * This will trap if the extension is not loaded
     */
    //Step++;
	//x = SpecialInstruction0(0,0,0,0);

    /* Did it work or did it fail?
     */
    //if (HadTrap) {
    //    Puts("Had a trap, our Extension is not loaded/enabled.\n");
    //    goto error;
    //} 

    //DumpUint32("logged writes", x);
    TheGPIO->Disable   = LED_MASK;
    Puts("TEST PASSED SUCCESSFULLY\n");
    return;

 error:
    TheGPIO->ClearData = LED_MASK;
    TheGPIO->Disable   = LED_MASK;
    Puts("TEST FAILED at Step=");
    PutChar(Step);
    Puts("\n");
    return;
}
