/* Dumps the Peripheral Mapping Table (PMT) on the Ml401
 */
#include "print.h"
#include <mips\ml40x.h>

void main(char *StackPointer)
{
    char Step = 'a'-1;
    volatile UINT32 a, b, c;

    /* Wait fro go
     */
    Delay(20 * 0x10000); // NB: about 1 sec
    Step++;

    a = 0x7fffffff;
    b = 0x80000000;
    c = a * b;
    PutWord(a); Puts(" * "); PutWord(b);
    Puts(" = "); PutWord(c); PutChar('\n');

    if (c != b) {
        goto error;
    }

    /* END: all is well
     */ 
    Puts("TEST PASSED SUCCESSFULLY\n");
    return;

error:
    Puts("TEST FAILED at Step=");
    PutChar(Step);
    Puts("\n");
    return;
}
