/* Dumps the Peripheral Mapping Table (PMT) on the Ml401
 */
#include "print.h"
#include <mips\ml40x.h>

typedef char *STRING;
typedef struct _CONTROLLER {
    STRING TagName;
    UINT (*DumpController)(struct _Pmt *PmtEntry, STRING TagName);
} CONTROLLER, *PCONTROLLER;

/* Dumpers for specific controllers
 * Returns the number of  peripheral of its kind found in that range
 */
UINT AnyController(struct _Pmt *PmtEntry, STRING TagName)
{
    return 0;
}

/* A few look like the SRAM one */
UINT GenericController(struct _Pmt *PmtEntry, STRING TagName)
{
    struct _Sram *pF = (struct _Sram *) (PmtEntry->TopOfPhysicalAddress << 16);
    UINT Found = 0;

    for (;(pF->BaseAddressAndTag & SRAMBT_TAG) == PmtEntry->Tag; pF++) {
        Puts("\n\t");Puts(TagName);Puts("["); PutWord(Found);
        Puts("].AddresssAndTag = "); PutWord(pF->BaseAddressAndTag);
        Puts("\n\t");Puts(TagName);Puts("["); PutWord(Found);
        Puts("].Control = "); PutWord(pF->Control);

        Found++;
    }
    return Found;
}

UINT AicController(struct _Pmt *PmtEntry, STRING TagName)
{
    struct _Aic *pF = (struct _Aic *) (PmtEntry->TopOfPhysicalAddress << 16);
    UINT Found = 0;

    for (;pF->Tag == PmtEntry->Tag; pF++) {
        Puts("\n\tAIC["); PutWord(Found);
        Puts("].Tag = "); PutWord(pF->Tag);

        Puts("\n\tAIC["); PutWord(Found);
        Puts("].IrqStatus = "); PutWord(pF->IrqStatus);

        Puts("\n\tAIC["); PutWord(Found);
        Puts("].IrqRawStatus = "); PutWord(pF->IrqRawStatus);

        Puts("\n\tAIC["); PutWord(Found);
        Puts("].IrqEnable = "); PutWord(pF->IrqEnable);

        Puts("\n\tAIC["); PutWord(Found);
        Puts("].IrqEnableClear = "); PutWord(pF->IrqEnableClear);

        Puts("\n\tAIC["); PutWord(Found);
        Puts("].IrqSoft = "); PutWord(pF->IrqSoft);

        Found++;
    }
    return Found;
}

UINT PioController(struct _Pmt *PmtEntry, STRING TagName)
{
    struct _Pio *pF = (struct _Pio *) (PmtEntry->TopOfPhysicalAddress << 16);
    UINT Found = 0;

    for (;pF->Tag == PmtEntry->Tag; pF++) {
        Puts("\n\tPIO["); PutWord(Found);
        Puts("].Tag = "); PutWord(pF->Tag);

        Puts("\n\tPIO["); PutWord(Found);
        Puts("].Enable = "); PutWord(pF->Enable);

        Puts("\n\tPIO["); PutWord(Found);
        Puts("].Disable = "); PutWord(pF->Disable);

        Puts("\n\tPIO["); PutWord(Found);
        Puts("].Direction = "); PutWord(pF->Direction);

        Puts("\n\tPIO["); PutWord(Found);
        Puts("].OutDisable = "); PutWord(pF->OutDisable);

        Puts("\n\tPIO["); PutWord(Found);
        Puts("].PinData = "); PutWord(pF->PinData);

        Puts("\n\tPIO["); PutWord(Found);
        Puts("].PinData = "); PutWord(pF->PinData);

        Puts("\n\tPIO["); PutWord(Found);
        Puts("].ClearData = "); PutWord(pF->ClearData);

        Puts("\n\tPIO["); PutWord(Found);
        Puts("].PinStatus = "); PutWord(pF->PinStatus);

        Puts("\n\tPIO["); PutWord(Found);
        Puts("].IntrStatus = "); PutWord(pF->IntrStatus);

        Puts("\n\tPIO["); PutWord(Found);
        Puts("].IntrEnable = "); PutWord(pF->IntrEnable);

        Puts("\n\tPIO["); PutWord(Found);
        Puts("].IntrDisable = "); PutWord(pF->IntrDisable);

        Puts("\n\tPIO["); PutWord(Found);
        Puts("].IntrTrigger = "); PutWord(pF->IntrTrigger);

        Puts("\n\tPIO["); PutWord(Found);
        Puts("].reserved[0] = "); PutWord(pF->reserved[0]);

        Puts("\n\tPIO["); PutWord(Found);
        Puts("].reserved[1] = "); PutWord(pF->reserved[1]);

        Puts("\n\tPIO["); PutWord(Found);
        Puts("].reserved[2] = "); PutWord(pF->reserved[2]);

        Found++;
    }
    return Found;
}

UINT UsartController(struct _Pmt *PmtEntry, STRING TagName)
{
    struct _Usart *pF = (struct _Usart *) (PmtEntry->TopOfPhysicalAddress << 16);
    UINT Found = 0;

    for (;pF->Tag == PmtEntry->Tag; pF++) {
        Puts("\n\tUSART["); PutWord(Found);
        Puts("].Tag = "); PutWord(pF->Tag);

        Puts("\n\tUSART["); PutWord(Found);
        Puts("].Control = "); PutWord(pF->Control);

        Puts("\n\tUSART["); PutWord(Found);
        Puts("].IntrEnable = "); PutWord(pF->IntrEnable);

        Puts("\n\tUSART["); PutWord(Found);
        Puts("].IntrDisable = "); PutWord(pF->IntrDisable);

        Puts("\n\tUSART["); PutWord(Found);
        Puts("].IntrMask = "); PutWord(pF->IntrMask);

        Puts("\n\tUSART["); PutWord(Found);
        Puts("].ChannelStatus = "); PutWord(pF->ChannelStatus);

        Puts("\n\tUSART["); PutWord(Found);
        Puts("].RxData = "); PutWord(pF->RxData);

        Puts("\n\tUSART["); PutWord(Found);
        Puts("].TxData = "); PutWord(pF->TxData);

        Puts("\n\tUSART["); PutWord(Found);
        Puts("].Baud = "); PutWord(pF->Baud);

        Puts("\n\tUSART["); PutWord(Found);
        Puts("].Timeout = "); PutWord(pF->Timeout);

        Puts("\n\tUSART["); PutWord(Found);
        Puts("].reserved[0] = "); PutWord(pF->reserved[0]);

        Puts("\n\tUSART["); PutWord(Found);
        Puts("].reserved[1] = "); PutWord(pF->reserved[1]);

        Puts("\n\tUSART["); PutWord(Found);
        Puts("].reserved[2] = "); PutWord(pF->reserved[2]);

        Puts("\n\tUSART["); PutWord(Found);
        Puts("].reserved[3] = "); PutWord(pF->reserved[3]);

        Puts("\n\tUSART["); PutWord(Found);
        Puts("].reserved[4] = "); PutWord(pF->reserved[4]);

        Puts("\n\tUSART["); PutWord(Found);
        Puts("].reserved[5] = "); PutWord(pF->reserved[5]);

        Found++;
    }
    return Found;
}

UINT TcController(struct _Pmt *PmtEntry, STRING TagName)
{
    struct _Tc *pF = (struct _Tc *) (PmtEntry->TopOfPhysicalAddress << 16);
    UINT Found = 0;

    for (;pF->Tag == PmtEntry->Tag; pF++) {
        Puts("\n\tTC["); PutWord(Found);
        Puts("].Tag = "); PutWord(pF->Tag);

        Puts("\n\tTC["); PutWord(Found);
        Puts("].Control = "); PutWord(pF->Control);

        Puts("\n\tTC["); PutWord(Found);
        Puts("].FreeRunning = "); PutWord(pF->FreeRunning>>16);PutWord((UINT32)pF->FreeRunning);

        Puts("\n\tTC["); PutWord(Found);
        Puts("].DownCounter = "); PutWord(pF->DownCounterHigh);PutWord(pF->DownCounter);

        Puts("\n\tTC["); PutWord(Found);
        Puts("].reserved[0] = "); PutWord(pF->reserved[0]);

        Puts("\n\tTC["); PutWord(Found);
        Puts("].reserved[1] = "); PutWord(pF->reserved[1]);

        Found++;
    }
    return Found;
}

UINT WdController(struct _Pmt *PmtEntry, STRING TagName)
{
    struct _Wd *pF = (struct _Wd *) (PmtEntry->TopOfPhysicalAddress << 16);
    UINT Found = 0;

    for (;pF->Tag == PmtEntry->Tag; pF++) {
        Puts("\n\tWD["); PutWord(Found);
        Puts("].Tag = "); PutWord(pF->Tag);

        Puts("\n\tWD["); PutWord(Found);
        Puts("].OvflMode = "); PutWord(pF->OvflMode);

        Puts("\n\tWD["); PutWord(Found);
        Puts("].ClockMode = "); PutWord(pF->ClockMode);

        Puts("\n\tWD["); PutWord(Found);
        Puts("].Control = "); PutWord(pF->Control);

        Puts("\n\tWD["); PutWord(Found);
        Puts("].Status = "); PutWord(pF->Status);

        Puts("\n\tWD["); PutWord(Found);
        Puts("].reserved[0] = "); PutWord(pF->reserved[0]);

        Puts("\n\tWD["); PutWord(Found);
        Puts("].reserved[1] = "); PutWord(pF->reserved[1]);

        Puts("\n\tWD["); PutWord(Found);
        Puts("].reserved[2] = "); PutWord(pF->reserved[2]);

        Found++;
    }
    return Found;
}

UINT PmcController(struct _Pmt *PmtEntry, STRING TagName)
{
    struct _Pmc *pF = (struct _Pmc *) (PmtEntry->TopOfPhysicalAddress << 16);
    UINT Found = 0;

    for (;pF->Tag == PmtEntry->Tag; pF++) {
        Puts("\n\tPMC["); PutWord(Found);
        Puts("].Tag = "); PutWord(pF->Tag);

        Puts("\n\tPMC["); PutWord(Found);
        Puts("].SystemPowerEnable = "); PutWord(pF->SystemPowerEnable);

        Puts("\n\tPMC["); PutWord(Found);
        Puts("].SystemPowerDisable = "); PutWord(pF->SystemPowerDisable);

        Puts("\n\tPMC["); PutWord(Found);
        Puts("].PeripheralPowerEnable = "); PutWord(pF->PeripheralPowerEnable);

        Puts("\n\tPMC["); PutWord(Found);
        Puts("].PeripheralPowerDisable = "); PutWord(pF->PeripheralPowerDisable);

        Puts("\n\tPMC["); PutWord(Found);
        Puts("].reserved[0] = "); PutWord(pF->reserved[0]);

        Puts("\n\tPMC["); PutWord(Found);
        Puts("].reserved[1] = "); PutWord(pF->reserved[1]);

        Puts("\n\tPMC["); PutWord(Found);
        Puts("].reserved[2] = "); PutWord(pF->reserved[2]);

        Found++;
    }
    return Found;
}

UINT AceController(struct _Pmt *PmtEntry, STRING TagName)
{
    struct _Sac *pF = (struct _Sac *) (PmtEntry->TopOfPhysicalAddress << 16);
    UINT Found = 0;

    for (;pF->Tag == PmtEntry->Tag; pF++) {
        Puts("\n\tACE["); PutWord(Found);
        Puts("].Tag = "); PutWord(pF->Tag);

        Puts("\n\tACE["); PutWord(Found);
        Puts("].Control = "); PutWord(pF->Control);

        Puts("\n\tACE["); PutWord(Found);
        Puts("].BUSMODEREG = "); PutWord(pF->BUSMODEREG);

        Puts("\n\tACE["); PutWord(Found);
        Puts("].STATUS = "); PutWord(pF->STATUS);

        Puts("\n\tACE["); PutWord(Found);
        Puts("].ERRORREG = "); PutWord(pF->ERRORREG);

        Puts("\n\tACE["); PutWord(Found);
        Puts("].CFGLBAREG = "); PutWord(pF->CFGLBAREG);

        Puts("\n\tACE["); PutWord(Found);
        Puts("].MPULBAREG = "); PutWord(pF->MPULBAREG);

        Puts("\n\tACE["); PutWord(Found);
        Puts("].VERSIONREG = "); PutWord(pF->VERSIONREG);

        Puts("\n\tACE["); PutWord(Found);
        Puts("].SECCNTCMDREG = "); PutWord(pF->SECCNTCMDREG);

        Puts("\n\tACE["); PutWord(Found);
        Puts("].CONTROLREG = "); PutWord(pF->CONTROLREG);

        Puts("\n\tACE["); PutWord(Found);
        Puts("].FATSTATREG = "); PutWord(pF->FATSTATREG);

        Found++;
    }
    return Found;
}

UINT EcController(struct _Pmt *PmtEntry, STRING TagName)
{
    struct _Ec *pF = (struct _Ec *) (PmtEntry->TopOfPhysicalAddress << 16);
    UINT Found = 0;

    for (;pF->Tag == PmtEntry->Tag; pF++) {
        Puts("\n\tEC["); PutWord(Found);
        Puts("].Tag = "); PutWord(pF->Tag);

        Puts("\n\tEC["); PutWord(Found);
        Puts("].Control = "); PutWord(pF->Control);

        Puts("\n\tEC["); PutWord(Found);
        Puts("].SlotStatusAndTag = "); PutWord(pF->SlotStatusAndTag);

        Puts("\n\tEC["); PutWord(Found);
        Puts("].BatOrSize[0] = "); PutWord(pF->BatOrSize[0]);

        Puts("\n\tEC["); PutWord(Found);
        Puts("].BatOrSize[1] = "); PutWord(pF->BatOrSize[1]);

        Puts("\n\tEC["); PutWord(Found);
        Puts("].BatOrSize[2] = "); PutWord(pF->BatOrSize[2]);

        Puts("\n\tEC["); PutWord(Found);
        Puts("].BatOrSize[3] = "); PutWord(pF->BatOrSize[3]);

        Puts("\n\tEC["); PutWord(Found);
        Puts("].BatOrSize[4] = "); PutWord(pF->BatOrSize[4]);

        Found++;
    }
    return Found;
}

CONTROLLER AllControllers[PMTTAG_LAST_TAG_DEFINED+1] = {
    { "BRAM", AnyController },
    { "PMT", AnyController },
    { "SRAM", GenericController },
    { "DDRAM", AnyController },
    { "FLASH", GenericController },
    { "INTERRUPT_CONTROLLER", AicController },
    { "USART", UsartController },
    { "TIMER", TcController },
    { "WATCHDOG", WdController },
    { "GPIO", PioController },
    { "SYSTEM_ACE", AceController },
    { "LCD", AnyController },
    { "PS2", AnyController },
    { "VGA", AnyController },
    { "ETHERNET", AnyController },
    { "AC97", AnyController },
    { "POWER_MGR", PmcController },
    { "EXTENSION_CONTROLLER", EcController }
};

void main(char *StackPointer)
{
    char Step = 'a'-1;
    struct _Pmt *Pmt = ThePmt;
    int maxe;
    PCONTROLLER pC;

    /* Wait fro go
     */
    Delay(20 * 0x10000); // NB: about 1 sec
    Step++;

    Puts("Peripheral Mapping Table, from the top at "); PutWord((UINT32)Pmt); PutChar('\n');

    for (maxe=0;maxe<100;maxe++,Pmt--) {
        Puts("Pmt["); PutWord(maxe); Puts("]: "); PutWord(*(UINT32*)Pmt);
        Puts(" -- Address = "); PutWord(Pmt->TopOfPhysicalAddress << 16);
        Puts(" Tag = "); PutWord(Pmt->Tag);
        
        if (Pmt->Tag < (PMTTAG_LAST_TAG_DEFINED+1)) {
            pC = &AllControllers[Pmt->Tag];
            PutChar(' '); Puts(pC->TagName);
            pC->DumpController(Pmt,pC->TagName);
        }
        if (Pmt->Tag == PMTTAG_END_OF_TABLE) {
            Puts(" END_OF_TABLE");
            Step++;
        }
        PutChar('\n');
        if (Pmt->Tag == PMTTAG_END_OF_TABLE)
            break;
        if (Pmt->Tag == PMTTAG_PMT)
            Step++;
    }


    /* END: all is well?
     */ 
    if (Step != 'c')
        goto error;
    Puts("TEST PASSED SUCCESSFULLY\n");
    return;

error:
    Puts("TEST FAILED at Step=");
    PutChar(Step);
    Puts("\n");
    return;
}
