	/* Trivial support for printing stuff on the serial line from C pgms.
     */
#include <mips/mips_asm.h>
#define __ASSEMBLER__ 1
#include <mips/ml40x.h>

        _IMPORT(main)

        _EXPORT(start)
        _EXPORT(PutWord)
        _EXPORT(Puts)
        _EXPORT(GetChar)
        _EXPORT(PutChar)
        _EXPORT(Delay)
        _EXPORT(GetPsr)
        _EXPORT(SetPsr)
        _EXPORT(GetCause)
        _EXPORT(GetEpc)
        _EXPORT(Stop)
        _EXPORT(ExceptionHandler)
        _EXPORT(ExceptionHandlerEnd)
        _EXPORT(UserInterruptHandler)
        
        .set noreorder

ENTRY(start)
    /* Get a stack
     */
    la    $sp,StackTop

    /* Jump to main
     */
    jal   main
    add   $a0,$sp,$zero

    /* Test succeeded, disable interrupts and download the next one
     */
    li     $t0,0x1260ff80  // NB: On new builds this is a SYS-RESET as well
    mtc0   $t0,$cp0_status

    lui    $t0,(BRAM_DEFAULT_ADDRESS>>16) // nb: knows about 16bit chop
	jr     $t0
    nop

_LABEL(Stop)
	b     Stop
    nop

END(start)

        .set noreorder
        .set noat
        .set nomacro

/* void Delay(UINT32 count)
 */
ENTRY(Delay)
    bne    $a0,$zero,Delay
    subu   $a0,1
    j      $ra
    nop
END(Delay)

/* UINT32 GetPsr(void)
 * Returns the PSR (coprocessor 0 status)
 */
ENTRY(GetPsr)
    mfc0   $v0,$cp0_status
    j      $ra
    nop
END(GetPsr)

/* void SetPsr(UINT32 Psr)
 * Sets the PSR (coprocessor 0 status)
 */
ENTRY(SetPsr)
    mtc0   $a0,$cp0_status
    j      $ra
    nop
END(SetPsr)

/* UINT32 GetCause(void)
 * Returns the Cause register (coprocessor 0)
 */
ENTRY(GetCause)
    mfc0   $v0,$cp0_cause
    j      $ra
    nop
END(GetCause)

/* UINT32 GetEpc(void)
 * Returns the Epc register (coprocessor 0)
 */
ENTRY(GetEpc)
    mfc0   $v0,$cp0_epc
    j      $ra
    nop
END(GetEpc)

/* Does not handle the exception, really.
 * But to test interrupts should be enough
 */
     .org 0x00000080
ENTRY(ExceptionHandler)
	FRAMESIZE(SIZEOF_CXTINFO)
    la     $k1, UserInterruptHandler
    lw     $k1,0($k1)
    bne    $k1,$zero,Dispatch
    mfc0   $k0, $cp0_epc
    j      $k0
    nop /* do not! pop status */

_LABEL(UserInterruptHandler)
    .word 0

_LABEL(Dispatch)
	/* Save state on stack */
	addiu   $sp, $sp, -SIZEOF_CXTINFO
	/* save registers */
	sw      $at, TS_AT($sp)
	sw      $v0, TS_V0($sp)
	sw      $v1, TS_V1($sp)
	sw      $a0, TS_A0($sp)
	sw      $a1, TS_A1($sp)
	sw      $a2, TS_A2($sp)
	sw      $a3, TS_A3($sp)
	sw      $t0, TS_T0($sp)
	sw      $t1, TS_T1($sp)
	sw      $t2, TS_T2($sp)
	sw      $t3, TS_T3($sp)
	sw      $t4, TS_T4($sp)
	sw      $t5, TS_T5($sp)
	sw      $t6, TS_T6($sp)
	sw      $t7, TS_T7($sp)
	sw      $s0, TS_S0($sp)
	sw      $s1, TS_S1($sp)
	sw      $s2, TS_S2($sp)
	sw      $s3, TS_S3($sp)
	sw      $s4, TS_S4($sp)
	sw      $s5, TS_S5($sp)
	sw      $s6, TS_S6($sp)
	sw      $s7, TS_S7($sp)
	sw      $t8, TS_T8($sp)
	sw      $t9, TS_T9($sp)
	sw      $k0, TS_K0($sp)
	sw      $k1, TS_K1($sp)
	sw      $gp, TS_GP($sp)
	/* sp: later */
	sw      $fp, TS_FP($sp)
	sw      $ra, TS_RA($sp)

    mfc0    $a0, $cp0_status
    mflo    $t0
    mfhi    $t1
	sw      $a0, TS_SR($sp)
	sw      $t0, TS_LO($sp)
	sw      $t1, TS_HI($sp)
	sw      $k0, TS_PC($sp)

	/* Save original stack */
    move    $a0,$sp
	addiu   $t0, $sp, SIZEOF_CXTINFO
    jalr    $k1
	sw      $t0, TS_SP($sp)
    
    /* Returned value is new PCXINFO */
    move    $a0,$v0

	/* First load most registers */
	lw       $at, TS_AT($a0)
	lw       $v0, TS_V0($a0)
	lw       $v1, TS_V1($a0)
	/* a0 later */
	lw       $a1, TS_A1($a0)
	lw       $a2, TS_A2($a0)
	lw       $a3, TS_A3($a0)
	lw       $t0, TS_T0($a0)
	lw       $t1, TS_T1($a0)
	lw       $t2, TS_T2($a0)
	lw       $t3, TS_T3($a0)
	lw       $t4, TS_T4($a0)
	lw       $t5, TS_T5($a0)
	lw       $t6, TS_T6($a0)
	lw       $t7, TS_T7($a0)
	lw       $s0, TS_S0($a0)
	lw       $s1, TS_S1($a0)
	lw       $s2, TS_S2($a0)
	lw       $s3, TS_S3($a0)
	lw       $s4, TS_S4($a0)
	lw       $s5, TS_S5($a0)
	lw       $s6, TS_S6($a0)
	lw       $s7, TS_S7($a0)
	lw       $t8, TS_T8($a0)
	lw       $t9, TS_T9($a0)
    /* k0,k1 not restored */
	lw       $gp, TS_GP($a0)
	/* sp later */
	lw       $fp, TS_FP($a0)
	lw       $ra, TS_RA($a0)

    lw       $k1, TS_HI($a0)
    lw       $k0, TS_LO($a0)
    mthi     $k1
    mtlo     $k0
    lw       $k1, TS_SR($a0)
    mtc0     $k1, $cp0_status
     /* NB: After this instruction we cannot take any interrupts or traps
      */
	lw	$sp, TS_SP($a0)

	/* Put pc into k0 */
	lw	$k0, TS_PC($a0)
	lw	$a0, TS_A0($a0)
	j	$k0
    rfe


_LABEL(ExceptionHandlerEnd)
END(ExceptionHandler)

/* int PutWord(UINT32 Word);
 * Returns: 0 if ok, -1 otherwise
 */
ENTRY(PutWord)
    FRAMESIZE(12)
    subu   $sp,$sp,12
    sw     $s0,8($sp)
    sw     $s1,4($sp)
    sw     $ra,0($sp)

    or     $s1,$a0,$zero
    /* Spit all nibbles
     */
    li     $s0,8
_LABEL(PutWordLoop)
    srl    $a0,$s1,32-4
    li     $t0,10
    sltu   $t1,$a0,$t0
    bnez   $t1,$Digit
    li     $a1,'0'
    subu   $a0,$a0,$t0
    li     $a1,'a'
$Digit:
    sll    $s1,$s1,4
    jal    PutChar
    add    $a0,$a0,$a1

    subu   $s0,$s0,1
    bne    $v0,$zero,PutWordDone /* printed ok? */
    li     $v0,-1

    /* done yet? */
    bne    $s0,$zero,PutWordLoop
    nop

    /* done
     */
_LABEL(PutWordDoneOk)
    li     $v0,0
_LABEL(PutWordDone)
    lw     $ra,0($sp)
    lw     $s1,4($sp)
    lw     $s0,8($sp)
    jr     $ra
    addiu  $sp,$sp,12

END(PutWord)

/* int Puts(char *String);
 * Returns: 0 if ok, -1 otherwise
 */
ENTRY(Puts)
	FRAMESIZE(8)
    subu   $sp,$sp,8
    sw     $s0,4($sp)
    sw     $ra,0($sp)

    or     $s0,$a0,$zero
    /* Spit all chars until zero
     */
_LABEL(PutsLoop)
    lbu    $a0,0($s0)
    addiu  $s0,$s0,1
    beq    $a0,$zero,PutsDoneOk
    nop
    jal    PutChar
    nop
    beq    $v0,$zero,PutsLoop
    nop

    /* Timed out
     */
    b      PutsDone
    li     $v0,-1

    /* done
     */
_LABEL(PutsDoneOk)
    li     $v0,0
_LABEL(PutsDone)
    lw     $ra,0($sp)
    lw     $s0,4($sp)
    jr     $ra
    addiu  $sp,$sp,8

END(Puts)


/* int GetChar(void);
 * Returns: a non-negative value if ok, -1 otherwise
 */
ENTRY(GetChar)
    lui    $t0,(USART_DEFAULT_ADDRESS>>16) // nb: knows about 16bit chop
    lui    $t1,1000          // n*65k spins max
_LABEL(RxNotReady)
    lw     $t4,USARTST($t0)       // ChannelStatus
    andi   $t4,$t4,USI_RXRDY
    bgtz   $t4,_L(GotByte)
    subu   $t1,$t1,1
    // still ok to spin?
    bgtz   $t1,_L(RxNotReady)
    nop
    /* Timed out
     */
    jr     $ra
    li     $v0,-1

    /* Gottabyte
     */
_LABEL(GotByte)
    lw     $v0,USARTRX($t0)        // RxData
    jr     $ra
    andi   $v0,0xff
END(GetChar)

/* int PutChar(UINT8 v);
 * Returns: 0 if ok, -1 otherwise
 */
ENTRY(PutChar)
    lui    $t0,(USART_DEFAULT_ADDRESS>>16) // nb: knows about 16bit chop
    lui    $t1,1000          // n*65k spins max
    li     $v0,0
_LABEL(TxNotReady)
    lw     $t4,USARTST($t0)       // ChannelStatus
    andi   $t4,$t4,USI_TXRDY
    bgtz   $t4,_L(TxReady)
    subu   $t1,$t1,1
    // still ok to spin?
    bgtz   $t1,_L(TxNotReady)
    nop
    /* Timed out
     */
    jr     $ra
    li     $v0,-1

    /* Send it
     */
_LABEL(TxReady)
    jr     $ra
    sw     $a0,USARTTX($t0)

END(PutChar)

        .data
_LABEL(StackBase)
    .space 512
_LABEL(StackTop)
    .byte  0xba,0xdf,0x00,0xd0
