/* Copyright (c) Microsoft Corporation. All rights reserved. */
#include "print.h"
#define _TCHAR char
#define _T(x) x
#define NULL 0

/* Buttons, if we got them.
 */
#define nBUTTONS 6

#define Button4 'l'
#define Button5 'r'
#define Button3 'd'
#define Button6 'u'
#define Button1 'p'
#define Button2 'q'

extern void OnButtonPress(int ButtonPressed);

/* They control which way the snake goes
 */
#define LEFT 0
#define RIGHT 1
#define UP 2
#define DOWN 3
#define TERMINATE 4
#define PAUSE 5
#define DIR_BITS 0x3

extern int CurrentDirection;

/* The game map
 */
#define TERMINAL_MAP_WIDTH  40
#define TERMINAL_MAP_HEIGHT 23  /* one line for status */

#define MAP_WIDTH  TERMINAL_MAP_WIDTH
#define MAP_HEIGHT TERMINAL_MAP_HEIGHT
#define NUM_PX     (MAP_WIDTH*MAP_HEIGHT)

extern UINT8 GameMap[NUM_PX];
typedef UINT8 *MAP;
#define PX_FREE   ((UINT8)0)
#define PX_BUSY   ((UINT8)1)
#define PX_GOODY  ((UINT8)3)

/* Map methods
 */
#define GetPixel(_m_,_n_)     _m_[_n_]
#define SetPixel(_m_,_n_,_v_) _m_[_n_] = _v_
#define ZeroMap(_m_,_v_)      memset(_m_,_v_,NUM_PX)
extern void InitScreen(void);
extern void ShowMap(MAP Map);
extern void Smile(void);

/* Utils
 */
#define NOISE(x)  //x
