#include "print.h"
#include <mips\ml40x.h>

#define _bs32(x) x

typedef struct _Usart USART;
#define DxPort  ((USART*)USART_DEFAULT_ADDRESS)
#define DxPortNo 0
#define CLOCK   (25*1000*1000)  /* ?!? */

/* *** ComPortReset
 *
 * Re-Initialize a COM port for low-level (polling) debugging use.
 *
 */
BOOL
ComPortReset(USART *Port, UINT Baud, UINT8 PortNo, BOOL Polling)
{
    UINT32 Divisor;
    BOOL r = TRUE;

    if (Polling) {
        /* disable all interrupts */
        Puts("Disabling\n");
        Port->IntrDisable = ~0;
    }

    /* Better be slower than faster, roundup 
     * NB: ASYNC, else no x16;
     */
    Divisor = (CLOCK/8)/Baud;
    Divisor = (Divisor/2) + (Divisor&1);
    //Port->Baud = _bs32(Divisor);
    Puts("Port->Baud="); PutWord(Divisor); PutChar('\n');
    if (Divisor != 0x29) {
        Puts("Wrong!\n");
        r = FALSE;
    }

    /* Enable rx/tx and clear any leftover status bits */
    /* 8 bit, no parity, 1 stop */
    /*Port->Control*/Divisor = _bs32(USC_CLKDIV_4 | USC_BPC_8 | USC_NONE | USC_1STOP |
                          USC_RXEN | USC_TXEN | USC_RSTSTA | USC_STPBRK);

    Puts("Port->Control="); PutWord(Divisor); PutChar('\n');
    if (Divisor != 0x02e00550) {
        Puts("Wrong!\n");
        r = FALSE;
    }
    return r;
}

void main(char *StackPointer)
{
    char Step = 'a';

    /* Wait fro go
     */
    Delay(20 * 0x10000); // NB: about 1 sec

    if (! ComPortReset(DxPort, 38400, DxPortNo, TRUE))
        goto error;

    /* END: all is well
     */ 
    Puts("TEST PASSED SUCCESSFULLY\n");
    return;

error:
    Puts("TEST FAILED at Step=");
    PutChar(Step);
    Puts("\n");
    return;
}
