#include "print.h"
#include <mips\ml40x.h>

#define _bs32(x) x

typedef struct _Usart USART;
#define DxPort  ((USART*)USART_DEFAULT_ADDRESS)
#define DxPortNo 0
#define CLOCK   (25*1000*1000)  /* ?!? */

/* *** ComPortReset
 *
 * Re-Initialize a COM port for low-level (polling) debugging use.
 *
 */
BOOL
ComPortReset(USART *Port, UINT Baud, UINT8 PortNo, BOOL Polling)
{
    UINT32 Divisor;
    BOOL r = TRUE;

    if (Polling) {
        /* disable all interrupts */
        Puts("Disabling\n");
        Port->IntrDisable = ~0;
    }

    /* Better be slower than faster, roundup 
     * NB: ASYNC, else no x16;
     */
    Divisor = (CLOCK/8)/Baud;
    Divisor = (Divisor/2) + (Divisor&1);
    //Port->Baud = _bs32(Divisor);
    Puts("Port->Baud="); PutWord(Divisor); PutChar('\n');
    if (Divisor != 0x29) {
        Puts("Wrong!\n");
        r = FALSE;
    }

    /* Enable rx/tx and clear any leftover status bits */
    /* 8 bit, no parity, 1 stop */
    /*Port->Control*/Divisor = _bs32(USC_CLKDIV_4 | USC_BPC_8 | USC_NONE | USC_1STOP |
                          USC_RXEN | USC_TXEN | USC_RSTSTA | USC_STPBRK);

    Puts("Port->Control="); PutWord(Divisor); PutChar('\n');
    if (Divisor != 0x02e00550) {
        Puts("Wrong!\n");
        r = FALSE;
    }
    return r;
}

BOOL TestDivision(UINT base)
{
    UINT x = 0xfadefade;
    UINT i, d, m, v;
    BOOL r = TRUE;
    for (i = 0; i < 8; i++) {
        d = x / base;
        m = x % base;
        v = (d * base) + m;
        if (x != v) {
            PutChar(' '); PutWord(x);
            Puts(" / "); PutWord(base);
            Puts(" = "); PutWord(d);
            PutChar('.'); PutWord(m);
            Puts(" ? "); PutWord(v);
            PutChar('\n');
            r = FALSE;
        }
        x >>= 4;
    }
    return r;
}

void main(char *StackPointer)
{
    BOOL r = TRUE;
    char Step = 'a';

    /* Wait for go
     */
    Delay(20 * 0x10000); // NB: about 1 sec

    r &= ComPortReset(DxPort, 38400, DxPortNo, TRUE);
    if (r) {
        Puts("Usart Seems ok.\n");
        Step++;
    } else
        Puts("Usart FAILED\n");

    r &= TestDivision(16);
    r &= TestDivision(10);

    /* END: all is well?
     */ 
    if (!r) goto error;
    Puts("DIV/MUL TEST PASSED SUCCESSFULLY\n");
    return;

error:
    Puts("TEST FAILED at Step=");
    PutChar(Step);
    Puts("\n");
    return;
}
