#include <mips/mips_asm.h>
#define __ASSEMBLER__ 1
#include <mips/ml40x.h>

        _EXPORT(start)
        
        .set noreorder
        .set noat
        .set nomacro

ENTRY(start)
    jal   PutChar
    li    $a0,'?'
start2:
    jal   GetChar
    nop
    blez  $v0,start
    li    $s0,'q'

    jal   PutChar
    or    $a0,$v0,$zero

    bne   $a0,$s0,start2
    nop

    /* Test succeeded, disable interrupts and download the next one
     */
    li     $t0,0x1260ff00
    mtc0   $t0,$cp0_status

    lui    $t0,(BRAM_DEFAULT_ADDRESS>>16) // nb: knows about 16bit chop
	jr     $t0
    nop

END(start)

/* int GetChar(void);
 * Returns: a non-negative value if ok, -1 otherwise
 */
ENTRY(GetChar)
    lui    $t0,(USART_DEFAULT_ADDRESS>>16) // nb: knows about 16bit chop
    lui    $t1,1000          // n*65k spins max
_LABEL(RxNotReady)
    lw     $t4,USARTST($t0)       // ChannelStatus
    andi   $t4,$t4,USI_RXRDY
    bgtz   $t4,_L(GotByte)
    subu   $t1,$t1,1
    // still ok to spin?
    bgtz   $t1,_L(RxNotReady)
    nop
    /* Timed out
     */
    jr     $ra
    li     $v0,-1

    /* Gottabyte
     */
_LABEL(GotByte)
    lw     $v0,USARTRX($t0)        // RxData
    jr     $ra
    andi   $v0,0xff
END(GetChar)

/* int PutChar(UINT8 v);
 * Returns: 0 if ok, -1 otherwise
 */
ENTRY(PutChar)
    lui    $t0,(USART_DEFAULT_ADDRESS>>16) // nb: knows about 16bit chop
    lui    $t1,1000          // n*65k spins max
    li     $v0,0
_LABEL(TxNotReady)
    lw     $t4,USARTST($t0)       // ChannelStatus
    andi   $t4,$t4,USI_TXRDY
    bgtz   $t4,_L(TxReady)
    subu   $t1,$t1,1
    // still ok to spin?
    bgtz   $t1,_L(TxNotReady)
    nop
    /* Timed out
     */
    jr     $ra
    li     $v0,-1

    /* Send it
     */
_LABEL(TxReady)
    jr     $ra
    sw     $a0,USARTTX($t0)

END(PutChar)
