#include "print.h"
#include <mips\ml40x.h>

#define TheFlash ((struct _Flash  *)FLASH_0_DEFAULT_ADDRESS)
#define FlashSpace 0xf0000000

void DumpUint32(char *What, UINT32 Value)
{
    Puts(What);
    PutWord(Value);
    PutChar('\n');
}

void DumpFLASHRegisters(void)
{
    Puts("-- FLASH --\n");
    DumpUint32("Tag=",TheFlash->BaseAddressAndTag);
    DumpUint32("Control=",TheFlash->Control);
}

void main(char *StackPointer)
{
    char Step = 'a'-1;
    int i, n;
	UINT32 *data;
    volatile UINT32 x, y;
    UINT32 psr;

    /* Wait for go
     */
    Delay(20 * 0x10000); // NB: about 1 sec

    /* Test utils */
    Step++;

    DumpUint32("HiMom! sp=", (UINT32)StackPointer);

    /* Check the tags, bail out if wrong
     */
    Step++;

	if ((TheFlash->BaseAddressAndTag & 0x0000ffff) != PMTTAG_FLASH) {
        DumpUint32("?FlashTag=", TheFlash->BaseAddressAndTag);
        goto error;
    }

    /* Dump all initial register values
     */
    Step++;

    DumpFLASHRegisters();

	Step++;

	TheFlash->Control = FLASHST_RESET_CONTROLLER;

	Delay(10);

	if ((TheFlash->BaseAddressAndTag & 0x0000ffff) != PMTTAG_FLASH) {
        DumpUint32("?FlashTag=", TheFlash->BaseAddressAndTag);
        goto error;
    }
	if ((TheFlash->BaseAddressAndTag & 0xffff0000) != FlashSpace) {
        DumpUint32("?FlashAddress=", TheFlash->BaseAddressAndTag);
        goto error;
    }
	if (TheFlash->Control != 0x0080800b) {
        DumpUint32("?1FlashControl=", TheFlash->Control);
        goto error;
    }

	TheFlash->Control = TheFlash->Control | FLASHST_RESET_PIN;

	Delay(10);

	if (TheFlash->Control != 0x0080801b) {
        DumpUint32("?2FlashControl=", TheFlash->Control);
        goto error;
    }

	DumpFLASHRegisters();

	/*Step++;

	TheFlash->Control = TheFlash->Control | 0xf;

	Delay(1000);

	DumpFLASHRegisters();*/

	/*Step++;

	Puts("Put FLASH in READ MODE\n");
	data = (UINT32*)(FlashSpace);
	x = 0xff00ff00;
	*data = x;*/

	Step++;

	Puts("Gathering Device Information\n");
	data = (UINT32*)(FlashSpace);
	x = 0x90909090;
	*data = x;
	Delay(0);
	x = *data;
	DumpUint32("Manufacturer Code=",x);
    /* Should be a Intel part, paired */
    if (x != 0x89008900) {
        Puts("Unexpected Manufacturer code, interface broken?\n");
        goto error;
    }

	data = (UINT32*)(FlashSpace | 0x4);
	x = 0x90909090;
	*data = x;
	Delay(0);
	x = *data;
	DumpUint32("Device Code=",x);
    /* Should be an Intel Strataflash 28F320, paired */
    if (x != 0x16001600) {
        Puts("Unexpected Device Code, interface broken?\n");
        goto error;
    }

    /* Put the flash back in read-array mode 
     */
	Puts("Restoring flash state\n");
	data = (UINT32*)(FlashSpace);
	x = 0xffffffff;
	*data = x;

	Puts("Current flash content:\n");
	DumpUint32("FLASH[0]=",data[0]);
	DumpUint32("FLASH[1]=",data[1]);
	DumpUint32("FLASH[2]=",data[2]);
	DumpUint32("FLASH[3]=",data[3]);
	Puts("...\n");

    /* END: all is well
     */ 
    Puts("TEST PASSED SUCCESSFULLY\n");
	return;

	error:
    Puts("TEST FAILED at Step=");
    PutChar(Step);
    Puts("\n");
    return;
}
