#include "print.h"
#include <mips\ml40x.h>

#define TheGPIO ((struct _Pio  *)GPIO_DEFAULT_ADDRESS)

void DumpUint32(char *What, UINT32 Value)
{
    Puts(What);
    PutWord(Value);
    PutChar('\n');
}

void DumpGPIORegisters(void)
{
    Puts("\n-- GPIO --\n");
    DumpUint32("Tag=",TheGPIO->Tag);
	DumpUint32("Enable=",TheGPIO->Enable);
	DumpUint32("Direction=",TheGPIO->Direction);
	DumpUint32("PinData=",TheGPIO->PinData);
	DumpUint32("IntrEnable=",TheGPIO->IntrEnable);
	DumpUint32("IntrStatus=",TheGPIO->IntrStatus);
	DumpUint32("IntrTrigger=",TheGPIO->IntrTrigger);
	DumpUint32("IntrNotLevel=",TheGPIO->IntrNotLevel);
}

void main(char *StackPointer)
{
    char Step = 'a'-1;
    int i, j, k, n;
	UINT32 *data;
    volatile UINT32 x, y;
    UINT32 psr;

    /* Wait for go
     */
    Delay(20 * 0x10000); // NB: about 1 sec

    /* Test utils */
    Step++;

    DumpUint32("HiMom! sp=", (UINT32)StackPointer);

    /* Check the tags, bail out if wrong
     */
    Step++;

	if (TheGPIO->Tag != PMTTAG_GPIO) {
        DumpUint32("?GPIOTag=", TheGPIO->Tag);
        goto error;
    }

    /* Dump all initial register values
     */
    Step++;

    DumpGPIORegisters();

	Step++;

	Puts("\nClearing All\n");

	TheGPIO->Disable = 0xffffffff;
	TheGPIO->OutDisable = 0xffffffff;
	TheGPIO->ClearData = 0xffffffff;
	TheGPIO->IntrDisable = 0xffffffff;
	TheGPIO->IntrStatus = 0xffffffff;
	TheGPIO->IntrTrigger = 0x00000000;
	TheGPIO->IntrNotLevel = 0x00000000;

	if (TheGPIO->Tag != PMTTAG_GPIO) {
        DumpUint32("?GPIOTag=", TheGPIO->Tag);
        goto error;
    }
	if (TheGPIO->Enable != 0) {
        DumpUint32("?GPIOEnable=", TheGPIO->Enable);
        goto error;
    }
	if (TheGPIO->Direction != 0) {
        DumpUint32("?GPIODirection=", TheGPIO->Direction);
        goto error;
    }
	if (TheGPIO->PinData != 0) {
        DumpUint32("?GPIOPinData=", TheGPIO->PinData);
        goto error;
    }
	if (TheGPIO->IntrEnable != 0) {
        DumpUint32("?GPIOIntrEnable=", TheGPIO->IntrEnable);
        goto error;
    }
	if (TheGPIO->IntrTrigger != 0) {
        DumpUint32("?GPIOIntrTrigger=", TheGPIO->IntrTrigger);
        goto error;
    }
	if (TheGPIO->IntrNotLevel != 0) {
        DumpUint32("?GPIOIntrNotLevel=", TheGPIO->IntrNotLevel);
        goto error;
    }

	DumpGPIORegisters();

	Step++;

	Puts("\nStrobe Enable\n");

	//DumpUint32("Enable=", TheGPIO->Enable);
	for(i=0;i<32;i++)
	{
		Delay(0x10000);
		TheGPIO->Enable = (1<<i);
		//DumpUint32("Enable=", TheGPIO->Enable);
		PutChar('.');
		if ((TheGPIO->Enable & (1<<i)) == 0) goto error;
	}
	for(i=0;i<32;i++)
	{
		Delay(0x10000);
		TheGPIO->Disable = (1<<i);
		//DumpUint32("Enable=", TheGPIO->Enable);
		PutChar('.');
		if ((TheGPIO->Enable & (1<<i)) > 0) goto error;
	}

	Step++;

	Puts("\nStrobe Direction\n");

	//DumpUint32("Direction=", TheGPIO->Direction);
	for(i=0;i<32;i++)
	{
		Delay(0x10000);
		TheGPIO->Direction = (1<<i);
		//DumpUint32("Direction=", TheGPIO->Direction);
		PutChar('.');
		if ((TheGPIO->Direction & (1<<i)) == 0) goto error;
	}
	for(i=0;i<32;i++)
	{
		Delay(0x10000);
		TheGPIO->OutDisable = (1<<i);
		//DumpUint32("Direction=", TheGPIO->Direction);
		PutChar('.');
		if ((TheGPIO->Direction & (1<<i)) > 0) goto error;
	}

	Step++;

	Puts("\nStrobe PinData\n");

	//DumpUint32("PinData=", TheGPIO->PinData);
	for(i=0;i<32;i++)
	{
		Delay(0x10000);
		TheGPIO->PinData = (1<<i);
		//DumpUint32("PinData=", TheGPIO->PinData);
		PutChar('.');
		if ((TheGPIO->PinData & (1<<i)) == 0) goto error;
	}
	for(i=0;i<32;i++)
	{
		Delay(0x10000);
		TheGPIO->ClearData = (1<<i);
		//DumpUint32("PinData=", TheGPIO->PinData);
		PutChar('.');
		if ((TheGPIO->PinData & (1<<i)) > 0) goto error;
	}

	Step++;

	Puts("\nStrobe IntrEnable\n");

	//DumpUint32("IntrEnable=", TheGPIO->IntrEnable);
	for(i=0;i<32;i++)
	{
		Delay(0x10000);
		TheGPIO->IntrEnable = (1<<i);
		//DumpUint32("IntrEnable=", TheGPIO->IntrEnable);
		PutChar('.');
		if ((TheGPIO->IntrEnable & (1<<i)) == 0) goto error;
	}
	for(i=0;i<32;i++)
	{
		Delay(0x10000);
		TheGPIO->IntrDisable = (1<<i);
		//DumpUint32("IntrEnable=", TheGPIO->IntrEnable);
		PutChar('.');
		if ((TheGPIO->IntrEnable & (1<<i)) > 0) goto error;
	}

	Step++;

	Puts("\nStrobe IntrTrigger\n");

	//DumpUint32("IntrTrigger=", TheGPIO->IntrTrigger);
	for(i=0;i<32;i++)
	{
		Delay(0x10000);
		TheGPIO->IntrTrigger = (1<<i) | TheGPIO->IntrTrigger;
		//DumpUint32("IntrTrigger=", TheGPIO->IntrTrigger);
		PutChar('.');
		if ((TheGPIO->IntrTrigger & (1<<i)) == 0) goto error;
	}
	for(i=0;i<32;i++)
	{
		Delay(0x10000);
		TheGPIO->IntrTrigger = ~(1<<i) & TheGPIO->IntrTrigger;
		//DumpUint32("IntrTrigger=", TheGPIO->IntrTrigger);
		PutChar('.');
		if ((TheGPIO->IntrTrigger & (1<<i)) > 0) goto error;
	}

	Step++;

	Puts("\nStrobe IntrNotLevel\n");

	//DumpUint32("IntrNotLevel=", TheGPIO->IntrNotLevel);
	for(i=0;i<32;i++)
	{
		Delay(0x10000);
		TheGPIO->IntrNotLevel = (1<<i) | TheGPIO->IntrNotLevel;
		//DumpUint32("IntrNotLevel=", TheGPIO->IntrNotLevel);
		PutChar('.');
		if ((TheGPIO->IntrNotLevel & (1<<i)) == 0) goto error;
	}
	for(i=0;i<32;i++)
	{
		Delay(0x10000);
		TheGPIO->IntrNotLevel = ~(1<<i) & TheGPIO->IntrNotLevel;
		//DumpUint32("IntrNotLevel=", TheGPIO->IntrNotLevel);
		PutChar('.');
		if ((TheGPIO->IntrNotLevel & (1<<i)) > 0) goto error;
	}

	Step++;

	Puts("\nStrobe Enable, Direction & PinData\n");

	//DumpUint32("Enable=", TheGPIO->Enable);
	//DumpUint32("\tDirection=", TheGPIO->Direction);
	//DumpUint32("\t\tPinData=", TheGPIO->PinData);

	for(i=0;i<32;i++)
	{
		TheGPIO->Enable = (1<<i);
		//DumpUint32("Enable=", TheGPIO->Enable);
		for (j=0;j<32;j++)
		{
			TheGPIO->Direction = (1<<j);
			//DumpUint32("\tDirection=", TheGPIO->Direction);
			for (k=0;k<32;k++)
			{
				TheGPIO->PinData = (1<<k);
				//DumpUint32("\t\tPinData=", TheGPIO->PinData);
				//DumpUint32("\t\t\tPinStatus=", TheGPIO->PinStatus);
				if ((k == i) && (k == j))
				{
					if  ((TheGPIO->PinStatus & (1<<k)) == 0) goto error;
				}
				else if (k == i)
				{
					if  ((TheGPIO->PinStatus & (1<<k)) > 0) goto error;
				}
				else
				{
					if  ((TheGPIO->PinStatus & (1<<k)) > 0) goto error;
				}
				if ((k == i) && (k == j)) Delay(5 * 20 * 0x10000);
				PutChar('.');
				TheGPIO->ClearData = (1<<k);
				//DumpUint32("\t\tPinData=", TheGPIO->PinData);
				//DumpUint32("\t\t\tPinStatus=", TheGPIO->PinStatus);
			}
			PutChar('\n');
			TheGPIO->OutDisable = (1<<j);
			//DumpUint32("\tDirection=", TheGPIO->Direction);
		}
		PutChar('\n');
		TheGPIO->Disable = (1<<i);
		//DumpUint32("Enable=", TheGPIO->Enable);
	}

	Puts("TEST PASSED SUCCESSFULLY\n");

	return;

	error:
	DumpGPIORegisters();
    Puts("TEST FAILED at Step=");
    PutChar(Step);
    Puts("\n");
    return;
}
