#include "print.h"
#include <mips\ml40x.h>

#define _bs32(x) x

/* try to repro Hostfs bug, by sending the request packet and causing a burst reply
 */

void PutBytes(UINT8 *Bytes, int nBytes)
{
    for ( ; nBytes-- > 0; ) {
        PutChar(*Bytes);
        Bytes++;
    }
}

#define TheAic ((struct _Aic *)INTERRUPT_CONTROLLER_DEFAULT_ADDRESS)
void SetIsr(void *Isr)
{
    /* Reset chip, disable all ints
     * Donno what to do for pending ones, sorry.
     */
    TheAic->IrqEnableClear = ~0;

    UserInterruptHandler = Isr;
    TheAic->IrqEnable = 1 << AIC_USART;
}

UINT8 HostfsRequest[] = {
 0x5b, 0x07, 0x02, 0x00, 0x00, 0x16, 0x43, 0x07, 0x00, 0x01,
 0xff, 0xff, 0x74, 0x7a, 0x6b, 0x2e, 0x65, 0x78, 0x65, 0x00,
 0x5d, 0xe7, 0x04
};

#define TheUsart ((struct _Usart *)USART_DEFAULT_ADDRESS)

UINT8 HostfsReply[128] = {0,};
UINT32 HostfsReplyPointer = 0;

BOOL UsartError = FALSE;
UINT FramingErrors = 0;
#define USI_ERRORS (USI_RXBRK|USI_OVRE/*|USI_FRAME*/|USI_PARE)

/* Return zero to keep interrupts off, the argument otherwise */
PCXTINFO UsartIsr(PCXTINFO Context)
{
    UINT32 s;

    /* Check status
00000252 = TXRDY ENDTX FRAME TXEMPTY
     */
    s = TheUsart->ChannelStatus;
    if (s & USI_ERRORS) {
        goto Error;
    }
    if ((s & USI_RXRDY) == 0) {
        goto Error;
    }
    if (s & USI_FRAME)
        FramingErrors++;

    /* Pick the byte
     */
    HostfsReply[HostfsReplyPointer++] = TheUsart->RxData;

    /* Done, re-enable interrupts
     */
    return Context;

    /* Error, keep interrupts off and say what
     */
 Error:
    PutWord(s); PutChar(' '); PutChar(0);
    UsartError = TRUE;
    Context->sr &= ~0x14;
    return Context;
}

void UsartInit(void)
{
    UINT32 psr;

    TheUsart->IntrEnable = USI_RXRDY | USI_ERRORS;

    SetIsr(UsartIsr);

    /* enable interrupts, drop BEV */
    psr = GetPsr();
    psr |= 1;
    psr &= ~0x00400000;
#if 1
    SetPsr(psr);
#endif
}

void main(char *StackPointer)
{
    int i, b;

    /* Wait fro go
     */
    (void) GetChar();

    UsartInit();

    for (i = 0; i < 5; i++) {
        /* Send request
         */
        PutBytes(HostfsRequest, sizeof(HostfsRequest));

        /* Get ready for next 
         */
        HostfsRequest[3] += 1; /* sequence number */
        HostfsRequest[21] += 1; /* checksum */

        /* Wait for reply
         */
        Delay(100 * 0x10000); // NB: about 5 sec

        /* Check reply
         */
        if (UsartError)
            goto Error;

        PutChar(0); PutWord(FramingErrors); PutChar(0);
        PutChar(0); PutWord(HostfsReplyPointer); PutChar(0);
        if (HostfsReplyPointer > sizeof(HostfsRequest))
            HostfsReplyPointer = sizeof(HostfsRequest);
        for (b = 0; b < HostfsReplyPointer; b++)
            PutChar(HostfsReply[b]);
        PutChar(0);
        /*
SerialOutput:  3 1 0 c 0 0 0 0 10 1f 7b 0
B6e B42 B79 B74 B65 B73 B3d B30 B30 B30 B30 B30 B30 B30 B66 Ba --nBytes=f
   B42 B56 B75 B1 
   B5b Bd0 B1 Bc B28 B10 B10 Bb4 B1 B5d B3 B3 Ba 
B5b B7 B2 B1 B0 B16 B43 B7 B0 B1 Bff Bff B74 B7a B6b B2e B65 B78 B65 B0 B5d Be8 B4

SerialOutput:  3 2 0 c 0 0 0 0 38 1f 7b 0
B6e B42 B79 B74 B65 B73 B3d B30 B30 B30 B30 B30 B30 B30 B62 Ba --nbytes=b
   B5b Bd0 B2 Bc B28 B10 B38 Bb4 B1 B5d B1e B1e Ba 
B5b B7 B2 B2 B0 B16 B43 B7 B0 B1 Bff Bff B74 B7a B6b B2e B65 B78 B65 B0 B5d Be9 B4

SerialOutput:  3 3 0 c 0 0 0 0 60 1f 7b 0
B6e B42 B79 B74 B65 B73 B3d B30 B30 B30 B30 B30 B30 B30 B62 Ba --nbytes=b
   B5b Bd0 B3 Bc B28 B10 B60 Bb4 B1 B5d B14 B14 Ba 
B5b B7 B2 B3 B0 B16 B43 B7 B0 B1 Bff Bff B74 B7a B6b B2e B65 B78 B65 B0 B5d Bea B4

SerialOutput:  3 4 0 c 0 0 0 0 88 1f 7b 0
B6e B42 B79 B74 B65 B73 B3d B30 B30 B30 B30 B30 B30 B30 B62 Ba --nbytes=b
   B5b Bd0 B4 Bc B28 B10 B88 Bb4 B1 B5d B4e B4e Ba 
B5b B7 B2 B4 B0 B16 B43 B7 B0 B1 Bff Bff B74 B7a B6b B2e B65 B78 B65 B0 B5d Beb B4

SerialOutput:  3 5 0 c 0 0 0 0 b0 1f 7b 0
B6e B42 B79 B74 B65 B73 B3d B30 B30 B30 B30 B30 B30 B30 B62 Ba --nbytes=b
   B5b Bd0 B5 Bc B28 B10 Bb0 Bb4 B1 B5d Bac Bac Ba 
B44 B6f B6e B65 Ba --Done


           42 56 75 01 
SerialOutput:  03 01 00 0c 00 00 00 00 10 1f 7b 00
            5b d0 01 0c 28 10 10 b4 01 5d 03 03 
SerialOutput:  03 02 00 0c 00 00 00 00 38 1f 7b 00
            5b d0 02 0c 28 10 38 b4 01 5d 1e 1e
SerialOutput:  03 03 00 0c 00 00 00 00 60 1f 7b 00
            5b d0 03 0c 28 10 60 b4 01 5d 14 14
SerialOutput:  03 04 00 0c 00 00 00 00 88 1f 7b 00
            5b d0 04 0c 28 10 88 b4 01 5d 4e 4e
SerialOutput:  03 05 00 0c 00 00 00 00 b0 1f 7b 00
            5b d0 05 0c 28 10 b0 b4 01 5d ac ac
         */

        /* Get ready for next 
         */
        HostfsReplyPointer = 0;
        FramingErrors = 0;
    }

    Puts("Done\n");
    return;

 Error:
    for (i = 0; i < 20; i++)
        Puts("Error detected, terminating test\n");
    return;
}
