#include "print.h"
#include <mips\ml40x.h>

/* Answer back what we get via interrupts
 */

void PutBytes(UINT8 *Bytes, int nBytes)
{
    for ( ; nBytes-- > 0; ) {
        PutChar(*Bytes);
        Bytes++;
    }
}

#define TheAic ((struct _Aic *)INTERRUPT_CONTROLLER_DEFAULT_ADDRESS)
void SetIsr(void *Isr)
{
    /* Reset chip, disable all ints
     * Donno what to do for pending ones, sorry.
     */
    TheAic->IrqEnableClear = ~0;

    UserInterruptHandler = Isr;
    TheAic->IrqEnable = 1 << AIC_USART;
}

#define TheUsart ((struct _Usart *)USART_DEFAULT_ADDRESS)

UINT8 HostReply[128] = {0,};
UINT32 HostReplyPointer = 0;

BOOL UsartError = FALSE;
UINT FramingErrors = 0;
UINT BreakErrors = 0;
#define USI_ERRORS (/*USI_RXBRK|*/USI_OVRE/*|USI_FRAME*/|USI_PARE)

/* Return zero to keep interrupts off, the argument otherwise */
PCXTINFO UsartIsr(PCXTINFO Context)
{
    UINT32 s;

    /* Check status
00000252 = TXRDY ENDTX FRAME TXEMPTY
00000217 = RXRDY TXRDY RXBRK ENDTX TXEMPTY
     */
    s = TheUsart->ChannelStatus;
    if (s & USI_ERRORS) {
        goto Error;
    }
    if (s & USI_FRAME)
        FramingErrors++;
    if (s & USI_RXBRK)
        BreakErrors++;

    if ((s & USI_RXRDY) == 0) {
        goto Error;
    }

    /* Pick the byte
     */
    HostReply[HostReplyPointer++] = TheUsart->RxData;

    /* Done, re-enable interrupts
     */
    return Context;

    /* Error, keep interrupts off and say what
     */
 Error:
    PutWord(s); PutChar(' '); PutChar(0);
    UsartError = TRUE;
    Context->sr &= ~0x14;
    return Context;
}

void UsartInit(void)
{
    UINT32 psr;

    TheUsart->IntrEnable = USI_RXRDY | USI_ERRORS;

    SetIsr(UsartIsr);

    /* enable interrupts, drop BEV */
    psr = GetPsr();
    psr |= 1;
    psr &= ~0x00400000;
#if 1
    SetPsr(psr);
#endif
}

void main(char *StackPointer)
{
    int i, b;

    UsartInit();

    for (i = 0; i < 5; i++) {

        /* Wait for reply
         */
        Delay(20 * 0x10000); // NB: about 1 sec

        /* Check reply
         */
        if (UsartError)
            goto Error;

        if (HostReplyPointer > sizeof(HostReply))
            HostReplyPointer = sizeof(HostReply);

        /* Send it back (slowly)
         */
        for (b = 0; b < HostReplyPointer; b++)
            PutChar(HostReply[b]);

        /* Get ready for next 
         */
        HostReplyPointer = 0;
    }

    if (FramingErrors) {
        Puts("f=");PutWord(FramingErrors);PutChar('\n');
    }

    if (BreakErrors) {
        Puts("b=");PutWord(BreakErrors);PutChar('\n');
    }

    Puts("Done\n");
    return;

 Error:
    for (i = 0; i < 20; i++)
        Puts("Error detected, terminating test\n");
    return;
}
