/* Test the timer with a poor man's scheduler
 */
#include "print.h"
#include <mips\ml40x.h>

/* Debug
 */
#if 0
void Bum(char *msg, void * v)
{
    Puts(msg);PutWord((UINT32)v);PutChar('\n');
}
#else
#define Bum(x,y)
#endif

/* Alloc-once
 */
void *malloc(UINT nBytes)
{
    static char *CurrentTop = NULL;
    char *New;

    if (CurrentTop == NULL)
        CurrentTop = (char *)(((UINT32)_end + 4 + 7) & ~7);

    nBytes = (nBytes + 7) & ~7;/* roundup to double-word */
    New = CurrentTop;
    CurrentTop = New + nBytes;
    Bum("malloc=",New);
    return New;
}

/* Threads are..
 */
#define STACK_SIZE 1024 /* bytes */
typedef struct _THREAD {
    void *NextThread; /* NB: MUST be first, else first thread not schedulable */
    PCXTINFO Context;
    char Stack[8]; /* more follows */
} THREAD, *PTHREAD;

/* List of running ones
 */
PTHREAD AllThreads = NULL;

/* Currently running one
 */
PTHREAD CurrentThread = NULL;

/* Constructor
 */
PTHREAD CreateThread(void *Start, void *Arg)
{
    PTHREAD New = malloc(sizeof(THREAD)+STACK_SIZE-8);
    PCXTINFO Context;

    Context = (PCXTINFO) New->Stack; /* e.g. bottom of the stack */
    Context->pc = (UINT32) Start;
    Context->sr = (GetPsr() | 5) & ~0x00400000;
    Context->gpr[4] = (UINT32)Arg;
    Context->gpr[29] = (UINT32)New->Stack + STACK_SIZE - 8;

    New->Context = Context;

    /* Add to list of runnables */
    New->NextThread = AllThreads;
    AllThreads = New;

    Bum("New->Next=",New->NextThread);

    /* Done */
    return New;
}

/* Bootstrapper
 */
PTHREAD CreateFirstThread(PCXTINFO Context)
{
    PTHREAD New = malloc(sizeof(THREAD)-8);

    New->Context = Context;

    /* Add to list of runnables */
    New->NextThread = AllThreads;
    AllThreads = New;

    Bum("New->Next=",New->NextThread);

    /* Done */
    return New;
}

/* 'Scheduler' proper
 */
PCXTINFO Reschedule(PCXTINFO Context)
{
    CurrentThread->Context = Context;
    CurrentThread = CurrentThread->NextThread;
    if (CurrentThread == NULL)
        CurrentThread = AllThreads;
    return CurrentThread->Context;
}

/* Interrupt controller
 */
#define TheAic ((struct _Aic *)INTERRUPT_CONTROLLER_DEFAULT_ADDRESS)
void SetIsr(void *Isr, int IntNo)
{
    /* Reset chip, disable all ints
     * Donno what to do for pending ones, sorry.
     */
    TheAic->IrqEnableClear = ~0;

    UserInterruptHandler = Isr;
    TheAic->IrqEnable = 1 << IntNo;
}

/* Timer management
 */
#define ThePit ((struct _Tc *)TIMER_DEFAULT_ADDRESS)
#define TIMESLICE (400*1000*10) /* 400msecs @10Mhz */

int nInterrupts = 0;

PCXTINFO TimerIsr(PCXTINFO Context)
{
    volatile UINT32 x;

    /* Do scheduling work */
    nInterrupts++;
    Context = Reschedule(Context);

    /* Ack interrupt
     */
    x = ThePit->Control;

    /* Re-start the counter */
    ThePit->DownCounterHigh = 0;
    ThePit->DownCounter = TIMESLICE;

    /* Done, re-enable interrupts
     */
    return Context;
}

void TimerInit(void)
{
    UINT32 psr;

    /* Clear up any pending decrementer interrupts, initialize boot time
     */
    ThePit->Control = TCCT_RESET;

    /* Install the ISR */
    SetIsr(TimerIsr, AIC_TIMER);

    /* Start the counter */
    ThePit->DownCounterHigh = 0;
    ThePit->DownCounter = TIMESLICE;
    ThePit->Control = TCCT_ENABLE | TCCT_INT_ENABLE;

    /* enable interrupts, drop BEV */
    psr = GetPsr();
    psr |= 1;
    psr &= ~0x00400000;
    SetPsr(psr);
}

/* Main
 */
BOOL test(void); /* forward */

void main(char *StackPointer)
{

    /* Wait for serplex to start so we dont lose output 
     */
    Delay(20 * 0x10000); // NB: about 1 sec
    Bum("sp=",StackPointer);

    /* Init the 'thread' package
     */
    CurrentThread = CreateFirstThread(NULL);

    /* Start the timer going
     */
    TimerInit();

    /* Create&run the application threads
     * If this returns the test has passed/failed as indicated.
     */
    if (test())
        Puts("TEST PASSED SUCCESSFULLY\n");
    else
        Puts("TEST FAILED\n");

}

