#include <mips/mips_asm.h>
#define __ASSEMBLER__ 1
#include <mips/ml40x.h>

        _EXPORT(start)
        
        .set noreorder

ENTRY(start)
    /* Get a stack
     */
    la    $sp,StackTop

    /* Wait for go
     */
    jal   PutChar
    li    $a0,'?'
    jal   GetChar
    nop

    /* test utils */
    la    $a0,HiMom
    jal   Puts
    nop
    jal   PutWord
    move  $a0,$sp
    jal   PutChar
    li    $a0,'\n'

    /* Running counter for tests
     */
    li    $s0,'a'-1


    /* TEST1: Check the tag, bail out if wrong
     */
    lui   $s1,(INTERRUPT_CONTROLLER_DEFAULT_ADDRESS>>16)
    lw    $t1,AICT($s1)
    li    $t2,PMTTAG_INTERRUPT_CONTROLLER
    bne   $t1,$t2,error
    addiu $s0,$s0,1


    /* TEST2: Dump all registers
     */
    jal   DumpAicRegisters
    addiu $s0,$s0,1


    /* TEST3: Enable interrupts from the USART, see what happens
     */
    la    $a0,Enabling
    jal   Puts
    nop

    lui   $t0,(USART_DEFAULT_ADDRESS>>16) // nb: knows about 16bit chop
    li    $t1,USI_RXRDY|USI_TXRDY
    sw    $t1,USARTIE($t0)

    li    $t0,AIC_USART_BIT
    sw    $t0,AICEN($s1)

    jal   Delay
    lui   $a0,1

    la    $a0,Done
    jal   Puts
    nop

    jal   DumpAicRegisters
    addiu $s0,$s0,1


    /* TEST3: Disable interrupts from the USART, see what happens
     */
    la    $a0,Disabling
    jal   Puts
    nop

    lui   $t0,(USART_DEFAULT_ADDRESS>>16) // nb: knows about 16bit chop
    li    $t1,USI_RXRDY|USI_TXRDY
    sw    $t1,USARTID($t0)

    la    $a0,Done
    jal   Puts
    nop

    jal   DumpAicRegisters
    addiu $s0,$s0,1


    /* END: all is well
     */ 
    jal   PutChar
    li    $a0,'o'
    jal   PutChar
    li    $a0,'k'

error:
    jal   PutChar
    or    $a0,$s0,$zero
done:
	b     done
    nop

HiMom:     .asciiz "HiMom! sp="
Enabling:  .asciiz "Enabling interrupts for USART..."
Disabling: .asciiz "Disabling interrupts for USART..."
Done:      .asciiz "done.\n"

   .align 2
END(start)

/* void DumpAicRegisters(void);
 */
ENTRY(DumpAicRegisters)
    subu   $sp,$sp,4
    sw     $ra,0($sp)

#define DumpRegister(_n_,_o_) \
    la    $a0,_n_; \
    jal   Puts; \
    nop; \
    jal   PutWord; \
    lw    $a0,_o_($s1); \
    jal   PutChar; \
    li    $a0,'\n'; \

    DumpRegister(IrqStatus,AICS)
    DumpRegister(IrqRawStatus,AICRS)
    DumpRegister(IrqEnable,AICEN)
    DumpRegister(IrqEnableClear,AICEC)
#undef DumpRegister

    lw     $ra,0($sp)
    jr     $ra
    addiu  $sp,$sp,4

IrqStatus: .asciiz "IrqStatus="
IrqRawStatus: .asciiz "IrqRawStatus="
IrqEnable: .asciiz "IrqEnable="
IrqEnableClear: .asciiz "IrqEnableClear="

   .align 2
END(DumpAicRegisters)

        .set noreorder
        .set noat
        .set nomacro

/* int PutWord(UINT32 Word);
 * Returns: 0 if ok, -1 otherwise
 */
ENTRY(PutWord)
    subu   $sp,$sp,12
    sw     $s0,8($sp)
    sw     $s1,4($sp)
    sw     $ra,0($sp)

    or     $s1,$a0,$zero
    /* Spit all nibbles
     */
    li     $s0,8
_LABEL(PutWordLoop)
    srl    $a0,$s1,32-4
    li     $t0,10
    sltu   $t1,$a0,$t0
    bnez   $t1,Digit
    li     $a1,'0'
    subu   $a0,$a0,$t0
    li     $a1,'a'
Digit:
    sll    $s1,$s1,4
    jal    PutChar
    add    $a0,$a0,$a1

    subu   $s0,$s0,1
    bne    $v0,$zero,PutWordDone /* printed ok? */
    li     $v0,-1

    /* done yet? */
    bne    $s0,$zero,PutWordLoop
    nop

    /* done
     */
_LABEL(PutWordDoneOk)
    li     $v0,0
_LABEL(PutWordDone)
    lw     $ra,0($sp)
    lw     $s1,4($sp)
    lw     $s0,8($sp)
    jr     $ra
    addiu  $sp,$sp,12

END(PutWord)


/* int Puts(char *String);
 * Returns: 0 if ok, -1 otherwise
 */
ENTRY(Puts)
    subu   $sp,$sp,8
    sw     $s0,4($sp)
    sw     $ra,0($sp)

    or     $s0,$a0,$zero
    /* Spit all chars until zero
     */
_LABEL(PutsLoop)
    lbu    $a0,0($s0)
    addiu  $s0,$s0,1
    beq    $a0,$zero,PutsDoneOk
    nop
    jal    PutChar
    nop
    beq    $v0,$zero,PutsLoop
    nop

    /* Timed out
     */
    b      PutsDone
    li     $v0,-1

    /* done
     */
_LABEL(PutsDoneOk)
    li     $v0,0
_LABEL(PutsDone)
    lw     $ra,0($sp)
    lw     $s0,4($sp)
    jr     $ra
    addiu  $sp,$sp,8

END(Puts)


/* int GetChar(void);
 * Returns: a non-negative value if ok, -1 otherwise
 */
ENTRY(GetChar)
    lui    $t0,(USART_DEFAULT_ADDRESS>>16) // nb: knows about 16bit chop
    lui    $t1,1000          // n*65k spins max
_LABEL(RxNotReady)
    lw     $t4,USARTST($t0)       // ChannelStatus
    andi   $t4,$t4,USI_RXRDY
    bgtz   $t4,_L(GotByte)
    subu   $t1,$t1,1
    // still ok to spin?
    bgtz   $t1,_L(RxNotReady)
    nop
    /* Timed out
     */
    jr     $ra
    li     $v0,-1

    /* Gottabyte
     */
_LABEL(GotByte)
    lw     $v0,USARTRX($t0)        // RxData
    jr     $ra
    andi   $v0,0xff
END(GetChar)

/* int PutChar(UINT8 v);
 * Returns: 0 if ok, -1 otherwise
 */
ENTRY(PutChar)
    lui    $t0,(USART_DEFAULT_ADDRESS>>16) // nb: knows about 16bit chop
    lui    $t1,1000          // n*65k spins max
    li     $v0,0
_LABEL(TxNotReady)
    lw     $t4,USARTST($t0)       // ChannelStatus
    andi   $t4,$t4,USI_TXRDY
    bgtz   $t4,_L(TxReady)
    subu   $t1,$t1,1
    // still ok to spin?
    bgtz   $t1,_L(TxNotReady)
    nop
    /* Timed out
     */
    jr     $ra
    li     $v0,-1

    /* Send it
     */
_LABEL(TxReady)
    jr     $ra
    sw     $a0,USARTTX($t0)

END(PutChar)

/* void Delay(UINT32 count)
 */
ENTRY(Delay)
    bne    $a0,$zero,Delay
    subu   $a0,1
    j      $ra
    nop
END(Delay)

_LABEL(StackBase)
    .space 128
_LABEL(StackTop)
    .byte  0xba,0xdf,0x00,0xd0
