#include "print.h"
#include <mips\ml40x.h>

void bcopy(UINT8 *from, UINT8 *to, int nBytes)
{
    while (nBytes-- > 0)
        *to++ = *from++;
}

void scopy(UINT8 *from, UINT8 *to, int nBytes)
{
    UINT16 *wfrom = (UINT16*)from;
    UINT16 *wto = (UINT16*)to;
    int nShorts = (nBytes+1)/2;
    while (nShorts-- > 0)
        *wto++ = *wfrom++;
}

void wcopy(UINT8 *from, UINT8 *to, int nBytes)
{
    UINT32 *wfrom = (UINT32*)from;
    UINT32 *wto = (UINT32*)to;
    int nWords = (nBytes+3)/4;
    while (nWords-- > 0)
        *wto++ = *wfrom++;
}

void wzero(UINT8 *to, int nBytes)
{
    UINT32 *wto = (UINT32*)to;
    int nWords = (nBytes+3)/4;
    while (nWords-- > 0)
        *wto++ = 0;
    
}

char *TestString = "audiquattro\n";
BOOL Check(char *String)
{
    char *Truth = TestString;
    for (;*Truth;)
        if (*(Truth++) != *(String++))
            return FALSE;
    return TRUE;
}

void main(char *StackPointer)
{
    char buffer[16];

    /* Wait fro go
     */
    Delay(20 * 0x10000); // NB: about 1 sec

#define Dump() {Puts("\nBuffer=");PutWord(*(UINT32*)(buffer));PutChar('\n'); Puts(buffer); }

    wzero(buffer,16);
    bcopy(TestString,buffer,13);
    Dump();
    if (!Check(buffer)) goto error;

    wzero(buffer,16);
    scopy(TestString,buffer,13);
    Dump();
    if (!Check(buffer)) goto error;

    wzero(buffer,16);
    wcopy(TestString,buffer,13);
    Dump();
    if (!Check(buffer)) goto error;

    Puts("TEST PASSED SUCCESSFULLY\n");
    return;

error:
    Puts("TEST FAILED\n");
}
