#include "print.h"
#include <mips\ml40x.h>

#define TheSAC ((struct _Sac  *)IDE_DEFAULT_ADDRESS)

void DumpUint32(char *What, UINT32 Value)
{
    Puts(What);
    PutWord(Value);
    PutChar('\n');
}

void DumpMem(UINT32 Index, UINT32 Value)
{
	UINT8 byte;
    PutWord(Index);
	Puts(" : ");
    PutWord(Value);
	Puts("  ");
	byte = Value;
	PutChar(byte);
	//PutWord(byte);
	Puts(" ");
	byte = Value>>8;
	PutChar(byte);
	//PutWord(byte);
	Puts(" ");
	byte = Value>>16;
	PutChar(byte);
	//PutWord(byte);
	Puts(" ");
	byte = Value>>24;
	PutChar(byte);
	//PutWord(byte);
	Puts(" ");
    PutChar('\n');
}

void DumpMem2(UINT32 Index, UINT32 Value)
{
	UINT8 byte;
	byte = Value;
	PutChar(byte);
	byte = Value>>8;
	PutChar(byte);
	byte = Value>>16;
	PutChar(byte);
	byte = Value>>24;
	PutChar(byte);
}

void DumpMem3(UINT32 Index, UINT32 Value1, UINT32 Value2)
{
	UINT8 byte;
    PutWord(Index);
	Puts(" : ");

    PutWord(Value1);
	Puts("  ");
	byte = Value1;
	PutChar(byte);
	//PutWord(byte);
	Puts(" ");
	byte = Value1>>8;
	PutChar(byte);
	//PutWord(byte);
	Puts(" ");
	byte = Value1>>16;
	PutChar(byte);
	//PutWord(byte);
	Puts(" ");
	byte = Value1>>24;
	PutChar(byte);
	//PutWord(byte);
	Puts(" ");
    PutChar('\t');

	PutWord(Value2);
	Puts("  ");
	byte = Value2;
	PutChar(byte);
	//PutWord(byte);
	Puts(" ");
	byte = Value2>>8;
	PutChar(byte);
	//PutWord(byte);
	Puts(" ");
	byte = Value2>>16;
	PutChar(byte);
	//PutWord(byte);
	Puts(" ");
	byte = Value2>>24;
	PutChar(byte);
	//PutWord(byte);
	Puts(" ");
    PutChar('\n');
}

void *malloc(UINT nBytes)
{
    static char *CurrentTop = NULL;
    char *New;

    if (CurrentTop == NULL)
        CurrentTop = (char *)(((UINT32)_end + 4 + 7) & ~7);

    nBytes = (nBytes + 7) & ~7;/* roundup to double-word */
    New = CurrentTop;
    CurrentTop = New + nBytes;
    //Bum("malloc=",New);
    return New;
}

void DumpSACRegisters(void)
{
    Puts("\n-- SAC --\n");
    DumpUint32("Tag=",TheSAC->Tag);
    DumpUint32("Control=",TheSAC->Control);
	DumpUint32("BUSMODEREG=",TheSAC->BUSMODEREG);
	DumpUint32("STATUS=",TheSAC->STATUS);
	DumpUint32("ERRORREG=",TheSAC->ERRORREG);
	//DumpUint32("CFGLBAREG=",TheSAC->CFGLBAREG);
	//DumpUint32("MPULBAREG=",TheSAC->MPULBAREG);
	DumpUint32("SECCNTCMDREG=",TheSAC->SECCNTCMDREG);
	DumpUint32("VERSIONREG=",TheSAC->VERSIONREG);
	DumpUint32("CONTROLREG=",TheSAC->CONTROLREG);
	DumpUint32("FATSTATREG=",TheSAC->FATSTATREG);
}

void DumpSACFlags(void)
{
	UINT32 busmode, status, error, control;
	UINT16 seccntcmd, version, fatstat;

	Puts("\n-- SAC Flags --\n");
	busmode = TheSAC->BUSMODEREG;
	DumpUint32("BUSMODEREG=",busmode);
	if ((busmode & SAC_MODE16) > 0) Puts("16 bit mode\n");
	else Puts("8 bit mode\n");
	PutChar('\n');
	status = TheSAC->STATUS;
	DumpUint32("STATUS=",status);
	if ((status & SAC_CFGLOCK) > 0) Puts("Configuration Controller Lock\n");
	if ((status & SAC_MPULOCK) > 0) Puts("MPU Interface Lock\n");
	if ((status & SAC_CFGERROR) > 0) Puts("Configuration Controller Error\n");
	if ((status & SAC_CFCERROR) > 0) Puts("CompactFlash Controller Error\n");
	if ((status & SAC_CFDETECT) > 0) Puts("CompactFlash Detected\n");
	if ((status & SAC_DATABUFRDY) > 0) Puts("Data Buffer Ready\n");
	if ((status & SAC_DATABUFMODE) > 0) Puts("Data Buffer Read Only\n");
	else Puts("Data Buffer Write Only\n");
	if ((status & SAC_CFGDONE) > 0) Puts("Configuration Done\n");
	if ((status & SAC_RDYFORCFCMD) > 0) Puts("Ready For CompactFlash Command\n");
	if ((status & SAC_CFGMODEPIN) > 0) Puts("Automatically Start Configuration At ACE Controller Reset\n");
	else Puts("Wait For CFGSTART To Start Configuration\n");
	if ((status & SAC_CFGADDRPINS) == SAC_CFGADDR_0) Puts("Configuration Pins Select CFG0\n");
	if ((status & SAC_CFGADDRPINS) == SAC_CFGADDR_1) Puts("Configuration Pins Select CFG1\n");
	if ((status & SAC_CFGADDRPINS) == SAC_CFGADDR_2) Puts("Configuration Pins Select CFG2\n");
	if ((status & SAC_CFGADDRPINS) == SAC_CFGADDR_3) Puts("Configuration Pins Select CFG3\n");
	if ((status & SAC_CFGADDRPINS) == SAC_CFGADDR_4) Puts("Configuration Pins Select CFG4\n");
	if ((status & SAC_CFGADDRPINS) == SAC_CFGADDR_5) Puts("Configuration Pins Select CFG5\n");
	if ((status & SAC_CFGADDRPINS) == SAC_CFGADDR_6) Puts("Configuration Pins Select CFG6\n");
	if ((status & SAC_CFGADDRPINS) == SAC_CFGADDR_7) Puts("Configuration Pins Select CFG7\n");
	if ((status & SAC_CFBSY) > 0) Puts("CompactFlash Busy\n");
	if ((status & SAC_CFRDY) > 0) Puts("CompactFlash Ready For Operation\n");
	if ((status & SAC_CFDWF) > 0) Puts("CompactFlash Data Write Fault\n");
	if ((status & SAC_CFDSC) > 0) Puts("CompactFlash Ready\n");
	if ((status & SAC_CFDRQ) > 0) Puts("Data Ready To Be Transferred\n");
	if ((status & SAC_CFCORR) > 0) Puts("Correctable Error\n");
	if ((status & SAC_CFERR)> 0) Puts("CompactFlash Error\n");
	PutChar('\n');
	error = TheSAC->ERRORREG;
	DumpUint32("ERRORREG=",error);
	if ((error & SAC_CARDRESETERR) > 0) Puts("CompactFlash Card Reset Error\n");
	if ((error & SAC_CARDRDYERR) > 0) Puts("CompactFlash Card Ready Error\n");
	if ((error & SAC_CARDREADERR) > 0) Puts("CompactFlash Card Read Error\n");
	if ((error & SAC_CARDWRITEERR) > 0) Puts("CompactFlash Card Write Error\n");
	if ((error & SAC_SECTORRDYERR) > 0) Puts("CompactFlash Sector Ready Error\n");
	if ((error & SAC_CFGADDRERR) > 0) Puts("Not A Valid Configuration Address Error\n");
	if ((error & SAC_CFGFAILED) > 0) Puts("Configuration Failed Error\n");
	if ((error & SAC_CFGREADERR) > 0) Puts("Configuration Read Error\n");
	if ((error & SAC_CFGINSTRERR) > 0) Puts("Configuration Instruction Error\n");
	if ((error & SAC_CFGINITERR) > 0) Puts("Configuration INIT Monitor Error\n");
	if ((error & SAC_CFBBK) > 0) Puts("CompactFlash Bad Block Error\n");
	if ((error & SAC_CFUNC) > 0) Puts("CompactFlash Unrecoverable Error\n");
	if ((error & SAC_CFIDNF) > 0) Puts("CompactFlash ID Not Found Error\n");
	if ((error & SAC_CFABORT) > 0) Puts("CompactFlash Command Abort Error\n");
	if ((error & SAC_CFAMNF) > 0) Puts("CompactFlash General Error\n");
	PutChar('\n');
	seccntcmd = TheSAC->SECCNTCMDREG;
	DumpUint32("SECCNTCMDREG=",seccntcmd);
	if ((seccntcmd & SAC_SECCCNT) > 0) DumpUint32("Sector Count ",(TheSAC->SECCNTCMDREG & SAC_SECCCNT));
	if ((seccntcmd & SAC_CMD) == SAC_CMD_RESETMEMCARD) Puts("Command: Reset Memory Card\n");
	if ((seccntcmd & SAC_CMD) == SAC_CMD_IDENTIFYMEMCARD) Puts("Command: Identify Memory Card\n");
	if ((seccntcmd & SAC_CMD) == SAC_CMD_READMEMCARDDATA) Puts("Command: Read Memory Card\n");
	if ((seccntcmd & SAC_CMD) == SAC_CMD_WRITEMEMCARDDATA) Puts("Command: Write Memory Card\n");
	if ((seccntcmd & SAC_CMD) == SAC_CMD_ABORT) Puts("Command: Abort Command\n");
	PutChar('\n');
	version = TheSAC->VERSIONREG;
	DumpUint32("VERSIONREG=",version);
	DumpUint32("Revision/Build Number ",(version & SAC_VERREV));
	DumpUint32("Minor Version Number ",((version & SAC_VERMINOR)>>8));
	DumpUint32("Major Version Number ",((version & SAC_VERMAJOR)>>12));
	PutChar('\n');
	control = TheSAC->CONTROLREG;
	DumpUint32("CONTROLREG=",control);
	if ((control & SAC_FORCELOCKREQ) > 0) Puts("Force MPU Lock Request\n");
	if ((control & SAC_LOCKREQ) > 0) Puts("MPU Request Lock\n");
	if ((control & SAC_FORCECFGADDR) > 0) Puts("Force Use Control Register To Select Configuration\n");
	else Puts("Use CFGMODEPIN To Determine Configuration\n");
	if ((control & SAC_FORCECFGMODE) > 0) ("Force Use CFGMODE\n");
	else Puts("Use CFGMODEPIN\n");
	if ((control & SAC_CFGMODE) > 0) Puts("Automatically Start Configuration After ACE Controller Reset\n");
	else Puts("Wait for CFGSTART To Start Configuration");
	if ((control & SAC_CFGSTART) > 0) Puts("Start Configuration\n");
	if ((control & SAC_CFGSEL) > 0) Puts("Configure From CompactFlash\n");
	else Puts("Configure From MPU\n");
	if ((control & SAC_CFGRESET) > 0) Puts("Configuration/CompactFlash Controller Reset\n");
	if ((control & SAC_DATABUFRDYIRQ) > 0) Puts("Data Buffer Ready IRQ Enabled\n");
	if ((control & SAC_ERRORIRQ) > 0) Puts("Error IRQ Enabled\n");
	if ((control & SAC_CFGDONEIRQ) > 0) Puts("Configuration DONE IRQ Enabled\n");
	if ((control & SAC_RESETIRQ) > 0) Puts("Reset IRQ\n");
	if ((control & SAC_CFGPROG) > 0) Puts("Invert ACE Controller Pin Control\n");
	if ((control & SAC_CFGADDRBIT) == SAC_CFGADDR_0) Puts("Configuration Bits Select CFG0\n");
	if ((control & SAC_CFGADDRBIT) == SAC_CFGADDR_1) Puts("Configuration Bits Select CFG1\n");
	if ((control & SAC_CFGADDRBIT) == SAC_CFGADDR_2) Puts("Configuration Bits Select CFG2\n");
	if ((control & SAC_CFGADDRBIT) == SAC_CFGADDR_3) Puts("Configuration Bits Select CFG3\n");
	if ((control & SAC_CFGADDRBIT) == SAC_CFGADDR_4) Puts("Configuration Bits Select CFG4\n");
	if ((control & SAC_CFGADDRBIT) == SAC_CFGADDR_5) Puts("Configuration Bits Select CFG5\n");
	if ((control & SAC_CFGADDRBIT) == SAC_CFGADDR_6) Puts("Configuration Bits Select CFG6\n");
	if ((control & SAC_CFGADDRBIT) == SAC_CFGADDR_7) Puts("Configuration Bits Select CFG7\n");
	PutChar('\n');
	fatstat = TheSAC->FATSTATREG;
	DumpUint32("FATSTATREG=",fatstat);
	if ((fatstat & SAC_MBRVALID) > 0) Puts("Master Boot Record Valid\n");
	if ((fatstat & SAC_PBRVALID) > 0) Puts("Partition Boot Record Valid\n");
	if ((fatstat & SAC_MBRFAT12) > 0) Puts("Master Boot Record FAT12\n");
	if ((fatstat & SAC_PBRFAT12) > 0) Puts("Partition Boot Record FAT12\n");
	if ((fatstat & SAC_MBRFAT16) > 0) Puts("Master Boot Record FAT16\n");
	if ((fatstat & SAC_PBRFAT16) > 0) Puts("Partition Boot Record FAT16\n");
	if ((fatstat & SAC_CALCFAT12) > 0) Puts("Calculated FAT12\n");
	if ((fatstat & SAC_CALCFAT16) > 0) Puts("Calculated FAT16\n");
	PutChar('\n');
}

int syncmode(void)
{
	UINT32 busmode, control;

	Puts("\nSynching Interfaces\n");

	busmode = TheSAC->BUSMODEREG;
	control = TheSAC->Control;

	DumpUint32("BUSMODEREG=",busmode);
	DumpUint32("SAC-Control=",control);

	if ((busmode & SAC_MODE16) > 0)
	{
		TheSAC->Control = TheSAC->Control | SAC_BUS16;
		TheSAC->Control = TheSAC->Control & ~SAC_BUS8;
	}
	else
	{
		TheSAC->Control = TheSAC->Control | SAC_BUS8;
		TheSAC->Control = TheSAC->Control & ~SAC_BUS16;
	}

	busmode = TheSAC->BUSMODEREG;
	control = TheSAC->Control;

	DumpUint32("BUSMODEREG=",busmode);
	DumpUint32("SAC-Control=",control);

	if (((busmode & SAC_MODE16) == 0) && ((control & SAC_BUS8) == 0)) return 0;
	if (((busmode & SAC_MODE16) > 0) && ((control & SAC_BUS16) == 0)) return 0;
	return 1;
}

int mode8(void)
{
	UINT32 busmode, control;

	Puts("\nChanging to 8bit Mode\n");
	if (syncmode())
	{
		busmode = TheSAC->BUSMODEREG;
		DumpUint32("BUSMODEREG=",busmode);

		TheSAC->BUSMODEREG = 0x00000000;

		busmode = TheSAC->BUSMODEREG;
		DumpUint32("BUSMODEREG=",busmode);

		control = TheSAC->Control;
		DumpUint32("SAC-Control=",control);

		TheSAC->Control = TheSAC->Control | SAC_BUS8;
		TheSAC->Control = TheSAC->Control & ~SAC_BUS16;

		control = TheSAC->Control;
		DumpUint32("SAC-Control=",control);

		return syncmode();
	}
	return 0;
}

int mode16(void)
{
	UINT32 busmode, control;

	Puts("\nChanging to 16bit Mode\n");
	if (syncmode())
	{
		busmode = TheSAC->BUSMODEREG;
		DumpUint32("BUSMODEREG=",busmode);

		TheSAC->BUSMODEREG = 0x00000101;  //in 8bit mode the busmodereg is at 0x0 and 0x1

		busmode = TheSAC->BUSMODEREG;
		DumpUint32("BUSMODEREG=",busmode);

		control = TheSAC->Control;
		DumpUint32("SAC-Control=",control);

		TheSAC->Control = TheSAC->Control | SAC_BUS16;
		TheSAC->Control = TheSAC->Control & ~SAC_BUS8;

		control = TheSAC->Control;
		DumpUint32("SAC-Control=",control);

		return syncmode();
	}
	return 0;
}

int get_cflock(int timeout)
{
	UINT32 status, control;
	int ticks;

	Puts("\nRequesting MPU Interface Lock\n");

	status = TheSAC->STATUS;

	DumpUint32("STATUS=",status);
	if ((status & SAC_MPULOCK) > 0) Puts("MPU Interface Lock\n");

	control = TheSAC->CONTROLREG;

	DumpUint32("CONTROLREG=",control);
	if ((control & SAC_LOCKREQ) > 0) Puts("MPU Request Lock\n");

	TheSAC->CONTROLREG = control | SAC_LOCKREQ;

	control = TheSAC->CONTROLREG;

	DumpUint32("CONTROLREG=",control);
	if ((control & SAC_LOCKREQ) > 0) Puts("MPU Request Lock\n");

	for (ticks = timeout; ticks > 0; ticks--)
	{
		Delay(0x100000);
		DumpUint32("Ticks remaining ",ticks);

		status = TheSAC->STATUS;

		DumpUint32("STATUS=",status);
		if ((status & SAC_MPULOCK) > 0) Puts("MPU Interface Lock\n");
		if ((status & SAC_MPULOCK) > 0)
		{
			return 1;
		}
	}
	Puts("Time out attempting to get MPU Interface Lock\n");
	return 0;
}

int rel_cflock(int timeout)
{
	UINT32 status, control;
	int ticks;

	Puts("\nRelease MPU Interface Lock\n");

	status = TheSAC->STATUS;

	DumpUint32("STATUS=",status);
	if ((status & SAC_MPULOCK) > 0) Puts("MPU Interface Lock\n");

	control = TheSAC->CONTROLREG;

	DumpUint32("CONTROLREG=",control);
	if ((control & SAC_LOCKREQ) > 0) Puts("MPU Request Lock\n");

	TheSAC->CONTROLREG = control & ~SAC_LOCKREQ;

	control = TheSAC->CONTROLREG;

	DumpUint32("CONTROLREG=",control);
	if ((control & SAC_LOCKREQ) > 0) Puts("MPU Request Lock\n");

	for (ticks = timeout; ticks > 0; ticks--)
	{
		Delay(0x100000);
		DumpUint32("Ticks remaining ",ticks);

		status = TheSAC->STATUS;

		DumpUint32("STATUS=",status);
		if ((status & SAC_MPULOCK) > 0) Puts("MPU Interface Lock\n");
		if ((status & SAC_MPULOCK) == 0)
		{
			return 1;
		}
	}
	Puts("Time out attempting to release MPU Interface Lock\n");
	return 0;
}

int chk_commrdy(int timeout)
{
	UINT32 status;
	int ticks;

	Puts("\nChecking if SystemACE is Ready for Command\n");
	for (ticks = timeout; ticks > 0; ticks--)
	{
		Delay(0x100000);
		DumpUint32("Ticks remaining ",ticks);

		status = TheSAC->STATUS;

		DumpUint32("STATUS=",status);
		if ((status & SAC_RDYFORCFCMD) > 0) Puts("Ready For CompactFlash Command\n");
		if ((status & SAC_RDYFORCFCMD) > 0)
		{
			return 1;
		}
	}
	Puts("Time out checking SystemAce readiness \n");
	return 0;
}

int wait_bsy(int timeout)
{
	UINT32 status;
	int ticks;

	Puts("\nChecking if SystemACE is Busy\n");
	for (ticks = timeout; ticks > 0; ticks--)
	{
		Delay(0x100000);
		DumpUint32("Ticks remaining ",ticks);

		status = TheSAC->STATUS;

		DumpUint32("STATUS=",status);
		if ((status & SAC_CFBSY) > 0) Puts("CompactFlash Busy\n");
		if ((status & SAC_CFBSY) == 0)
		{
			return 1;
		}
	}
	Puts("Time out waiting for SystemACE to finish\n");
	return 0;
}

int wait_bufrdy(int timeout)
{
	UINT32 status;
	int ticks;

	Puts("\nWaiting for Buffer Ready\n");
	for (ticks = timeout; ticks > 0; ticks--)
	{
		Delay(0x100000);
		DumpUint32("Ticks remaining ",ticks);

		status = TheSAC->STATUS;

		DumpUint32("STATUS=",status);
		if ((status & SAC_DATABUFRDY) > 0) Puts("Data Buffer Ready\n");
		if ((status & SAC_DATABUFRDY) > 0) 
		{
			return 1;
		}
	}
	Puts("Time out waiting on data buffer\n");
	return 0;
}

UINT32 *rd_databuf(int wordcnt)
{
	int words;
	UINT32 idedata;
	UINT32 *data;

	Puts("\nReading Contents of SystemACE data buffer\n");
	if (wait_bufrdy(0x10))
	{
		data = (UINT32*)malloc(wordcnt*sizeof(UINT32));
		for (words = wordcnt; words > 0; words--)
		{	
			//Delay(0x1000000);
			idedata = TheSAC->DATABUFREG[0];
			DumpMem(wordcnt-words,idedata);
			data[wordcnt-words] = idedata;
		}
		return data;
	}
	Puts("Timed out waiting for buffer\n");
	return 0;
}

UINT32 *rd_datablock(int buffercnt, int wordcnt)
{
	int buffers, i;
	UINT32 idedata;
	UINT32 *data, *buffdata;

	Puts("\nReading Contents of CompactFlash data sector block\n");
	data = (UINT32*)malloc(wordcnt*buffercnt*sizeof(UINT32));
	for (buffers = buffercnt; buffers > 0; buffers--)
	{
		DumpUint32("buffers remaining ",buffers);
		//Delay(0x1000000);
		buffdata = rd_databuf(wordcnt);
		if (buffdata == NULL)
		{
			DumpUint32("Error Reading from Buffer ",buffercnt-buffers);
			return 0;
		}
		else
		{
			PutChar('\n');
			for (i = 0; i<wordcnt; i++)
			{
				idedata = buffdata[i];
				DumpMem(i+((buffercnt-buffers)*wordcnt),idedata);
				data[i+((buffercnt-buffers)*wordcnt)] = idedata;
			}
			PutChar('\n');
		}
	}
	return data;
}

UINT32 *rd_data(int blockcnt, int buffercnt, int wordcnt)
{
	int blocks, i;
	UINT32 idedata;
	UINT32 *data, *blockdata;

	Puts("\nReading CompactFlash data sector blocks\n");
	data = (UINT32*)malloc(blockcnt*buffercnt*wordcnt*sizeof(UINT32));
	for (blocks = blockcnt; blocks > 0; blocks--)
	{
		DumpUint32("blocks remaining ",blocks);
		blockdata = rd_datablock(buffercnt, wordcnt);
		if (blockdata == NULL)
		{
			DumpUint32("Error Reading from Block ",blockcnt-blocks);
			return 0;
		}
		else
		{
			PutChar('\n');
			for (i = 0; i<(buffercnt*wordcnt); i++)
			{
				idedata = blockdata[i];
				DumpMem(i+((blockcnt-blocks)*buffercnt*wordcnt),idedata);
				data[i+((blockcnt-blocks)*buffercnt*wordcnt)] = idedata;
			}
			PutChar('\n');
		}
	}
	return data;
}

int reset(void)
{
	UINT32 seccntcmd, control, status;

	Puts("\nResetting SystemACE\n");
	if (get_cflock(0x10))
	{
		if (chk_commrdy(0x10))
		{
			TheSAC->SECCNTCMDREG = SAC_CMD_RESETMEMCARD;
			TheSAC->CONTROLREG = SAC_LOCKREQ | SAC_FORCECFGMODE | SAC_CFGRESET;
			TheSAC->CONTROLREG = SAC_LOCKREQ | SAC_FORCECFGMODE;
			TheSAC->Control = TheSAC->Control | SAC_RST;
			if (syncmode())
			{
				if (wait_bsy(0x10))
				{
					if (rel_cflock(0x10))
					{
						Puts("Compact Flash Successfully Reset\n");
						return 1;
					}
					Puts("Error Releasing CompactFlash MPU Interface Lock\n");
					return 0;
				}
				Puts("Error Command did not complete\n");
				if (rel_cflock(0x10))
				{
					return 0;
				}
				Puts("Error Releasing CompactFlash MPU Interface Lock\n");
				return 0;
			}
			Puts("Error Synching Interfaces\n");
			if (rel_cflock(0x10))
			{
				return 0;
			}
			Puts("Error Releasing CompactFlash MPU Interface Lock\n");
			return 0;
		}
		Puts("Timed out while waiting SystemACE to become ready\n");
		if (rel_cflock(0x10))
		{
			return 0;
		}
		Puts("Error Releasing CompactFlash MPU Interface Lock\n");
		return 0;
	}
	Puts("Could not get CompactFlash MPU Interface Lock\n");
	return 0;
}

UINT32 *id_cf(int buffercnt, int wordcnt)
{
	UINT32 *data;
	UINT32 mpulba, seccntcmd, control;

	Puts("\nIdentifying CompactFlash Device\n");
	if (get_cflock(0x10))
	{
		if (chk_commrdy(0x10))
		{
			//TheSAC->MPULBAREG = startat;
			TheSAC->SECCNTCMDREG = SAC_CMD_IDENTIFYMEMCARD;

			control = TheSAC->CONTROLREG;

			DumpUint32("CONTROLREG=",control);
			if ((control & SAC_CFGRESET) > 0) Puts("Configuration/CompactFlash Controller Reset\n");

			TheSAC->CONTROLREG = control | SAC_CFGRESET;

			control = TheSAC->CONTROLREG;

			DumpUint32("CONTROLREG=",control);
			if ((control & SAC_CFGRESET) > 0) Puts("Configuration/CompactFlash Controller Reset\n");

			data = rd_data(1,buffercnt,wordcnt);
			if (data != NULL)
			{
				PutChar('\n');

				control = TheSAC->CONTROLREG;

				DumpUint32("CONTROLREG=",control);
				if ((control & SAC_CFGRESET) > 0) Puts("Configuration/CompactFlash Controller Reset\n");

				TheSAC->CONTROLREG = control & ~SAC_CFGRESET;
				
				control = TheSAC->CONTROLREG;
				
				DumpUint32("CONTROLREG=",control);
				if ((control  & SAC_CFGRESET) > 0) Puts("Configuration/CompactFlash Controller Reset\n");

				if (rel_cflock(0x10))
				{
					Puts("Data Read successfully from CompactFlash\n");
					return data;
				}
				Puts("Error Releasing CompactFlash MPU Interface Lock\n");
				
				control = TheSAC->CONTROLREG;
				
				DumpUint32("CONTROLREG=",control);
				if ((control & SAC_CFGRESET) > 0) Puts("Configuration/CompactFlash Controller Reset\n");

				TheSAC->CONTROLREG = control & ~SAC_CFGRESET;

				control = TheSAC->CONTROLREG;
				
				DumpUint32("CONTROLREG=",control);
				if ((control & SAC_CFGRESET) > 0) Puts("Configuration/CompactFlash Controller Reset\n");

				return 0;
			}
			Puts("Error Reading from CompactFlash\n");

			control = TheSAC->CONTROLREG;

			DumpUint32("CONTROLREG=",control);
			if ((control & SAC_CFGRESET) > 0) Puts("Configuration/CompactFlash Controller Reset\n");

			TheSAC->CONTROLREG = control & ~SAC_CFGRESET;

			control = TheSAC->CONTROLREG;

			DumpUint32("CONTROLREG=",control);
			if ((control & SAC_CFGRESET) > 0) Puts("Configuration/CompactFlash Controller Reset\n");

			if (rel_cflock(0x10))
			{
				return 0;
			}
			Puts("Error Releasing CompactFlash MPU Interface Lock\n");
			return 0;
		}
		Puts("Timed out while waiting SystemACE to become ready\n");
		if (rel_cflock(0x10))
		{
			return 0;
		}
		Puts("Error Releasing CompactFlash MPU Interface Lock\n");
		return 0;
	}
	Puts("Could not get CompactFlash MPU Interface Lock\n");
	return 0;
}

UINT32 *rd_cfdata(UINT32 startat, int blockcnt, int buffercnt, int wordcnt)
{
	UINT32 *data;
	UINT32 mpulba, seccntcmd, control;

	Puts("\nReading CompactFlash data\n");
	if (get_cflock(0x10))
	{
		if (chk_commrdy(0x10))
		{
			TheSAC->MPULBAREG = startat;
			TheSAC->SECCNTCMDREG = blockcnt | SAC_CMD_READMEMCARDDATA;

			control = TheSAC->CONTROLREG;

			DumpUint32("CONTROLREG=",control);
			if ((control & SAC_CFGRESET) > 0) Puts("Configuration/CompactFlash Controller Reset\n");

			TheSAC->CONTROLREG = control | SAC_CFGRESET;

			control = TheSAC->CONTROLREG;

			DumpUint32("CONTROLREG=",control);
			if ((control & SAC_CFGRESET) > 0) Puts("Configuration/CompactFlash Controller Reset\n");

			data = rd_data(blockcnt,buffercnt,wordcnt);
			if (data != NULL)
			{
				PutChar('\n');

				control = TheSAC->CONTROLREG;

				DumpUint32("CONTROLREG=",control);
				if ((control & SAC_CFGRESET) > 0) Puts("Configuration/CompactFlash Controller Reset\n");

				TheSAC->CONTROLREG = control & ~SAC_CFGRESET;
				
				control = TheSAC->CONTROLREG;
				
				DumpUint32("CONTROLREG=",control);
				if ((control  & SAC_CFGRESET) > 0) Puts("Configuration/CompactFlash Controller Reset\n");

				if (rel_cflock(0x10))
				{
					Puts("Data Read successfully from CompactFlash\n");
					return data;
				}
				Puts("Error Releasing CompactFlash MPU Interface Lock\n");
				
				control = TheSAC->CONTROLREG;
				
				DumpUint32("CONTROLREG=",control);
				if ((control & SAC_CFGRESET) > 0) Puts("Configuration/CompactFlash Controller Reset\n");

				TheSAC->CONTROLREG = control & ~SAC_CFGRESET;

				control = TheSAC->CONTROLREG;
				
				DumpUint32("CONTROLREG=",control);
				if ((control & SAC_CFGRESET) > 0) Puts("Configuration/CompactFlash Controller Reset\n");

				return 0;
			}
			Puts("Error Reading from CompactFlash\n");

			control = TheSAC->CONTROLREG;

			DumpUint32("CONTROLREG=",control);
			if ((control & SAC_CFGRESET) > 0) Puts("Configuration/CompactFlash Controller Reset\n");

			TheSAC->CONTROLREG = control & ~SAC_CFGRESET;

			control = TheSAC->CONTROLREG;

			DumpUint32("CONTROLREG=",control);
			if ((control & SAC_CFGRESET) > 0) Puts("Configuration/CompactFlash Controller Reset\n");

			if (rel_cflock(0x10))
			{
				return 0;
			}
			Puts("Error Releasing CompactFlash MPU Interface Lock\n");
			return 0;
		}
		Puts("Timed out while waiting SystemACE to become ready\n");
		if (rel_cflock(0x10))
		{
			return 0;
		}
		Puts("Error Releasing CompactFlash MPU Interface Lock\n");
		return 0;
	}
	Puts("Could not get CompactFlash MPU Interface Lock\n");
	return 0;
}

int readtest(int mode, int width, int debug)
{
	UINT32 control;
	int i, n;
	int blocks, buffers, words, errors;
	UINT32 *data1, *data2;

	Puts("\nRead Test ");

	if (mode == 16) Puts(" 16 bit mode ");
	else Puts (" 8 bit mode ");

	if (width == 32) Puts(" 32 bit bus ");
	else if (width == 8) Puts(" 8 bit bus ");
	else Puts(" 16 bit bus ");

	if (debug) Puts("Debug mode");

	Puts("\n");

	TheSAC->Control = SAC_RST;

	Delay(20 * 0x10000);

	if (syncmode());
	else return 0;

	if (mode == 16) 
	{
		if (mode16());
		else return 0;
	}
	else
	{
		if (mode8());
		else return 0;
	}

	control = TheSAC->Control;
	DumpUint32("SAC-Control=",control);

	control = control & ~SAC_BUFW8;
	control = control & ~SAC_BUFW16;
	control = control & ~SAC_BUFW32;
	if (width == 32) control = control | SAC_BUFW32;
	else if (width == 8) control = control | SAC_BUFW8;
	else control = control | SAC_BUFW16;
	TheSAC->Control = control;

	control = TheSAC->Control;
	DumpUint32("SAC-Control=",control);

	if (debug) 
	{
		control = control | SAC_DEBUG;
		TheSAC->Control = control;

		control = TheSAC->Control;
		DumpUint32("SAC-Control=",control);
	}

	Delay(20 * 0x10000);

	blocks = 2;
	buffers = 16;
	if (width == 32) words = 8;
	else if (width == 8) words = 32;
	else words = 16;

	errors = 0;

	data1 = rd_cfdata(0x00000000, blocks, buffers, words);
	if (data1 == NULL) return 0;
	data2 = rd_cfdata(0x00000000, blocks, buffers, words);
	if (data2 == NULL) return 0;

	for (i=0; i<(blocks*buffers*words); i++)
	{
		if (data1[i] != data2[i])
		{
			Puts("ERROR\t");
			errors = errors + 1;
		}
		else Puts("\t");
		DumpMem3(i,data1[i],data2[i]);
	}

	DumpUint32("ERRORS ", errors);

	if (errors) return 0;

	return 1;
}

void main(char *StackPointer)
{
    char Step = 'a'-1;
    int i, n;
    volatile UINT32 x, y;
    UINT32 psr;
	UINT32 *iddata;

    /* Wait for go
     */
    Delay(20 * 0x10000); // NB: about 1 sec

    /* Test utils */
    Step++;

    DumpUint32("HiMom! sp=", (UINT32)StackPointer);

    /* Check the tags, bail out if wrong
     */
    Step++;

	if ((TheSAC->Tag & SAC_TAG) != PMTTAG_SYSTEM_ACE) {
        DumpUint32("?SACTag=", TheSAC->Tag);
        goto error;
    }

    /* Dump all initial register values
     */
    Step++;

	if (syncmode());
	else goto error;

	Step++;

	DumpSACRegisters();

	Step++;

	DumpSACFlags();

	Step++;

	if (reset());
	else goto error;

	//Step++;

	//DumpSACRegisters();
	//DumpSACFlags();

	Step++;

	/*if ((TheSAC->BUSMODEREG & SAC_MODE16) > 0)
	{
		Puts("16 bit mode\n");
		x = 1;
	}
	else 
	{
		Puts("8 bit mode\n");
		x = 0;
	}

	if ((TheSAC->BUSMODEREG & SAC_MODE16) > 0) mode8();
	else mode16();

	if ((TheSAC->BUSMODEREG & SAC_MODE16) > 0) 
	{
		Puts("16 bit mode\n");
		if (x == 1) goto error;
		x = 1;
	}
	else 
	{
		Puts("8 bit mode\n");
		if (x == 0) goto error;
		x = 0;
	}

	if ((TheSAC->BUSMODEREG & SAC_MODE16) > 0) mode8();
	else mode16();

	if ((TheSAC->BUSMODEREG & SAC_MODE16) > 0) 
	{
		Puts("16 bit mode\n");
		if (x == 1) goto error;
		x = 1;
	}
	else 
	{
		Puts("8 bit mode\n");
		if (x == 0) goto error;
		x = 0;
	}

	if ((TheSAC->BUSMODEREG & SAC_MODE16) > 0) mode8();

	Step++;

	Puts("start\n");*/

	/*data1 = rd_cfdata(0x00000000, 0x00000001);
	if (data1 == NULL) goto error;
	data2 = rd_cfdata(0x00000000, 0x00000001);
	if (data2 == NULL) goto error;

	for (i=0; i<8*16; i++)
	{
		DumpMem3(i,data1[i],data2[i]);
		PutChar('\n');
		if (data1[i] != data2[i]) goto error;
	}*/

	//8 bit mode, 8 bit data
	if (readtest(8, 8, 0));
	else goto error;

	Delay(5 * 20 * 0x10000);

	//8 bit mode 16 bit data
	if (readtest(8, 16, 0));
	else goto error;

	Delay(5 * 20 * 0x10000);

	//8 bit mode 32 bit data
	if (readtest(8, 32, 0));
	else goto error;

	Delay(5 * 20 * 0x10000);

	//16 bit mode 16 bit data
	if (readtest(16, 16, 0));
	else goto error;

	Delay(5 * 20 * 0x10000);

	//16 bit mode 32 bit data
	if (readtest(16, 32, 0));
	else goto error;

	iddata = id_cf(16, 8);
	if (iddata == NULL) goto error;

	for(i=0; i<(1*16*8); i++)
	{
		DumpMem(i,iddata[i]);
	}

    /* END: all is well
     */ 
    Puts("\nTEST PASSED SUCCESSFULLY\n");
	return;

	error:
    Puts("TEST FAILED at Step=");
    PutChar(Step);
    Puts("\n");
    return;
}
