/* Test the timer with a poor man's scheduler
 */
#include "threads.c"

/* Application threads
 */
#define NT 5
BOOL ThreadHasRun[NT] = {FALSE,};
void test_thread(int me)
{
    int i;
    int c;

    /* NB: Threads cannot terminate! */
    for (;;) {
        PutWord(me); Puts(" wants it...\n");
        c = GetChar();
        PutWord(me); Puts(" got "); PutChar(c); PutChar('\n');

        /* Say this here, after we got our input */
        ThreadHasRun[me] = TRUE;

    }
}

BOOL test(void)
{
    int i, b, c;

    /* Create the other applicaiton threads
     */
    for (i = 0; i < NT; i++)
        CreateThread(test_thread,i);

    /* We're done, now watch what's happening
     */
    for (i = 0; i < 2; i++) {

        /* Wait for interrupts
         */
        //Delay(20 * 0x10000); // NB: about 1 sec
        Delay(100 * 0x10000); // NB: about 5 sec

        /* Get ready for next 
         */
        b = nInterrupts;
        nInterrupts = 0;

        /* Say how we are doing
         */
        c += b;
        Puts("nInts="); PutWord(b); PutChar('\n');
    }

    Puts("nIntsTotal="); PutWord(c); PutChar('\n');
    Puts("Test complete\n");

    /* Check that all threads got to run
     */
    for (i = 0; i < NT; i++)
        if (! ThreadHasRun[i])
            return FALSE;
    return TRUE;
}

