#include "print.h"
#include <mips\ml40x.h>

#define TheAic ((struct _Aic *)INTERRUPT_CONTROLLER_DEFAULT_ADDRESS)
#define TheUsart ((struct _Usart *)USART_DEFAULT_ADDRESS)

void DumpAicRegisters(void)
{
#define DumpRegister(_n_,_o_) { \
    Puts(_n_); \
    PutWord(TheAic->_o_); \
    PutChar('\n'); \
}
    Puts("-- AIC --\n");
    DumpRegister("Tag=",Tag);
    DumpRegister("IrqStatus=",IrqStatus);
    DumpRegister("IrqRawStatus=",IrqRawStatus);
    DumpRegister("IrqEnable=",IrqEnable);
    DumpRegister("IrqEnableClear=",IrqEnableClear);
    DumpRegister("IrqSoft=",IrqSoft);
#undef DumpRegister
}

void DumpUsartRegisters(void)
{
#define DumpRegister(_n_,_o_) { \
    Puts(_n_); \
    PutWord(TheUsart->_o_); \
    PutChar('\n'); \
}
#define DumpRegisterSlow(_n_,_o_) { \
    Puts(_n_); \
    Delay(20*0x10000/*~1sec*/); \
    PutWord(TheUsart->_o_); \
    PutChar('\n'); \
}
    Puts("-- USART --\n");
    DumpRegister("Tag=",Tag);
    DumpRegister("Control=",Control);
    DumpRegister("IntrEnable=",IntrEnable);
    DumpRegister("IntrDisable=",IntrDisable);
    DumpRegister("IntrMask=",IntrMask);
    DumpRegisterSlow("ChannelStatus=",ChannelStatus);
    DumpRegister("RxData=",RxData);
    DumpRegister("TxData=",TxData);
    DumpRegister("Baud=",Baud);
    DumpRegister("Timeout=",Timeout);
#undef DumpRegister
#undef DumpRegisterSlow
}

void DumpPsr(void)
{
    UINT32 v;
    Puts("-- COPROC-0 --\n");
    v = GetPsr();
    Puts("psr="); PutWord(v); PutChar('\n');
    v = GetCause();
    Puts("cause="); PutWord(v); PutChar('\n');
    v = GetEpc();
    Puts("epc="); PutWord(v); PutChar('\n');
}


void main(char *StackPointer)
{
    char Step = 'a'-1;
    UINT32 psr, x, status;
    UINT32 epc1, epc2;

    /* Wait fro go
     */
    Delay(20 * 0x10000); // NB: about 1 sec

    /* Test utils */
    Step++;
    Puts("\tHiMom! sp=");
    PutWord((UINT32)StackPointer);
    PutChar('\n');

    /* TEST: Check the tags, bail out if wrong
     */
    Step++;
    if (TheAic->Tag != PMTTAG_INTERRUPT_CONTROLLER) {
        Puts("AIC: bad tag="); PutWord(TheAic->Tag); PutChar('\n');
        goto error;
    }
    if (TheUsart->Tag != PMTTAG_USART) {
        Puts("USART: bad tag="); PutWord(TheUsart->Tag); PutChar('\n');
        goto error;
    }

    /* TEST: Enable interrupts, dump all registers
     */
    Step++;

    /* enable interrupts, drop BEV */
    psr = GetPsr();
    psr |= 1;
    psr &= ~0x00400000;
#if 1
    Puts("psr->");PutWord(psr);PutChar('\n');
    SetPsr(psr);
#endif

    DumpUsartRegisters();
    DumpAicRegisters();
    DumpPsr();

    /* TEST: Enable interrupts from the USART, see what happens
     */
    Step++;
    Puts("\tEnabling interrupts for USART...{type quickly to test overruns}");
    Delay(0x10000);

    epc1 = GetEpc();

#define ZEBITS (USI_RXRDY|USI_RXBRK|USI_OVRE|USI_FRAME|USI_PARE|USI_TXRDY)
    TheUsart->IntrEnable = ZEBITS;
    TheAic->IrqEnable = AIC_USART_BIT;

    /*
     * CHECK: We should get a xmit complete interrupt, from our printing.
     */
    Delay(0x10000);
    x = TheAic->IrqRawStatus;

    epc2 = GetEpc();
    status = TheUsart->ChannelStatus;
    if (epc1 != epc2) {
        Puts("Got interrupt! Done ok. \n");
    }

    Puts("Usart->ChannelStatus=");PutWord(status);PutChar('\n');
    Puts("Aic->IrqRawStatus=");PutWord(x);PutChar('\n');
    DumpUsartRegisters();
    DumpAicRegisters();
    DumpPsr();
    if (epc1 == epc2) {
        Puts("USART did not interrupt, test failed.\n");
        goto error;
    }

    /*
     * CHECK: If we got an overrun, clear errors
     */
    if (status & USI_OVRE) {
        Puts("Clearing recv overrun error...\n");
        x = TheUsart->Control;
        TheUsart->Control = x | USC_RSTSTA; /* auto-clears */
        status = TheUsart->ChannelStatus;
        Puts("Usart->ChannelStatus=");PutWord(status);PutChar('\n');
    }
     

    /* TEST: Disable interrupts from the USART, see what happens
     */
    Step++;
    Puts("\tDisabling interrupts for USART...");

    TheUsart->IntrDisable = ZEBITS;

    /*
     * CHECK: User inspects values
     */
    Puts("Done\n");
    DumpUsartRegisters();
    DumpAicRegisters();
    DumpPsr();


    /* END: all is well
     */ 
    Puts("TEST PASSED SUCCESSFULLY\n");
    return;

error:
    Puts("TEST FAILED at Step=");
    PutChar(Step);
    Puts("\n");
}
