from z3 import *
import sys

def G12(dst,src):
    return And(Extract(2,1,dst) == 2, Extract(2,1,src) == 1)

def G13(dst,src):
    return And(Not(G12(dst,src)), Extract(2,2,dst) == 1)

def G2B(dst,src):
    return Extract(2,1,dst) == 2

def G3D(dst,src):
    return Extract(2,2,dst) == 1

def G32(dst,src):
    return And(Not(G3D(dst,src)), Extract(2,2,dst) == 1)

bv3 = BitVecSort(3)
Loc, (A,B,D,R1,R2,R3) = EnumSort('Location', ['A','B','D','R1','R2','R3'])


def T(src,dst,l,src1,dst1,l1):
    return Or(And(R1 == l, G12(dst,src), R2 == l1, src1 == src, dst1 == dst),
	      And(R1 == l, G13(dst,src), R3 == l1, src1 == src, dst1 == dst),
	      And(R2 == l, G2B(dst,src), B == l1,  src1 == src, dst1 == dst),
	      And(R3 == l, G3D(dst,src), D == l1,  src1 == src, dst1 == dst),
	      And(R3 == l, G32(dst,src), (5 & dst) == dst1, R2 == l1, src1 == src),
	      And(A == l,  R1 == l1, src1 == src, dst1 == dst))

src0, dst0, src1, dst1, src2, dst2, src3, dst3 = Consts('src0 dst0 src1 dst1 src2 dst2 src3 dst3', bv3)
l0, l1, l2, l3 = Consts('l0 l1 l2 l3', Loc)

print "Try a trace of length 2"
sys.stdout.flush()
sys.stdin.readline()

fml = And(l0 == A,
	  T(src0, dst0, l0, src1, dst1, l1),
	  T(src1, dst1, l1, src2, dst2, l2),
	  l2 == B)

s = Solver()
s.add(fml)
print s.check()
print "hit enter to try a longer trace"
sys.stdout.flush()
sys.stdin.readline()

fml = And(l0 == A,
	  T(src0, dst0, l0, src1, dst1, l1),
	  T(src1, dst1, l1, src2, dst2, l2),
	  T(src2, dst2, l2, src3, dst3, l3),
	  l3 == B)

s = Solver()
s.add(fml)
print s.check()
print s.model()
