from z3 import *

def G12(dst,src):
    return And(Extract(2,1,dst) == 2, Extract(2,1,src) == 1)

def G13(dst,src):
    return And(Not(G12(dst,src)), Extract(2,2,dst) == 1)

def G2B(dst,src):
    return Extract(2,1,dst) == 2

def G3D(dst,src):
    return Extract(2,2,dst) == 1

def G32(dst,src):
    return And(Not(G3D(dst,src)), Extract(2,2,dst) == 1)

fp = Fixedpoint()
fp.set('datalog.default_relation','doc')
bv3 = BitVecSort(3)
A  = Function('A', bv3, bv3, BoolSort())
B  = Function('B', bv3, bv3, BoolSort())
D  = Function('D', bv3, bv3, BoolSort())
R1 = Function('R1', bv3, bv3, BoolSort())
R2 = Function('R2', bv3, bv3, BoolSort())
R3 = Function('R3', bv3, bv3, BoolSort())

src, dst, dst1 = Consts('src dst dst1', bv3)
fp.register_relation(A, B, D, R1, R2, R3)
fp.declare_var(src, dst, dst1)
fp.rule(B(dst,src))
fp.rule(R1(dst,src), [G12(dst,src), R2(dst, src)])
fp.rule(R1(dst,src), [G13(dst,src), R3(dst, src)])
fp.rule(R2(dst,src), [G2B(dst,src), B(dst, src)])
fp.rule(R3(dst,src), [G3D(dst,src), D(dst, src)])
fp.rule(R3(dst,src), [G32(dst,src), (5 & dst) == dst1, R2(dst1, src)])
fp.rule(A(dst,src),  R1(dst,src))
print fp.query(A(dst,src))
print fp.get_answer()
