(set-option :fixedpoint.datalog.default_relation doc)
(define-sort bv3 () (_ BitVec 3))
(declare-var src bv3)
(declare-var dst bv3)
(declare-var src1 bv3)
(declare-var dst1 bv3)
(declare-rel A (bv3 bv3))
(declare-rel B (bv3 bv3))
(declare-rel D (bv3 bv3))
(declare-rel R1 (bv3 bv3))
(declare-rel R2 (bv3 bv3))
(declare-rel R3 (bv3 bv3))

(define-fun G12 ((dst bv3) (src bv3)) Bool
     (and (= ((_ extract 2 1) dst) #b10) (= ((_ extract 2 1) src) #b01)))

(define-fun G13 ((dst bv3) (src bv3)) Bool
     (and (not (G12 dst src)) (= ((_ extract 2 2) dst) #b1)))

(define-fun G2B ((dst bv3) (src bv3)) Bool
     (= ((_ extract 2 1) dst) #b10))

(define-fun G3D ((dst bv3) (src bv3)) Bool
     (= ((_ extract 2 2) dst) #b1))

(define-fun G32 ((dst bv3) (src bv3)) Bool
    (and (not (G3D dst src)) (= ((_ extract 2 2) dst) #b1)))

(rule (B dst src))
(rule (=> (and (G12 dst src) (R2 dst src)) (R1 dst src)))
(rule (=> (and (G13 dst src) (R3 dst src)) (R1 dst src)))
(rule (=> (and (G2B dst src) (B  dst src)) (R2 dst src)))
(rule (=> (and (G3D dst src) (D  dst src)) (R3 dst src)))
(rule (=> (and (G32 dst src) (= dst1 (bvand #b101 dst)) (R2 dst1 src))
           (R3 dst src)))

(rule (=> (R1 dst src) (A dst src)))
(query (A dst src)
 :print-answer true)
