from z3 import *

I = IntSort()
f = Function('f', I, I)
x, y, z = Ints('x y z')
A = Array('A',I,I)

print """
I = IntSort()
f = Function('f', I, I)
x, y, z = Ints('x y z')
A = Array('A',I,I)
"""

def pprove(e):
    print "prove(", e, ")"
    sys.stdin.readline()
    prove(e)
    print ""
    sys.stdin.readline()

def psolve(e):
    print "solve(", e, ")"
    sys.stdin.readline()
    solve(e)
    print ""
    sys.stdin.readline()

# Valid:
pprove(Implies(x + 2 == y, f(Select(Store(A, x, 3), y - 2)) == f(y - x + 1)))

# Not valid:
pprove(Implies(x + 2 > y, f(Select(Store(A, x, 3), y - 2)) == f(y - x + 1)))

#Satisfiable:
psolve(Implies(x + 2 == y, f(Select(Store(A, x, 3), y - 2)) == f(y - x + 1)))

# A is a don't care.

