from z3 import *


print """
# Declare a List of integers
# Constructor cons: (Int, List) -> List
# Constructor nil: List
# Create the datatype

List = Datatype('List')                     
List.declare('cons', ('car', IntSort()), ('cdr', List))    
List.declare('nil')                                        
List = List.create()                                       
"""
sys.stdin.readline()

print """
cons = List.cons                   # cons function
car  = List.car                    # car function
cdr  = List.cdr                    # cdr function
nil  = List.nil                    # nil
"""
sys.stdin.readline()

print """
l1 = cons(10, cons(20, nil))
"""

List = Datatype('List')
List.declare('cons', ('car', IntSort()), ('cdr', List))
List.declare('nil')
List = List.create()
cons = List.cons
car  = List.car
cdr  = List.cdr
nil  = List.nil
l1 = cons(10, cons(20, nil))

print """
print simplify(cdr(l1))"""
sys.stdin.readline()
print ">>", simplify(cdr(l1))
sys.stdin.readline()

print """
print simplify(car(l1))"""
sys.stdin.readline()
print ">>", simplify(car(l1))
sys.stdin.readline()

print """
print simplify(l1 == nil)
"""
sys.stdin.readline()
print ">>", simplify(l1 == nil)

sys.stdin.readline()

x, y = Ints('x y')
l1 = Const('l1',List)
l2 = Const('l2',List)
s = Solver()
s.add(x >= y)
s.add(cons(x, l1) != cons(y, l2))
s.add(l1 == l2)
print """
x, y = Ints('x y')
l1 = Const('l1',List)
l2 = Const('l2',List)
s = Solver()
s.add(x >= y)
s.add(cons(x, l1) != cons(y, l2))
s.add(l1 == l2)
s.check()
s.model()
"""
sys.stdin.readline()
s.check()
print ">>", s.model()

sys.stdin.readline()
s.add(x <= y)
print """s.add(x <= y)
s.check()
"""
print ">>", s.check()

sys.stdin.readline()




