﻿// -----------------------------------------------------------------------
// <copyright file="CreateRouter.cs" company="Microsoft IT">
// TODO: Update copyright text.
// </copyright>
// -----------------------------------------------------------------------

namespace Microsoft.Cis.Security.Tools.FirewallBenchmarks
{
    using System;
    using System.Collections.Generic;
    using System.Collections.Specialized;
    using System.Configuration;
    using System.IO;
    using System.Linq;
    using System.Net;
    using System.Text;

    /// <summary>
    /// TODO: Update summary.
    /// </summary>
    public class CreateRouter
    {
        UInt32 NumberOfRules;
        UInt32 NumberOfQueries;
        UInt32 BegAllowIPRange;
        UInt32 EndAllowIPRange;
        UInt32 BegPortRange;
        UInt32 EndPortRange;
        UInt32 IPRangeLen;
        UInt32 PortRangeLen;
        UInt32 PercentRangeLen;
        UInt32 BlockPerAllow;
        string LocalIP;
        string[] protocols;
        List<RouterRule> Rules;
        List<RouterQuery> Queries;

        public CreateRouter(UInt32 numberOfRules)
        {
            NameValueCollection appsettings = ConfigurationManager.AppSettings;
            protocols = new string[] { "TCP", "UDP" };
            this.NumberOfRules = numberOfRules;
            this.NumberOfQueries = UInt32.Parse(appsettings["NoOfQueries"]);
            this.BegAllowIPRange = Conv.IP2Num(appsettings["BegAllowIPRange"]);
            this.EndAllowIPRange = Conv.IP2Num(appsettings["EndAllowIPRange"]);
            this.BegPortRange = UInt16.Parse(appsettings["BegPortRange"]);
            this.EndPortRange = UInt16.Parse(appsettings["EndPortRange"]);
            this.IPRangeLen = uint.Parse(appsettings["IPRangeLen"]);
            this.PortRangeLen = uint.Parse(appsettings["PortRangeLen"]); 
            this.PercentRangeLen = uint.Parse(appsettings["PercentRangeLen"]); 
            this.BlockPerAllow = uint.Parse(appsettings["BlockPerAllow"]); 
            this.Rules = new List<RouterRule>();
            this.Queries = new List<RouterQuery>();
            this.LocalIP = Utility.ChooseRandomIP(this.BegAllowIPRange, this.EndAllowIPRange);
        }

        public void CreateQueries()
        {
            for (int i = 0; i < this.NumberOfQueries; i++)
            {
                string iprange = Utility.ChooseRandomIP(this.BegAllowIPRange, this.EndAllowIPRange, (this.IPRangeLen * this.PercentRangeLen / 100));
                this.Queries.Add(new RouterQuery(iprange, "*", this.LocalIP, "*", "*"));
            }
        }

        public void CreateRules()
        {
            Random rndGen = new Random();

            while (Rules.Count < this.NumberOfRules)
            {
                if (rndGen.Next()%2 == 0)
                {
                    Rules.Add(CreateAllowRule(true));
                }
                else
                {
                    Rules.Add(CreateBlockRule(33));
                }
            }
        }

        public RouterRule CreateAllowRule(bool wildcardProtocol)
        {
            string remoteIP = Utility.ChooseRandomIP(this.BegAllowIPRange, this.EndAllowIPRange, this.IPRangeLen);
            string protocol = string.Empty;

            if (wildcardProtocol)
            {
                protocol = "*";
            }
            else
            {
                protocol = Utility.ChooseRandomStr(protocols);
            }

            RouterRule rule = new RouterRule("Permit", protocol, remoteIP, "", this.LocalIP, "", "", "");

            return rule;
        }

        public RouterRule CreateBlockRule(UInt32 percentRangeLen)
        {
            UInt32 rangeLenIP = (this.IPRangeLen * percentRangeLen) / 100;
            string remoteIP = Utility.ChooseRandomIP(this.BegAllowIPRange, this.EndAllowIPRange, rangeLenIP);
            string protocol = Utility.ChooseRandomStr(protocols);

            RouterRule rule = new RouterRule("Deny", protocol, remoteIP, "", this.LocalIP, "", "", "");

            return rule;
        }

        public RouterRule CreateBlockRule(UInt32 begIPRange, UInt32 endIPRange, UInt32 percentRangeLen)
        {
            UInt32 rangeLenIP = (this.IPRangeLen * percentRangeLen) / 100;
            string remoteIP = Utility.ChooseRandomIP(begIPRange, endIPRange, rangeLenIP);
            string protocol = Utility.ChooseRandomStr(protocols);

            RouterRule rule = new RouterRule("Deny", protocol, remoteIP, "", this.LocalIP, "", "", ""); 
            
            return rule;
        }

        public void WriteQueries(string filename)
        {
            List<string> queries = new List<string>();

            queries.Add(RouterQuery.Header());

            foreach (RouterQuery query in this.Queries)
            {
                queries.Add(query.ToString());
            }

            this.Write(filename, queries.ToArray<string>());
        }

        public void WriteRouter(string filename)
        {
            List<string> rules = new List<string>();

            // Write header
            rules.Add(RouterRule.Header());

            foreach(RouterRule rule in this.Rules)
            {
                rules.Add(rule.ToString());
            }

            this.Write(filename, rules.ToArray<string>());
        }

        public void Write(string filename, string[] lines)
        {
            StreamWriter writer = new StreamWriter(filename);

            foreach (string line in lines)
            {
                writer.WriteLine(line);
            }

            writer.Close();
        }
    }
}
