﻿// -----------------------------------------------------------------------
// <copyright file="FirewallRule.cs" company="Microsoft IT">
// TODO: Update copyright text.
// </copyright>
// -----------------------------------------------------------------------

namespace Microsoft.Cis.Security.Tools.FirewallBenchmarks
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;

    /// <summary>
    /// TODO: Update summary.
    /// </summary>
    public class FirewallRule
    {
        public string Name;
        public string Direction; 
        public string LocalAddress; 
        public string LocalPort; 
        public string RemoteAddress; 
        public string RemotePort;
        public string Protocol;
        public string Action;
        public const string RuleName = "Rule Name";
        public const string RulePermission = "Action";
        public const string RuleDir = "Direction";
        public const string RuleLocalAddr = "Host ID";
        public const string RuleLocalPort = "Local Ports";
        public const string RuleRemoteAddr = "Remote Addresses";
        public const string RuleRemotePort = "Remote Ports";
        public const string RuleProtocol = "Protocol";

        public FirewallRule(string name, string action, string dir, string localAddr, string localPort, string rmtAddr, string rmtPort, string prot)
        {
            this.Name = name;
            this.Action = action;
            this.Direction = dir;
            this.LocalAddress = localAddr;
            this.LocalPort = localPort;
            this.RemoteAddress = rmtAddr;
            this.RemotePort = rmtPort;
            this.Protocol = prot;
        }

        public override string ToString()
        {
            //Host ID , Rule Name , Action , Direction , Local Ports , Remote Addresses , Remote Ports , Protocol
            return string.Format("{0},{1},{2},{3},{4},{5},{6},{7},,", this.LocalAddress, this.Name, this.Action, this.Direction, this.LocalPort, this.RemoteAddress, this.RemotePort, this.Protocol);
        }

        public static string Header()
        {
            //Host ID , Rule Name , Action , Direction , Local Ports , Remote Addresses , Remote Ports , Protocol
            return string.Format("{0},{1},{2},{3},{4},{5},{6},{7},,", RuleLocalAddr, RuleName, RulePermission, RuleDir, RuleLocalPort, RuleRemoteAddr, RuleRemotePort, RuleProtocol);
        }
    }
}