﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Microsoft.Cis.Security.Tools.FirewallBenchmarks
{
    class Program
    {
        static void Main(string[] args)
        {
            string helpedMessage = "FirewallBenchmarks -Rules <no of rules> -Output <file> -Query <file> -Firewall | -Router";
            ClineArguments cline = new ClineArguments(args, helpedMessage);

            string filename = cline.GetNthValue("Output", 0);
            string queryfile = cline.GetNthValue("Query", 0);
            uint noofrules = uint.Parse(cline.GetNthValue("Rules", 0));

            if (cline.Contains("Firewall"))
            {
                CreateFirewall firewall = new CreateFirewall(noofrules);

                firewall.CreateRules(GeneratioMode.REALISTIC);
                firewall.CreateQueries();
                firewall.WriteFirewall(filename);
                firewall.WriteQueries(queryfile);
            }

            if (cline.Contains("Router"))
            {
                CreateRouter router = new CreateRouter(noofrules);

                router.CreateRules();
                router.CreateQueries();
                router.WriteRouter(filename);
                router.WriteQueries(queryfile);
            }
        }
    }
}
