﻿// -----------------------------------------------------------------------
// <copyright file="RouterRule.cs" company="Microsoft IT">
// TODO: Update copyright text.
// </copyright>
// -----------------------------------------------------------------------

namespace Microsoft.Cis.Security.Tools.FirewallBenchmarks
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;

    /// <summary>
    /// TODO: Update summary.
    /// </summary>
    public class RouterRule
    {
        public const string HdrRuleType = "RuleType";
        public const string HdrProtocol = "Protocol";
        public const string HdrSource = "Source";
        public const string HdrSourcePortExpr = "SourcePortExpr";
        public const string HdrDestination = "Destination";
        public const string HdrDestPortExpr = "DestPortExpr";
        public const string HdrFlags = "Flags";
        public const string HdrIcmpMessageType = "IcmpMessageType";

        public string RuleType;
        public string Protocol;
        public string Src;
        public string SrcPortExpr;
        public string Dst;
        public string DstPortExpr;
        public string Flags;
        public string IcmpMessageType;

        public RouterRule(string ruleType, string protocol, string src, string srcPortExpr, string dst, string dstPortExpr, string flags, string icmpMessageType)
        {
            this.RuleType = ruleType;
            this.Protocol = protocol;
            this.Src = src;
            this.SrcPortExpr = srcPortExpr;
            this.Dst = dst;
            this.DstPortExpr = dstPortExpr;
            this.Flags = flags;
            this.IcmpMessageType = icmpMessageType;
        }

        public override string ToString()
        {
            return string.Format("{0},{1},,{2},{3},{4},{5},{6},{7}", RuleType, Protocol, Src, SrcPortExpr, Dst, DstPortExpr, Flags, IcmpMessageType);
        }

        public static string Header()
        {
            //RuleType,Protocol,ProtocolNum,Source,SourcePortExpr,Destination,DestPortExpr,Flags,IcmpMessageType
            return string.Format("{0},{1},,{2},{3},{4},{5},{6},{7}", HdrRuleType, HdrProtocol, HdrSource, HdrSourcePortExpr, HdrDestination, HdrDestPortExpr, HdrFlags, HdrIcmpMessageType);
        }
    }
}
