﻿// -----------------------------------------------------------------------
// <copyright file="Utility.cs" company="Microsoft IT">
// TODO: Update copyright text.
// </copyright>
// -----------------------------------------------------------------------

namespace Microsoft.Cis.Security.Tools.FirewallBenchmarks
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;

    /// <summary>
    /// TODO: Update summary.
    /// </summary>
    public class Utility
    {
        static Random rndGen = new Random();

        /// <summary>
        /// Returns a random choice of a string from
        /// the list of strings passed to it. 
        /// </summary>
        /// <param name="xs">list of strings</param>
        /// <returns>random choice of a string</returns>
        public static string ChooseRandomStr(string[] xs)
        {
            if (xs.Length == 0)
            {
                throw new ArgumentException("protocols array is empty");
            }

            UInt16 picknum = (UInt16) rndGen.Next(xs.Length);

            return xs[picknum];
        }

        /// <summary>
        /// Returns a port range of specified length at random.
        /// </summary>
        /// <param name="startNum">Beginning of range for port numbers</param>
        /// <param name="endNum">End of range for port numbers</param>
        /// <param name="rangeLen">Length of range</param>
        /// <returns>String representation of port range</returns>
        public static string ChooseRandomPort(UInt16 startNum, UInt16 endNum, UInt16 rangeLen)
        {
            UInt16 pickPort1 = (UInt16)rndGen.Next(startNum, endNum);
            UInt16 pickPort2 = (UInt16)(pickPort1 + rangeLen);

            return string.Format("{0}-{1}", pickPort1, pickPort2);
        }

        /// <summary>
        /// Choose a port at random within a specified range.
        /// </summary>
        /// <param name="startNum">Beginning of range for port numbers</param>
        /// <param name="endNum">End of range for port numbers</param>
        /// <returns>String representation of port</returns>
        public static string ChooseRandomPort(UInt16 startNum, UInt16 endNum)
        {
            UInt16 pickPort1 = (UInt16)rndGen.Next(startNum, endNum);

            return string.Format("{0}", pickPort1);
        }

        /// <summary>
        /// Returns true or false at random to
        /// simulate a random coin toss
        /// </summary>
        /// <returns>Returns true for a head and false otherwise</returns>
        public static bool CoinToss()
        {
            if (rndGen.Next(0, 1) == 1)
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        /// <summary>
        /// Choose a port at random
        /// </summary>
        /// <returns>String representation of port</returns>
        public static string ChooseRandomPort()
        {
            return ChooseRandomPort(UInt16.MinValue, UInt16.MaxValue);
        }

        /// <summary>
        /// Choose a random range of IP addresses
        /// </summary>
        /// <param name="startAddr">Beginning range of IP address</param>
        /// <param name="endAddr">Ending range of IP address</param>
        /// <param name="rangeLen">Length of the range</param>
        /// <returns>Range of IP address</returns>
        public static string ChooseRandomIP(UInt32 startAddr, UInt32 endAddr, UInt32 rangeLen)
        {
            UInt32 diff = endAddr - startAddr;

            string pickIP1 = ChooseRandomIP(startAddr, (endAddr - rangeLen));
            string pickIP2 = Conv.IPNUM2STR(Conv.IP2Num(pickIP1) + rangeLen);

            return string.Format("{0}-{1}", pickIP1, pickIP2);
        }

        /// <summary>
        /// Choose a random range of IP addresses
        /// </summary>
        /// <param name="startAddr">Beginning range of IP address</param>
        /// <param name="endAddr">Ending range of IP address</param>
        /// <param name="rangeLen">Length of the range</param>
        /// <returns>Range of IP address</returns>
        public static string ChooseRandomIP(string startAddr, string endAddr, UInt32 rangeLen)
        {
            UInt32 startRange = Conv.IP2Num(startAddr), endRange = Conv.IP2Num(endAddr);
            UInt32 diff = endRange - startRange;

            string pickIP1 = ChooseRandomIP(startAddr, Conv.IPNUM2STR(endRange - rangeLen));
            string pickIP2 = Conv.IPNUM2STR(Conv.IP2Num(pickIP1) + rangeLen);

            return string.Format("{0}-{1}", pickIP1, pickIP2);
        }

        /// <summary>
        /// Choose a random IP address within the mentioned range
        /// </summary>
        /// <param name="startAddr">Beginning of range</param>
        /// <param name="endAddr">End of range</param>
        /// <returns>String representation of chosen IP address</returns>
        public static string ChooseRandomIP(UInt32 startAddr, UInt32 endAddr)
        {
            UInt32 diff = endAddr - startAddr;

            UInt32 random = (UInt32)rndGen.Next();
            random = random % diff;

            UInt32 pickIP = startAddr + random;

            return Conv.IPNUM2STR(pickIP);
        }

        /// <summary>
        /// Choose a random IP address with the bounds
        /// of the mentioned start address and end address.
        /// </summary>
        /// <param name="startAddr">Begin address</param>
        /// <param name="endAddr">Ending address</param>
        /// <returns>Random IP address</returns>
        public static string ChooseRandomIP(string startAddr, string endAddr)
        {
            UInt32 startRange = Conv.IP2Num(startAddr), endRange = Conv.IP2Num(endAddr);
            UInt32 diff = endRange - startRange;

            UInt32 random = (UInt32)rndGen.Next();
            random = random % diff;

            UInt32 pickIP = startRange + random;

            return Conv.IPNUM2STR(pickIP);
        }
    }

    public class Conv
    {
        /// <summary>
        /// Returns a 32 bit unsigned number corresponding
        /// to the IP address mentioned in the string
        /// </summary>
        /// <param name="IPAddress">String containing IP address</param>
        /// <returns>Unsigned number corresponding to IP address</returns>
        public static UInt32 IP2Num(string IPAddress)
        {
            UInt32 IPAddressNum = 0;
            string[] IPOctets = IPAddress.Split('.');

            if (IPOctets.Length == 4)
            {
                foreach (string octet in IPOctets)
                {
                    IPAddressNum = IPAddressNum << 8;
                    IPAddressNum += byte.Parse(octet);
                }
            }
            else
            {
                throw new FormatException(string.Format("The following IP address is not in the correct format {0}", IPAddress));
            }

            return IPAddressNum;
        }

        /// <summary>
        /// Return a string representation of the IP address
        /// corresponding to the unsigned number in input.
        /// </summary>
        /// <param name="p">Unsigned number corresponding to an IP address</param>
        /// <returns>String representation of the IP address</returns>
        public static string IPNUM2STR(UInt32 p)
        {
            return string.Format("{0}.{1}.{2}.{3}", (p >> 24), (p >> 16) & 0xFF, (p >> 8) & 0xFF, p & 0xFF);
        }
    }
}
